/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.gce.imagemosaic;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import org.apache.commons.io.FileUtils;
import org.geotools.TestData;
import org.geotools.api.data.Query;
import org.geotools.coverage.grid.io.AbstractGridFormat;
import org.geotools.coverage.grid.io.HarvestedSource;
import org.geotools.gce.imagemosaic.ImageMosaicReader;
import org.geotools.gce.imagemosaic.TestUtils;
import org.geotools.gce.imagemosaic.properties.PropertiesCollector;
import org.geotools.gce.imagemosaic.properties.PropertiesCollectorFinder;
import org.geotools.gce.imagemosaic.properties.PropertiesCollectorSPI;
import org.geotools.gce.imagemosaic.properties.string.StringFileNameExtractorSPI;
import org.geotools.gce.imagemosaic.properties.time.TimestampFileNameExtractorSPI;
import org.geotools.util.URLs;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class PropertiesCollectorTest {
    @BeforeClass
    public static void init() {
        System.setProperty("org.geotools.referencing.forceXY", "true");
        System.setProperty("user.timezone", "GMT");
        System.setProperty("org.geotools.shapefile.datetime", "true");
    }

    @AfterClass
    public static void cleanup() {
        System.clearProperty("org.geotools.referencing.forceXY");
        System.clearProperty("user.timezone");
        System.clearProperty("org.geotools.shapefile.datetime");
    }

    @Test
    public void test() {
        Set spis = PropertiesCollectorFinder.getPropertiesCollectorSPI();
        Assert.assertNotNull((Object)spis);
        Assert.assertFalse((boolean)spis.isEmpty());
        Assert.assertEquals((long)15L, (long)spis.size());
    }

    @Test
    public void testString() throws IOException {
        Set spis = PropertiesCollectorFinder.getPropertiesCollectorSPI();
        Assert.assertNotNull((Object)spis);
        Assert.assertFalse((boolean)spis.isEmpty());
        URL testUrl = TestData.url((Object)this, (String)"time_geotiff/stringregex.properties");
        for (PropertiesCollectorSPI spi : spis) {
            if (!(spi instanceof StringFileNameExtractorSPI)) continue;
            PropertiesCollector pc = spi.create((Object)testUrl, Arrays.asList("string_attr"));
            pc.collect(TestData.file((Object)this, (String)"time_geotiff/world.200402.3x5400x2700.tiff"));
            return;
        }
        Assert.fail();
    }

    @Test
    public void testTime() throws IOException {
        Set spis = PropertiesCollectorFinder.getPropertiesCollectorSPI();
        Assert.assertNotNull((Object)spis);
        Assert.assertFalse((boolean)spis.isEmpty());
        URL testUrl = TestData.url((Object)this, (String)"time_geotiff/timeregex.properties");
        for (PropertiesCollectorSPI spi : spis) {
            if (!(spi instanceof TimestampFileNameExtractorSPI)) continue;
            PropertiesCollector pc = spi.create((Object)testUrl, Arrays.asList("time_attr"));
            pc.collect(TestData.file((Object)this, (String)"time_geotiff/world.200403.3x5400x2700.tiff"));
            return;
        }
        Assert.fail();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testHarvestCurrentTime() throws Exception {
        File source = URLs.urlToFile((URL)org.geotools.test.TestData.url((Object)this, (String)"rgba/"));
        File config = URLs.urlToFile((URL)org.geotools.test.TestData.url((Object)this, (String)"currentdate/"));
        File testDataDir = org.geotools.test.TestData.file((Object)this, (String)".");
        File directory1 = new File(testDataDir, "currTimeHarvest1");
        File directory2 = new File(testDataDir, "currTimeHarvest2");
        if (directory1.exists()) {
            FileUtils.deleteDirectory((File)directory1);
        }
        FileUtils.copyDirectory((File)source, (File)directory1);
        FileUtils.copyDirectory((File)config, (File)directory1);
        if (directory2.exists()) {
            FileUtils.deleteDirectory((File)directory2);
        }
        FileUtils.copyDirectory((File)source, (File)directory2);
        for (File file : directory1.listFiles(f -> !f.getName().startsWith("passA2006128193711.") && !f.getName().endsWith(".properties"))) {
            Assert.assertTrue((boolean)file.delete());
        }
        URL harvestSingleURL = URLs.fileToUrl((File)directory1);
        AbstractGridFormat format = TestUtils.getFormat(harvestSingleURL);
        ImageMosaicReader reader = TestUtils.getReader(harvestSingleURL, format);
        try {
            Thread.sleep(100L);
            File harvestSourceOne = new File(directory2, "passA2006128194218.png");
            List summary = reader.harvest(null, (Object)harvestSourceOne, null);
            Assert.assertEquals((long)1L, (long)summary.size());
            HarvestedSource hf = (HarvestedSource)summary.get(0);
            Assert.assertTrue((boolean)hf.success());
            Thread.sleep(100L);
            File harvestSourceTwo = new File(directory2, "passA2006128211927.png");
            summary = reader.harvest(null, (Object)harvestSourceTwo, null);
            Assert.assertEquals((long)1L, (long)summary.size());
            hf = (HarvestedSource)summary.get(0);
            Assert.assertTrue((boolean)hf.success());
            HashMap mappedDates = new HashMap();
            reader.getGranules(null, true).getGranules(Query.ALL).accepts(feature -> {
                String location = (String)feature.getProperty("location").getValue();
                int idxSlash = location.lastIndexOf(92);
                int idxBackslash = location.lastIndexOf(47);
                String name = location;
                if (idxSlash > -1 || idxBackslash > -1) {
                    name = location.substring(Math.max(idxSlash, idxBackslash) + 1);
                }
                Date ingest = (Date)feature.getProperty("ingestion").getValue();
                mappedDates.put(name, ingest);
            }, null);
            MatcherAssert.assertThat((Object)((Date)mappedDates.get("passA2006128193711.png")), (Matcher)Matchers.lessThan((Comparable)((Date)mappedDates.get("passA2006128194218.png"))));
            MatcherAssert.assertThat((Object)((Date)mappedDates.get("passA2006128194218.png")), (Matcher)Matchers.lessThan((Comparable)((Date)mappedDates.get("passA2006128211927.png"))));
            long now = System.currentTimeMillis();
            long oneHour = 3600000L;
            for (Date d : mappedDates.values()) {
                MatcherAssert.assertThat((String)(d + " vs " + new Date()), (Object)(now - d.getTime()), (Matcher)Matchers.lessThanOrEqualTo((Comparable)Long.valueOf(oneHour)));
            }
        }
        finally {
            reader.dispose();
        }
    }
}

