/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.gce.imagemosaic;

import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileOutputStream;
import java.io.ObjectOutputStream;
import java.util.PriorityQueue;
import javax.media.jai.Histogram;
import javax.media.jai.remote.SerializableRenderedImage;
import org.geotools.gce.imagemosaic.SampleImage;
import org.geotools.gce.imagemosaic.Utils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

public class UtilsTest {
    @ClassRule
    public static TemporaryFolder folder = new TemporaryFolder();

    @Before
    @After
    public void reset() {
        System.clearProperty("org.geotools.gce.imagemosaic.sampleimage.allowlist");
        Utils.resetSampleImageAllowlist();
    }

    @Test
    public void testGetHistogramValid() throws Exception {
        String file = folder.newFile("valid.histogram").getAbsolutePath();
        try (ObjectOutputStream out = new ObjectOutputStream(new FileOutputStream(file));){
            out.writeObject(new Histogram(1, 0.0, 1.0, 1));
        }
        Assert.assertNotNull((Object)Utils.getHistogram((String)file));
    }

    @Test
    public void testGetHistogramInvalid() throws Exception {
        String file = folder.newFile("invalid.histogram").getAbsolutePath();
        try (ObjectOutputStream out = new ObjectOutputStream(new FileOutputStream(file));){
            out.writeObject(new PriorityQueue());
        }
        Assert.assertNull((Object)Utils.getHistogram((String)file));
    }

    @Test
    public void testLoadSampleImageValid() throws Exception {
        File file = folder.newFile("valid.sample.image").getAbsoluteFile();
        try (ObjectOutputStream out = new ObjectOutputStream(new FileOutputStream(file));){
            BufferedImage image = new BufferedImage(1, 1, 1);
            out.writeObject(new SampleImage(image.getSampleModel(), image.getColorModel()));
        }
        Assert.assertNotNull((Object)Utils.loadSampleImage((File)file));
    }

    @Test
    public void testLoadSampleImageInvalid() throws Exception {
        File file = folder.newFile("invalid.sample.image").getAbsoluteFile();
        try (ObjectOutputStream out = new ObjectOutputStream(new FileOutputStream(file));){
            out.writeObject(new PriorityQueue());
        }
        Assert.assertNull((Object)Utils.loadSampleImage((File)file));
    }

    @Test
    public void testLoadSampleImageSerializableRenderedImage() throws Exception {
        File file = folder.newFile("serializable.rendered.image").getAbsoluteFile();
        try (ObjectOutputStream out = new ObjectOutputStream(new FileOutputStream(file));){
            out.writeObject(new SerializableRenderedImage((RenderedImage)new BufferedImage(1, 1, 1)));
        }
        Assert.assertNull((Object)Utils.loadSampleImage((File)file));
        System.setProperty("org.geotools.gce.imagemosaic.sampleimage.allowlist", "^java\\.(net\\.InetAddress|util\\.Hashtable)$");
        Assert.assertNotNull((Object)Utils.resetSampleImageAllowlist());
        Assert.assertNotNull((Object)Utils.loadSampleImage((File)file));
        System.clearProperty("org.geotools.gce.imagemosaic.sampleimage.allowlist");
        Assert.assertNull((Object)Utils.resetSampleImageAllowlist());
        Assert.assertNotNull((Object)Utils.loadSampleImage((File)file));
    }
}

