/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.gce.imagemosaic.properties.time;

import java.io.File;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.Set;
import java.util.TimeZone;
import org.geotools.api.feature.simple.SimpleFeature;
import org.geotools.api.feature.simple.SimpleFeatureType;
import org.geotools.data.DataUtilities;
import org.geotools.feature.SchemaException;
import org.geotools.gce.imagemosaic.properties.PropertiesCollector;
import org.geotools.gce.imagemosaic.properties.PropertiesCollectorFinder;
import org.geotools.gce.imagemosaic.properties.PropertiesCollectorSPI;
import org.geotools.gce.imagemosaic.properties.time.TimestampFileNameExtractorSPI;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TimestampFileNameExtractorTest {
    private SimpleDateFormat df;
    private SimpleFeature feature;

    @Before
    public void setup() throws SchemaException {
        this.df = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");
        this.df.setTimeZone(TimeZone.getTimeZone("GMT"));
        SimpleFeatureType ft = DataUtilities.createType((String)"test", (String)"id:int,time:java.util.Date");
        this.feature = DataUtilities.createFeature((SimpleFeatureType)ft, (String)"1|null");
    }

    @Test
    public void testParseIsoTimestamp() {
        PropertiesCollectorSPI spi = this.getTimestampSpi();
        PropertiesCollector collector = spi.create((Object)"regex=[0-9]{8}T[0-9]{6}", Arrays.asList("time"));
        File file = new File("polyphemus_20130301T000000.nc");
        collector.collect(file);
        collector.setProperties(this.feature);
        Date time = (Date)this.feature.getAttribute("time");
        Assert.assertNotNull((Object)time);
        Assert.assertEquals((Object)"2013-03-01T00:00:00.000Z", (Object)this.df.format(time));
    }

    @Test
    public void testUnableToParse() {
        PropertiesCollectorSPI spi = this.getTimestampSpi();
        PropertiesCollector collector = spi.create((Object)"regex=[0-9]{8}T[0-9]{6}", Arrays.asList("time"));
        File file = new File("polyphemus_20130301T00000.nc");
        boolean parsed = true;
        try {
            collector.collect(file);
            collector.setProperties(this.feature);
        }
        catch (IllegalArgumentException ie) {
            parsed = false;
        }
        Assert.assertFalse((boolean)parsed);
    }

    @Test
    public void testParseCustomTimestamp() {
        PropertiesCollectorSPI spi = this.getTimestampSpi();
        PropertiesCollector collector = spi.create((Object)"regex=[0-9]{14},format=yyyyMMddHHmmss", Arrays.asList("time"));
        File file = new File("polyphemus_20130301000000.nc");
        collector.collect(file);
        collector.setProperties(this.feature);
        Date time = (Date)this.feature.getAttribute("time");
        Assert.assertNotNull((Object)time);
        Assert.assertEquals((Object)"2013-03-01T00:00:00.000Z", (Object)this.df.format(time));
    }

    @Test
    public void testParseCustomTimestampUseHighTime() {
        PropertiesCollectorSPI spi = this.getTimestampSpi();
        PropertiesCollector collector = spi.create((Object)"regex=[0-9]{10},format=yyyyMMddHH,useHighTime=true", Arrays.asList("time"));
        File file = new File("Temperature_2017111319.tif");
        collector.collect(file);
        collector.setProperties(this.feature);
        Date time = (Date)this.feature.getAttribute("time");
        Assert.assertNotNull((Object)time);
        Assert.assertEquals((Object)"2017-11-13T19:59:59.999Z", (Object)this.df.format(time));
    }

    @Test
    public void testParseFullPathTimestamp() {
        PropertiesCollectorSPI spi = this.getTimestampSpi();
        String regex = "(?:\\\\)(\\d{8})(?:\\\\)(?:file.)(T\\d{6})(?:.txt)";
        PropertiesCollector collector = spi.create((Object)("regex=" + regex + ",fullPath=true"), Arrays.asList("time"));
        File file = new File("c:\\data\\20120602\\file.T120000.txt");
        collector.collect(file);
        collector.setProperties(this.feature);
        Date time = (Date)this.feature.getAttribute("time");
        Assert.assertNotNull((Object)time);
        Assert.assertEquals((Object)"2012-06-02T12:00:00.000Z", (Object)this.df.format(time));
    }

    @Test
    public void testTimestampWithHighTimeRange() {
        PropertiesCollectorSPI spi = this.getTimestampSpi();
        PropertiesCollector collector = spi.create((Object)"regex=[0-9]{8},useHighTime=true", Arrays.asList("time"));
        File file = new File("polyphemus_20130301.nc");
        collector.collect(file);
        collector.setProperties(this.feature);
        Date time = (Date)this.feature.getAttribute("time");
        Assert.assertNotNull((Object)time);
        Assert.assertEquals((Object)"2013-03-01T23:59:59.999Z", (Object)this.df.format(time));
    }

    @Test
    public void testParseFullPathTimestampWithCustomFormat() {
        PropertiesCollectorSPI spi = this.getTimestampSpi();
        String regex = "(?:\\\\)(\\d{8})(?:\\\\)(?:file.)(t\\d{2}z)(?:.txt)";
        PropertiesCollector collector = spi.create((Object)("regex=" + regex + ",format=yyyyMMdd't'HH'z',fullPath=true"), Arrays.asList("time"));
        File file = new File("c:\\data\\20120602\\file.t12z.txt");
        collector.collect(file);
        collector.setProperties(this.feature);
        Date time = (Date)this.feature.getAttribute("time");
        Assert.assertNotNull((Object)time);
        Assert.assertEquals((Object)"2012-06-02T12:00:00.000Z", (Object)this.df.format(time));
    }

    @Test
    public void testParseFullPathTimestampWithCustomFormat2() {
        PropertiesCollectorSPI spi = this.getTimestampSpi();
        String regex = "(?:\\\\)(\\d{8})(?:\\\\)(?:file.)(t\\d{2}z)(?:.txt)";
        PropertiesCollector collector = spi.create((Object)("regex=" + regex + ",fullPath=true,format=yyyyMMdd't'HH'z'"), Arrays.asList("time"));
        File file = new File("c:\\data\\20120602\\file.t12z.txt");
        collector.collect(file);
        collector.setProperties(this.feature);
        Date time = (Date)this.feature.getAttribute("time");
        Assert.assertNotNull((Object)time);
        Assert.assertEquals((Object)"2012-06-02T12:00:00.000Z", (Object)this.df.format(time));
    }

    @Test
    public void testParseFullPathTimestampWithCustomFormatHighTimeRange() {
        PropertiesCollectorSPI spi = this.getTimestampSpi();
        String regex = "(?:\\\\)(\\d{8})(?:\\\\)(?:file.)(t\\d{2}z)(?:.txt)";
        PropertiesCollector collector = spi.create((Object)("regex=" + regex + ",fullPath=true,format=yyyyMMdd't'HH'z',useHighTime=true"), Arrays.asList("time"));
        File file = new File("c:\\data\\20120602\\file.t12z.txt");
        collector.collect(file);
        collector.setProperties(this.feature);
        Date time = (Date)this.feature.getAttribute("time");
        Assert.assertNotNull((Object)time);
        Assert.assertEquals((Object)"2012-06-02T12:59:59.999Z", (Object)this.df.format(time));
    }

    @Test
    public void testParseFullPathTimestampWithCustomFormatHighTimeRange2() {
        PropertiesCollectorSPI spi = this.getTimestampSpi();
        String regex = "(?:\\\\)(\\d{8})(?:\\\\)(?:file.)(t\\d{2}z)(?:.txt)";
        PropertiesCollector collector = spi.create((Object)("regex=" + regex + ",format=yyyyMMdd't'HH'z', useHighTime=true,   fullPath=true"), Arrays.asList("time"));
        File file = new File("c:\\data\\20120602\\file.t12z.txt");
        collector.collect(file);
        collector.setProperties(this.feature);
        Date time = (Date)this.feature.getAttribute("time");
        Assert.assertNotNull((Object)time);
        Assert.assertEquals((Object)"2012-06-02T12:59:59.999Z", (Object)this.df.format(time));
    }

    private PropertiesCollectorSPI getTimestampSpi() {
        Set spis = PropertiesCollectorFinder.getPropertiesCollectorSPI();
        for (PropertiesCollectorSPI spi : spis) {
            if (!spi.getName().equals(TimestampFileNameExtractorSPI.class.getSimpleName())) continue;
            return spi;
        }
        return null;
    }
}

