/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.gce.imagemosaic;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import it.geosolutions.imageio.pam.PAMDataset;
import it.geosolutions.imageio.pam.PAMParser;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.image.ColorModel;
import java.awt.image.IndexColorModel;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.media.jai.ImageLayout;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.geotools.api.coverage.grid.GridEnvelope;
import org.geotools.api.data.Query;
import org.geotools.api.data.Transaction;
import org.geotools.api.feature.FeatureVisitor;
import org.geotools.api.feature.simple.SimpleFeature;
import org.geotools.api.feature.simple.SimpleFeatureType;
import org.geotools.api.feature.type.AttributeDescriptor;
import org.geotools.api.filter.Filter;
import org.geotools.api.filter.FilterFactory;
import org.geotools.api.filter.PropertyIsEqualTo;
import org.geotools.api.filter.expression.Expression;
import org.geotools.api.filter.expression.PropertyName;
import org.geotools.api.filter.sort.SortBy;
import org.geotools.api.filter.sort.SortOrder;
import org.geotools.api.geometry.BoundingBox;
import org.geotools.api.geometry.Bounds;
import org.geotools.api.metadata.Identifier;
import org.geotools.api.parameter.GeneralParameterValue;
import org.geotools.api.parameter.ParameterDescriptor;
import org.geotools.api.referencing.FactoryException;
import org.geotools.api.referencing.ReferenceIdentifier;
import org.geotools.api.referencing.crs.CoordinateReferenceSystem;
import org.geotools.api.referencing.datum.PixelInCell;
import org.geotools.api.referencing.operation.MathTransform;
import org.geotools.api.referencing.operation.MathTransform2D;
import org.geotools.api.referencing.operation.TransformException;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.coverage.grid.GridCoverageFactory;
import org.geotools.coverage.grid.GridEnvelope2D;
import org.geotools.coverage.grid.io.AbstractGridCoverage2DReader;
import org.geotools.coverage.grid.io.AbstractGridFormat;
import org.geotools.coverage.grid.io.DecimationPolicy;
import org.geotools.coverage.grid.io.DefaultDimensionDescriptor;
import org.geotools.coverage.grid.io.DimensionDescriptor;
import org.geotools.coverage.grid.io.GranuleSource;
import org.geotools.coverage.grid.io.GridFormatFinder;
import org.geotools.coverage.grid.io.OverviewPolicy;
import org.geotools.coverage.grid.io.RenamingGranuleSource;
import org.geotools.coverage.grid.io.StructuredGridCoverage2DReader;
import org.geotools.coverage.util.CoverageUtilities;
import org.geotools.coverage.util.FeatureUtilities;
import org.geotools.data.DataUtilities;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.data.simple.SimpleFeatureIterator;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.visitor.CalcResult;
import org.geotools.feature.visitor.FeatureCalc;
import org.geotools.feature.visitor.MaxVisitor;
import org.geotools.feature.visitor.MinVisitor;
import org.geotools.feature.visitor.UniqueVisitor;
import org.geotools.filter.SortByImpl;
import org.geotools.gce.imagemosaic.ConvertersHack;
import org.geotools.gce.imagemosaic.DateRangeVisitor;
import org.geotools.gce.imagemosaic.DomainFilterBuilder;
import org.geotools.gce.imagemosaic.GranuleDescriptor;
import org.geotools.gce.imagemosaic.ImageMosaicReader;
import org.geotools.gce.imagemosaic.MosaicConfigurationBean;
import org.geotools.gce.imagemosaic.MosaicQueryBuilder;
import org.geotools.gce.imagemosaic.OverviewsController;
import org.geotools.gce.imagemosaic.PathType;
import org.geotools.gce.imagemosaic.RATCollectorListener;
import org.geotools.gce.imagemosaic.RangeVisitor;
import org.geotools.gce.imagemosaic.RasterLayerRequest;
import org.geotools.gce.imagemosaic.RasterLayerResponse;
import org.geotools.gce.imagemosaic.Utils;
import org.geotools.gce.imagemosaic.catalog.CatalogConfigurationBean;
import org.geotools.gce.imagemosaic.catalog.GranuleCatalog;
import org.geotools.gce.imagemosaic.catalog.GranuleCatalogSource;
import org.geotools.gce.imagemosaic.catalog.GranuleCatalogStore;
import org.geotools.gce.imagemosaic.catalog.GranuleCatalogVisitor;
import org.geotools.gce.imagemosaic.catalog.index.Indexer;
import org.geotools.gce.imagemosaic.catalog.index.IndexerUtils;
import org.geotools.gce.imagemosaic.granulecollector.DefaultSubmosaicProducerFactory;
import org.geotools.gce.imagemosaic.granulecollector.SubmosaicProducerFactory;
import org.geotools.gce.imagemosaic.granulecollector.SubmosaicProducerFactoryFinder;
import org.geotools.geometry.GeneralBounds;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.image.util.ImageUtilities;
import org.geotools.parameter.DefaultParameterDescriptor;
import org.geotools.referencing.CRS;
import org.geotools.referencing.operation.builder.GridToEnvelopeMapper;
import org.geotools.referencing.operation.transform.AffineTransform2D;
import org.geotools.referencing.operation.transform.IdentityTransform;
import org.geotools.referencing.operation.transform.ProjectiveTransform;
import org.geotools.renderer.crs.ProjectionHandler;
import org.geotools.renderer.crs.ProjectionHandlerFinder;
import org.geotools.util.URLs;
import org.geotools.util.Utilities;
import org.geotools.util.factory.Hints;
import org.geotools.util.logging.Logging;
import org.locationtech.jts.geom.Envelope;

public class RasterManager
implements Cloneable {
    final Hints excludeMosaicHints = new Hints((RenderingHints.Key)Utils.EXCLUDE_MOSAIC, (Object)true);
    LoadingCache<Integer, Boolean> alternativeCRSCache;
    public static final String ALTERNATIVE_CRS_CACHE_EXPIRATION_SECONDS_KEY = "org.geotools.imagemosaic.crscache.expiration.seconds";
    public static final String ALTERNATIVE_CRS_CACHE_SIZE_KEY = "org.geotools.imagemosaic.crscache.size";
    private static final int DEFAULT_ALTERNATIVE_CRS_CACHE_EXPIRATION_SECONDS = 60;
    private static final int DEFAULT_ALTERNATIVE_CRS_CACHE_SIZE = 150;
    private static final Integer ALTERNATIVE_CRS_CACHE_EXPIRATION_SECONDS = Integer.getInteger("org.geotools.imagemosaic.crscache.expiration.seconds", 60);
    private static final Integer ALTERNATIVE_CRS_CACHE_SIZE = Integer.getInteger("org.geotools.imagemosaic.crscache.size", 150);
    private SubmosaicProducerFactory submosaicProducerFactory = new DefaultSubmosaicProducerFactory();
    private PAMDataset pamDataset;
    private static final Logger LOGGER = Logging.getLogger(RasterManager.class);
    private GridCoverageFactory coverageFactory;
    ColorModel defaultCM;
    SampleModel defaultSM;
    byte[][] defaultPalette;
    private String coverageIdentifier;
    private Hints hints;
    OverviewsController overviewsController;
    OverviewPolicy overviewPolicy;
    DecimationPolicy decimationPolicy;
    private PathType pathType;
    boolean expandMe;
    boolean heterogeneousGranules;
    boolean heterogeneousCRS;
    double[][] levels;
    SpatialDomainManager spatialDomainManager;
    ImageLayout defaultImageLayout;
    DomainManager domainsManager;
    DomainManager elevationDomainManager;
    DomainManager timeDomainManager;
    volatile boolean enableEvents = false;
    List<DimensionDescriptor> dimensionDescriptors = new ArrayList<DimensionDescriptor>();
    ImageMosaicReader parentReader;
    GranuleCatalog granuleCatalog;
    GranuleSource granuleSource;
    String typeName;
    String name;
    Bounds imposedEnvelope;
    MosaicConfigurationBean configuration;
    String[] providedBandsNames = null;

    public RasterManager(ImageMosaicReader parentReader, MosaicConfigurationBean configuration) throws IOException {
        Utilities.ensureNonNull((String)"ImageMosaicReader", (Object)((Object)parentReader));
        Utilities.ensureNonNull((String)"MosaicConfigurationBean", (Object)configuration);
        this.parentReader = parentReader;
        this.expandMe = configuration.isExpandToRGB();
        boolean checkAuxiliaryMetadata = configuration.isCheckAuxiliaryMetadata();
        this.heterogeneousGranules = configuration.getCatalogConfigurationBean().isHeterogeneous();
        this.heterogeneousCRS = configuration.getCatalogConfigurationBean().isHeterogeneousCRS();
        this.configuration = configuration;
        this.hints = parentReader.getHints();
        this.name = configuration.getName();
        this.updateHints(this.hints, configuration, parentReader);
        if (checkAuxiliaryMetadata) {
            this.hints.add(new RenderingHints((RenderingHints.Key)Utils.CHECK_AUXILIARY_METADATA, checkAuxiliaryMetadata));
        }
        this.granuleCatalog = parentReader.granuleCatalog;
        this.coverageFactory = parentReader.getGridCoverageFactory();
        this.coverageIdentifier = configuration.getName();
        this.pathType = configuration.getCatalogConfigurationBean().getPathType();
        this.extractOverviewPolicy();
        this.extractDecimationPolicy();
        this.loadSampleImage(configuration);
        this.loadPamDataset(configuration);
        CatalogConfigurationBean catalogBean = configuration.getCatalogConfigurationBean();
        this.typeName = catalogBean != null ? catalogBean.getTypeName() : null;
        this.initDomains(configuration);
        if (this.defaultSM == null) {
            this.defaultSM = configuration.getSampleModel();
        }
        if (this.defaultCM == null) {
            this.defaultCM = configuration.getColorModel();
        }
        if (this.defaultPalette == null) {
            this.defaultPalette = configuration.getPalette();
        }
        if (this.defaultSM != null && this.defaultCM != null && this.defaultImageLayout == null) {
            this.defaultImageLayout = new ImageLayout().setColorModel(this.defaultCM).setSampleModel(this.defaultSM);
        }
        this.levels = configuration.getLevels();
        double[] highRes = this.levels[0];
        int numOverviews = configuration.getLevelsNum() - 1;
        double[][] overviews = null;
        if (numOverviews > 0) {
            overviews = new double[numOverviews][2];
            for (int i = 0; i < numOverviews; ++i) {
                overviews[i][0] = this.levels[i + 1][0];
                overviews[i][1] = this.levels[i + 1][1];
            }
        }
        this.overviewsController = new OverviewsController(highRes, numOverviews, overviews);
        this.imposedEnvelope = configuration.getEnvelope();
        if (configuration.getIndexer() != null) {
            String submosaickerFactory;
            Indexer indexer = configuration.getIndexer();
            if (indexer.getMultipleBandsDimensions() != null && indexer.getMultipleBandsDimensions().getMultipleBandsDimension() != null && !indexer.getMultipleBandsDimensions().getMultipleBandsDimension().isEmpty()) {
                List<Indexer.MultipleBandsDimensions.MultipleBandsDimension> multipleBandsDimensions = indexer.getMultipleBandsDimensions().getMultipleBandsDimension();
                if (multipleBandsDimensions.size() != 1) {
                    throw new IllegalStateException("Only a single dimension with multiple bands is supported.");
                }
                this.providedBandsNames = multipleBandsDimensions.get(0).getBandsNames().split("\\s*,\\s*");
            }
            if ((submosaickerFactory = IndexerUtils.getParameter("GranuleCollectorFactory", indexer)) != null) {
                SubmosaicProducerFactory submosaicProducerFactory = SubmosaicProducerFactoryFinder.getGranuleHandlersSPI().get(submosaickerFactory);
                if (submosaicProducerFactory != null) {
                    this.submosaicProducerFactory = submosaicProducerFactory;
                } else {
                    LOGGER.warning("Found SubmosaicProducerFactory config in the Image Mosaic indexer, however the specified factory (" + submosaickerFactory + ") could not be found. This may mean the indexer.properties or indexer.xmlis misconfigured");
                }
            }
        }
        if (this.heterogeneousCRS) {
            CacheLoader<Integer, Boolean> loader = new CacheLoader<Integer, Boolean>(){

                public Boolean load(Integer epsgCode) throws Exception {
                    Query query = new Query(RasterManager.this.typeName);
                    String crsAttribute = RasterManager.this.getCrsAttribute();
                    query.setPropertyNames(Arrays.asList(crsAttribute));
                    FilterFactory ff = FeatureUtilities.DEFAULT_FILTER_FACTORY;
                    query.setFilter((Filter)ff.equals((Expression)ff.property(crsAttribute), (Expression)ff.literal((Object)("EPSG:" + epsgCode))));
                    query.setMaxFeatures(1);
                    SimpleFeature first = (SimpleFeature)DataUtilities.first((FeatureCollection)RasterManager.this.granuleCatalog.getGranules(query));
                    return first != null;
                }
            };
            this.alternativeCRSCache = CacheBuilder.newBuilder().maximumSize((long)ALTERNATIVE_CRS_CACHE_SIZE.intValue()).expireAfterWrite((long)ALTERNATIVE_CRS_CACHE_EXPIRATION_SECONDS.intValue(), TimeUnit.SECONDS).build((CacheLoader)loader);
        }
    }

    private void updateHints(Hints hints, MosaicConfigurationBean configuration, ImageMosaicReader parentReader) {
        if (configuration != null) {
            String auxiliaryFilePath = configuration.getAuxiliaryFilePath();
            String auxiliaryDatastorePath = configuration.getAuxiliaryDatastorePath();
            boolean update = false;
            if (auxiliaryFilePath != null) {
                hints.add(new RenderingHints((RenderingHints.Key)Utils.AUXILIARY_FILES_PATH, auxiliaryFilePath));
                update = true;
            }
            if (auxiliaryDatastorePath != null) {
                hints.add(new RenderingHints((RenderingHints.Key)Utils.AUXILIARY_DATASTORE_PATH, auxiliaryDatastorePath));
                update = true;
            }
            if (update && !hints.containsKey((Object)Utils.PARENT_DIR)) {
                String parentDir = null;
                if (parentReader.parentDirectory != null) {
                    parentDir = parentReader.parentDirectory.getAbsolutePath();
                } else {
                    Object source = parentReader.getSource();
                    if (source != null && source instanceof File && ((File)source).isDirectory()) {
                        parentDir = ((File)source).getAbsolutePath();
                    }
                }
                if (parentDir != null) {
                    hints.add(new RenderingHints((RenderingHints.Key)Utils.PARENT_DIR, parentDir));
                }
            }
        }
    }

    private void initDomains(MosaicConfigurationBean configuration) throws IOException {
        SimpleFeatureType schema;
        this.checkTypeName();
        if (this.typeName != null && (schema = this.granuleCatalog.getType(this.typeName)) != null) {
            String elevationAttribute;
            String timeDomain;
            String additionalDomainConfig = configuration.getAdditionalDomainAttributes();
            if (additionalDomainConfig != null && this.domainsManager == null) {
                this.domainsManager = new DomainManager(additionalDomainConfig, schema);
                this.dimensionDescriptors.addAll(this.domainsManager.dimensions);
            }
            if ((timeDomain = configuration.getTimeAttribute()) != null && this.timeDomainManager == null) {
                HashMap<String, String> init = new HashMap<String, String>();
                init.put("TIME", timeDomain);
                this.timeDomainManager = new DomainManager(init, schema);
                this.dimensionDescriptors.addAll(this.timeDomainManager.dimensions);
            }
            if ((elevationAttribute = configuration.getElevationAttribute()) != null && this.elevationDomainManager == null) {
                HashMap<String, String> init = new HashMap<String, String>();
                init.put("ELEVATION", elevationAttribute);
                this.elevationDomainManager = new DomainManager(init, schema);
                this.dimensionDescriptors.addAll(this.elevationDomainManager.dimensions);
            }
            this.addExtraAttribute(schema, configuration.getCRSAttribute(), "CRS");
            this.addExtraAttribute(schema, configuration.getResolutionAttribute(), "RESOLUTION");
            this.addExtraAttribute(schema, configuration.getResolutionXAttribute(), "RESOLUTION_X");
            this.addExtraAttribute(schema, configuration.getResolutionYAttribute(), "RESOLUTION_Y");
        }
    }

    private void addExtraAttribute(SimpleFeatureType schema, String attributeName, String domainName) {
        if (attributeName != null) {
            if (this.domainsManager == null) {
                this.domainsManager = new DomainManager(Collections.singletonMap(domainName, attributeName), schema);
                this.dimensionDescriptors.addAll(this.domainsManager.dimensions);
            } else {
                DimensionDescriptor crsDimension = this.domainsManager.addDimension("crs", attributeName);
                if (!this.dimensionDescriptors.stream().anyMatch(dd -> "crs".equalsIgnoreCase(dd.getName()))) {
                    this.dimensionDescriptors.add(crsDimension);
                }
            }
        }
    }

    private void checkTypeName() throws IOException {
        if (this.typeName == null) {
            URL sourceURL = this.parentReader.sourceURL;
            this.typeName = sourceURL.getPath().endsWith("shp") ? FilenameUtils.getBaseName((String)URLs.urlToFile((URL)sourceURL).getCanonicalPath()) : this.configuration.getName();
        }
        if (this.typeName == null && this.granuleCatalog != null) {
            String[] typeNames = this.granuleCatalog.getTypeNames();
            this.typeName = typeNames != null && typeNames.length > 0 ? typeNames[0] : null;
        }
    }

    private void loadPamDataset(MosaicConfigurationBean configuration) {
        if (this.parentReader.sourceURL == null) {
            return;
        }
        File pamDatasetFile = this.getPamDatasetFile(configuration);
        if (pamDatasetFile == null || !pamDatasetFile.exists()) {
            return;
        }
        try {
            PAMParser parser = new PAMParser();
            this.pamDataset = parser.parsePAM(pamDatasetFile);
        }
        catch (IOException e) {
            LOGGER.warning("Failed to load PAM dataset: " + e);
        }
    }

    private File getPamDatasetFile(MosaicConfigurationBean configuration) {
        String name;
        URL baseURL = this.parentReader.sourceURL;
        File baseFile = URLs.urlToFile((URL)baseURL);
        if (baseFile == null) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("Unable to find PAM dataset for path " + baseURL);
            }
            return null;
        }
        String baseName = baseFile.getParent() + "/";
        String fileName = null;
        File pamDatasetFile = null;
        if (configuration != null && (name = configuration.getName()) != null) {
            fileName = baseName + name + ".aux.xml";
            pamDatasetFile = new File(fileName);
        }
        if (pamDatasetFile == null) {
            pamDatasetFile = new File(baseName + ".aux.xml");
        }
        return pamDatasetFile;
    }

    private void loadSampleImage(MosaicConfigurationBean configuration) {
        RenderedImage sampleImage;
        String name;
        if (this.parentReader.sourceURL == null) {
            return;
        }
        URL baseURL = this.parentReader.sourceURL;
        File baseFile = URLs.urlToFile((URL)baseURL);
        if (baseFile == null) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("Unable to find sample image for path " + baseURL);
            }
            return;
        }
        String baseName = baseFile.getParent() + "/";
        String fileName = null;
        File sampleImageFile = null;
        if (!(configuration == null || (name = configuration.getName()) == null || (sampleImageFile = new File(fileName = baseName + name + "sample_image.dat")).exists() && sampleImageFile.canRead() || (sampleImageFile = new File(fileName = baseName + name + "sample_image")).exists() && sampleImageFile.canRead())) {
            sampleImageFile = null;
        }
        if (sampleImageFile == null && !(sampleImageFile = new File(baseName + "sample_image.dat")).exists()) {
            sampleImageFile = new File(baseName + "sample_image");
        }
        if ((sampleImage = Utils.loadSampleImage(sampleImageFile)) != null) {
            this.defaultCM = sampleImage.getColorModel();
            this.defaultSM = sampleImage.getSampleModel();
            if (this.defaultCM instanceof IndexColorModel) {
                this.defaultPalette = Utils.extractPalette((IndexColorModel)this.defaultCM);
            }
            this.defaultImageLayout = new ImageLayout().setColorModel(this.defaultCM).setSampleModel(this.defaultSM);
        } else if (LOGGER.isLoggable(Level.WARNING)) {
            LOGGER.warning("Unable to find sample image for path " + baseURL);
        }
    }

    private OverviewPolicy extractOverviewPolicy() {
        this.overviewPolicy = (OverviewPolicy)Utils.getHintIfAvailable((RenderingHints)this.hints, (RenderingHints.Key)Hints.OVERVIEW_POLICY);
        if (this.overviewPolicy == null) {
            this.overviewPolicy = OverviewPolicy.getDefaultPolicy();
        }
        assert (this.overviewPolicy != null);
        return this.overviewPolicy;
    }

    private DecimationPolicy extractDecimationPolicy() {
        this.decimationPolicy = (DecimationPolicy)Utils.getHintIfAvailable((RenderingHints)this.hints, (RenderingHints.Key)Hints.DECIMATION_POLICY);
        if (this.decimationPolicy == null) {
            this.decimationPolicy = DecimationPolicy.getDefaultPolicy();
        }
        assert (this.decimationPolicy != null);
        return this.decimationPolicy;
    }

    public Collection<GridCoverage2D> read(GeneralParameterValue[] params) throws IOException {
        RasterLayerRequest request = new RasterLayerRequest(params, this);
        if (request.isEmpty()) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.log(Level.FINE, "Request is empty: " + request.toString());
            }
            return Collections.emptyList();
        }
        RasterLayerResponse response = new RasterLayerResponse(request, this, this.submosaicProducerFactory);
        GridCoverage2D elem = response.createResponse();
        if (elem != null) {
            return Collections.singletonList(elem);
        }
        return Collections.emptyList();
    }

    void getGranuleDescriptors(Query q, GranuleCatalogVisitor visitor) throws IOException {
        this.granuleCatalog.getGranuleDescriptors(q, visitor);
    }

    public PathType getPathType() {
        return this.pathType;
    }

    public String getCoverageIdentifier() {
        return this.coverageIdentifier;
    }

    public Hints getHints() {
        return this.hints;
    }

    public GridCoverageFactory getCoverageFactory() {
        return this.coverageFactory;
    }

    public String getTypeName() {
        return this.typeName;
    }

    FeatureCalc createExtremaQuery(String metadataName, String attributeName) throws IOException {
        Query query = new Query(this.typeName);
        query.setPropertyNames(Arrays.asList(attributeName));
        MaxVisitor visitor = metadataName.toLowerCase().endsWith("maximum") ? new MaxVisitor(attributeName) : new MinVisitor(attributeName);
        this.granuleCatalog.computeAggregateFunction(query, (FeatureCalc)visitor);
        return visitor;
    }

    Set extractDomain(String attribute) throws IOException {
        Query query = new Query(this.typeName);
        query.setPropertyNames(Arrays.asList(attribute));
        UniqueVisitor visitor = new UniqueVisitor(new String[]{attribute});
        this.granuleCatalog.computeAggregateFunction(query, (FeatureCalc)visitor);
        return visitor.getUnique();
    }

    private Set extractDomain(String attribute, String secondAttribute, DomainType domainType) throws IOException {
        Query query = new Query(this.typeName);
        PropertyName propertyName = FeatureUtilities.DEFAULT_FILTER_FACTORY.property(attribute);
        query.setPropertyNames(Arrays.asList(attribute, secondAttribute));
        Object[] sb = new SortByImpl[]{new SortByImpl(propertyName, SortOrder.ASCENDING)};
        if (this.granuleCatalog.getQueryCapabilities(this.typeName).supportsSorting((SortBy[])sb)) {
            query.setSortBy((SortBy[])sb);
        } else {
            LOGGER.severe("Sorting parameter ignored, underlying datastore cannot sort on " + Arrays.toString(sb));
        }
        RangeVisitor visitor = domainType == DomainType.TIME_RANGE ? new DateRangeVisitor(attribute, secondAttribute) : new RangeVisitor(attribute, secondAttribute);
        this.granuleCatalog.computeAggregateFunction(query, visitor);
        return domainType == DomainType.TIME_RANGE ? visitor.getRange() : ((RangeVisitor)visitor).getRange();
    }

    public boolean hasAlternativeCRS(Integer epsgCode) throws IOException {
        try {
            return epsgCode != null && this.heterogeneousCRS ? (Boolean)this.alternativeCRSCache.get((Object)epsgCode) : false;
        }
        catch (ExecutionException e) {
            throw new IOException("Exception Occurred while checking for alternative CRS:" + epsgCode, e);
        }
    }

    public GranuleCatalog getGranuleCatalog() {
        return this.granuleCatalog;
    }

    public void createStore(SimpleFeatureType indexSchema) throws IOException {
        SimpleFeatureType type;
        String typeName = indexSchema.getTypeName();
        SimpleFeatureType simpleFeatureType = type = typeName != null ? this.granuleCatalog.getType(typeName) : null;
        if (type == null) {
            this.granuleCatalog.createType(indexSchema);
            this.typeName = typeName;
        } else {
            if (this.typeName == null) {
                this.typeName = typeName;
            }
            Query query = new Query(type.getTypeName());
            query.setFilter((Filter)Filter.INCLUDE);
            this.granuleCatalog.removeGranules(query, Transaction.AUTO_COMMIT);
        }
    }

    public void removeStore(String typeName, boolean forceDelete, boolean checkForReferences) throws IOException {
        Utilities.ensureNonNull((String)"typeName", (Object)typeName);
        if (typeName != null) {
            Query query = new Query(typeName);
            query.setFilter((Filter)Filter.INCLUDE);
            this.cleanupGranules(query, checkForReferences, forceDelete);
            this.granuleCatalog.removeGranules(query, Transaction.AUTO_COMMIT);
            this.granuleCatalog.removeType(typeName);
        }
        if (this.alternativeCRSCache != null) {
            this.alternativeCRSCache.invalidateAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cleanupGranules(Query query, boolean checkForReferences, boolean deleteData) throws IOException {
        SimpleFeatureCollection collection = this.granuleCatalog.getGranules(query);
        UniqueVisitor visitor = new UniqueVisitor(new String[]{this.parentReader.locationAttributeName});
        collection.accepts((FeatureVisitor)visitor, null);
        Set features = visitor.getUnique();
        String coverageName = query.getTypeName();
        for (String feature : features) {
            AbstractGridFormat format;
            URL rasterPath = this.pathType.resolvePath(URLs.fileToUrl((File)this.parentReader.parentDirectory).toString(), feature);
            boolean delete = true;
            if (checkForReferences) {
                boolean bl = delete = !this.checkForReferences(coverageName);
            }
            if ((format = GridFormatFinder.findFormat((Object)rasterPath, (Hints)this.excludeMosaicHints)) == null) continue;
            AbstractGridCoverage2DReader coverageReader = null;
            try {
                coverageReader = format.getReader((Object)rasterPath, this.hints);
                if (coverageReader instanceof StructuredGridCoverage2DReader) {
                    StructuredGridCoverage2DReader reader = (StructuredGridCoverage2DReader)coverageReader;
                    if (delete) {
                        reader.delete(deleteData);
                        continue;
                    }
                    reader.removeCoverage(coverageName, false);
                    continue;
                }
                if (!deleteData) continue;
                FileUtils.deleteQuietly((File)URLs.urlToFile((URL)rasterPath));
            }
            finally {
                if (coverageReader == null) continue;
                try {
                    coverageReader.dispose();
                }
                catch (Throwable throwable) {}
            }
        }
        if (this.alternativeCRSCache != null) {
            this.alternativeCRSCache.invalidateAll();
        }
    }

    private boolean checkForReferences(String coverageName) throws IOException {
        String[] coverageNames;
        for (String typeName : coverageNames = this.parentReader.getGridCoverageNames()) {
            if (coverageName.equalsIgnoreCase(typeName)) continue;
            Query query = new Query(typeName);
            SimpleFeatureCollection collection = this.granuleCatalog.getGranules(query);
            UniqueVisitor visitor = new UniqueVisitor(new String[]{this.parentReader.locationAttributeName});
            collection.accepts((FeatureVisitor)visitor, null);
            Set features = visitor.getUnique();
            if (features.isEmpty()) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GranuleSource getGranuleSource(boolean readOnly, Hints hints) {
        RasterManager rasterManager = this;
        synchronized (rasterManager) {
            if (readOnly) {
                if (this.granuleSource == null) {
                    this.granuleSource = new GranuleCatalogSource(this, this.granuleCatalog, this.typeName, hints);
                    if (!this.typeName.equalsIgnoreCase(this.name)) {
                        this.granuleSource = new RenamingGranuleSource(this.name, this.granuleSource);
                    }
                }
                return this.granuleSource;
            }
            return new GranuleCatalogStore(this, this.granuleCatalog, this.typeName, hints);
        }
    }

    public List<DimensionDescriptor> getDimensionDescriptors() {
        return this.dimensionDescriptors;
    }

    public MosaicConfigurationBean getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(MosaicConfigurationBean configuration) {
        this.configuration = configuration;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        RasterManager rasterManager = this;
        synchronized (rasterManager) {
            try {
                if (this.granuleCatalog != null) {
                    this.granuleCatalog.dispose();
                }
                if (this.alternativeCRSCache != null) {
                    this.alternativeCRSCache.invalidateAll();
                }
            }
            catch (Exception e) {
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.log(Level.FINE, e.getLocalizedMessage(), e);
                }
            }
            finally {
                if (this.granuleSource != null) {
                    this.granuleSource = null;
                }
                if (this.granuleCatalog != null) {
                    this.granuleCatalog = null;
                }
            }
        }
    }

    public void initialize(boolean checkDomains) throws IOException {
        this.initialize(checkDomains, Transaction.AUTO_COMMIT);
    }

    public void initialize(boolean checkDomains, Transaction transaction) throws IOException {
        BoundingBox bounds = this.granuleCatalog.getBounds(this.typeName, transaction);
        if (checkDomains) {
            this.initDomains(this.configuration);
        }
        CoordinateReferenceSystem crs = bounds.getCoordinateReferenceSystem();
        GeneralBounds originalEnvelope = null;
        if (this.imposedEnvelope == null) {
            originalEnvelope = new GeneralBounds((Bounds)bounds);
        } else {
            originalEnvelope = new GeneralBounds(this.imposedEnvelope);
            originalEnvelope.setCoordinateReferenceSystem(crs);
        }
        OverviewsController.OverviewLevel highResOvLevel = this.overviewsController.resolutionsLevels.get(0);
        double[] highestRes = new double[]{highResOvLevel.resolutionX, highResOvLevel.resolutionY};
        GridEnvelope2D originalGridRange = new GridEnvelope2D(new Rectangle((int)(originalEnvelope.getSpan(0) / highestRes[0]), (int)(originalEnvelope.getSpan(1) / highestRes[1])));
        AffineTransform2D raster2Model = new AffineTransform2D(highestRes[0], 0.0, 0.0, -highestRes[1], originalEnvelope.getLowerCorner().getOrdinate(0) + 0.5 * highestRes[0], originalEnvelope.getUpperCorner().getOrdinate(1) - 0.5 * highestRes[1]);
        try {
            this.spatialDomainManager = new SpatialDomainManager(originalEnvelope, originalGridRange, crs, (MathTransform)raster2Model, this.overviewsController);
        }
        catch (FactoryException | TransformException e) {
            throw new IOException("Exception occurred while initializing the SpatialDomainManager", e);
        }
        if (this.alternativeCRSCache != null) {
            this.alternativeCRSCache.invalidateAll();
        }
    }

    String[] getMetadataNames() {
        ArrayList<String> metadataNames = new ArrayList<String>();
        metadataNames.add("TIME_DOMAIN");
        metadataNames.add("HAS_TIME_DOMAIN");
        metadataNames.add("TIME_DOMAIN_MINIMUM");
        metadataNames.add("TIME_DOMAIN_MAXIMUM");
        metadataNames.add("TIME_DOMAIN_RESOLUTION");
        metadataNames.add("TIME_DOMAIN_DATATYPE");
        metadataNames.add("ELEVATION_DOMAIN");
        metadataNames.add("ELEVATION_DOMAIN_MINIMUM");
        metadataNames.add("ELEVATION_DOMAIN_MAXIMUM");
        metadataNames.add("HAS_ELEVATION_DOMAIN");
        metadataNames.add("ELEVATION_DOMAIN_RESOLUTION");
        metadataNames.add("ELEVATION_DOMAIN_DATATYPE");
        if (this.domainsManager != null) {
            metadataNames.addAll(this.domainsManager.getMetadataNames());
        }
        metadataNames.add("MultiCRSReader");
        return metadataNames.toArray(new String[metadataNames.size()]);
    }

    public ColorModel getDefaultCM() {
        return this.defaultCM;
    }

    String getMetadataValue(String name) {
        boolean hasElevationDomain;
        String value = null;
        boolean hasTimeDomain = this.timeDomainManager != null;
        boolean bl = hasElevationDomain = this.elevationDomainManager != null;
        if (name.equalsIgnoreCase("HAS_ELEVATION_DOMAIN")) {
            return String.valueOf(hasElevationDomain);
        }
        if (name.equalsIgnoreCase("HAS_TIME_DOMAIN")) {
            return String.valueOf(hasTimeDomain);
        }
        if (name.equalsIgnoreCase("TIME_DOMAIN_RESOLUTION")) {
            return null;
        }
        if (name.equalsIgnoreCase("ELEVATION_DOMAIN_RESOLUTION")) {
            return null;
        }
        if (hasTimeDomain) {
            if (name.equalsIgnoreCase("time_domain")) {
                return this.timeDomainManager.getMetadataValue(name);
            }
            if (name.equalsIgnoreCase("time_domain_minimum") || name.equalsIgnoreCase("time_domain_maximum")) {
                return this.timeDomainManager.getMetadataValue(name);
            }
            if (name.equalsIgnoreCase("time_domain_datatype")) {
                return this.timeDomainManager.getMetadataValue(name);
            }
        }
        if (hasElevationDomain) {
            if (name.equalsIgnoreCase("elevation_domain")) {
                return this.elevationDomainManager.getMetadataValue(name);
            }
            if (name.equalsIgnoreCase("elevation_domain_minimum") || name.equalsIgnoreCase("elevation_domain_maximum")) {
                return this.elevationDomainManager.getMetadataValue(name);
            }
            if (name.equalsIgnoreCase("elevation_domain_datatype")) {
                return this.elevationDomainManager.getMetadataValue(name);
            }
        }
        if (name.equalsIgnoreCase("MultiCRSReader")) {
            return String.valueOf(this.heterogeneousCRS);
        }
        if (name.equalsIgnoreCase("MultiCRSEPSGCodes") && this.heterogeneousCRS) {
            String crsAttribute = null;
            try {
                crsAttribute = this.getCrsAttribute();
                if (crsAttribute != null) {
                    Set crsSet = this.extractDomain(crsAttribute);
                    for (String crs : crsSet) {
                        String epsgCode = crs.replaceAll("[^0-9,]", "");
                        this.alternativeCRSCache.put((Object)Integer.valueOf(epsgCode), (Object)true);
                    }
                    return String.join((CharSequence)",", crsSet);
                }
            }
            catch (IOException e) {
                if (LOGGER.isLoggable(Level.WARNING)) {
                    LOGGER.log(Level.WARNING, "Unable to retrieve the list of supported CRSs", e);
                }
                return "";
            }
        }
        if (this.domainsManager != null) {
            return this.domainsManager.getMetadataValue(name);
        }
        return value;
    }

    public byte[][] getDefaultPalette() {
        return this.defaultPalette;
    }

    public DomainManager getDomainsManager() {
        return this.domainsManager;
    }

    public boolean isExpandMe() {
        return this.expandMe;
    }

    public ImageMosaicReader getParentReader() {
        return this.parentReader;
    }

    public RasterManager getForGranuleCRS(RasterLayerRequest request, GranuleDescriptor templateDescriptor, ReferencedEnvelope requestBounds, ReferencedEnvelope requestBoundsQuery) throws Exception {
        CoordinateReferenceSystem referenceCRS;
        CoordinateReferenceSystem granuleCRS = templateDescriptor.getGranuleEnvelope().getCoordinateReferenceSystem();
        CoordinateReferenceSystem requestedCRS = requestBounds.getCoordinateReferenceSystem();
        boolean useAlternativeCRS = this.heterogeneousCRS && !requestBounds.equals((Object)requestBoundsQuery) && this.hasAlternativeCRS(CRS.lookupEpsgCode((CoordinateReferenceSystem)requestedCRS, (boolean)false));
        CoordinateReferenceSystem coordinateReferenceSystem = referenceCRS = useAlternativeCRS ? requestedCRS : this.spatialDomainManager.coverageCRS2D;
        if (CRS.equalsIgnoreMetadata((Object)referenceCRS, (Object)granuleCRS)) {
            return this;
        }
        ReferencedEnvelope bounds = this.getBoundsForGranuleCRS(request, templateDescriptor, requestBoundsQuery);
        ReferencedEnvelope targetBounds = this.reprojectBounds(requestBounds, granuleCRS, bounds);
        RasterManager reprojected = (RasterManager)this.clone();
        reprojected.configuration = new MosaicConfigurationBean(this.configuration);
        reprojected.configuration.setCrs(granuleCRS);
        if (useAlternativeCRS) {
            reprojected.heterogeneousCRS = false;
        }
        reprojected.configuration.setEnvelope(targetBounds);
        if (reprojected.imposedEnvelope != null) {
            reprojected.imposedEnvelope = targetBounds;
        }
        if (templateDescriptor.getOverviewsController() != null) {
            reprojected.overviewsController = templateDescriptor.getOverviewsController();
        }
        OverviewsController.OverviewLevel level = templateDescriptor.getOverviewsController().getLevel(0);
        double[] highestRes = new double[]{level.resolutionX, level.resolutionY};
        GridEnvelope2D originalGridRange = new GridEnvelope2D(new Rectangle((int)(targetBounds.getSpan(0) / highestRes[0]), (int)(targetBounds.getSpan(1) / highestRes[1])));
        AffineTransform2D raster2Model = new AffineTransform2D(highestRes[0], 0.0, 0.0, -highestRes[1], targetBounds.getLowerCorner().getOrdinate(0) + 0.5 * highestRes[0], targetBounds.getUpperCorner().getOrdinate(1) - 0.5 * highestRes[1]);
        reprojected.spatialDomainManager = new SpatialDomainManager(new GeneralBounds((Bounds)targetBounds), originalGridRange, granuleCRS, (MathTransform)raster2Model, reprojected.overviewsController);
        return reprojected;
    }

    private ReferencedEnvelope reprojectBounds(ReferencedEnvelope referenceBounds, CoordinateReferenceSystem targetCRS, ReferencedEnvelope bounds) throws FactoryException, TransformException {
        ProjectionHandler ph = ProjectionHandlerFinder.getHandler((ReferencedEnvelope)referenceBounds, (CoordinateReferenceSystem)targetCRS, (boolean)true);
        ReferencedEnvelope targetBounds = null;
        if (ph != null) {
            List queryEnvelopes = ph.getQueryEnvelopes();
            for (ReferencedEnvelope envelope : queryEnvelopes) {
                ReferencedEnvelope transformed = envelope.transform(targetCRS, true);
                if (targetBounds == null) {
                    targetBounds = transformed;
                    continue;
                }
                targetBounds.expandToInclude((Envelope)transformed);
            }
        } else {
            targetBounds = bounds.transform(targetCRS, true);
        }
        return targetBounds;
    }

    private ReferencedEnvelope getBoundsForGranuleCRS(RasterLayerRequest request, GranuleDescriptor templateDescriptor, ReferencedEnvelope requestBounds) throws IOException, FactoryException, TransformException {
        String crsAttribute = this.getCrsAttribute();
        if (crsAttribute == null) {
            throw new IllegalStateException("Invalid heterogeneous mosaic configuration, the 'crs' property is missing from the index schema");
        }
        Object granuleCRSCode = Utils.getAttribute(templateDescriptor.getOriginator(), crsAttribute);
        FilterFactory ff = FeatureUtilities.DEFAULT_FILTER_FACTORY;
        PropertyIsEqualTo crsFilter = ff.equal((Expression)ff.property(crsAttribute), (Expression)ff.literal(granuleCRSCode), false);
        GranuleSource granuleSource = this.getGranuleSource(true, null);
        MosaicQueryBuilder builder = new MosaicQueryBuilder(request, requestBounds);
        Query q = builder.build();
        q.setFilter((Filter)ff.and(q.getFilter(), (Filter)crsFilter));
        SimpleFeatureCollection granules = granuleSource.getGranules(q);
        ReferencedEnvelope bounds = granules.getBounds();
        return bounds;
    }

    public String getCrsAttribute() throws IOException {
        GranuleSource granuleSource;
        String crsAttribute = this.configuration.getCRSAttribute();
        if (crsAttribute == null) {
            crsAttribute = "crs";
        }
        if ((granuleSource = this.getGranuleSource(true, null)).getSchema().getDescriptor(crsAttribute) == null) {
            if (this.heterogeneousCRS) {
                throw new IllegalStateException("Invalid heterogeneous mosaic configuration, the 'crs' property is missing from the index schema");
            }
            return null;
        }
        return crsAttribute;
    }

    public String getParentLocation() {
        return URLs.fileToUrl((File)this.getParentReader().parentDirectory).toString();
    }

    public String getLocationAttribute() {
        return this.getParentReader().locationAttributeName;
    }

    public String getName() {
        return this.name;
    }

    public PAMDataset getPamDataset() {
        return this.pamDataset;
    }

    public void reloadPamDataset() throws IOException {
        Query query = new Query(this.typeName);
        SimpleFeatureCollection granules = this.getGranuleCatalog().getGranules(query);
        File pamDatasetFile = this.getPamDatasetFile(this.configuration);
        RATCollectorListener ratCollector = new RATCollectorListener(pamDatasetFile);
        GranuleDescriptor.PathResolver pathResolver = new GranuleDescriptor.PathResolver(this.pathType, this.getParentLocation());
        try (SimpleFeatureIterator it = granules.features();){
            while (it.hasNext()) {
                File file;
                URL resolved;
                SimpleFeature feature = (SimpleFeature)it.next();
                String location = (String)feature.getAttribute(this.getLocationAttribute());
                if (location == null || (resolved = pathResolver.resolve(location)) == null || !(file = URLs.urlToFile((URL)resolved)).exists()) continue;
                ratCollector.collectRAT(file);
            }
        }
        ratCollector.generateMosaicRAT();
        this.loadPamDataset(this.configuration);
    }

    static enum DomainType {
        SINGLE_VALUE,
        TIME_RANGE,
        NUMBER_RANGE;

    }

    public class DomainManager {
        private final Map<String, DomainDescriptor> domainsMap = new HashMap<String, DomainDescriptor>();
        private final List<DimensionDescriptor> dimensions = new ArrayList<DimensionDescriptor>();
        private final SimpleFeatureType simpleFeatureType;

        private final boolean attributeHasRange(String attribute) {
            return attribute.contains(";");
        }

        DomainManager(Map<String, String> additionalDomainAttributes, SimpleFeatureType simpleFeatureType) {
            Utilities.ensureNonNull((String)"additionalDomainAttributes", additionalDomainAttributes);
            Utilities.ensureNonNull((String)"simpleFeatureType", (Object)simpleFeatureType);
            this.simpleFeatureType = simpleFeatureType;
            this.init(additionalDomainAttributes, simpleFeatureType);
        }

        public DimensionDescriptor addDimension(String name, String attribute) {
            List<DimensionDescriptor> descriptors = this.init(Collections.singletonMap(name, attribute), this.simpleFeatureType);
            return descriptors.get(0);
        }

        private List<DimensionDescriptor> init(Map<String, String> domainAttributes, SimpleFeatureType simpleFeatureType) throws IllegalArgumentException {
            ArrayList<DimensionDescriptor> descriptors = new ArrayList<DimensionDescriptor>();
            for (Map.Entry<String, String> entry : domainAttributes.entrySet()) {
                String propertyName;
                String domainName;
                block10: {
                    DomainType domainType;
                    block9: {
                        domainType = DomainType.SINGLE_VALUE;
                        domainName = entry.getKey();
                        propertyName = entry.getValue();
                        try {
                            if (this.attributeHasRange(propertyName)) {
                                domainType = domainAttributes.containsKey("TIME") ? DomainType.TIME_RANGE : DomainType.NUMBER_RANGE;
                                descriptors.add(this.addDomain(domainName, propertyName, domainType, simpleFeatureType));
                                continue;
                            }
                            if (simpleFeatureType.getDescriptor(propertyName = this.extractAttributes(propertyName)) != null) {
                                descriptors.add(this.addDomain(domainName, propertyName, domainType, simpleFeatureType));
                                continue;
                            }
                        }
                        catch (Exception e) {
                            if (!LOGGER.isLoggable(Level.FINE)) break block9;
                            LOGGER.log(Level.FINE, e.getLocalizedMessage(), e);
                        }
                    }
                    if (propertyName.length() > 10) {
                        propertyName = propertyName.substring(0, 10);
                        try {
                            if (simpleFeatureType.getDescriptor(propertyName) != null) {
                                descriptors.add(this.addDomain(domainName, propertyName, domainType, simpleFeatureType));
                                continue;
                            }
                        }
                        catch (Exception e) {
                            if (!LOGGER.isLoggable(Level.FINE)) break block10;
                            LOGGER.log(Level.FINE, e.getLocalizedMessage(), e);
                        }
                    }
                }
                throw new IllegalArgumentException("Unable to add this domain:" + domainName + "-" + propertyName);
            }
            return descriptors;
        }

        DomainManager(String additionalDomainAttributes, SimpleFeatureType simpleFeatureType) {
            Utilities.ensureNonNull((String)"additionalDomainAttributes", (Object)additionalDomainAttributes);
            Utilities.ensureNonNull((String)"simpleFeatureType", (Object)simpleFeatureType);
            this.simpleFeatureType = simpleFeatureType;
            HashMap<String, String> domainPairs = new HashMap<String, String>();
            String[] additionalDomainsNames = additionalDomainAttributes.split(",");
            if (additionalDomainsNames.length <= 0) {
                throw new IllegalArgumentException("Number of Domains should be > 0");
            }
            for (String propertyName : additionalDomainsNames) {
                String domainName = this.cleanupDomainName(propertyName);
                domainPairs.put(domainName, propertyName);
            }
            this.init(domainPairs, simpleFeatureType);
        }

        private String cleanupDomainName(String domainName) {
            if (this.attributeHasRange(domainName) || domainName.contains("(") && domainName.contains(")")) {
                domainName = domainName.substring(0, domainName.indexOf("("));
            }
            return domainName;
        }

        private DimensionDescriptor addDomain(String name, String propertyName, DomainType domainType, SimpleFeatureType featureType) {
            Utilities.ensureNonNull((String)"name", (Object)name);
            Utilities.ensureNonNull((String)"propertyName", (Object)propertyName);
            if (this.domainsMap.containsKey(name)) {
                throw new IllegalArgumentException("Trying to add a domain with an existing name" + name);
            }
            String basePropertyName = propertyName;
            String additionalPropertyName = null;
            if (domainType != DomainType.SINGLE_VALUE) {
                String[] properties = (propertyName = this.extractAttributes(propertyName)).split(";");
                if (properties == null || properties.length != 2) {
                    throw new IllegalArgumentException("Malformed domain with ranges: it should contain 2 attributes");
                }
                basePropertyName = properties[0];
                additionalPropertyName = properties[1];
            }
            String upperCase = name.toUpperCase();
            AttributeDescriptor descriptor = featureType.getDescriptor(basePropertyName);
            String type = descriptor.getType().getBinding().getName();
            this.domainsMap.put(upperCase + "_DOMAIN", new DomainDescriptor(name, domainType, type, basePropertyName, additionalPropertyName));
            return this.addDimensionDescriptor(name, upperCase, basePropertyName, additionalPropertyName);
        }

        private DimensionDescriptor addDimensionDescriptor(String name, String upperCase, String basePropertyName, String additionalPropertyName) {
            String unitsName;
            String string = upperCase.equalsIgnoreCase("TIME") ? CoverageUtilities.UCUM.TIME_UNITS.getName() : (unitsName = upperCase.equalsIgnoreCase("ELEVATION") ? CoverageUtilities.UCUM.ELEVATION_UNITS.getName() : "FIXME");
            String unitsSymbol = upperCase.equalsIgnoreCase("TIME") ? CoverageUtilities.UCUM.TIME_UNITS.getSymbol() : (upperCase.equalsIgnoreCase("ELEVATION") ? CoverageUtilities.UCUM.ELEVATION_UNITS.getSymbol() : "FIXME");
            DefaultDimensionDescriptor dimensionDescriptor = new DefaultDimensionDescriptor(name, unitsName, unitsSymbol, basePropertyName, additionalPropertyName);
            this.dimensions.add((DimensionDescriptor)dimensionDescriptor);
            return dimensionDescriptor;
        }

        private String extractAttributes(String propertyName) {
            if (propertyName.contains("(") && propertyName.contains(")")) {
                propertyName = propertyName.substring(propertyName.indexOf("(")).replace("(", "").replace(")", "");
            }
            return propertyName;
        }

        public boolean isParameterSupported(Identifier name) {
            if (!this.domainsMap.isEmpty()) {
                for (DomainDescriptor domain : this.domainsMap.values()) {
                    ReferenceIdentifier nameLoc = domain.getDomainParameterDescriptor().getName();
                    if (!nameLoc.equals(name)) continue;
                    return true;
                }
            }
            return false;
        }

        public List<String> getMetadataNames() {
            ArrayList<String> metadataNames = new ArrayList<String>();
            if (!this.domainsMap.isEmpty()) {
                for (DomainDescriptor domain : this.domainsMap.values()) {
                    String domainName = domain.getIdentifier().toUpperCase();
                    metadataNames.add(domainName + "_DOMAIN");
                    if (domain.getDataType() != null) {
                        metadataNames.add(domainName + "_DOMAIN_DATATYPE");
                    }
                    metadataNames.add("HAS_" + domainName + "_DOMAIN");
                }
            }
            return metadataNames;
        }

        public String getMetadataValue(String name) {
            Utilities.ensureNonNull((String)"name", (Object)name);
            String value = null;
            if (!this.domainsMap.isEmpty()) {
                if (this.domainsMap.containsKey(name)) {
                    DomainDescriptor domainDescriptor = this.domainsMap.get(name);
                    value = domainDescriptor.getValues();
                } else {
                    if (name.startsWith("HAS_")) {
                        String substring = name.substring("HAS_".length(), name.length());
                        if (this.domainsMap.containsKey(substring)) {
                            return Boolean.toString(Boolean.TRUE);
                        }
                        return Boolean.toString(Boolean.FALSE);
                    }
                    if (name.endsWith("_DATATYPE")) {
                        return this.domainsMap.get(name.substring(0, name.lastIndexOf("_DATATYPE"))).getDataType();
                    }
                    if (name.endsWith("MINIMUM") || name.endsWith("MAXIMUM")) {
                        return this.domainsMap.get(name.substring(0, name.lastIndexOf("_"))).getExtrema(name);
                    }
                }
            }
            return value;
        }

        public Filter createFilter(String domain, List values) {
            if (domain == null || domain.isEmpty()) {
                throw new IllegalArgumentException("Null domain requested");
            }
            if (values == null || values.isEmpty()) {
                throw new IllegalArgumentException("Null domain values provided");
            }
            if (this.domainsMap.isEmpty() || !this.domainsMap.containsKey(domain)) {
                throw new IllegalArgumentException("requested domain is not supported by this mosaic: " + domain);
            }
            DomainDescriptor domainDescriptor = this.domainsMap.get(domain);
            return domainDescriptor.createFilter(values);
        }

        public Set<ParameterDescriptor<List>> getDynamicParameters() {
            HashSet<ParameterDescriptor<List>> dynamicParameters = new HashSet<ParameterDescriptor<List>>();
            if (!this.domainsMap.isEmpty()) {
                for (DomainDescriptor domain : this.domainsMap.values()) {
                    dynamicParameters.add((ParameterDescriptor<List>)domain.getDomainParameterDescriptor());
                }
            }
            return dynamicParameters;
        }
    }

    public class DomainDescriptor {
        public static final String DOMAIN_SUFFIX = "_DOMAIN";
        static final String HAS_PREFIX = "HAS_";
        static final String DATATYPE_SUFFIX = "_DATATYPE";
        private DomainType domainType = DomainType.SINGLE_VALUE;
        private final String identifier;
        private final String propertyName;
        private final String additionalPropertyName;
        private final String dataType;
        private final DefaultParameterDescriptor<List> domainParameterDescriptor;

        private String getIdentifier() {
            return this.identifier;
        }

        public boolean isHasRanges() {
            return this.additionalPropertyName != null;
        }

        public String getDataType() {
            return this.dataType;
        }

        private DefaultParameterDescriptor<List> getDomainParameterDescriptor() {
            return this.domainParameterDescriptor;
        }

        private DomainDescriptor(String identifier, DomainType domainType, String dataType, String propertyName, String additionalPropertyName) {
            this.identifier = identifier;
            this.propertyName = propertyName;
            this.domainType = domainType;
            this.dataType = dataType;
            this.additionalPropertyName = additionalPropertyName;
            String name = identifier.toUpperCase();
            this.domainParameterDescriptor = DefaultParameterDescriptor.create((String)name, (CharSequence)("Additional " + identifier + " domain"), List.class, null, (boolean)false);
        }

        public String toString() {
            return "DomainDescriptor [identifier=" + this.identifier + ", propertyName=" + this.propertyName + ", dataType=" + this.dataType + ", additionalPropertyName=" + (this.additionalPropertyName != null ? this.additionalPropertyName : "__UNAVAILABLE__") + "]";
        }

        private String getExtrema(String extrema) {
            try {
                FeatureCalc visitor;
                CalcResult tempRes;
                String attribute = this.propertyName;
                if (this.domainType != DomainType.SINGLE_VALUE && extrema.toLowerCase().endsWith("maximum")) {
                    attribute = this.additionalPropertyName;
                }
                if ((tempRes = (visitor = RasterManager.this.createExtremaQuery(extrema, attribute)).getResult()) == null) {
                    throw new IllegalStateException("Unable to compute extrema value:" + extrema);
                }
                Object result = tempRes.getValue();
                if (result == null) {
                    throw new IllegalStateException("Unable to compute extrema value:" + extrema);
                }
                return ConvertersHack.convert(result, String.class);
            }
            catch (IOException e) {
                if (LOGGER.isLoggable(Level.WARNING)) {
                    LOGGER.log(Level.WARNING, "Unable to compute extrema for TIME_DOMAIN", e);
                }
                return null;
            }
        }

        private String getValues() {
            if (this.domainType == DomainType.SINGLE_VALUE) {
                return this.getSingleValues();
            }
            return this.getRangeValues();
        }

        private String getRangeValues() {
            try {
                Set result = RasterManager.this.extractDomain(this.propertyName, this.additionalPropertyName, this.domainType);
                if (result.isEmpty()) {
                    return "";
                }
                StringBuilder buff = new StringBuilder();
                Iterator it = result.iterator();
                while (it.hasNext()) {
                    buff.append(ConvertersHack.convert(it.next(), String.class));
                    if (!it.hasNext()) continue;
                    buff.append(",");
                }
                return buff.toString();
            }
            catch (IOException e) {
                if (LOGGER.isLoggable(Level.WARNING)) {
                    LOGGER.log(Level.WARNING, "Unable to parse attribute: " + this.identifier, e);
                }
                return "";
            }
        }

        private String getSingleValues() {
            try {
                TreeSet result = new TreeSet(RasterManager.this.extractDomain(this.propertyName));
                if (result.isEmpty()) {
                    return "";
                }
                StringBuilder buff = new StringBuilder();
                Iterator it = result.iterator();
                while (it.hasNext()) {
                    buff.append(ConvertersHack.convert(it.next(), String.class));
                    if (!it.hasNext()) continue;
                    buff.append(",");
                }
                return buff.toString();
            }
            catch (IOException e) {
                if (LOGGER.isLoggable(Level.WARNING)) {
                    LOGGER.log(Level.WARNING, "Unable to parse attribute: " + this.identifier, e);
                }
                return "";
            }
        }

        private Filter createFilter(List values) {
            return new DomainFilterBuilder(this.identifier, this.propertyName, this.additionalPropertyName).createFilter(values);
        }
    }

    static class SpatialDomainManager {
        ReferencedEnvelope coverageBBox;
        CoordinateReferenceSystem coverageCRS;
        CoordinateReferenceSystem coverageCRS2D;
        GeneralBounds coverageEnvelope = null;
        double[] coverageFullResolution;
        ReferencedEnvelope coverageGeographicBBox;
        CoordinateReferenceSystem coverageGeographicCRS2D;
        MathTransform2D coverageGridToWorld2D;
        Rectangle coverageRasterArea;
        GridEnvelope gridEnvelope;

        public SpatialDomainManager(GeneralBounds envelope, GridEnvelope2D coverageGridrange, CoordinateReferenceSystem crs, MathTransform coverageGridToWorld2D, OverviewsController overviewsController) throws TransformException, FactoryException {
            this.coverageEnvelope = envelope.clone();
            this.gridEnvelope = coverageGridrange.clone();
            this.coverageRasterArea = (Rectangle)this.gridEnvelope;
            this.coverageCRS = crs;
            this.coverageGridToWorld2D = (MathTransform2D)coverageGridToWorld2D;
            this.coverageFullResolution = new double[2];
            OverviewsController.OverviewLevel highestLevel = overviewsController.resolutionsLevels.get(0);
            this.coverageFullResolution[0] = highestLevel.resolutionX;
            this.coverageFullResolution[1] = highestLevel.resolutionY;
            this.prepareCoverageSpatialElements();
        }

        private void prepareCoverageSpatialElements() throws TransformException, FactoryException {
            this.coverageGeographicBBox = ImageUtilities.getWGS84ReferencedEnvelope((GeneralBounds)this.coverageEnvelope);
            this.coverageGeographicCRS2D = this.coverageGeographicBBox != null ? this.coverageGeographicBBox.getCoordinateReferenceSystem() : null;
            this.coverageCRS2D = CRS.getHorizontalCRS((CoordinateReferenceSystem)this.coverageCRS);
            assert (this.coverageCRS2D.getCoordinateSystem().getDimension() == 2);
            if (this.coverageCRS.getCoordinateSystem().getDimension() != 2) {
                MathTransform transform = CRS.findMathTransform((CoordinateReferenceSystem)this.coverageCRS, (CoordinateReferenceSystem)this.coverageCRS2D);
                GeneralBounds bbox = CRS.transform((MathTransform)transform, (Bounds)this.coverageEnvelope);
                this.coverageBBox = ReferencedEnvelope.create((Bounds)bbox, (CoordinateReferenceSystem)this.coverageCRS2D);
            } else {
                this.coverageBBox = ReferencedEnvelope.create((Bounds)this.coverageEnvelope, (CoordinateReferenceSystem)this.coverageEnvelope.getCoordinateReferenceSystem());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public MathTransform getOriginalGridToWorld(PixelInCell pixInCell) {
            AffineTransform tr;
            SpatialDomainManager spatialDomainManager = this;
            synchronized (spatialDomainManager) {
                if (this.coverageGridToWorld2D == null) {
                    GridToEnvelopeMapper geMapper = new GridToEnvelopeMapper(this.gridEnvelope, (Bounds)this.coverageEnvelope);
                    geMapper.setPixelAnchor(PixelInCell.CELL_CENTER);
                    this.coverageGridToWorld2D = (MathTransform2D)geMapper.createTransform();
                }
            }
            if (pixInCell == PixelInCell.CELL_CENTER) {
                return this.coverageGridToWorld2D;
            }
            if (this.coverageGridToWorld2D instanceof AffineTransform) {
                tr = new AffineTransform((AffineTransform)this.coverageGridToWorld2D);
                tr.concatenate(AffineTransform.getTranslateInstance(-0.5, -0.5));
                return ProjectiveTransform.create((AffineTransform)tr);
            }
            if (this.coverageGridToWorld2D instanceof IdentityTransform) {
                tr = new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f);
                tr.concatenate(AffineTransform.getTranslateInstance(-0.5, -0.5));
                return ProjectiveTransform.create((AffineTransform)tr);
            }
            throw new IllegalStateException("This reader's grid to world transform is invalud!");
        }
    }
}

