/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.gce.imagemosaic.catalog;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geotools.api.data.Query;
import org.geotools.api.data.Transaction;
import org.geotools.api.feature.simple.SimpleFeature;
import org.geotools.api.feature.simple.SimpleFeatureType;
import org.geotools.data.collection.ListFeatureCollection;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.data.simple.SimpleFeatureIterator;
import org.geotools.feature.collection.DecoratingSimpleFeatureCollection;
import org.geotools.feature.collection.DecoratingSimpleFeatureIterator;
import org.geotools.gce.imagemosaic.catalog.AbstractGTDataStoreGranuleCatalog;
import org.geotools.gce.imagemosaic.catalog.CatalogConfigurationBeans;
import org.geotools.gce.imagemosaic.catalog.DelegatingGranuleCatalog;
import org.geotools.util.SoftValueHashMap;
import org.geotools.util.logging.Logging;

public class QueryCacheGranuleCatalog
extends DelegatingGranuleCatalog {
    static final Logger LOGGER = Logging.getLogger(QueryCacheGranuleCatalog.class);
    private final int maxCachedFeatures;
    private final int maxAge;
    private final SoftValueHashMap<Query, ExpiringFeatureCollection> queryCache = new SoftValueHashMap();

    public QueryCacheGranuleCatalog(AbstractGTDataStoreGranuleCatalog adaptee, int maxCachedFeatures, int maxAge) {
        super(adaptee);
        this.maxCachedFeatures = maxCachedFeatures;
        this.maxAge = maxAge;
    }

    @Override
    public SimpleFeatureCollection getGranules(Query q) throws IOException {
        return this.getGranules(q, Transaction.AUTO_COMMIT);
    }

    @Override
    public SimpleFeatureCollection getGranules(Query q, Transaction t) throws IOException {
        if (this.maxAge > 0 && t == Transaction.AUTO_COMMIT) {
            ExpiringFeatureCollection cached = (ExpiringFeatureCollection)((Object)this.queryCache.get((Object)this.getCacheKey(q)));
            if (cached != null) {
                if (!cached.isExpired(this.maxAge)) {
                    LOGGER.log(Level.FINE, () -> "Cache hit on query: " + q);
                    return cached;
                }
                LOGGER.log(Level.FINE, () -> "Cache found, but expired, refreshing, on query: " + q);
            } else {
                LOGGER.log(Level.FINE, "Cache miss on query: " + q);
            }
            return new CachingFeatureCollection(q, this.adaptee.getGranules(q, t));
        }
        return this.adaptee.getGranules(q);
    }

    private Query getCacheKey(Query q) {
        Query key = new Query(q);
        key.getHints().remove((Object)CatalogConfigurationBeans.COVERAGE_NAME);
        return key;
    }

    @Override
    public void addGranules(String typeName, Collection<SimpleFeature> granules, Transaction transaction) throws IOException {
        this.queryCache.clear();
        super.addGranules(typeName, granules, transaction);
    }

    @Override
    public void removeType(String typeName) throws IOException {
        this.queryCache.clear();
        super.removeType(typeName);
    }

    @Override
    public void addGranule(String typeName, SimpleFeature granule, Transaction transaction) throws IOException {
        this.queryCache.clear();
        super.addGranule(typeName, granule, transaction);
    }

    @Override
    public int removeGranules(Query query) {
        this.queryCache.clear();
        return super.removeGranules(query);
    }

    @Override
    public int removeGranules(Query query, Transaction transaction) {
        this.queryCache.clear();
        return super.removeGranules(query, transaction);
    }

    private class CachingFeatureCollection
    extends DecoratingSimpleFeatureCollection {
        private final Query query;

        public CachingFeatureCollection(Query query, SimpleFeatureCollection delegate) {
            super(delegate);
            this.query = query;
        }

        public SimpleFeatureIterator features() {
            return new CachingFeatureIterator(this.query, this.getSchema(), this.delegate.features());
        }
    }

    private static class ExpiringFeatureCollection
    extends ListFeatureCollection {
        private final long created = System.currentTimeMillis();

        public ExpiringFeatureCollection(SimpleFeatureType schema, List<SimpleFeature> features) {
            super(schema, features);
        }

        public boolean isExpired(int maxAge) {
            return System.currentTimeMillis() - (long)maxAge > this.created;
        }
    }

    class CachingFeatureIterator
    extends DecoratingSimpleFeatureIterator {
        private final Query query;
        private final SimpleFeatureType schema;
        List<SimpleFeature> features;
        protected boolean completed;

        public CachingFeatureIterator(Query query, SimpleFeatureType schema, SimpleFeatureIterator iterator) {
            super(iterator);
            this.features = new ArrayList<SimpleFeature>();
            this.query = query;
            this.schema = schema;
        }

        public boolean hasNext() {
            boolean hasNext = super.hasNext();
            if (!hasNext) {
                this.completed = true;
            }
            return hasNext;
        }

        public SimpleFeature next() throws NoSuchElementException {
            SimpleFeature next = (SimpleFeature)super.next();
            if (this.features.size() < QueryCacheGranuleCatalog.this.maxCachedFeatures) {
                this.features.add(next);
            }
            return next;
        }

        public void close() {
            if (this.features.size() < QueryCacheGranuleCatalog.this.maxCachedFeatures) {
                QueryCacheGranuleCatalog.this.queryCache.put((Object)QueryCacheGranuleCatalog.this.getCacheKey(this.query), (Object)new ExpiringFeatureCollection(this.schema, this.features));
            }
            super.close();
        }
    }
}

