/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.gce.imagemosaic.catalog.postgis;

import java.io.IOException;
import java.util.List;
import java.util.Properties;
import org.geotools.api.data.DataStore;
import org.geotools.api.data.SimpleFeatureSource;
import org.geotools.api.data.SimpleFeatureStore;
import org.geotools.api.feature.simple.SimpleFeatureType;
import org.geotools.data.transform.Definition;
import org.geotools.gce.imagemosaic.catalog.oracle.DataStoreWrapper;
import org.geotools.gce.imagemosaic.catalog.oracle.FeatureTypeMapper;
import org.geotools.gce.imagemosaic.catalog.postgis.PostgisFeatureTypeMapper;
import org.geotools.gce.imagemosaic.catalog.postgis.PostgisTransformFeatureStore;

public class PostgisDatastoreWrapper
extends DataStoreWrapper {
    static final String SRID = "SRID";

    public PostgisDatastoreWrapper(DataStore datastore, String location, String subFolderName) {
        super(datastore, location, subFolderName);
    }

    public PostgisDatastoreWrapper(DataStore datastore, String location) {
        super(datastore, location);
    }

    @Override
    protected FeatureTypeMapper getFeatureTypeMapper(Properties props) throws Exception {
        FeatureTypeMapper mapper = super.getFeatureTypeMapper(props);
        Object srID = props.get(SRID);
        if (srID != null) {
            ((PostgisFeatureTypeMapper)mapper).setSrID(Integer.valueOf((String)srID));
        }
        return mapper;
    }

    @Override
    protected FeatureTypeMapper getFeatureTypeMapper(SimpleFeatureType featureType) throws Exception {
        return new PostgisFeatureTypeMapper(featureType);
    }

    @Override
    protected SimpleFeatureSource transformFeatureStore(SimpleFeatureStore store, FeatureTypeMapper mapper) throws IOException {
        Object transformedSource = mapper.getSimpleFeatureSource();
        if (transformedSource != null) {
            return transformedSource;
        }
        transformedSource = new PostgisTransformFeatureStore(store, mapper.getName(), mapper.getDefinitions(), this.datastore);
        ((PostgisFeatureTypeMapper)mapper).setSimpleFeatureSource((SimpleFeatureSource)transformedSource);
        return transformedSource;
    }

    @Override
    protected void storeMapper(FeatureTypeMapper mapper) {
        Properties properties = new Properties();
        String typeName = mapper.getName().toString();
        properties.setProperty("NAME", typeName);
        properties.setProperty("MAPPEDNAME", mapper.getMappedName().toString());
        List<Definition> definitions = mapper.getDefinitions();
        StringBuilder builder = new StringBuilder();
        for (Definition definition : definitions) {
            builder.append(definition.getName()).append(":").append(definition.getBinding().getName()).append(",");
        }
        String schema = builder.toString();
        schema = schema.substring(0, schema.length() - 1);
        properties.setProperty("SCHEMA", schema);
        properties.setProperty("CRS", mapper.getCoordinateReferenceSystem().toWKT());
        properties.setProperty(SRID, Integer.toString(((PostgisFeatureTypeMapper)mapper).getSrID()));
        this.storeProperties(properties, typeName);
    }
}

