/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.gce.imagemosaic;

import java.awt.Dimension;
import java.awt.Rectangle;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.net.URL;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.TimeZone;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.io.FileUtils;
import org.geotools.api.coverage.grid.GridEnvelope;
import org.geotools.api.data.Query;
import org.geotools.api.feature.simple.SimpleFeature;
import org.geotools.api.feature.simple.SimpleFeatureType;
import org.geotools.api.filter.sort.SortBy;
import org.geotools.api.filter.sort.SortOrder;
import org.geotools.api.geometry.Bounds;
import org.geotools.api.parameter.GeneralParameterValue;
import org.geotools.api.parameter.ParameterValue;
import org.geotools.coverage.grid.GridEnvelope2D;
import org.geotools.coverage.grid.GridGeometry2D;
import org.geotools.coverage.grid.io.AbstractGridFormat;
import org.geotools.coverage.grid.io.DimensionDescriptor;
import org.geotools.coverage.util.FeatureUtilities;
import org.geotools.filter.SortByImpl;
import org.geotools.gce.imagemosaic.GranuleDescriptor;
import org.geotools.gce.imagemosaic.ImageMosaicFormat;
import org.geotools.gce.imagemosaic.ImageMosaicReader;
import org.geotools.gce.imagemosaic.ImageMosaicReaderTest;
import org.geotools.gce.imagemosaic.RasterManager;
import org.geotools.gce.imagemosaic.TestUtils;
import org.geotools.geometry.GeneralBounds;
import org.geotools.test.OnlineTestCase;
import org.geotools.test.TestData;
import org.geotools.util.NumberRange;
import org.geotools.util.factory.Hints;
import org.geotools.util.logging.Logging;
import org.junit.Test;

public class ImageMosaicPostgisIndexOnlineTest
extends OnlineTestCase {
    private static final Logger LOGGER = Logging.getLogger(ImageMosaicPostgisIndexOnlineTest.class);
    static final String tempFolderNoEpsg = "rgbNoEpsg";
    static final String tempFolderName1 = "waterTempPG";
    static final String tempFolderName2 = "waterTempPG2";
    static final String tempFolderName3 = "waterTempPG3";
    static final String tempFolderName4 = "waterTempPGCD";
    static final String tempFolderNameWrap = "waterTempPGWrap";
    static final String VERY_LONG_NAME = "very_very_long_name_with_number_of_chars_greater_than_64_to_test_the_postgis_wrapper";
    private final String noGeomFirst = "wNoGeom";
    private final String noGeomLast = "zNotGeom";

    protected Properties createExampleFixture() {
        Properties props = new Properties();
        props.setProperty("SPI", "org.geotools.data.postgis.PostgisNGDataStoreFactory");
        props.setProperty("host", "localhost");
        props.setProperty("port", "5432");
        props.setProperty("user", "xxx");
        props.setProperty("passwd", "xxx");
        props.setProperty("database", "ddd");
        props.setProperty("schema", "public");
        props.setProperty("Loose bbox", "true");
        props.setProperty("Estimated extends", "false");
        props.setProperty("validate connections", "true");
        props.setProperty("Connection timeout", "10");
        props.setProperty("preparedStatements", "false");
        props.setProperty("create database params", "WITH TEMPLATE=template_postgis");
        return props;
    }

    protected String getFixtureId() {
        return "postgis_datastore";
    }

    @Test
    public void testPostgisIndexing() throws Exception {
        File workDir = new File(TestData.file((Object)((Object)this), (String)"."), tempFolderName1);
        ImageMosaicPostgisIndexOnlineTest.assertTrue((boolean)workDir.mkdir());
        FileUtils.copyFile((File)TestData.file((Object)((Object)this), (String)"watertemp.zip"), (File)new File(workDir, "watertemp.zip"));
        TestData.unzipFile((Object)((Object)this), (String)"waterTempPG/watertemp.zip");
        URL timeElevURL = TestData.url((Object)((Object)this), (String)tempFolderName1);
        this.setupDataStoreProperties(tempFolderName1);
        AbstractGridFormat format = TestUtils.getFormat(timeElevURL);
        ImageMosaicPostgisIndexOnlineTest.assertNotNull((Object)format);
        ImageMosaicReader reader = TestUtils.getReader(timeElevURL, format);
        ImageMosaicPostgisIndexOnlineTest.assertNotNull((Object)reader);
        String[] metadataNames = reader.getMetadataNames();
        ImageMosaicPostgisIndexOnlineTest.assertNotNull((Object)metadataNames);
        ImageMosaicPostgisIndexOnlineTest.assertEquals((int)13, (int)metadataNames.length);
        ImageMosaicPostgisIndexOnlineTest.assertEquals((String)"true", (String)reader.getMetadataValue("HAS_TIME_DOMAIN"));
        String timeMetadata = reader.getMetadataValue("TIME_DOMAIN");
        ImageMosaicPostgisIndexOnlineTest.assertNotNull((Object)timeMetadata);
        ImageMosaicPostgisIndexOnlineTest.assertEquals((int)2, (int)timeMetadata.split(",").length);
        ImageMosaicPostgisIndexOnlineTest.assertEquals((String)timeMetadata.split(",")[0], (String)reader.getMetadataValue("TIME_DOMAIN_MINIMUM"));
        ImageMosaicPostgisIndexOnlineTest.assertEquals((String)timeMetadata.split(",")[1], (String)reader.getMetadataValue("TIME_DOMAIN_MAXIMUM"));
        ImageMosaicPostgisIndexOnlineTest.assertEquals((String)"true", (String)reader.getMetadataValue("HAS_ELEVATION_DOMAIN"));
        String elevationMetadata = reader.getMetadataValue("ELEVATION_DOMAIN");
        ImageMosaicPostgisIndexOnlineTest.assertNotNull((Object)elevationMetadata);
        ImageMosaicPostgisIndexOnlineTest.assertEquals((int)2, (int)elevationMetadata.split(",").length);
        ImageMosaicPostgisIndexOnlineTest.assertEquals((double)Double.parseDouble(elevationMetadata.split(",")[0]), (double)Double.parseDouble(reader.getMetadataValue("ELEVATION_DOMAIN_MINIMUM")), (double)1.0E-6);
        ImageMosaicPostgisIndexOnlineTest.assertEquals((double)Double.parseDouble(elevationMetadata.split(",")[1]), (double)Double.parseDouble(reader.getMetadataValue("ELEVATION_DOMAIN_MAXIMUM")), (double)1.0E-6);
        ParameterValue gg = AbstractGridFormat.READ_GRIDGEOMETRY2D.createValue();
        GeneralBounds envelope = reader.getOriginalEnvelope();
        Dimension dim = new Dimension();
        dim.setSize((double)reader.getOriginalGridRange().getSpan(0) / 2.0, (double)reader.getOriginalGridRange().getSpan(1) / 2.0);
        GridEnvelope2D rasterArea = (GridEnvelope2D)reader.getOriginalGridRange();
        rasterArea.setSize(dim);
        GridEnvelope2D range = new GridEnvelope2D((Rectangle)rasterArea);
        gg.setValue((Object)new GridGeometry2D((GridEnvelope)range, (Bounds)envelope));
        ParameterValue time = ImageMosaicFormat.TIME.createValue();
        ArrayList<Date> timeValues = new ArrayList<Date>();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.sss'Z'");
        sdf.setTimeZone(TimeZone.getTimeZone("GMT+0"));
        Date date = sdf.parse("2008-10-31T00:00:00.000Z");
        timeValues.add(date);
        time.setValue(timeValues);
        ParameterValue bkg = ImageMosaicFormat.BACKGROUND_VALUES.createValue();
        bkg.setValue((Object)new double[]{-9999.0});
        ParameterValue direct = ImageMosaicFormat.USE_JAI_IMAGEREAD.createValue();
        direct.setValue(false);
        ParameterValue elevation = ImageMosaicFormat.ELEVATION.createValue();
        elevation.setValue(Arrays.asList(100.0));
        ImageMosaicPostgisIndexOnlineTest.assertNotNull((Object)reader.read(new GeneralParameterValue[]{gg, time, bkg, elevation, direct}));
        TestUtils.checkCoverage(reader, new GeneralParameterValue[]{gg, time, bkg, elevation, direct}, "Time-Elevation Test");
        reader = TestUtils.getReader(timeElevURL, format);
        elevation.setValue(Arrays.asList(NumberRange.create((double)0.0, (double)10.0)));
        TestUtils.checkCoverage(reader, new GeneralParameterValue[]{gg, time, bkg, elevation, direct}, "Time-Elevation Test");
        reader.dispose();
    }

    @Test
    public void testPostgisIndexingNoEpsgCode() throws Exception {
        File workDir = new File(TestData.file((Object)((Object)this), (String)"."), tempFolderNoEpsg);
        workDir.mkdir();
        ImageMosaicPostgisIndexOnlineTest.assertTrue((boolean)workDir.exists());
        FileUtils.copyFile((File)TestData.file((Object)((Object)this), (String)"rgb_noepsg.zip"), (File)new File(workDir, "rgb_noepsg.zip"));
        TestData.unzipFile((Object)((Object)this), (String)"rgbNoEpsg/rgb_noepsg.zip");
        URL noEpsgURL = TestData.url((Object)((Object)this), (String)tempFolderNoEpsg);
        this.setupDataStoreProperties(tempFolderNoEpsg);
        AbstractGridFormat format = TestUtils.getFormat(noEpsgURL);
        ImageMosaicPostgisIndexOnlineTest.assertNotNull((Object)format);
        ImageMosaicReader reader = TestUtils.getReader(noEpsgURL, format);
        ImageMosaicPostgisIndexOnlineTest.assertNotNull((Object)reader);
    }

    @Test
    public void testPostgisCreateAndDrop() throws Exception {
        File workDir = new File(TestData.file((Object)((Object)this), (String)"."), tempFolderName4);
        workDir.mkdir();
        ImageMosaicPostgisIndexOnlineTest.assertTrue((boolean)workDir.exists());
        FileUtils.copyFile((File)TestData.file((Object)((Object)this), (String)"watertemp.zip"), (File)new File(workDir, "watertemp.zip"));
        TestData.unzipFile((Object)((Object)this), (String)"waterTempPGCD/watertemp.zip");
        URL timeElevURL = TestData.url((Object)((Object)this), (String)tempFolderName4);
        this.setupDataStoreProperties(tempFolderName4);
        AbstractGridFormat format = TestUtils.getFormat(timeElevURL);
        ImageMosaicPostgisIndexOnlineTest.assertNotNull((Object)format);
        ImageMosaicReader reader = TestUtils.getReader(timeElevURL, format);
        ImageMosaicPostgisIndexOnlineTest.assertNotNull((Object)reader);
        reader.delete(true);
        boolean dropSuccessfull = false;
        try {
            this.dropTables(new String[]{tempFolderName4}, this.fixture.getProperty("database"));
            dropSuccessfull = true;
        }
        catch (SQLException e) {
            ImageMosaicPostgisIndexOnlineTest.assertFalse((boolean)dropSuccessfull);
        }
        reader.dispose();
    }

    private void setupDataStoreProperties(String folder) throws IOException, FileNotFoundException {
        try (FileWriter out = new FileWriter(new File(TestData.file((Object)((Object)this), (String)"."), folder + "/datastore.properties"));){
            Set<Object> keyset = this.fixture.keySet();
            for (Object key : keyset) {
                String key_ = (String)key;
                String value = this.fixture.getProperty(key_);
                out.write(key_.replace(" ", "\\ ") + "=" + value.replace(" ", "\\ ") + "\n");
            }
            out.flush();
        }
    }

    @Test
    public void testSortingAndLimiting() throws Exception {
        File workDir = new File(TestData.file((Object)((Object)this), (String)"."), tempFolderName2);
        ImageMosaicPostgisIndexOnlineTest.assertTrue((boolean)workDir.mkdir());
        FileUtils.copyFile((File)TestData.file((Object)((Object)this), (String)"watertemp.zip"), (File)new File(workDir, "watertemp.zip"));
        TestData.unzipFile((Object)((Object)this), (String)"waterTempPG2/watertemp.zip");
        URL timeElevURL = TestData.url((Object)((Object)this), (String)tempFolderName2);
        this.setupDataStoreProperties(tempFolderName2);
        AbstractGridFormat format = TestUtils.getFormat(timeElevURL);
        ImageMosaicPostgisIndexOnlineTest.assertNotNull((Object)format);
        ImageMosaicReader reader = TestUtils.getReader(timeElevURL, format);
        ImageMosaicPostgisIndexOnlineTest.assertNotNull((Object)reader);
        String[] metadataNames = reader.getMetadataNames();
        ImageMosaicPostgisIndexOnlineTest.assertNotNull((Object)metadataNames);
        ImageMosaicPostgisIndexOnlineTest.assertEquals((int)13, (int)metadataNames.length);
        ImageMosaicPostgisIndexOnlineTest.assertEquals((String)"true", (String)reader.getMetadataValue("HAS_TIME_DOMAIN"));
        ImageMosaicPostgisIndexOnlineTest.assertEquals((String)"true", (String)reader.getMetadataValue("HAS_ELEVATION_DOMAIN"));
        reader.dispose();
        MyImageMosaicReader reader1 = new MyImageMosaicReader(timeElevURL);
        RasterManager rasterManager = reader1.getRasterManager(reader1.getGridCoverageNames()[0]);
        SimpleFeatureType type = rasterManager.granuleCatalog.getType(tempFolderName2);
        Query query = null;
        if (type != null) {
            query = new Query(type.getTypeName());
            query.setMaxFeatures(1);
            SortBy[] clauses = new SortBy[]{new SortByImpl(FeatureUtilities.DEFAULT_FILTER_FACTORY.property("ingestion"), SortOrder.DESCENDING), new SortByImpl(FeatureUtilities.DEFAULT_FILTER_FACTORY.property("elevation"), SortOrder.ASCENDING)};
            query.setSortBy(clauses);
        }
        ArrayList features = new ArrayList();
        rasterManager.getGranuleDescriptors(query, (granule, o) -> features.add(granule));
        ImageMosaicPostgisIndexOnlineTest.assertEquals((int)features.size(), (int)1);
        GranuleDescriptor granule2 = (GranuleDescriptor)features.iterator().next();
        SimpleFeature sf = granule2.getOriginator();
        ImageMosaicPostgisIndexOnlineTest.assertNotNull((Object)sf);
        Object ingestion = sf.getAttribute("ingestion");
        ImageMosaicPostgisIndexOnlineTest.assertTrue((boolean)(ingestion instanceof Timestamp));
        GregorianCalendar gc = new GregorianCalendar(TimeZone.getTimeZone("GMT"));
        gc.setTimeInMillis(1225497600000L);
        ImageMosaicPostgisIndexOnlineTest.assertEquals((int)0, (int)((Timestamp)ingestion).compareTo(gc.getTime()));
        Object elevation = sf.getAttribute("elevation");
        ImageMosaicPostgisIndexOnlineTest.assertTrue((boolean)(elevation instanceof Integer));
        ImageMosaicPostgisIndexOnlineTest.assertEquals((int)((Integer)elevation), (int)0);
        SortBy[] clauses = new SortBy[]{new SortByImpl(FeatureUtilities.DEFAULT_FILTER_FACTORY.property("ingestion"), SortOrder.ASCENDING), new SortByImpl(FeatureUtilities.DEFAULT_FILTER_FACTORY.property("elevation"), SortOrder.DESCENDING)};
        query.setSortBy(clauses);
        features.clear();
        rasterManager.getGranuleDescriptors(query, (granule1, o) -> features.add(granule1));
        ImageMosaicPostgisIndexOnlineTest.assertEquals((int)features.size(), (int)1);
        granule2 = (GranuleDescriptor)features.iterator().next();
        sf = granule2.getOriginator();
        ImageMosaicPostgisIndexOnlineTest.assertNotNull((Object)sf);
        ingestion = sf.getAttribute("ingestion");
        ImageMosaicPostgisIndexOnlineTest.assertTrue((boolean)(ingestion instanceof Timestamp));
        ImageMosaicPostgisIndexOnlineTest.assertNotSame((Object)0, (Object)((Timestamp)ingestion).compareTo(gc.getTime()));
        elevation = sf.getAttribute("elevation");
        ImageMosaicPostgisIndexOnlineTest.assertTrue((boolean)(elevation instanceof Integer));
        ImageMosaicPostgisIndexOnlineTest.assertNotSame((Object)((Integer)elevation), (Object)0);
        reader1.dispose();
    }

    protected void setUpInternal() throws Exception {
        super.setUpInternal();
        System.setProperty("org.geotools.referencing.forceXY", "true");
        System.setProperty("user.timezone", "GMT");
    }

    private void dropTables(String[] tables) throws Exception {
        this.dropTables(tables, null);
    }

    private void dropTables(String[] tables, String database) throws Exception {
        Class.forName("org.postgresql.Driver");
        try (Connection connection = DriverManager.getConnection("jdbc:postgresql://" + this.fixture.getProperty("host") + ":" + this.fixture.getProperty("port") + "/" + (database != null ? database : this.fixture.getProperty("database")), this.fixture.getProperty("user"), this.fixture.getProperty("passwd"));
             Statement st = connection.createStatement();){
            for (String table : tables) {
                st.execute("DROP TABLE IF EXISTS \"" + table + "\"");
            }
        }
        catch (SQLException e) {
            LOGGER.log(Level.SEVERE, e.getLocalizedMessage(), e);
        }
    }

    @Test
    public void testPostgisWrapping() throws Exception {
        File workDir = new File(TestData.file((Object)((Object)this), (String)"."), tempFolderNameWrap);
        ImageMosaicPostgisIndexOnlineTest.assertTrue((boolean)workDir.mkdir());
        FileUtils.copyFile((File)TestData.file((Object)((Object)this), (String)"watertemplongnames.zip"), (File)new File(workDir, "watertemplongnames.zip"));
        TestData.unzipFile((Object)((Object)this), (String)"waterTempPGWrap/watertemplongnames.zip");
        URL dataUrl = TestData.url((Object)((Object)this), (String)tempFolderNameWrap);
        this.setupDataStoreProperties(tempFolderNameWrap);
        AbstractGridFormat format = TestUtils.getFormat(dataUrl, null);
        ImageMosaicPostgisIndexOnlineTest.assertNotNull((Object)format);
        ImageMosaicReader reader = TestUtils.getReader(dataUrl, format, null);
        ImageMosaicPostgisIndexOnlineTest.assertNotNull((Object)reader);
        String[] metadataNames = reader.getMetadataNames();
        String[] coverageNames = reader.getGridCoverageNames();
        String coverageName = coverageNames[0];
        ImageMosaicPostgisIndexOnlineTest.assertEquals((String)VERY_LONG_NAME, (String)coverageName);
        List descriptors = reader.getDimensionDescriptors(coverageName);
        for (DimensionDescriptor descriptor : descriptors) {
            String name = descriptor.getName();
            if (!name.equalsIgnoreCase("time")) continue;
            ImageMosaicPostgisIndexOnlineTest.assertTrue((descriptor.getStartAttribute().length() > 64 ? 1 : 0) != 0);
            break;
        }
        ImageMosaicPostgisIndexOnlineTest.assertNotNull((Object)metadataNames);
        ImageMosaicPostgisIndexOnlineTest.assertEquals((int)13, (int)metadataNames.length);
        ImageMosaicPostgisIndexOnlineTest.assertEquals((String)"true", (String)reader.getMetadataValue("HAS_TIME_DOMAIN"));
        String timeMetadata = reader.getMetadataValue("TIME_DOMAIN");
        ImageMosaicPostgisIndexOnlineTest.assertNotNull((Object)timeMetadata);
        ImageMosaicPostgisIndexOnlineTest.assertEquals((int)2, (int)timeMetadata.split(",").length);
        ImageMosaicPostgisIndexOnlineTest.assertEquals((String)timeMetadata.split(",")[0], (String)reader.getMetadataValue("TIME_DOMAIN_MINIMUM"));
        ImageMosaicPostgisIndexOnlineTest.assertEquals((String)timeMetadata.split(",")[1], (String)reader.getMetadataValue("TIME_DOMAIN_MAXIMUM"));
        ImageMosaicPostgisIndexOnlineTest.assertEquals((String)"true", (String)reader.getMetadataValue("HAS_ELEVATION_DOMAIN"));
        String elevationMetadata = reader.getMetadataValue("ELEVATION_DOMAIN");
        ImageMosaicPostgisIndexOnlineTest.assertNotNull((Object)elevationMetadata);
        ImageMosaicPostgisIndexOnlineTest.assertEquals((int)2, (int)elevationMetadata.split(",").length);
        ImageMosaicPostgisIndexOnlineTest.assertEquals((double)Double.parseDouble(elevationMetadata.split(",")[0]), (double)Double.parseDouble(reader.getMetadataValue("ELEVATION_DOMAIN_MINIMUM")), (double)1.0E-6);
        ImageMosaicPostgisIndexOnlineTest.assertEquals((double)Double.parseDouble(elevationMetadata.split(",")[1]), (double)Double.parseDouble(reader.getMetadataValue("ELEVATION_DOMAIN_MAXIMUM")), (double)1.0E-6);
        ParameterValue gg = AbstractGridFormat.READ_GRIDGEOMETRY2D.createValue();
        GeneralBounds envelope = reader.getOriginalEnvelope();
        Dimension dim = new Dimension();
        dim.setSize((double)reader.getOriginalGridRange().getSpan(0) / 2.0, (double)reader.getOriginalGridRange().getSpan(1) / 2.0);
        GridEnvelope2D rasterArea = (GridEnvelope2D)reader.getOriginalGridRange();
        rasterArea.setSize(dim);
        GridEnvelope2D range = new GridEnvelope2D((Rectangle)rasterArea);
        gg.setValue((Object)new GridGeometry2D((GridEnvelope)range, (Bounds)envelope));
        ParameterValue time = ImageMosaicFormat.TIME.createValue();
        ArrayList<Date> timeValues = new ArrayList<Date>();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.sss'Z'");
        sdf.setTimeZone(TimeZone.getTimeZone("GMT+0"));
        Date date = sdf.parse("2008-10-31T00:00:00.000Z");
        timeValues.add(date);
        time.setValue(timeValues);
        ParameterValue bkg = ImageMosaicFormat.BACKGROUND_VALUES.createValue();
        bkg.setValue((Object)new double[]{-9999.0});
        ParameterValue direct = ImageMosaicFormat.USE_JAI_IMAGEREAD.createValue();
        direct.setValue(false);
        ParameterValue elevation = ImageMosaicFormat.ELEVATION.createValue();
        elevation.setValue(Arrays.asList(100.0));
        ImageMosaicPostgisIndexOnlineTest.assertNotNull((Object)reader.read(new GeneralParameterValue[]{gg, time, bkg, elevation, direct}));
        TestUtils.checkCoverage(reader, new GeneralParameterValue[]{gg, time, bkg, elevation, direct}, "Time-Elevation Test");
        reader = TestUtils.getReader(dataUrl, format, null);
        elevation.setValue(Arrays.asList(NumberRange.create((double)0.0, (double)10.0)));
        TestUtils.checkCoverage(reader, new GeneralParameterValue[]{gg, time, bkg, elevation, direct}, "Time-Elevation Test");
        reader.dispose();
    }

    protected void tearDownInternal() throws Exception {
        this.dropTables(new String[]{tempFolderNoEpsg, tempFolderName1, tempFolderName2, "zNotGeom", "wNoGeom", tempFolderName3, VERY_LONG_NAME.substring(0, 63)});
        System.clearProperty("org.geotools.referencing.forceXY");
        if (!ImageMosaicReaderTest.INTERACTIVE) {
            File parent = TestData.file((Object)((Object)this), (String)".");
            for (String name : Arrays.asList(tempFolderName1, tempFolderName2, tempFolderName3, tempFolderName4, tempFolderNameWrap, tempFolderNoEpsg)) {
                File directory = new File(parent, name);
                if (!directory.isDirectory() || !directory.exists()) continue;
                FileUtils.deleteDirectory((File)directory);
            }
        }
        super.tearDownInternal();
    }

    private static class MyImageMosaicReader
    extends ImageMosaicReader {
        public MyImageMosaicReader(Object source) throws IOException {
            super(source);
        }

        public MyImageMosaicReader(Object source, Hints uHints) throws IOException {
            super(source, uHints);
        }
    }
}

