/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.gce.imagepyramid;

import it.geosolutions.imageio.maskband.DatasetLayout;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.channels.Channels;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.ImageReadParam;
import javax.media.jai.ImageLayout;
import org.geotools.coverage.CoverageFactoryFinder;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.coverage.grid.GridEnvelope2D;
import org.geotools.coverage.grid.GridGeometry2D;
import org.geotools.coverage.grid.io.AbstractGridCoverage2DReader;
import org.geotools.coverage.grid.io.AbstractGridFormat;
import org.geotools.coverage.grid.io.OverviewPolicy;
import org.geotools.data.DataSourceException;
import org.geotools.data.PrjFileReader;
import org.geotools.gce.imagemosaic.ImageMosaicReader;
import org.geotools.gce.imagepyramid.ImageLevelsMapper;
import org.geotools.gce.imagepyramid.ImagePyramidFormat;
import org.geotools.gce.imagepyramid.Utils;
import org.geotools.geometry.GeneralEnvelope;
import org.geotools.referencing.operation.builder.GridToEnvelopeMapper;
import org.geotools.util.URLs;
import org.geotools.util.factory.Hints;
import org.geotools.util.logging.Logging;
import org.opengis.coverage.grid.Format;
import org.opengis.coverage.grid.GridCoverageReader;
import org.opengis.coverage.grid.GridEnvelope;
import org.opengis.geometry.Envelope;
import org.opengis.parameter.GeneralParameterValue;
import org.opengis.parameter.ParameterDescriptor;
import org.opengis.parameter.ParameterValue;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.datum.PixelInCell;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.TransformException;

public final class ImagePyramidReader
extends AbstractGridCoverage2DReader
implements GridCoverageReader {
    private static final Logger LOGGER = Logging.getLogger(ImagePyramidReader.class);
    private URL sourceURL;
    private String[] coverageNames;
    private int count = 1;
    private ImageLevelsMapper imageLevelsMapper;

    public ImagePyramidReader(Object source, Hints uHints) throws IOException {
        this.hints = uHints == null ? new Hints((RenderingHints.Key)Hints.FORCE_LONGITUDE_FIRST_AXIS_ORDER, (Object)Boolean.TRUE) : uHints;
        this.coverageFactory = CoverageFactoryFinder.getGridCoverageFactory((Hints)this.hints);
        if (source == null) {
            throw new DataSourceException("ImagePyramidReader:null source set to read this coverage.");
        }
        this.source = source;
        this.sourceURL = Utils.checkSource(source, uHints);
        if (this.sourceURL == null) {
            throw new DataSourceException("This plugin accepts only a URL, a File or a String pointing to a directory with a structure similar to the one of gdal_retile!");
        }
        URL prjURL = URLs.changeUrlExt((URL)this.sourceURL, (String)"prj");
        PrjFileReader crsReader = null;
        try {
            crsReader = new PrjFileReader(Channels.newChannel(prjURL.openStream()));
        }
        catch (FactoryException e) {
            throw new DataSourceException((Throwable)e);
        }
        finally {
            block16: {
                try {
                    crsReader.close();
                }
                catch (Throwable e) {
                    if (!LOGGER.isLoggable(Level.FINE)) break block16;
                    LOGGER.log(Level.FINE, e.getLocalizedMessage(), e);
                }
            }
        }
        Object tempCRS = this.hints.get((Object)Hints.DEFAULT_COORDINATE_REFERENCE_SYSTEM);
        if (tempCRS != null) {
            this.crs = (CoordinateReferenceSystem)tempCRS;
            LOGGER.log(Level.WARNING, "Using forced coordinate reference system " + this.crs.toWKT());
        } else {
            CoordinateReferenceSystem tempcrs = crsReader.getCoordinateReferenceSystem();
            if (tempcrs == null) {
                this.crs = AbstractGridFormat.getDefaultCRS();
                LOGGER.log(Level.WARNING, "Unable to find a CRS for this coverage, using a default one: " + this.crs.toWKT());
            } else {
                this.crs = tempcrs;
            }
        }
        this.parseMainFile(this.sourceURL);
    }

    private void parseMainFile(URL sourceURL) throws IOException {
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("Parsing pyramid properties file at:" + sourceURL.toExternalForm());
        }
        try (InputStream in = sourceURL.openStream();
             BufferedInputStream propertyStream = new BufferedInputStream(in);){
            Properties properties = new Properties();
            properties.load(propertyStream);
            String envelope = properties.getProperty("Envelope2D");
            String[] pairs = envelope.split(" ");
            double[][] cornersV = new double[2][2];
            for (int i = 0; i < 2; ++i) {
                String[] pair = pairs[i].split(",");
                cornersV[i][0] = Double.parseDouble(pair[0]);
                cornersV[i][1] = Double.parseDouble(pair[1]);
            }
            this.originalEnvelope = new GeneralEnvelope(cornersV[0], cornersV[1]);
            this.originalEnvelope.setCoordinateReferenceSystem(this.crs);
            this.imageLevelsMapper = new ImageLevelsMapper(properties);
            this.numOverviews = this.imageLevelsMapper.getNumOverviews();
            this.overViewResolutions = this.imageLevelsMapper.getOverViewResolutions();
            this.highestRes = this.imageLevelsMapper.getHighestResolution();
            this.coverageName = properties.getProperty("Name");
            if (this.coverageName != null) {
                if (this.coverageName.contains(",")) {
                    this.coverageNames = this.coverageName.split(",");
                    this.coverageName = this.coverageNames[0];
                } else {
                    this.coverageNames = new String[]{this.coverageName};
                }
                this.count = this.coverageNames.length;
            }
            this.originalGridRange = new GridEnvelope2D(new Rectangle((int)Math.round(this.originalEnvelope.getSpan(0) / this.highestRes[0]), (int)Math.round(this.originalEnvelope.getSpan(1) / this.highestRes[1])));
            GridToEnvelopeMapper geMapper = new GridToEnvelopeMapper(this.originalGridRange, (Envelope)this.originalEnvelope);
            geMapper.setPixelAnchor(PixelInCell.CELL_CORNER);
            this.raster2Model = geMapper.createTransform();
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("Parsed pyramid properties file at:" + sourceURL.toExternalForm());
            }
        }
    }

    public ImagePyramidReader(Object source) throws IOException {
        this(source, null);
    }

    public Format getFormat() {
        return new ImagePyramidFormat();
    }

    public GridCoverage2D read(GeneralParameterValue[] params) throws IOException {
        return this.read(this.coverageName, params);
    }

    public GridEnvelope getOriginalGridRange(String coverageName) {
        return this.getFirstLevelReader(coverageName, false).getOriginalGridRange(this.getReaderCoverageName(coverageName));
    }

    public CoordinateReferenceSystem getCoordinateReferenceSystem(String coverageName) {
        return this.getFirstLevelReader(coverageName, false).getCoordinateReferenceSystem(this.getReaderCoverageName(coverageName));
    }

    public GeneralEnvelope getOriginalEnvelope(String coverageName) {
        return this.getFirstLevelReader(coverageName, false).getOriginalEnvelope(this.getReaderCoverageName(coverageName));
    }

    public MathTransform getOriginalGridToWorld(String coverageName, PixelInCell pixInCell) {
        return this.getFirstLevelReader(coverageName, false).getOriginalGridToWorld(this.getReaderCoverageName(coverageName), pixInCell);
    }

    public Set<ParameterDescriptor<List>> getDynamicParameters(String coverageName) {
        return this.getFirstLevelReader(coverageName, false).getDynamicParameters(this.getReaderCoverageName(coverageName));
    }

    public DatasetLayout getDatasetLayout(String coverageName) {
        return this.getFirstLevelReader(coverageName, false).getDatasetLayout(this.getReaderCoverageName(coverageName));
    }

    public ImageLayout getImageLayout(String coverageName) throws IOException {
        return this.getFirstLevelReader(coverageName, false).getImageLayout(this.getReaderCoverageName(coverageName));
    }

    public double[][] getResolutionLevels(String coverageName) throws IOException {
        return this.getFirstLevelReader(coverageName, false).getResolutionLevels(this.getReaderCoverageName(coverageName));
    }

    public GridCoverage2D read(String coverageName, GeneralParameterValue[] params) throws IOException {
        GeneralEnvelope requestedEnvelope = null;
        Rectangle dim = null;
        OverviewPolicy overviewPolicy = null;
        if (params != null) {
            for (int i = 0; i < params.length; ++i) {
                ParameterValue param = (ParameterValue)params[i];
                if (param == null) continue;
                String name = param.getDescriptor().getName().getCode();
                if (name.equals(AbstractGridFormat.READ_GRIDGEOMETRY2D.getName().toString())) {
                    GridGeometry2D gg = (GridGeometry2D)param.getValue();
                    requestedEnvelope = new GeneralEnvelope((Envelope)gg.getEnvelope2D());
                    dim = gg.getGridRange2D().getBounds();
                    continue;
                }
                if (!name.equals(AbstractGridFormat.OVERVIEW_POLICY.getName().toString())) continue;
                overviewPolicy = (OverviewPolicy)param.getValue();
            }
        }
        return this.loadRequestedTiles(coverageName, requestedEnvelope, dim, params, overviewPolicy);
    }

    private GridCoverage2D loadRequestedTiles(String coverageName, GeneralEnvelope requestedEnvelope, Rectangle dim, GeneralParameterValue[] params, OverviewPolicy overviewPolicy) throws IOException {
        ImageReadParam readP = new ImageReadParam();
        Integer imageChoice = 0;
        if (dim != null) {
            try {
                imageChoice = this.setReadParams(overviewPolicy, readP, requestedEnvelope, dim);
            }
            catch (TransformException e) {
                throw new DataSourceException((Throwable)e);
            }
        }
        if (!this.imageLevelsMapper.hasReaders()) {
            throw new IllegalStateException("This ImagePyramidReader has already been disposed");
        }
        ImageMosaicReader reader = this.getImageMosaicReaderForLevel(coverageName, imageChoice);
        GridCoverage2D mosaicCoverage = reader.read(this.getReaderCoverageName(coverageName), params);
        if (mosaicCoverage != null) {
            return new GridCoverage2D((CharSequence)coverageName, mosaicCoverage);
        }
        return null;
    }

    public synchronized void dispose() {
        super.dispose();
        this.imageLevelsMapper.dispose();
    }

    public String[] getGridCoverageNames() {
        return this.coverageNames;
    }

    public int getGridCoverageCount() {
        return this.count;
    }

    public String getMetadataValue(String coverageName, String name) {
        return this.getImageMosaicMetadataValue(coverageName, name);
    }

    public String getMetadataValue(String name) {
        return this.getImageMosaicMetadataValue(this.coverageName, name);
    }

    private ImageMosaicReader getFirstLevelReader(String coverageName) {
        return this.getFirstLevelReader(coverageName, false);
    }

    private ImageMosaicReader getFirstLevelReader(String coverageName, boolean canBeNull) {
        ImageMosaicReader reader;
        block3: {
            reader = null;
            try {
                reader = this.getImageMosaicReaderForLevel(coverageName, 0);
            }
            catch (IOException e) {
                if (LOGGER.isLoggable(Level.WARNING)) {
                    LOGGER.log(Level.WARNING, "Could not get reader for datasource.", e);
                }
                if (reader != null || canBeNull) break block3;
                throw new IllegalArgumentException("Could not get reader for the specified coverageName: " + coverageName, e);
            }
        }
        return reader;
    }

    private String getImageMosaicMetadataValue(String coverageName, String name) {
        ImageMosaicReader firstLevelReader = this.getFirstLevelReader(coverageName);
        if (firstLevelReader == null) {
            return null;
        }
        if (name.equalsIgnoreCase("HAS_TIME_DOMAIN")) {
            return String.valueOf(this.hasTimeDomain(coverageName, firstLevelReader));
        }
        if (("TIME_DOMAIN".equalsIgnoreCase(name) || "TIME_DOMAIN_MAXIMUM".equalsIgnoreCase(name) || "TIME_DOMAIN_MINIMUM".equalsIgnoreCase(name)) && this.hasTimeDomain(coverageName, firstLevelReader)) {
            return this.getTimeDomain(coverageName, firstLevelReader, name);
        }
        return firstLevelReader.getMetadataValue(this.getReaderCoverageName(coverageName), name);
    }

    public String[] getMetadataNames(String coverageName) {
        return this.getMetadataNames();
    }

    public String[] getMetadataNames() {
        String[] parentNames = super.getMetadataNames();
        ArrayList<String> metadataNames = new ArrayList<String>();
        metadataNames.add("TIME_DOMAIN");
        metadataNames.add("HAS_TIME_DOMAIN");
        metadataNames.add("TIME_DOMAIN_MINIMUM");
        metadataNames.add("TIME_DOMAIN_MAXIMUM");
        metadataNames.add("TIME_DOMAIN_RESOLUTION");
        if (parentNames != null) {
            metadataNames.addAll(Arrays.asList(parentNames));
        }
        return metadataNames.toArray(new String[metadataNames.size()]);
    }

    private String getTimeDomain(String coverageName, ImageMosaicReader reader, String name) {
        if (this.hasTimeDomain(coverageName, reader) && reader != null) {
            return reader.getMetadataValue(this.getReaderCoverageName(coverageName), name);
        }
        return null;
    }

    private boolean hasTimeDomain(String coverageName, ImageMosaicReader reader) {
        if (reader != null) {
            String strHasTimeDomain = reader.getMetadataValue(this.getReaderCoverageName(coverageName), "HAS_TIME_DOMAIN");
            return Boolean.parseBoolean(strHasTimeDomain);
        }
        return false;
    }

    public ImageMosaicReader getImageMosaicReaderForLevel(Integer imageChoice) throws IOException {
        return this.getImageMosaicReaderForLevel(this.coverageName, imageChoice);
    }

    public ImageMosaicReader getImageMosaicReaderForLevel(String coverageName, Integer imageChoice) throws IOException {
        return this.imageLevelsMapper.getReader(imageChoice, coverageName, this.sourceURL, this.hints);
    }

    private String getReaderCoverageName(String coverageName) {
        return this.count > 1 ? coverageName : "_UN$PECIFIED_";
    }
}

