/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.singlestore;

import java.io.IOException;
import org.geotools.api.filter.expression.Expression;
import org.geotools.api.filter.expression.ExpressionVisitor;
import org.geotools.api.filter.expression.Literal;
import org.geotools.api.filter.expression.PropertyName;
import org.geotools.api.filter.spatial.BBOX;
import org.geotools.api.filter.spatial.Beyond;
import org.geotools.api.filter.spatial.BinarySpatialOperator;
import org.geotools.api.filter.spatial.Contains;
import org.geotools.api.filter.spatial.Crosses;
import org.geotools.api.filter.spatial.DWithin;
import org.geotools.api.filter.spatial.Disjoint;
import org.geotools.api.filter.spatial.DistanceBufferOperator;
import org.geotools.api.filter.spatial.Equals;
import org.geotools.api.filter.spatial.Intersects;
import org.geotools.api.filter.spatial.Overlaps;
import org.geotools.api.filter.spatial.Touches;
import org.geotools.api.filter.spatial.Within;
import org.geotools.data.jdbc.FilterToSQL;
import org.geotools.filter.FilterCapabilities;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.LinearRing;

public class SingleStoreFilterToSQL
extends FilterToSQL {
    protected FilterCapabilities createFilterCapabilities() {
        FilterCapabilities caps = super.createFilterCapabilities();
        caps.addType(BBOX.class);
        caps.addType(Contains.class);
        caps.addType(Intersects.class);
        caps.addType(DWithin.class);
        caps.addType(Beyond.class);
        return caps;
    }

    protected void visitLiteralGeometry(Literal expression) throws IOException {
        Geometry g = (Geometry)this.evaluateLiteral(expression, Geometry.class);
        if (g instanceof LinearRing) {
            g = g.getFactory().createLineString(((LinearRing)g).getCoordinateSequence());
        }
        this.out.write("'" + g.toText() + "'");
    }

    protected Object visitBinarySpatialOperator(BinarySpatialOperator filter, PropertyName property, Literal geometry, boolean swapped, Object extraData) {
        return this.visitBinarySpatialOperator(filter, (Expression)property, (Expression)geometry, swapped, extraData);
    }

    protected Object visitBinarySpatialOperator(BinarySpatialOperator filter, Expression e1, Expression e2, Object extraData) {
        return this.visitBinarySpatialOperator(filter, e1, e2, false, extraData);
    }

    protected Object visitBinarySpatialOperator(BinarySpatialOperator filter, Expression e1, Expression e2, boolean swapped, Object extraData) {
        try {
            if (!(filter instanceof Disjoint)) {
                this.out.write("APPROX_GEOGRAPHY_INTERSECTS(");
                e1.accept((ExpressionVisitor)this, extraData);
                this.out.write(",");
                e2.accept((ExpressionVisitor)this, extraData);
                this.out.write(")");
                if (!(filter instanceof BBOX)) {
                    this.out.write(" AND ");
                }
            }
            if (filter instanceof BBOX) {
                return extraData;
            }
            if (filter instanceof DistanceBufferOperator) {
                this.out.write("GEOGRAPHY_DISTANCE(");
                e1.accept((ExpressionVisitor)this, extraData);
                this.out.write(", ");
                e2.accept((ExpressionVisitor)this, extraData);
                this.out.write(")");
                if (filter instanceof DWithin) {
                    this.out.write("<");
                } else if (filter instanceof Beyond) {
                    this.out.write(">");
                } else {
                    throw new RuntimeException("Unknown distance operator");
                }
                this.out.write(Double.toString(((DistanceBufferOperator)filter).getDistance()));
            } else if (!(filter instanceof BBOX)) {
                if (filter instanceof Contains) {
                    this.out.write("GEOGRAPHY_CONTAINS(");
                } else if (filter instanceof Intersects) {
                    this.out.write("GEOGRAPHY_INTERSECTS(");
                } else {
                    throw new RuntimeException("Unknown operator: " + filter);
                }
                if (swapped) {
                    e2.accept((ExpressionVisitor)this, extraData);
                    this.out.write(", ");
                    e1.accept((ExpressionVisitor)this, extraData);
                } else {
                    e1.accept((ExpressionVisitor)this, extraData);
                    this.out.write(", ");
                    e2.accept((ExpressionVisitor)this, extraData);
                }
                this.out.write(")");
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return extraData;
    }

    protected Object visitBinarySpatialOperatorEnhanced(BinarySpatialOperator filter, Expression e1, Expression e2, boolean swapped, Object extraData) {
        try {
            if (filter instanceof DistanceBufferOperator) {
                this.out.write("ST_Distance(");
                e1.accept((ExpressionVisitor)this, extraData);
                this.out.write(", ");
                e2.accept((ExpressionVisitor)this, extraData);
                this.out.write(")");
                if (filter instanceof DWithin) {
                    this.out.write("<");
                } else if (filter instanceof Beyond) {
                    this.out.write(">");
                } else {
                    throw new RuntimeException("Unknown distance operator");
                }
                this.out.write(Double.toString(((DistanceBufferOperator)filter).getDistance()));
            } else if (filter instanceof BBOX) {
                this.out.write("MBRIntersects(");
                e1.accept((ExpressionVisitor)this, extraData);
                this.out.write(",");
                e2.accept((ExpressionVisitor)this, extraData);
                this.out.write(")");
            } else {
                if (filter instanceof Contains) {
                    this.out.write("ST_Contains(");
                } else if (filter instanceof Crosses) {
                    this.out.write("ST_Crosses(");
                } else if (filter instanceof Disjoint) {
                    this.out.write("ST_Disjoint(");
                } else if (filter instanceof Equals) {
                    this.out.write("ST_Equals(");
                } else if (filter instanceof Intersects) {
                    this.out.write("ST_Intersects(");
                } else if (filter instanceof Overlaps) {
                    this.out.write("ST_Overlaps(");
                } else if (filter instanceof Touches) {
                    this.out.write("ST_Touches(");
                } else if (filter instanceof Within) {
                    this.out.write("ST_Within(");
                } else {
                    throw new RuntimeException("Unknown operator: " + filter);
                }
                if (swapped) {
                    e2.accept((ExpressionVisitor)this, extraData);
                    this.out.write(", ");
                    e1.accept((ExpressionVisitor)this, extraData);
                } else {
                    e1.accept((ExpressionVisitor)this, extraData);
                    this.out.write(", ");
                    e2.accept((ExpressionVisitor)this, extraData);
                }
                this.out.write(")");
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return extraData;
    }
}

