/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.singlestore;

import java.util.ArrayList;
import org.geotools.api.filter.Filter;
import org.geotools.api.filter.FilterFactory;
import org.geotools.api.filter.expression.Expression;
import org.geotools.api.filter.expression.Literal;
import org.geotools.api.filter.spatial.BBOX;
import org.geotools.filter.visitor.DuplicatingFilterVisitor;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LinearRing;
import org.locationtech.jts.geom.Polygon;

public class SingleStoreLargeGeometryPreProcessor
extends DuplicatingFilterVisitor {
    private static final double EPS = 0.1;
    private static final Envelope WORLD_ENVELOPE = new Envelope(-179.9, 179.9, -89.9, 89.9);
    private static final double GEODESIC_DENSIFICATION = Double.parseDouble(System.getProperty("org.geotools.singlestore.densification", "1"));
    private static final double MAX_GEOMETRY_SPAN = 180.0;
    private static final GeometryFactory GEOMETRY_FACTORY = new GeometryFactory();

    public Object visit(BBOX filter, Object extraData) {
        FilterFactory ff = this.getFactory(extraData);
        Expression propertyName = this.visit(filter.getExpression1(), extraData);
        Expression box = filter.getExpression2();
        if (box instanceof Literal && ((Literal)box).getValue() instanceof Envelope) {
            Envelope envelope = (Envelope)((Literal)box).getValue();
            if (!WORLD_ENVELOPE.contains(envelope)) {
                envelope = envelope.intersection(WORLD_ENVELOPE);
            }
            if (envelope.getWidth() > 180.0) {
                double mid = (envelope.getMinX() + envelope.getMaxX()) / 2.0;
                Envelope leftPart = new Envelope(envelope.getMinX(), mid, envelope.getMinY(), envelope.getMaxY());
                Envelope rightPart = new Envelope(mid, envelope.getMaxX(), envelope.getMinY(), envelope.getMaxY());
                Polygon leftPolygon = SingleStoreLargeGeometryPreProcessor.densifyEnvelope(leftPart, GEOMETRY_FACTORY);
                Polygon rightPolygon = SingleStoreLargeGeometryPreProcessor.densifyEnvelope(rightPart, GEOMETRY_FACTORY);
                return ff.or((Filter)ff.intersects(propertyName, (Expression)ff.literal((Object)leftPolygon)), (Filter)ff.intersects(propertyName, (Expression)ff.literal((Object)rightPolygon)));
            }
            if (envelope.getWidth() > GEODESIC_DENSIFICATION || envelope.getHeight() > GEODESIC_DENSIFICATION) {
                Polygon polygon = SingleStoreLargeGeometryPreProcessor.densifyEnvelope(envelope, GEOMETRY_FACTORY);
                return ff.intersects(propertyName, (Expression)ff.literal((Object)polygon));
            }
        }
        box = this.visit(box, extraData);
        return ff.bbox(propertyName, box, filter.getMatchAction());
    }

    static Polygon densifyEnvelope(Envelope env, GeometryFactory geomFactory) {
        double x;
        ArrayList<Coordinate> coordinates = new ArrayList<Coordinate>();
        double minX = env.getMinX();
        double maxX = env.getMaxX();
        double minY = env.getMinY();
        double maxY = env.getMaxY();
        for (x = minX; x < maxX; x += GEODESIC_DENSIFICATION) {
            coordinates.add(new Coordinate(x, minY));
        }
        coordinates.add(new Coordinate(maxX, minY));
        coordinates.add(new Coordinate(maxX, maxY));
        for (x = maxX; x > minX; x -= GEODESIC_DENSIFICATION) {
            coordinates.add(new Coordinate(x, maxY));
        }
        coordinates.add(new Coordinate(minX, maxY));
        coordinates.add(new Coordinate(minX, minY));
        LinearRing shell = geomFactory.createLinearRing(coordinates.toArray(new Coordinate[0]));
        return geomFactory.createPolygon(shell, null);
    }
}

