/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.jdbc;

import java.io.IOException;
import java.sql.Connection;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import org.apache.commons.lang3.RandomStringUtils;
import org.geotools.data.DataUtilities;
import org.geotools.data.FeatureReader;
import org.geotools.data.FeatureWriter;
import org.geotools.data.Query;
import org.geotools.data.Transaction;
import org.geotools.data.store.ContentFeatureCollection;
import org.geotools.data.store.ContentFeatureSource;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.NameImpl;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.geotools.jdbc.Index;
import org.geotools.jdbc.JDBCDataStoreFactory;
import org.geotools.jdbc.JDBCTestSupport;
import org.geotools.referencing.CRS;
import org.junit.Assert;
import org.junit.Test;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.io.WKTReader;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.AttributeDescriptor;
import org.opengis.feature.type.AttributeType;
import org.opengis.feature.type.Name;
import org.opengis.filter.Filter;
import org.opengis.filter.FilterFactory;
import org.opengis.filter.PropertyIsEqualTo;
import org.opengis.filter.expression.Expression;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public abstract class JDBCDataStoreOnlineTest
extends JDBCTestSupport {
    @Test
    public void testGetNames() throws IOException {
        String[] typeNames = this.dataStore.getTypeNames();
        Assert.assertTrue((boolean)new HashSet<String>(Arrays.asList(typeNames)).contains(this.tname("ft1")));
    }

    @Test
    public void testGetSchema() throws Exception {
        SimpleFeatureType ft1 = this.dataStore.getSchema(this.tname("ft1"));
        Assert.assertNotNull((Object)ft1);
        Assert.assertNotNull((Object)ft1.getDescriptor(this.aname("geometry")));
        Assert.assertNotNull((Object)ft1.getDescriptor(this.aname("intProperty")));
        Assert.assertNotNull((Object)ft1.getDescriptor(this.aname("doubleProperty")));
        Assert.assertNotNull((Object)ft1.getDescriptor(this.aname("stringProperty")));
        Assert.assertTrue((boolean)Geometry.class.isAssignableFrom(ft1.getDescriptor(this.aname("geometry")).getType().getBinding()));
        Assert.assertTrue((boolean)Number.class.isAssignableFrom(ft1.getDescriptor(this.aname("intProperty")).getType().getBinding()));
        Assert.assertEquals(Double.class, (Object)ft1.getDescriptor(this.aname("doubleProperty")).getType().getBinding());
        Assert.assertEquals(String.class, (Object)ft1.getDescriptor(this.aname("stringProperty")).getType().getBinding());
    }

    @Test
    public void testCreateSchema() throws Exception {
        SimpleFeatureTypeBuilder builder = new SimpleFeatureTypeBuilder();
        builder.setName(this.tname("ft2"));
        builder.setNamespaceURI(this.dataStore.getNamespaceURI());
        builder.setCRS(CRS.decode((String)"EPSG:4326"));
        builder.add(this.aname("geometry"), Geometry.class);
        builder.add(this.aname("intProperty"), Integer.class);
        builder.add(this.aname("dateProperty"), Date.class);
        SimpleFeatureType featureType = builder.buildFeatureType();
        this.dataStore.createSchema(featureType);
        SimpleFeatureType ft2 = this.dataStore.getSchema(this.tname("ft2"));
        this.assertEqualsLax(ft2, featureType);
        Assert.assertNotSame((Object)ft2, (Object)featureType);
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT * FROM ");
        if (this.dataStore.getDatabaseSchema() != null) {
            this.dataStore.getSQLDialect().encodeSchemaName(this.dataStore.getDatabaseSchema(), sql);
            sql.append(".");
        }
        this.dataStore.getSQLDialect().encodeTableName("ft2", sql);
        try (Connection cx = this.dataStore.createConnection();
             Statement st = cx.createStatement();){
            ResultSet rs = st.executeQuery(sql.toString());
            if (rs != null) {
                rs.close();
            }
        }
    }

    @Test
    public void testCreateSchemaWithConstraints() throws Exception {
        SimpleFeatureTypeBuilder builder = new SimpleFeatureTypeBuilder();
        builder.setName(this.tname("ft2"));
        builder.setNamespaceURI(this.dataStore.getNamespaceURI());
        builder.setCRS(CRS.decode((String)"EPSG:4326"));
        builder.add(this.aname("geometry"), Geometry.class);
        builder.nillable(false).add(this.aname("intProperty"), Integer.class);
        builder.length(5).add(this.aname("stringProperty"), String.class);
        SimpleFeatureType featureType = builder.buildFeatureType();
        this.dataStore.createSchema(featureType);
        this.dataStore.getSchema(this.tname("ft2"));
        try (FeatureWriter w = this.dataStore.getFeatureWriter(this.tname("ft2"), Transaction.AUTO_COMMIT);){
            w.hasNext();
            SimpleFeature f = (SimpleFeature)w.next();
            f.setAttribute(1, (Object)0);
            f.setAttribute(2, (Object)"hello");
            w.write();
            w.hasNext();
            f = (SimpleFeature)w.next();
            f.setAttribute(1, null);
            try {
                w.write();
                Assert.fail((String)"null value for intProperty should have failed");
            }
            catch (Exception exception) {
                // empty catch block
            }
            f.setAttribute(1, (Object)1);
            f.setAttribute(2, (Object)"hello!");
            try {
                w.write();
                Assert.fail((String)"string greather than 5 chars should have failed");
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @Test
    public void testCreateSchemaWithNativeTypename() throws Exception {
        this.assertLargeText(b -> b.userData((Object)"org.geotools.jdbc.nativeTypeName", (Object)this.getCLOBTypeName()));
    }

    protected String getCLOBTypeName() {
        return "CLOB";
    }

    @Test
    public void testCreateSchemaWithNativeType() throws Exception {
        this.assertLargeText(b -> b.userData((Object)"org.geotools.jdbc.nativeType", (Object)2005));
    }

    private void assertLargeText(Consumer<SimpleFeatureTypeBuilder> stringCustomizer) throws FactoryException, IOException {
        SimpleFeatureTypeBuilder builder = new SimpleFeatureTypeBuilder();
        String typeName = this.tname("ft2");
        builder.setName(typeName);
        builder.setNamespaceURI(this.dataStore.getNamespaceURI());
        builder.setCRS(CRS.decode((String)"EPSG:4326"));
        builder.add(this.aname("geometry"), Geometry.class);
        builder.nillable(false).add(this.aname("intProperty"), Integer.class);
        String stringProperty = this.aname("stringProperty");
        stringCustomizer.accept(builder);
        builder.add(stringProperty, String.class);
        SimpleFeatureType featureType = builder.buildFeatureType();
        this.dataStore.createSchema(featureType);
        String largeString = RandomStringUtils.random((int)32768, (boolean)true, (boolean)false);
        try (FeatureWriter w = this.dataStore.getFeatureWriter(typeName, Transaction.AUTO_COMMIT);){
            w.hasNext();
            SimpleFeature f = (SimpleFeature)w.next();
            f.setAttribute(1, (Object)123);
            f.setAttribute(2, (Object)largeString);
            w.write();
        }
        ContentFeatureCollection fc = this.dataStore.getFeatureSource(typeName).getFeatures();
        SimpleFeature test = (SimpleFeature)DataUtilities.first((FeatureCollection)fc);
        Assert.assertEquals((Object)largeString, (Object)test.getAttribute(stringProperty));
    }

    @Test
    public void testRemoveSchema() throws Exception {
        SimpleFeatureType ft = this.dataStore.getSchema(this.tname("ft1"));
        Assert.assertNotNull((Object)ft);
        this.dataStore.removeSchema(this.tname("ft1"));
        try {
            this.dataStore.getSchema(this.tname("ft1"));
            Assert.fail((String)"getSchema() should fail if table was deleted");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Test
    public void testSimpleIndex() throws Exception {
        SimpleFeatureType ft = this.dataStore.getSchema(this.tname("ft1"));
        Assert.assertNotNull((Object)ft);
        String ft1TypeName = ft.getTypeName();
        List indexes = this.dataStore.getIndexes(ft1TypeName);
        Assert.assertNotNull((Object)indexes);
        int initialSize = indexes.size();
        String indexName = "ft1_str_index";
        Index stringIndex = new Index(ft1TypeName, indexName, false, new String[]{this.aname("stringProperty")});
        this.dataStore.createIndex(stringIndex);
        indexes = this.dataStore.getIndexes(ft1TypeName);
        Assert.assertEquals((long)(initialSize + 1), (long)indexes.size());
        for (Index index : indexes) {
            Assert.assertEquals((Object)ft1TypeName, (Object)index.getTypeName());
            if (!index.getIndexName().equals(indexName)) continue;
            List attributes = index.getAttributes();
            Assert.assertEquals((long)1L, (long)attributes.size());
            Assert.assertEquals((Object)this.aname("stringProperty"), attributes.get(0));
            Assert.assertFalse((boolean)index.isUnique());
        }
        this.dataStore.dropIndex(ft1TypeName, indexName);
        indexes = this.dataStore.getIndexes(ft1TypeName);
        Assert.assertEquals((long)initialSize, (long)indexes.size());
        for (Index index : indexes) {
            Assert.assertEquals((Object)ft1TypeName, (Object)index.getTypeName());
            if (!index.getIndexName().equals(indexName)) continue;
            Assert.fail((String)"the index has not been removed");
        }
    }

    @Test
    public void testMultiColumnIndex() throws Exception {
        SimpleFeatureType ft = this.dataStore.getSchema(this.tname("ft1"));
        Assert.assertNotNull((Object)ft);
        String ft1TypeName = ft.getTypeName();
        List indexes = this.dataStore.getIndexes(ft1TypeName);
        Assert.assertNotNull((Object)indexes);
        int initialSize = indexes.size();
        String indexName = "ft1_str_index";
        Index stringIndex = new Index(ft1TypeName, indexName, false, new String[]{this.aname("stringProperty"), this.aname("intProperty")});
        this.dataStore.createIndex(stringIndex);
        indexes = this.dataStore.getIndexes(ft1TypeName);
        Assert.assertEquals((long)(initialSize + 1), (long)indexes.size());
        for (Index index : indexes) {
            Assert.assertEquals((Object)ft1TypeName, (Object)index.getTypeName());
            if (!index.getIndexName().equals(indexName)) continue;
            List attributes = index.getAttributes();
            Assert.assertEquals((long)2L, (long)attributes.size());
            Assert.assertEquals((Object)this.aname("stringProperty"), attributes.get(0));
            Assert.assertEquals((Object)this.aname("intProperty"), attributes.get(1));
        }
        this.dataStore.dropIndex(ft1TypeName, indexName);
        indexes = this.dataStore.getIndexes(ft1TypeName);
        Assert.assertEquals((long)initialSize, (long)indexes.size());
        for (Index index : indexes) {
            Assert.assertEquals((Object)ft1TypeName, (Object)index.getTypeName());
            if (!index.getIndexName().equals(indexName)) continue;
            Assert.fail((String)"the index has not been removed");
        }
    }

    @Test
    public void testCreateSchemaUTMCRS() throws Exception {
        SimpleFeatureTypeBuilder builder = new SimpleFeatureTypeBuilder();
        builder.setName(this.tname("ft2"));
        builder.setNamespaceURI(this.dataStore.getNamespaceURI());
        builder.setCRS(this.getUTMCRS());
        builder.add(this.aname("geometry"), Point.class);
        builder.add(this.aname("intProperty"), Integer.class);
        builder.add(this.aname("stringProperty"), String.class);
        SimpleFeatureType featureType = builder.buildFeatureType();
        this.dataStore.createSchema(featureType);
        SimpleFeatureType ft2 = this.dataStore.getSchema(this.tname("ft2"));
        Assert.assertNotNull((Object)ft2);
        try (FeatureWriter w = this.dataStore.getFeatureWriter(this.tname("ft2"), Transaction.AUTO_COMMIT);){
            w.hasNext();
            SimpleFeature f = (SimpleFeature)w.next();
            Geometry g = new WKTReader().read("POINT(593493 4914730)");
            g.setSRID(26713);
            f.setAttribute(0, (Object)g);
            f.setAttribute(1, (Object)0);
            f.setAttribute(2, (Object)"hello");
            w.write();
        }
        this.dataStore.getEntry((Name)new NameImpl(this.dataStore.getNamespaceURI(), this.tname("ft2"))).dispose();
        ft2 = this.dataStore.getSchema(this.tname("ft2"));
        Assert.assertTrue((boolean)CRS.equalsIgnoreMetadata((Object)this.getUTMCRS(), (Object)ft2.getCoordinateReferenceSystem()));
    }

    protected CoordinateReferenceSystem getUTMCRS() throws FactoryException {
        return this.decodeEPSG(26713);
    }

    @Test
    public void testCreateSchemaFidColumn() throws Exception {
        SimpleFeatureTypeBuilder builder = new SimpleFeatureTypeBuilder();
        builder.setName(this.tname("ft2"));
        builder.setNamespaceURI(this.dataStore.getNamespaceURI());
        builder.setCRS(this.getUTMCRS());
        builder.add(this.aname("geometry"), Point.class);
        builder.add(this.aname("intProperty"), Integer.class);
        builder.add(this.aname("stringProperty"), String.class);
        builder.add(this.aname("fid"), String.class);
        SimpleFeatureType featureType = builder.buildFeatureType();
        this.dataStore.createSchema(featureType);
        SimpleFeatureType ft2 = this.dataStore.getSchema(this.tname("ft2"));
        Assert.assertNotNull((Object)ft2.getDescriptor(this.aname("fid")));
    }

    void assertEqualsLax(SimpleFeatureType e, SimpleFeatureType a) {
        if (e.equals(a)) {
            return;
        }
        Assert.assertEquals((long)e.getAttributeCount(), (long)a.getAttributeCount());
        for (int i = 0; i < e.getAttributeCount(); ++i) {
            AttributeDescriptor att1 = e.getDescriptor(i);
            AttributeDescriptor att2 = a.getDescriptor(i);
            Assert.assertEquals((Object)att1.getName(), (Object)att2.getName());
            Assert.assertEquals((long)att1.getMinOccurs(), (long)att2.getMinOccurs());
            Assert.assertEquals((long)att1.getMaxOccurs(), (long)att2.getMaxOccurs());
            Assert.assertEquals((Object)att1.isNillable(), (Object)att2.isNillable());
            Assert.assertEquals((Object)att1.getDefaultValue(), (Object)att2.getDefaultValue());
            AttributeType t1 = att1.getType();
            AttributeType t2 = att2.getType();
            Assert.assertEquals((Object)t1.getName(), (Object)t2.getName());
            Assert.assertEquals((Object)t1.getDescription(), (Object)t2.getDescription());
            Assert.assertEquals((Object)t1.getRestrictions(), (Object)t2.getRestrictions());
            if (t1.getBinding().equals(t2.getBinding())) continue;
            if (Number.class.isAssignableFrom(t1.getBinding())) {
                Assert.assertTrue((boolean)Number.class.isAssignableFrom(t2.getBinding()));
            }
            if (!Date.class.isAssignableFrom(t2.getBinding())) continue;
            Assert.assertTrue((boolean)Date.class.isAssignableFrom(t2.getBinding()));
        }
    }

    @Test
    public void testGetFeatureSource() throws Exception {
        ContentFeatureSource featureSource = this.dataStore.getFeatureSource(this.tname("ft1"));
        Assert.assertNotNull((Object)featureSource);
    }

    @Test
    public void testGetFeatureReader() throws Exception {
        final GeometryFactory gf = this.dataStore.getGeometryFactory();
        Query query = new Query(this.tname("ft1"));
        try (FeatureReader reader = this.dataStore.getFeatureReader(query, Transaction.AUTO_COMMIT);){
            this.assertFeatureReader(0, 3, reader, new JDBCTestSupport.SimpleFeatureAssertion(){

                @Override
                public int toIndex(SimpleFeature feature) {
                    return ((Number)feature.getAttribute(JDBCDataStoreOnlineTest.this.aname("intProperty"))).intValue();
                }

                @Override
                public void check(int index, SimpleFeature feature) {
                    Assert.assertEquals((long)4L, (long)feature.getAttributeCount());
                    Point p = gf.createPoint(new Coordinate((double)index, (double)index));
                    Assert.assertTrue((boolean)p.equalsExact((Geometry)feature.getAttribute(JDBCDataStoreOnlineTest.this.aname("geometry"))));
                    Number ip = (Number)feature.getAttribute(JDBCDataStoreOnlineTest.this.aname("intProperty"));
                    Assert.assertEquals((long)index, (long)ip.intValue());
                }
            });
        }
        query.setPropertyNames(new String[]{this.aname("intProperty")});
        reader = this.dataStore.getFeatureReader(query, Transaction.AUTO_COMMIT);
        try {
            for (int i = 0; i < 3; ++i) {
                Assert.assertTrue((boolean)reader.hasNext());
                SimpleFeature feature = (SimpleFeature)reader.next();
                Assert.assertEquals((long)1L, (long)feature.getAttributeCount());
            }
            Assert.assertFalse((boolean)reader.hasNext());
        }
        finally {
            if (reader != null) {
                reader.close();
            }
        }
        FilterFactory ff = this.dataStore.getFilterFactory();
        PropertyIsEqualTo f = ff.equals((Expression)ff.property(this.aname("intProperty")), (Expression)ff.literal(1));
        query.setFilter((Filter)f);
        try (FeatureReader reader = this.dataStore.getFeatureReader(query, Transaction.AUTO_COMMIT);){
            for (int i = 0; i < 1; ++i) {
                Assert.assertTrue((boolean)reader.hasNext());
                reader.next();
            }
            Assert.assertFalse((boolean)reader.hasNext());
        }
    }

    @Test
    public void testGetFeatureWriter() throws IOException {
        try (FeatureWriter writer = this.dataStore.getFeatureWriter(this.tname("ft1"), Transaction.AUTO_COMMIT);){
            while (writer.hasNext()) {
                SimpleFeature feature = (SimpleFeature)writer.next();
                feature.setAttribute(this.aname("stringProperty"), (Object)"foo");
                writer.write();
            }
        }
        Query query = new Query(this.tname("ft1"));
        try (FeatureReader reader = this.dataStore.getFeatureReader(query, Transaction.AUTO_COMMIT);){
            Assert.assertTrue((boolean)reader.hasNext());
            while (reader.hasNext()) {
                SimpleFeature feature = (SimpleFeature)reader.next();
                Assert.assertEquals((Object)"foo", (Object)feature.getAttribute(this.aname("stringProperty")));
            }
        }
    }

    @Test
    public void testGetFeatureWriterWithFilter() throws IOException {
        FilterFactory ff = this.dataStore.getFilterFactory();
        PropertyIsEqualTo f = ff.equals((Expression)ff.property(this.aname("intProperty")), (Expression)ff.literal(100));
        ContentFeatureCollection features = this.dataStore.getFeatureSource(this.tname("ft1")).getFeatures((Filter)f);
        Assert.assertEquals((long)0L, (long)features.size());
        f = ff.equals((Expression)ff.property(this.aname("intProperty")), (Expression)ff.literal(1));
        try (FeatureWriter writer = this.dataStore.getFeatureWriter(this.tname("ft1"), (Filter)f, Transaction.AUTO_COMMIT);){
            while (writer.hasNext()) {
                SimpleFeature feature = (SimpleFeature)writer.next();
                feature.setAttribute(this.aname("intProperty"), (Object)100);
                writer.write();
            }
        }
        f = ff.equals((Expression)ff.property(this.aname("intProperty")), (Expression)ff.literal(100));
        features = this.dataStore.getFeatureSource(this.tname("ft1")).getFeatures((Filter)f);
        Assert.assertEquals((long)1L, (long)features.size());
    }

    @Test
    public void testGetFeatureWriterAppend() throws IOException {
        try (FeatureWriter writer = this.dataStore.getFeatureWriterAppend(this.tname("ft1"), Transaction.AUTO_COMMIT);){
            for (int i = 3; i < 6; ++i) {
                SimpleFeature feature = (SimpleFeature)writer.next();
                feature.setAttribute(this.aname("intProperty"), (Object)i);
                writer.write();
            }
        }
        ContentFeatureCollection features = this.dataStore.getFeatureSource(this.tname("ft1")).getFeatures();
        Assert.assertEquals((long)6L, (long)features.size());
    }

    @Override
    protected Map<String, Object> createDataStoreFactoryParams() throws Exception {
        Map<String, Object> params = super.createDataStoreFactoryParams();
        params.put(JDBCDataStoreFactory.BATCH_INSERT_SIZE.key, 1);
        return params;
    }
}

