/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.jdbc;

import java.io.IOException;
import org.geotools.data.simple.SimpleFeatureIterator;
import org.geotools.data.store.ContentFeatureCollection;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.feature.NameImpl;
import org.geotools.jdbc.JDBCFeatureStoreOnlineTest;
import org.junit.Assert;
import org.junit.Test;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.type.Name;
import org.opengis.filter.Filter;
import org.opengis.filter.FilterFactory;
import org.opengis.filter.PropertyIsEqualTo;
import org.opengis.filter.expression.Expression;

public abstract class JDBCFeatureStoreExposePkOnlineTest
extends JDBCFeatureStoreOnlineTest {
    @Override
    protected void connect() throws Exception {
        super.connect();
        this.featureStore.setExposePrimaryKeyColumns(true);
    }

    @Test
    public void testModifyExposedPk() throws IOException {
        FilterFactory ff = CommonFactoryFinder.getFilterFactory();
        PropertyIsEqualTo filter = ff.equal((Expression)ff.property(this.aname("stringProperty")), (Expression)ff.literal((Object)"zero"), false);
        this.featureStore.modifyFeatures(new Name[]{new NameImpl(this.aname("stringProperty")), new NameImpl(this.aname("id"))}, new Object[]{"foo", 123}, (Filter)filter);
        PropertyIsEqualTo idFilter = ff.equal((Expression)ff.property(this.aname("id")), (Expression)ff.literal(0), false);
        ContentFeatureCollection features = this.featureStore.getFeatures((Filter)idFilter);
        try (SimpleFeatureIterator i = features.features();){
            Assert.assertTrue((boolean)i.hasNext());
            while (i.hasNext()) {
                SimpleFeature feature = (SimpleFeature)i.next();
                Assert.assertEquals((Object)"foo", (Object)feature.getAttribute(this.aname("stringProperty")));
                Assert.assertEquals((long)0L, (long)((Number)feature.getAttribute(this.aname("id"))).intValue());
            }
        }
    }
}

