/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.jdbc;

import org.geotools.data.DataUtilities;
import org.geotools.data.FeatureStore;
import org.geotools.data.Transaction;
import org.geotools.data.simple.SimpleFeatureIterator;
import org.geotools.data.store.ContentFeatureCollection;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.jdbc.JDBCNoPrimaryKeyTestSetup;
import org.geotools.jdbc.JDBCTestSupport;
import org.junit.Assert;
import org.junit.Test;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.filter.FilterFactory;

public abstract class JDBCNoPrimaryKeyOnlineTest
extends JDBCTestSupport {
    protected static final String LAKE = "lake";
    protected static final String ID = "id";
    protected static final String NAME = "name";
    protected static final String GEOM = "geom";
    protected FilterFactory ff = CommonFactoryFinder.getFilterFactory(null);
    protected SimpleFeatureType lakeSchema;

    @Override
    protected abstract JDBCNoPrimaryKeyTestSetup createTestSetup();

    @Override
    protected void connect() throws Exception {
        super.connect();
        this.lakeSchema = DataUtilities.createType((String)(this.dataStore.getNamespaceURI() + ".lake"), (String)"id:0,geom:Polygon,name:String");
    }

    @Test
    public void testSchema() throws Exception {
        SimpleFeatureType ft = this.dataStore.getSchema(this.tname(LAKE));
        this.assertFeatureTypesEqual(this.lakeSchema, ft);
    }

    @Test
    public void testReadFeatures() throws Exception {
        ContentFeatureCollection fc = this.dataStore.getFeatureSource(this.tname(LAKE)).getFeatures();
        Assert.assertEquals((long)1L, (long)fc.size());
        try (SimpleFeatureIterator fr = fc.features();){
            Assert.assertTrue((boolean)fr.hasNext());
            fr.next();
            Assert.assertFalse((boolean)fr.hasNext());
        }
    }

    @Test
    public void testGetBounds() throws Exception {
        ReferencedEnvelope reference = this.dataStore.getFeatureSource(this.tname(LAKE)).getBounds();
        Assert.assertEquals((double)12.0, (double)reference.getMinX(), (double)0.0);
        Assert.assertEquals((double)16.0, (double)reference.getMaxX(), (double)0.0);
        Assert.assertEquals((double)4.0, (double)reference.getMinY(), (double)0.0);
        Assert.assertEquals((double)8.0, (double)reference.getMaxY(), (double)0.0);
    }

    @Test
    public void testReadOnly() throws Exception {
        try {
            this.dataStore.getFeatureWriter(this.tname(LAKE), Transaction.AUTO_COMMIT);
            Assert.fail((String)"Should not be able to pick a writer without a pk");
        }
        catch (Exception exception) {
            // empty catch block
        }
        Assert.assertFalse((boolean)(this.dataStore.getFeatureSource(this.tname(LAKE)) instanceof FeatureStore));
    }
}

