/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.jdbc;

import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.geotools.data.Join;
import org.geotools.data.Query;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.data.simple.SimpleFeatureIterator;
import org.geotools.data.store.ContentFeatureSource;
import org.geotools.jdbc.JDBCDateTestSetup;
import org.geotools.jdbc.JDBCTestSupport;
import org.geotools.temporal.object.DefaultInstant;
import org.geotools.temporal.object.DefaultPeriod;
import org.geotools.temporal.object.DefaultPosition;
import org.geotools.util.Converters;
import org.junit.Assert;
import org.junit.Test;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.filter.Filter;
import org.opengis.filter.FilterFactory;
import org.opengis.filter.expression.Expression;
import org.opengis.filter.sort.SortBy;
import org.opengis.filter.sort.SortOrder;
import org.opengis.filter.temporal.After;
import org.opengis.filter.temporal.Before;
import org.opengis.filter.temporal.Begins;
import org.opengis.filter.temporal.BegunBy;
import org.opengis.filter.temporal.During;
import org.opengis.filter.temporal.Ends;
import org.opengis.filter.temporal.TContains;
import org.opengis.filter.temporal.TEquals;
import org.opengis.temporal.Instant;
import org.opengis.temporal.Period;
import org.opengis.temporal.Position;

public abstract class JDBCTemporalFilterOnlineTest
extends JDBCTestSupport {
    DateFormat FORMAT = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

    @Override
    protected abstract JDBCDateTestSetup createTestSetup();

    void assertDatesMatch(Filter filter, String ... dates) throws Exception {
        FilterFactory ff = this.dataStore.getFilterFactory();
        Query query = new Query(this.aname("dates"), filter);
        query.setSortBy(new SortBy[]{ff.sort(this.aname("dt"), SortOrder.ASCENDING)});
        this.assertDatesMatch(query, dates);
    }

    protected void assertDatesMatch(Query query, String ... dates) throws Exception {
        ContentFeatureSource source = this.dataStore.getFeatureSource(this.tname("dates"));
        Assert.assertEquals((long)dates.length, (long)source.getCount(query));
        SimpleFeatureCollection features = source.getFeatures(query);
        try (SimpleFeatureIterator it = features.features();){
            int i = 0;
            while (it.hasNext()) {
                SimpleFeature f = (SimpleFeature)it.next();
                Date expected = this.date(dates[i++]);
                Assert.assertEquals((Object)Converters.convert((Object)expected, Timestamp.class), (Object)f.getAttribute(this.aname("dt")));
            }
        }
    }

    @Test
    public void testAfter() throws Exception {
        FilterFactory ff = this.dataStore.getFilterFactory();
        After after = ff.after((Expression)ff.property(this.aname("dt")), (Expression)ff.literal((Object)"2009-02-01 00:00:00"));
        this.assertDatesMatch((Filter)after, "2009-06-28 15:12:41", "2009-09-29 17:54:23");
    }

    @Test
    public void testAfterInterval() throws Exception {
        Period period = this.period("2009-02-01 00:00:00", "2009-07-01 00:00:00");
        FilterFactory ff = this.dataStore.getFilterFactory();
        After after = ff.after((Expression)ff.property(this.aname("dt")), (Expression)ff.literal((Object)period));
        this.assertDatesMatch((Filter)after, "2009-09-29 17:54:23");
        after = ff.after((Expression)ff.literal((Object)period), (Expression)ff.property(this.aname("dt")));
        this.assertDatesMatch((Filter)after, "2009-01-15 13:10:12");
    }

    @Test
    public void testBefore() throws Exception {
        FilterFactory ff = this.dataStore.getFilterFactory();
        Before before = ff.before((Expression)ff.property(this.aname("dt")), (Expression)ff.literal((Object)"2009-02-01 00:00:00"));
        this.assertDatesMatch((Filter)before, "2009-01-15 13:10:12");
    }

    @Test
    public void testBeforeInterval() throws Exception {
        Period period = this.period("2009-07-01 00:00:00", "2009-12-01 00:00:00");
        FilterFactory ff = this.dataStore.getFilterFactory();
        Before before = ff.before((Expression)ff.property(this.aname("dt")), (Expression)ff.literal((Object)period));
        this.assertDatesMatch((Filter)before, "2009-01-15 13:10:12", "2009-06-28 15:12:41");
        period = this.period("2009-07-01 00:00:00", "2009-08-01 00:00:00");
        before = ff.before((Expression)ff.literal((Object)period), (Expression)ff.property(this.aname("dt")));
        this.assertDatesMatch((Filter)before, "2009-09-29 17:54:23");
    }

    @Test
    public void testBegins() throws Exception {
        Period period = this.period("2009-01-15 13:10:12", "2009-06-28 15:12:41");
        FilterFactory ff = this.dataStore.getFilterFactory();
        Begins before = ff.begins((Expression)ff.property(this.aname("dt")), (Expression)ff.literal((Object)period));
        this.assertDatesMatch((Filter)before, "2009-01-15 13:10:12");
    }

    @Test
    public void testBegunBy() throws Exception {
        Period period = this.period("2009-01-15 13:10:12", "2009-06-28 15:12:41");
        FilterFactory ff = this.dataStore.getFilterFactory();
        BegunBy before = ff.begunBy((Expression)ff.literal((Object)period), (Expression)ff.property(this.aname("dt")));
        this.assertDatesMatch((Filter)before, "2009-01-15 13:10:12");
    }

    @Test
    public void testEnds() throws Exception {
        Period period = this.period("2009-01-15 13:10:12", "2009-06-28 15:12:41");
        FilterFactory ff = this.dataStore.getFilterFactory();
        Ends before = ff.ends((Expression)ff.property(this.aname("dt")), (Expression)ff.literal((Object)period));
        this.assertDatesMatch((Filter)before, "2009-06-28 15:12:41");
    }

    @Test
    public void testEndedBy() throws Exception {
        Period period = this.period("2009-01-15 13:10:12", "2009-06-28 15:12:41");
        FilterFactory ff = this.dataStore.getFilterFactory();
        Ends before = ff.ends((Expression)ff.property(this.aname("dt")), (Expression)ff.literal((Object)period));
        this.assertDatesMatch((Filter)before, "2009-06-28 15:12:41");
    }

    @Test
    public void testDuring() throws Exception {
        Period period = this.period("2009-01-01 00:00:00", "2009-07-28 15:12:41");
        FilterFactory ff = this.dataStore.getFilterFactory();
        During during = ff.during((Expression)ff.property(this.aname("dt")), (Expression)ff.literal((Object)period));
        this.assertDatesMatch((Filter)during, "2009-01-15 13:10:12", "2009-06-28 15:12:41");
    }

    @Test
    public void testTContains() throws Exception {
        Period period = this.period("2009-01-01 00:00:00", "2009-07-28 15:12:41");
        FilterFactory ff = this.dataStore.getFilterFactory();
        TContains during = ff.tcontains((Expression)ff.literal((Object)period), (Expression)ff.property(this.aname("dt")));
        this.assertDatesMatch((Filter)during, "2009-01-15 13:10:12", "2009-06-28 15:12:41");
    }

    @Test
    public void testTEquals() throws Exception {
        FilterFactory ff = this.dataStore.getFilterFactory();
        TEquals equals = ff.tequals((Expression)ff.literal((Object)"2009-01-15 13:10:12"), (Expression)ff.property(this.aname("dt")));
        this.assertDatesMatch((Filter)equals, "2009-01-15 13:10:12");
    }

    @Test
    public void testTemporalJoin() throws Exception {
        FilterFactory ff = this.dataStore.getFilterFactory();
        After after = ff.after((Expression)ff.property(this.aname("dt")), (Expression)ff.property("other." + this.aname("dt")));
        Query q = new Query(this.tname("dates"));
        q.getJoins().add(new Join(this.tname("dates"), (Filter)after).alias("other"));
        q.setSortBy(new SortBy[]{ff.sort(this.aname("dt"), SortOrder.ASCENDING)});
        this.assertDatesMatch(q, "2009-06-28 15:12:41", "2009-09-29 17:54:23", "2009-09-29 17:54:23");
    }

    protected Date date(String date) throws ParseException {
        return this.FORMAT.parse(date);
    }

    protected Instant instant(String d) throws ParseException {
        return new DefaultInstant((Position)new DefaultPosition(this.date(d)));
    }

    protected Period period(String d1, String d2) throws ParseException {
        return new DefaultPeriod(this.instant(d1), this.instant(d2));
    }
}

