/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.jdbc;

import java.util.Arrays;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.geotools.filter.visitor.SimplifyingFilterVisitor;
import org.geotools.jdbc.NullHandlingVisitor;
import org.junit.Assert;
import org.junit.Test;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.FeatureType;
import org.opengis.filter.And;
import org.opengis.filter.Filter;
import org.opengis.filter.FilterFactory2;
import org.opengis.filter.FilterVisitor;
import org.opengis.filter.Not;
import org.opengis.filter.Or;
import org.opengis.filter.PropertyIsBetween;
import org.opengis.filter.PropertyIsEqualTo;
import org.opengis.filter.PropertyIsLike;
import org.opengis.filter.expression.Expression;
import org.opengis.filter.expression.PropertyName;

public class NullHandlingVisitorTest {
    FilterFactory2 ff = CommonFactoryFinder.getFilterFactory2();

    @Test
    public void testBetween() {
        PropertyIsBetween between = this.ff.between((Expression)this.ff.property("a"), (Expression)this.ff.property("b"), (Expression)this.ff.property("c"));
        NullHandlingVisitor visitor = new NullHandlingVisitor();
        Filter result = (Filter)between.accept((FilterVisitor)visitor, null);
        Assert.assertTrue((boolean)(result instanceof And));
        And expected = this.ff.and(Arrays.asList(between, this.propertyNotNull("a"), this.propertyNotNull("b"), this.propertyNotNull("c")));
        Assert.assertEquals((Object)expected, (Object)result);
        between = this.ff.between((Expression)this.ff.property("a"), (Expression)this.ff.property("b"), (Expression)this.ff.literal(10));
        result = (Filter)between.accept((FilterVisitor)visitor, null);
        Assert.assertTrue((boolean)(result instanceof And));
        expected = this.ff.and(Arrays.asList(between, this.propertyNotNull("a"), this.propertyNotNull("b")));
        Assert.assertEquals((Object)expected, (Object)result);
        between = this.ff.between((Expression)this.ff.property("a"), (Expression)this.ff.literal(5), (Expression)this.ff.literal(10));
        result = (Filter)between.accept((FilterVisitor)visitor, null);
        Assert.assertTrue((boolean)(result instanceof And));
        expected = this.ff.and(Arrays.asList(between, this.propertyNotNull("a")));
        Assert.assertEquals((Object)expected, (Object)result);
        between = this.ff.between((Expression)this.ff.literal(7), (Expression)this.ff.literal(5), (Expression)this.ff.literal(10));
        result = (Filter)between.accept((FilterVisitor)visitor, null);
        Assert.assertEquals((Object)between, (Object)result);
    }

    @Test
    public void testLike() {
        PropertyIsLike like = this.ff.like((Expression)this.ff.property("a"), "*A*");
        NullHandlingVisitor visitor = new NullHandlingVisitor();
        Filter result = (Filter)like.accept((FilterVisitor)visitor, null);
        Assert.assertTrue((boolean)(result instanceof And));
        And expected = this.ff.and((Filter)like, (Filter)this.propertyNotNull("a"));
        Assert.assertEquals((Object)expected, (Object)result);
        like = this.ff.like((Expression)this.ff.literal((Object)"a"), "*A*");
        result = (Filter)like.accept((FilterVisitor)visitor, null);
        Assert.assertEquals((Object)like, (Object)result);
    }

    @Test
    public void testBinaryComparison() {
        PropertyIsEqualTo equal = this.ff.equal((Expression)this.ff.property("a"), (Expression)this.ff.property("b"), false);
        NullHandlingVisitor visitor = new NullHandlingVisitor();
        Filter result = (Filter)equal.accept((FilterVisitor)visitor, null);
        Assert.assertTrue((boolean)(result instanceof And));
        And expected = this.ff.and(Arrays.asList(equal, this.propertyNotNull("a"), this.propertyNotNull("b")));
        Assert.assertEquals((Object)expected, (Object)result);
        equal = this.ff.equal((Expression)this.ff.property("a"), (Expression)this.ff.literal(10), false);
        result = (Filter)equal.accept((FilterVisitor)visitor, null);
        Assert.assertTrue((boolean)(result instanceof And));
        expected = this.ff.and(Arrays.asList(equal, this.propertyNotNull("a")));
        Assert.assertEquals((Object)expected, (Object)result);
        equal = this.ff.equal((Expression)this.ff.literal(10), (Expression)this.ff.property("b"), false);
        result = (Filter)equal.accept((FilterVisitor)visitor, null);
        Assert.assertTrue((boolean)(result instanceof And));
        expected = this.ff.and(Arrays.asList(equal, this.propertyNotNull("b")));
        Assert.assertEquals((Object)expected, (Object)result);
        equal = this.ff.equal((Expression)this.ff.literal(10), (Expression)this.ff.literal(20), false);
        result = (Filter)equal.accept((FilterVisitor)visitor, null);
        Assert.assertEquals((Object)equal, (Object)result);
    }

    @Test
    public void testNullableAttributes() {
        SimpleFeatureTypeBuilder tb = new SimpleFeatureTypeBuilder();
        tb.nillable(true);
        tb.add("a", String.class);
        tb.nillable(false);
        tb.add("b", String.class);
        tb.nillable(true);
        tb.add("c", String.class);
        tb.setName("test");
        SimpleFeatureType schema = tb.buildFeatureType();
        PropertyIsBetween between = this.ff.between((Expression)this.ff.property("a"), (Expression)this.ff.property("b"), (Expression)this.ff.property("c"));
        NullHandlingVisitor visitor = new NullHandlingVisitor((FeatureType)schema);
        Filter result = (Filter)between.accept((FilterVisitor)visitor, null);
        Assert.assertTrue((boolean)(result instanceof And));
        And expected = this.ff.and(Arrays.asList(between, this.propertyNotNull("a"), this.propertyNotNull("c")));
        Assert.assertEquals((Object)expected, (Object)result);
    }

    @Test
    public void testSimplifyRedundant() {
        PropertyIsBetween between = this.ff.between((Expression)this.ff.property("a"), (Expression)this.ff.property("b"), (Expression)this.ff.property("c"));
        PropertyIsEqualTo equal = this.ff.equal((Expression)this.ff.property("a"), (Expression)this.ff.property("b"), false);
        And and = this.ff.and((Filter)between, (Filter)equal);
        NullHandlingVisitor nh = new NullHandlingVisitor();
        Filter nhResult = (Filter)and.accept((FilterVisitor)nh, null);
        SimplifyingFilterVisitor simplifier = new SimplifyingFilterVisitor();
        Filter simplified = (Filter)nhResult.accept((FilterVisitor)simplifier, null);
        Assert.assertTrue((boolean)(simplified instanceof And));
        And expected = this.ff.and(Arrays.asList(between, equal, this.propertyNotNull("a"), this.propertyNotNull("b"), this.propertyNotNull("c")));
        Assert.assertEquals((Object)expected, (Object)simplified);
    }

    private Not propertyNotNull(String name) {
        return this.ff.not((Filter)this.ff.isNull((Expression)this.ff.property(name)));
    }

    @Test
    public void testRepeatedOr() {
        PropertyName p = this.ff.property("prop");
        Or orFilter = this.ff.or(Arrays.asList(this.ff.equal((Expression)p, (Expression)this.ff.literal((Object)"zero"), true), this.ff.equal((Expression)p, (Expression)this.ff.literal((Object)"one"), true), this.ff.equal((Expression)p, (Expression)this.ff.literal((Object)"two"), true)));
        NullHandlingVisitor nh = new NullHandlingVisitor();
        Filter nhResult = (Filter)orFilter.accept((FilterVisitor)nh, null);
        And expected = this.ff.and(Arrays.asList(orFilter, this.ff.not((Filter)this.ff.isNull((Expression)p))));
        Assert.assertEquals((Object)expected, (Object)nhResult);
    }

    @Test
    public void testRepeatedMixedOr() {
        PropertyName spp = this.ff.property("sp");
        PropertyName ipp = this.ff.property("ip");
        PropertyName dpp = this.ff.property("dp");
        Or orFilter = this.ff.or(Arrays.asList(this.ff.equal((Expression)spp, (Expression)this.ff.literal((Object)"zero"), true), this.ff.equal((Expression)ipp, (Expression)this.ff.literal(1), true), this.ff.equal((Expression)dpp, (Expression)this.ff.literal(0.0), true), this.ff.equal((Expression)spp, (Expression)this.ff.literal((Object)"two"), true), this.ff.equal((Expression)ipp, (Expression)this.ff.literal(2), true)));
        NullHandlingVisitor nh = new NullHandlingVisitor();
        Filter nhResult = (Filter)orFilter.accept((FilterVisitor)nh, null);
        Or expected = this.ff.or(Arrays.asList(this.ff.and((Filter)this.ff.or((Filter)this.ff.equal((Expression)spp, (Expression)this.ff.literal((Object)"zero"), true), (Filter)this.ff.equal((Expression)spp, (Expression)this.ff.literal((Object)"two"), true)), (Filter)this.ff.not((Filter)this.ff.isNull((Expression)spp))), this.ff.and((Filter)this.ff.or((Filter)this.ff.equal((Expression)ipp, (Expression)this.ff.literal(1), true), (Filter)this.ff.equal((Expression)ipp, (Expression)this.ff.literal(2), true)), (Filter)this.ff.not((Filter)this.ff.isNull((Expression)ipp))), this.ff.and((Filter)this.ff.equal((Expression)dpp, (Expression)this.ff.literal(0.0), true), (Filter)this.ff.not((Filter)this.ff.isNull((Expression)dpp)))));
        Assert.assertEquals((Object)expected, (Object)nhResult);
    }
}

