/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.jdbc;

import org.geotools.api.data.FeatureWriter;
import org.geotools.api.data.Transaction;
import org.geotools.api.feature.simple.SimpleFeature;
import org.geotools.data.DefaultTransaction;
import org.geotools.data.simple.SimpleFeatureIterator;
import org.geotools.data.store.ContentFeatureCollection;
import org.geotools.jdbc.JDBCEmptyGeometryTestSetup;
import org.geotools.jdbc.JDBCTestSupport;
import org.junit.Assert;
import org.junit.Test;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.io.WKTReader;

public abstract class JDBCEmptyGeometryOnlineTest
extends JDBCTestSupport {
    @Override
    protected abstract JDBCEmptyGeometryTestSetup createTestSetup();

    @Test
    public void testEmptyPoint() throws Exception {
        this.testInsertEmptyGeometry("POINT");
    }

    @Test
    public void testEmptyLine() throws Exception {
        this.testInsertEmptyGeometry("LINESTRING");
    }

    @Test
    public void testEmptyPolygon() throws Exception {
        this.testInsertEmptyGeometry("POLYGON");
    }

    @Test
    public void testEmptyMultiPoint() throws Exception {
        this.testInsertEmptyGeometry("MULTIPOINT");
    }

    @Test
    public void testEmptyMultiLine() throws Exception {
        this.testInsertEmptyGeometry("MULTILINESTRING");
    }

    @Test
    public void testEmptyMultiPolygon() throws Exception {
        this.testInsertEmptyGeometry("MULTIPOLYGON");
    }

    private void testInsertEmptyGeometry(String type) throws Exception {
        WKTReader reader = new WKTReader();
        Geometry emptyGeometry = reader.read(type.toUpperCase() + " EMPTY");
        String emptyGeometryName = this.aname("geom_" + type.toLowerCase());
        try (DefaultTransaction tx = new DefaultTransaction();
             FeatureWriter writer = this.dataStore.getFeatureWriterAppend(this.tname("empty"), (Transaction)tx);){
            SimpleFeature feature = (SimpleFeature)writer.next();
            feature.setAttribute(this.aname("id"), (Object)100);
            feature.setAttribute(emptyGeometryName, (Object)emptyGeometry);
            feature.setAttribute(this.aname("name"), (Object)("empty " + type));
            writer.write();
            writer.close();
            tx.commit();
        }
        ContentFeatureCollection fc = this.dataStore.getFeatureSource(this.tname("empty")).getFeatures();
        Assert.assertEquals((long)1L, (long)fc.size());
        try (SimpleFeatureIterator fi = fc.features();){
            SimpleFeature nf = (SimpleFeature)fi.next();
            Geometry geometry = (Geometry)nf.getAttribute(emptyGeometryName);
            this.assertEmptyGeometry(geometry);
        }
    }

    protected void assertEmptyGeometry(Geometry geometry) {
        Assert.assertTrue((geometry == null || geometry.isEmpty() ? 1 : 0) != 0);
    }
}

