/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.jdbc;

import java.awt.RenderingHints;
import java.sql.Connection;
import java.util.Arrays;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geotools.api.data.Query;
import org.geotools.api.data.QueryCapabilities;
import org.geotools.api.data.Transaction;
import org.geotools.api.feature.Feature;
import org.geotools.api.feature.FeatureVisitor;
import org.geotools.api.feature.simple.SimpleFeature;
import org.geotools.api.feature.simple.SimpleFeatureType;
import org.geotools.api.filter.And;
import org.geotools.api.filter.Filter;
import org.geotools.api.filter.FilterFactory;
import org.geotools.api.filter.Or;
import org.geotools.api.filter.PropertyIsEqualTo;
import org.geotools.api.filter.PropertyIsLike;
import org.geotools.api.filter.expression.Expression;
import org.geotools.api.filter.expression.Function;
import org.geotools.api.filter.expression.PropertyName;
import org.geotools.api.filter.expression.Subtract;
import org.geotools.api.filter.sort.SortBy;
import org.geotools.api.filter.sort.SortOrder;
import org.geotools.api.filter.spatial.BBOX;
import org.geotools.api.geometry.Bounds;
import org.geotools.data.DataUtilities;
import org.geotools.data.DefaultTransaction;
import org.geotools.data.jdbc.FilterToSQL;
import org.geotools.data.simple.SimpleFeatureIterator;
import org.geotools.data.store.ContentFeatureCollection;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.feature.FeatureCollection;
import org.geotools.filter.function.FilterFunction_strToLowerCase;
import org.geotools.geometry.jts.LiteCoordinateSequenceFactory;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.jdbc.BasicSQLDialect;
import org.geotools.jdbc.JDBCFeatureStore;
import org.geotools.jdbc.JDBCTestSupport;
import org.geotools.jdbc.PreparedFilterToSQL;
import org.geotools.jdbc.PreparedStatementSQLDialect;
import org.geotools.jdbc.SQLDialect;
import org.geotools.util.factory.Hints;
import org.junit.Assert;
import org.junit.Test;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;

public abstract class JDBCFeatureSourceOnlineTest
extends JDBCTestSupport {
    protected JDBCFeatureStore featureSource;

    @Override
    protected void connect() throws Exception {
        super.connect();
        this.featureSource = (JDBCFeatureStore)this.dataStore.getFeatureSource(this.tname("ft1"));
    }

    @Test
    public void testSchema() throws Exception {
        SimpleFeatureType schema = this.featureSource.getSchema();
        Assert.assertEquals((Object)this.tname("ft1"), (Object)schema.getTypeName());
        Assert.assertEquals((Object)this.dataStore.getNamespaceURI(), (Object)schema.getName().getNamespaceURI());
        Assert.assertTrue((boolean)this.areCRSEqual(this.decodeEPSG(4326), schema.getCoordinateReferenceSystem()));
        Assert.assertEquals((long)4L, (long)schema.getAttributeCount());
        Assert.assertNotNull((Object)schema.getDescriptor(this.aname("geometry")));
        Assert.assertNotNull((Object)schema.getDescriptor(this.aname("intProperty")));
        Assert.assertNotNull((Object)schema.getDescriptor(this.aname("stringProperty")));
        Assert.assertNotNull((Object)schema.getDescriptor(this.aname("doubleProperty")));
    }

    @Test
    public void testBounds() throws Exception {
        ReferencedEnvelope bounds = this.featureSource.getBounds();
        Assert.assertEquals((long)0L, (long)Math.round(bounds.getMinX()));
        Assert.assertEquals((long)0L, (long)Math.round(bounds.getMinY()));
        Assert.assertEquals((long)2L, (long)Math.round(bounds.getMaxX()));
        Assert.assertEquals((long)2L, (long)Math.round(bounds.getMaxY()));
        Assert.assertTrue((boolean)this.areCRSEqual(this.decodeEPSG(4326), bounds.getCoordinateReferenceSystem()));
    }

    @Test
    public void testBoundsWithQuery() throws Exception {
        FilterFactory ff = this.dataStore.getFilterFactory();
        PropertyIsEqualTo filter = ff.equals((Expression)ff.property(this.aname("stringProperty")), (Expression)ff.literal((Object)"one"));
        Query query = new Query();
        query.setFilter((Filter)filter);
        ReferencedEnvelope bounds = this.featureSource.getBounds(query);
        Assert.assertEquals((long)1L, (long)Math.round(bounds.getMinX()));
        Assert.assertEquals((long)1L, (long)Math.round(bounds.getMinY()));
        Assert.assertEquals((long)1L, (long)Math.round(bounds.getMaxX()));
        Assert.assertEquals((long)1L, (long)Math.round(bounds.getMaxY()));
        Assert.assertTrue((boolean)this.areCRSEqual(this.decodeEPSG(4326), bounds.getCoordinateReferenceSystem()));
    }

    @Test
    public void testBoundsWithLimit() throws Exception {
        Query query = new Query(this.featureSource.getSchema().getTypeName());
        query.setMaxFeatures(2);
        FilterFactory ff = this.dataStore.getFilterFactory();
        query.setSortBy(new SortBy[]{ff.sort(this.aname("intProperty"), SortOrder.ASCENDING)});
        ReferencedEnvelope bounds = this.featureSource.getBounds(query);
        Assert.assertEquals((long)0L, (long)Math.round(bounds.getMinX()));
        Assert.assertEquals((long)0L, (long)Math.round(bounds.getMinY()));
        Assert.assertEquals((long)1L, (long)Math.round(bounds.getMaxX()));
        Assert.assertEquals((long)1L, (long)Math.round(bounds.getMaxY()));
        Assert.assertTrue((boolean)this.areCRSEqual(this.decodeEPSG(4326), bounds.getCoordinateReferenceSystem()));
    }

    @Test
    public void testBoundsWithOffset() throws Exception {
        Query query = new Query(this.featureSource.getSchema().getTypeName());
        query.setStartIndex(Integer.valueOf(2));
        FilterFactory ff = this.dataStore.getFilterFactory();
        query.setSortBy(new SortBy[]{ff.sort(this.aname("intProperty"), SortOrder.ASCENDING)});
        ReferencedEnvelope bounds = this.featureSource.getBounds(query);
        Assert.assertEquals((long)2L, (long)Math.round(bounds.getMinX()));
        Assert.assertEquals((long)2L, (long)Math.round(bounds.getMinY()));
        Assert.assertEquals((long)2L, (long)Math.round(bounds.getMaxX()));
        Assert.assertEquals((long)2L, (long)Math.round(bounds.getMaxY()));
        Assert.assertTrue((boolean)this.areCRSEqual(this.decodeEPSG(4326), bounds.getCoordinateReferenceSystem()));
    }

    @Test
    public void testCount() throws Exception {
        Assert.assertEquals((long)3L, (long)this.featureSource.getCount(Query.ALL));
    }

    @Test
    public void testCountWithFilter() throws Exception {
        FilterFactory ff = this.dataStore.getFilterFactory();
        PropertyIsEqualTo filter = ff.equals((Expression)ff.property(this.aname("stringProperty")), (Expression)ff.literal((Object)"one"));
        Query query = new Query();
        query.setFilter((Filter)filter);
        Assert.assertEquals((long)1L, (long)this.featureSource.getCount(query));
    }

    @Test
    public void testCountWithOffsetLimit() throws Exception {
        Query query = new Query();
        query.setStartIndex(Integer.valueOf(1));
        query.setMaxFeatures(1);
        Assert.assertEquals((long)1L, (long)this.featureSource.getCount(query));
    }

    @Test
    public void testGetFeatures() throws Exception {
        ContentFeatureCollection features = this.featureSource.getFeatures();
        Assert.assertEquals((long)3L, (long)features.size());
    }

    @Test
    public void testGetFeaturesWithFilter() throws Exception {
        FilterFactory ff = this.dataStore.getFilterFactory();
        PropertyIsEqualTo filter = ff.equals((Expression)ff.property(this.aname("stringProperty")), (Expression)ff.literal((Object)"one"));
        ContentFeatureCollection features = this.featureSource.getFeatures((Filter)filter);
        Assert.assertEquals((long)1L, (long)features.size());
        try (SimpleFeatureIterator iterator = features.features();){
            Assert.assertTrue((boolean)iterator.hasNext());
            SimpleFeature feature = (SimpleFeature)iterator.next();
            Assert.assertEquals((Object)"one", (Object)feature.getAttribute(this.aname("stringProperty")));
            Assert.assertEquals((Object)1.1, (Object)feature.getAttribute(this.aname("doubleProperty")));
        }
    }

    @Test
    public void testGetFeaturesWithInvalidFilter() throws Exception {
        FilterFactory ff = CommonFactoryFinder.getFilterFactory(null);
        PropertyIsEqualTo f = ff.equals((Expression)ff.property("invalidAttribute"), (Expression)ff.literal(5));
        try (SimpleFeatureIterator fi = this.featureSource.getFeatures((Filter)f).features();){
            Assert.fail((String)"This query should have failed, it contains an invalid filter");
        }
        catch (Exception e) {
            Logger.getGlobal().log(Level.INFO, "", e);
        }
    }

    @Test
    public void testGetFeaturesWithLogicFilter() throws Exception {
        FilterFactory ff = this.dataStore.getFilterFactory();
        PropertyIsEqualTo property = ff.equals((Expression)ff.property(this.aname("stringProperty")), (Expression)ff.literal((Object)"one"));
        BBOX bbox = ff.bbox(this.aname("geometry"), -20.0, -20.0, 20.0, 20.0, "EPSG:4326");
        And filter = ff.and((Filter)property, (Filter)bbox);
        ContentFeatureCollection features = this.featureSource.getFeatures((Filter)filter);
        Assert.assertEquals((long)1L, (long)features.size());
        try (SimpleFeatureIterator iterator = features.features();){
            Assert.assertTrue((boolean)iterator.hasNext());
            SimpleFeature feature = (SimpleFeature)iterator.next();
            Assert.assertEquals((Object)"one", (Object)feature.getAttribute(this.aname("stringProperty")));
            Assert.assertEquals((Object)1.1, (Object)feature.getAttribute(this.aname("doubleProperty")));
        }
    }

    @Test
    public void testCaseInsensitiveFilter() throws Exception {
        FilterFactory ff = this.dataStore.getFilterFactory();
        PropertyIsEqualTo sensitive = ff.equal((Expression)ff.property(this.aname("stringProperty")), (Expression)ff.literal((Object)"OnE"), true);
        PropertyIsEqualTo insensitive = ff.equal((Expression)ff.property(this.aname("stringProperty")), (Expression)ff.literal((Object)"OnE"), false);
        Assert.assertEquals((long)0L, (long)this.featureSource.getCount(new Query(null, (Filter)sensitive)));
        Assert.assertEquals((long)1L, (long)this.featureSource.getCount(new Query(null, (Filter)insensitive)));
    }

    @Test
    public void testGetFeaturesWithQuery() throws Exception {
        FilterFactory ff = this.dataStore.getFilterFactory();
        PropertyIsEqualTo filter = ff.equals((Expression)ff.property(this.aname("stringProperty")), (Expression)ff.literal((Object)"one"));
        Query query = new Query();
        query.setPropertyNames(new String[]{this.aname("doubleProperty"), this.aname("intProperty")});
        query.setFilter((Filter)filter);
        ContentFeatureCollection features = this.featureSource.getFeatures(query);
        Assert.assertEquals((long)1L, (long)features.size());
        try (SimpleFeatureIterator iterator = features.features();){
            Assert.assertTrue((boolean)iterator.hasNext());
            SimpleFeature feature = (SimpleFeature)iterator.next();
            Assert.assertEquals((long)2L, (long)feature.getAttributeCount());
            Assert.assertEquals((Object)1.1, (Object)feature.getAttribute(this.aname("doubleProperty")));
            Assert.assertNotNull((Object)feature.getAttribute(this.aname("intProperty")));
        }
    }

    @Test(expected=Exception.class)
    public void testGetFeaturesWithInvalidQuery() throws Exception {
        FilterFactory ff = CommonFactoryFinder.getFilterFactory(null);
        PropertyIsEqualTo f = ff.equals((Expression)ff.property("invalidAttribute"), (Expression)ff.literal(5));
        SimpleFeatureIterator fi = this.featureSource.getFeatures(new Query("ft1", (Filter)f)).features();
        if (fi != null) {
            fi.close();
        }
    }

    @Test
    public void testGetFeaturesWithSort() throws Exception {
        SimpleFeature f;
        FilterFactory ff = this.dataStore.getFilterFactory();
        SortBy sort = ff.sort(this.aname("stringProperty"), SortOrder.ASCENDING);
        Query query = new Query();
        query.setSortBy(new SortBy[]{sort});
        ContentFeatureCollection features = this.featureSource.getFeatures(query);
        Assert.assertEquals((long)3L, (long)features.size());
        try (SimpleFeatureIterator iterator = features.features();){
            Assert.assertTrue((boolean)iterator.hasNext());
            f = (SimpleFeature)iterator.next();
            Assert.assertEquals((Object)"one", (Object)f.getAttribute(this.aname("stringProperty")));
            Assert.assertTrue((boolean)iterator.hasNext());
            f = (SimpleFeature)iterator.next();
            Assert.assertEquals((Object)"two", (Object)f.getAttribute(this.aname("stringProperty")));
            Assert.assertTrue((boolean)iterator.hasNext());
            f = (SimpleFeature)iterator.next();
            Assert.assertEquals((Object)"zero", (Object)f.getAttribute(this.aname("stringProperty")));
        }
        sort = ff.sort(this.aname("stringProperty"), SortOrder.DESCENDING);
        query.setSortBy(new SortBy[]{sort});
        features = this.featureSource.getFeatures(query);
        iterator = features.features();
        try {
            Assert.assertTrue((boolean)iterator.hasNext());
            f = (SimpleFeature)iterator.next();
            Assert.assertEquals((Object)"zero", (Object)f.getAttribute(this.aname("stringProperty")));
            Assert.assertTrue((boolean)iterator.hasNext());
            f = (SimpleFeature)iterator.next();
            Assert.assertEquals((Object)"two", (Object)f.getAttribute(this.aname("stringProperty")));
            Assert.assertTrue((boolean)iterator.hasNext());
            f = (SimpleFeature)iterator.next();
            Assert.assertEquals((Object)"one", (Object)f.getAttribute(this.aname("stringProperty")));
        }
        finally {
            if (iterator != null) {
                iterator.close();
            }
        }
    }

    @Test
    public void testGetFeaturesWithMax() throws Exception {
        Query q = new Query(this.featureSource.getSchema().getTypeName());
        q.setMaxFeatures(2);
        FilterFactory ff = this.dataStore.getFilterFactory();
        q.setSortBy(new SortBy[]{ff.sort(this.aname("intProperty"), SortOrder.ASCENDING)});
        ContentFeatureCollection features = this.featureSource.getFeatures(q);
        Assert.assertEquals((long)2L, (long)features.size());
        try (SimpleFeatureIterator it = features.features();){
            int count = 0;
            ReferencedEnvelope env = new ReferencedEnvelope(((SimpleFeatureType)features.getSchema()).getCoordinateReferenceSystem());
            while (it.hasNext()) {
                SimpleFeature f = (SimpleFeature)it.next();
                env.expandToInclude((Envelope)ReferencedEnvelope.reference((Bounds)f.getBounds()));
                ++count;
            }
            Assert.assertEquals((long)2L, (long)count);
            Assert.assertTrue((boolean)this.areReferencedEnvelopesEqual(env, features.getBounds()));
        }
    }

    @Test
    public void testGetFeaturesWithOffset() throws Exception {
        Query q = new Query(this.featureSource.getSchema().getTypeName());
        q.setSortBy(new SortBy[]{this.dataStore.getFilterFactory().sort(this.aname("intProperty"), SortOrder.ASCENDING)});
        q.setStartIndex(Integer.valueOf(2));
        ContentFeatureCollection features = this.featureSource.getFeatures(q);
        Assert.assertEquals((long)1L, (long)features.size());
        try (SimpleFeatureIterator it = features.features();){
            Assert.assertTrue((boolean)it.hasNext());
            SimpleFeature f = (SimpleFeature)it.next();
            ReferencedEnvelope fe = ReferencedEnvelope.reference((Bounds)f.getBounds());
            Assert.assertEquals((long)2L, (long)((Number)f.getAttribute(this.aname("intProperty"))).intValue());
            Assert.assertFalse((boolean)it.hasNext());
            Assert.assertTrue((boolean)this.areReferencedEnvelopesEqual(fe, features.getBounds()));
        }
    }

    @Test
    public void testGetFeaturesWithOffsetLimit() throws Exception {
        Query q = new Query(this.featureSource.getSchema().getTypeName());
        q.setStartIndex(Integer.valueOf(1));
        q.setMaxFeatures(1);
        FilterFactory ff = this.dataStore.getFilterFactory();
        q.setSortBy(new SortBy[]{ff.sort(this.aname("intProperty"), SortOrder.ASCENDING)});
        ContentFeatureCollection features = this.featureSource.getFeatures(q);
        Assert.assertEquals((long)1L, (long)features.size());
        try (SimpleFeatureIterator it = features.features();){
            Assert.assertTrue((boolean)it.hasNext());
            SimpleFeature f = (SimpleFeature)it.next();
            ReferencedEnvelope fe = ReferencedEnvelope.reference((Bounds)f.getBounds());
            Assert.assertEquals((long)1L, (long)((Number)f.getAttribute(this.aname("intProperty"))).intValue());
            Assert.assertFalse((boolean)it.hasNext());
            Assert.assertTrue((boolean)this.areReferencedEnvelopesEqual(fe, features.getBounds()));
        }
    }

    @Test
    public void testGetFeaturesWithOffsetLimitAndPostFilter() throws Exception {
        Query q = new Query(this.featureSource.getSchema().getTypeName());
        FilterFactory ff = this.dataStore.getFilterFactory();
        PropertyIsEqualTo filter = ff.equal((Expression)ff.literal((Object)"one"), (Expression)ff.function("strToLowerCase", new Expression[]{ff.property(this.aname("stringProperty"))}), true);
        q.setFilter((Filter)filter);
        q.setStartIndex(Integer.valueOf(0));
        q.setMaxFeatures(1);
        ContentFeatureCollection features = this.featureSource.getFeatures(q);
        Assert.assertEquals((long)1L, (long)features.size());
        try (SimpleFeatureIterator it = features.features();){
            Assert.assertTrue((boolean)it.hasNext());
            SimpleFeature f = (SimpleFeature)it.next();
            ReferencedEnvelope fe = ReferencedEnvelope.reference((Bounds)f.getBounds());
            Assert.assertEquals((long)1L, (long)((Number)f.getAttribute(this.aname("intProperty"))).intValue());
            Assert.assertFalse((boolean)it.hasNext());
            Assert.assertTrue((boolean)this.areReferencedEnvelopesEqual(fe, features.getBounds()));
        }
    }

    @Test
    public void testRendererBehaviour() throws Exception {
        Query query = new Query(this.featureSource.getSchema().getTypeName());
        query.setHints(new Hints((RenderingHints)new Hints((RenderingHints.Key)Hints.JTS_COORDINATE_SEQUENCE_FACTORY, (Object)new LiteCoordinateSequenceFactory())));
        ContentFeatureCollection fc = this.featureSource.getFeatures(query);
        try (SimpleFeatureIterator fi = fc.features();){
            while (fi.hasNext()) {
                fi.next();
            }
        }
    }

    @Test
    public void testQueryCapabilitiesSort() throws Exception {
        FilterFactory ff = this.dataStore.getFilterFactory();
        QueryCapabilities caps = this.featureSource.getQueryCapabilities();
        Assert.assertTrue((boolean)caps.supportsSorting(new SortBy[]{ff.sort(this.aname("intProperty"), SortOrder.ASCENDING)}));
        Assert.assertTrue((boolean)caps.supportsSorting(new SortBy[]{ff.sort(this.aname("stringProperty"), SortOrder.DESCENDING)}));
        Assert.assertTrue((boolean)caps.supportsSorting(new SortBy[]{ff.sort(this.aname("doubleProperty"), SortOrder.ASCENDING)}));
        Assert.assertFalse((boolean)caps.supportsSorting(new SortBy[]{ff.sort(this.aname("geometry"), SortOrder.ASCENDING)}));
    }

    @Test
    public void testQueryCapabilitiesReliableFid() throws Exception {
        QueryCapabilities caps = this.featureSource.getQueryCapabilities();
        Assert.assertTrue((boolean)caps.isReliableFIDSupported());
    }

    @Test
    public void testNaturalSortingAsc() throws Exception {
        Query q = new Query(this.featureSource.getSchema().getTypeName());
        q.setSortBy(new SortBy[]{SortBy.NATURAL_ORDER});
        try (SimpleFeatureIterator features = this.featureSource.getFeatures(q).features();){
            String prevId = null;
            while (features.hasNext()) {
                String currId = ((SimpleFeature)features.next()).getID();
                if (prevId != null) {
                    Assert.assertTrue((prevId.compareTo(currId) <= 0 ? 1 : 0) != 0);
                }
                prevId = currId;
            }
        }
    }

    @Test
    public void testNaturalSortingdesc() throws Exception {
        Query q = new Query(this.featureSource.getSchema().getTypeName());
        q.setSortBy(new SortBy[]{SortBy.REVERSE_ORDER});
        try (SimpleFeatureIterator features = this.featureSource.getFeatures(q).features();){
            String prevId = null;
            while (features.hasNext()) {
                String currId = ((SimpleFeature)features.next()).getID();
                if (prevId != null) {
                    Assert.assertTrue((prevId.compareTo(currId) >= 0 ? 1 : 0) != 0);
                }
                prevId = currId;
            }
        }
    }

    @Test
    public void testFeatureIteratorNextContract() throws Exception {
        try (SimpleFeatureIterator features = this.featureSource.getFeatures().features();){
            SimpleFeature f = (SimpleFeature)features.next();
            Assert.assertNotNull((Object)f);
        }
    }

    @Test
    public void testFeatureIteratorEmptyContract() throws Exception {
        FilterFactory ff = this.dataStore.getFilterFactory();
        PropertyIsEqualTo filter = ff.equals((Expression)ff.property(this.aname("stringProperty")), (Expression)ff.literal((Object)"not_there"));
        try (SimpleFeatureIterator features = this.featureSource.getFeatures((Filter)filter).features();){
            SimpleFeature f = (SimpleFeature)features.next();
            Assert.assertNotNull((Object)f);
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
    }

    @Test
    public void testLikeFilter() throws Exception {
        FilterFactory ff = this.dataStore.getFilterFactory();
        PropertyIsLike caseSensitiveLike = ff.like((Expression)ff.property(this.aname("stringProperty")), "Z*", "*", "?", "\\", true);
        PropertyIsLike caseInsensitiveLike = ff.like((Expression)ff.property(this.aname("stringProperty")), "Z*", "*", "?", "\\", false);
        PropertyIsLike caseInsensitiveLike2 = ff.like((Expression)ff.property(this.aname("stringProperty")), "z*", "*", "?", "\\", false);
        Assert.assertEquals((long)0L, (long)this.featureSource.getCount(new Query(null, (Filter)caseSensitiveLike)));
        Assert.assertEquals((long)1L, (long)this.featureSource.getCount(new Query(null, (Filter)caseInsensitiveLike)));
        Assert.assertEquals((long)1L, (long)this.featureSource.getCount(new Query(null, (Filter)caseInsensitiveLike2)));
    }

    @Test
    public void testConversionFilter() throws Exception {
        FilterFactory ff = this.dataStore.getFilterFactory();
        PropertyIsEqualTo f = ff.equals((Expression)ff.property(this.aname("doubleProperty")), (Expression)ff.add((Expression)ff.property(this.aname("intProperty")), (Expression)ff.literal((Object)"0.1")));
        Assert.assertEquals((long)1L, (long)this.featureSource.getCount(new Query(null, (Filter)f)));
    }

    @Test
    public void testNotFilter() throws Exception {
        FilterFactory ff = this.dataStore.getFilterFactory();
        PropertyIsEqualTo f = ff.equal((Expression)ff.property(this.aname("stringProperty")), (Expression)ff.literal((Object)"one"), true);
        f = ff.not((Filter)f);
        Assert.assertEquals((long)(this.featureSource.getCount(Query.ALL) - 1), (long)this.featureSource.getCount(new Query(null, (Filter)f)));
    }

    @Test
    public void testGeometryFactoryHint() throws Exception {
        FilterFactory ff = this.dataStore.getFilterFactory();
        PropertyIsEqualTo filter = ff.equals((Expression)ff.property(this.aname("stringProperty")), (Expression)ff.literal((Object)"one"));
        Query query = new Query();
        query.setFilter((Filter)filter);
        GeometryFactory gf1 = new GeometryFactory();
        query.setHints(new Hints((RenderingHints.Key)Hints.JTS_GEOMETRY_FACTORY, (Object)gf1));
        SimpleFeature f1 = (SimpleFeature)DataUtilities.first((FeatureCollection)this.featureSource.getFeatures(query));
        Assert.assertSame((Object)gf1, (Object)((Geometry)f1.getDefaultGeometry()).getFactory());
        GeometryFactory gf2 = new GeometryFactory();
        query.setHints(new Hints((RenderingHints.Key)Hints.JTS_GEOMETRY_FACTORY, (Object)gf2));
        SimpleFeature f2 = (SimpleFeature)DataUtilities.first((FeatureCollection)this.featureSource.getFeatures(query));
        Assert.assertSame((Object)gf2, (Object)((Geometry)f2.getDefaultGeometry()).getFactory());
    }

    @Test
    public void testGetFeaturesWithArithmeticOpFilter() throws Exception {
        FilterFactory ff = this.dataStore.getFilterFactory();
        Subtract sub = ff.subtract((Expression)ff.property(this.aname("doubleProperty")), (Expression)ff.literal(0.1));
        PropertyIsEqualTo filter = ff.equals((Expression)ff.property(this.aname("intProperty")), (Expression)sub);
        Assert.assertTrue((this.featureSource.getCount(new Query(null, (Filter)filter)) > 0 ? 1 : 0) != 0);
    }

    @Test
    public void testAcceptsVisitor() throws Exception {
        class TotalVisitor
        implements FeatureVisitor {
            int total = 0;

            TotalVisitor() {
            }

            public void visit(Feature feature) {
                ++this.total;
            }
        }
        TotalVisitor visitor = new TotalVisitor();
        int count = this.featureSource.getCount(Query.ALL);
        this.featureSource.accepts(Query.ALL, (FeatureVisitor)visitor, null);
        Assert.assertEquals((long)count, (long)visitor.total);
        visitor.total = 0;
        JDBCFeatureStore ft1 = (JDBCFeatureStore)this.dataStore.getFeatureSource(this.tname("ft1"));
        try (DefaultTransaction transaction = new DefaultTransaction();){
            ft1.setTransaction((Transaction)transaction);
            try (Connection connection = ft1.getDataStore().getConnection(ft1.getState());){
                Assert.assertFalse((String)"connection established", (boolean)connection.isClosed());
                ft1.accepts(Query.ALL, (FeatureVisitor)visitor, null);
                Assert.assertFalse((String)"connection maintained", (boolean)connection.isClosed());
            }
        }
    }

    @Test
    public void testSimpleEncodeIn() throws Exception {
        FilterFactory ff = this.dataStore.getFilterFactory();
        String property = this.aname("stringProperty");
        PropertyName p = ff.property(property);
        Or orFilter = ff.or(Arrays.asList(ff.equal((Expression)p, (Expression)ff.literal((Object)"zero"), true), ff.equal((Expression)p, (Expression)ff.literal((Object)"one"), true), ff.equal((Expression)p, (Expression)ff.literal((Object)"two"), true)));
        Filter[] filters = this.featureSource.getFeatureSource().splitFilter((Filter)orFilter);
        Assert.assertEquals((Object)filters[1], (Object)Filter.INCLUDE);
        SQLDialect dialect = this.featureSource.getDataStore().getSQLDialect();
        if (dialect instanceof BasicSQLDialect) {
            FilterToSQL filterToSQL = ((BasicSQLDialect)dialect).createFilterToSQL();
            String sql = filterToSQL.encodeToString(filters[0]);
            String escapedProperty = filterToSQL.escapeName(property);
            Assert.assertEquals((Object)("WHERE (" + escapedProperty + " IN ('zero', 'one', 'two') AND " + escapedProperty + " IS NOT NULL )"), (Object)sql);
        } else if (dialect instanceof PreparedStatementSQLDialect) {
            PreparedFilterToSQL filterToSQL = ((PreparedStatementSQLDialect)dialect).createPreparedFilterToSQL();
            filterToSQL.setFeatureType(this.featureSource.getSchema());
            String sql = filterToSQL.encodeToString(filters[0]);
            String escapedProperty = filterToSQL.escapeName(property);
            Assert.assertEquals((Object)("WHERE (" + escapedProperty + " IN (?, ?, ?) AND " + escapedProperty + " IS NOT NULL )"), (Object)sql);
            List literals = filterToSQL.getLiteralValues();
            Assert.assertEquals(Arrays.asList("zero", "one", "two"), (Object)literals);
        } else {
            Assert.fail((String)("Unexpected dialect type: " + dialect));
        }
    }

    protected List<Object> getTestMixedEncodeInExpected() {
        return Arrays.asList("zero", "two", 1, 2, 0.0);
    }

    @Test
    public void testMixedEncodeIn() throws Exception {
        FilterFactory ff = this.dataStore.getFilterFactory();
        String sp = this.aname("stringProperty");
        PropertyName spp = ff.property(sp);
        String ip = this.aname("intProperty");
        PropertyName ipp = ff.property(ip);
        String dp = this.aname("doubleProperty");
        PropertyName dpp = ff.property(dp);
        Or orFilter = ff.or(Arrays.asList(ff.equal((Expression)spp, (Expression)ff.literal((Object)"zero"), true), ff.equal((Expression)ipp, (Expression)ff.literal(1), true), ff.equal((Expression)dpp, (Expression)ff.literal(0.0), true), ff.equal((Expression)spp, (Expression)ff.literal((Object)"two"), true), ff.equal((Expression)ipp, (Expression)ff.literal(2), true)));
        Filter[] filters = this.featureSource.getFeatureSource().splitFilter((Filter)orFilter);
        Assert.assertEquals((Object)filters[1], (Object)Filter.INCLUDE);
        SQLDialect dialect = this.featureSource.getDataStore().getSQLDialect();
        if (dialect instanceof BasicSQLDialect) {
            FilterToSQL filterToSQL = ((BasicSQLDialect)dialect).createFilterToSQL();
            String sql = filterToSQL.encodeToString(filters[0]);
            String spe = filterToSQL.escapeName(sp);
            String ipe = filterToSQL.escapeName(ip);
            String dpe = filterToSQL.escapeName(dp);
            Assert.assertEquals((Object)("WHERE ((" + spe + " IN ('zero', 'two') AND " + spe + " IS NOT NULL ) OR (" + ipe + " IN (1, 2) AND " + ipe + " IS NOT NULL ) OR (" + dpe + " = 0.0 AND " + dpe + " IS NOT NULL ))"), (Object)sql);
        } else if (dialect instanceof PreparedStatementSQLDialect) {
            PreparedFilterToSQL filterToSQL = ((PreparedStatementSQLDialect)dialect).createPreparedFilterToSQL();
            filterToSQL.setFeatureType(this.featureSource.getSchema());
            String sql = filterToSQL.encodeToString(filters[0]);
            String spe = filterToSQL.escapeName(sp);
            String ipe = filterToSQL.escapeName(ip);
            String dpe = filterToSQL.escapeName(dp);
            Assert.assertEquals((Object)("WHERE ((" + spe + " IN (?, ?) AND " + spe + " IS NOT NULL ) OR (" + ipe + " IN (?, ?) AND " + ipe + " IS NOT NULL ) OR (" + dpe + " = ? AND " + dpe + " IS NOT NULL ))"), (Object)sql);
            List literals = filterToSQL.getLiteralValues();
            Assert.assertEquals(this.getTestMixedEncodeInExpected(), (Object)literals);
        } else {
            Assert.fail((String)("Unexpected dialect, supports basic or prepared, but was a : " + dialect));
        }
    }

    @Test
    public void testStringFunction() throws Exception {
        if (!this.dataStore.getFilterCapabilities().supports(FilterFunction_strToLowerCase.class)) {
            LOGGER.info("Ignoring testStringFunction test");
            return;
        }
        FilterFactory ff = this.dataStore.getFilterFactory();
        Function function = ff.function("strToLowerCase", new Expression[]{ff.property(this.aname("stringProperty"))});
        PropertyIsLike likeWithStringFunction = ff.like((Expression)function, "z%", "%", "-", "\\", true);
        Assert.assertEquals((long)1L, (long)this.featureSource.getCount(new Query(null, (Filter)likeWithStringFunction)));
    }

    @Test
    public void testStrMatchesFilter() throws Exception {
        FilterFactory ff = this.dataStore.getFilterFactory();
        Function function = ff.function("strToLowerCase", new Expression[]{ff.property(this.aname("stringProperty"))});
        Function functiond = ff.function("strMatches", new Expression[]{function, ff.literal((Object)"^z.*")});
        PropertyIsEqualTo StrMatchFunction = ff.equals((Expression)functiond, (Expression)ff.literal(true));
        Assert.assertEquals((long)1L, (long)this.featureSource.getCount(new Query(null, (Filter)StrMatchFunction)));
    }
}

