/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.jdbc;

import java.io.IOException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geotools.api.data.SimpleFeatureSource;
import org.geotools.api.feature.simple.SimpleFeature;
import org.geotools.api.filter.Filter;
import org.geotools.api.filter.FilterFactory;
import org.geotools.api.filter.PropertyIsEqualTo;
import org.geotools.api.filter.PropertyIsGreaterThanOrEqualTo;
import org.geotools.api.filter.expression.Expression;
import org.geotools.api.filter.expression.Function;
import org.geotools.api.filter.expression.Multiply;
import org.geotools.data.simple.SimpleFeatureIterator;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.filter.LengthFunction;
import org.geotools.filter.function.FilterFunction_strConcat;
import org.geotools.filter.function.FilterFunction_strEndsWith;
import org.geotools.filter.function.FilterFunction_strEqualsIgnoreCase;
import org.geotools.filter.function.FilterFunction_strIndexOf;
import org.geotools.filter.function.FilterFunction_strLength;
import org.geotools.filter.function.FilterFunction_strStartsWith;
import org.geotools.filter.function.FilterFunction_strSubstring;
import org.geotools.filter.function.FilterFunction_strSubstringStart;
import org.geotools.filter.function.FilterFunction_strToLowerCase;
import org.geotools.filter.function.FilterFunction_strToUpperCase;
import org.geotools.filter.function.FilterFunction_strTrim;
import org.geotools.filter.function.math.FilterFunction_abs;
import org.geotools.filter.function.math.FilterFunction_abs_2;
import org.geotools.filter.function.math.FilterFunction_abs_3;
import org.geotools.filter.function.math.FilterFunction_abs_4;
import org.geotools.filter.function.math.FilterFunction_ceil;
import org.geotools.jdbc.JDBCTestSupport;
import org.geotools.util.logging.Logging;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Test;

public abstract class JDBCFunctionOnlineTest
extends JDBCTestSupport {
    static final Logger LOGGER = Logging.getLogger(JDBCFunctionOnlineTest.class);
    FilterFactory ff = CommonFactoryFinder.getFilterFactory(null);
    SimpleFeatureSource fs;

    @Override
    protected void connect() throws Exception {
        super.connect();
        this.fs = this.dataStore.getFeatureSource(this.tname("ft1"));
    }

    @Test
    public void testStrfunc() throws IOException {
        Assume.assumeFalse((boolean)this.skipTests(FilterFunction_strConcat.class));
        Function func = this.ff.function("strConcat", new Expression[]{this.ff.property(this.aname("stringProperty")), this.ff.literal((Object)"abc")});
        PropertyIsEqualTo filter = this.ff.equals((Expression)func, (Expression)this.ff.literal((Object)"zeroabc"));
        this.assertFeatures(this.fs, (Filter)filter, this.tname("ft1") + ".0");
    }

    @Test
    public void testStrfuncNumbers() throws IOException {
        Assume.assumeFalse((boolean)this.skipTests(FilterFunction_strConcat.class));
        Function func = this.ff.function("strConcat", new Expression[]{this.ff.property(this.aname("intProperty")), this.ff.property(this.aname("intProperty"))});
        PropertyIsEqualTo filter = this.ff.equals((Expression)func, (Expression)this.ff.literal((Object)"11"));
        this.assertFeatures(this.fs, (Filter)filter, this.tname("ft1") + ".1");
    }

    @Test
    public void testStrEndsWith() throws IOException {
        Assume.assumeFalse((boolean)this.skipTests(FilterFunction_strEndsWith.class));
        Function func = this.ff.function("strEndsWith", new Expression[]{this.ff.property(this.aname("stringProperty")), this.ff.literal((Object)"o")});
        PropertyIsEqualTo filter = this.ff.equals((Expression)func, (Expression)this.ff.literal(true));
        this.assertFeatures(this.fs, (Filter)filter, this.tname("ft1") + ".0", this.tname("ft1") + ".2");
    }

    @Test
    public void testStrEndsWithOtherProperty() throws IOException {
        Assume.assumeFalse((boolean)this.skipTests(FilterFunction_strEndsWith.class));
        Function func = this.ff.function("strEndsWith", new Expression[]{this.ff.property(this.aname("doubleProperty")), this.ff.property(this.aname("intProperty"))});
        PropertyIsEqualTo filter = this.ff.equals((Expression)func, (Expression)this.ff.literal(true));
        this.assertFeatures(this.fs, (Filter)filter, this.tname("ft1") + ".0", this.tname("ft1") + ".1", this.tname("ft1") + ".2");
    }

    @Test
    public void testStrStartsWith() throws IOException {
        Assume.assumeFalse((boolean)this.skipTests(FilterFunction_strStartsWith.class));
        Function func = this.ff.function("strStartsWith", new Expression[]{this.ff.property(this.aname("stringProperty")), this.ff.literal((Object)"ze")});
        PropertyIsEqualTo filter = this.ff.equals((Expression)func, (Expression)this.ff.literal(true));
        this.assertFeatures(this.fs, (Filter)filter, this.tname("ft1") + ".0");
    }

    @Test
    public void testStrStartsWithOtherProperty() throws IOException {
        Assume.assumeFalse((boolean)this.skipTests(FilterFunction_strStartsWith.class));
        Function func = this.ff.function("strStartsWith", new Expression[]{this.ff.property(this.aname("doubleProperty")), this.ff.property(this.aname("intProperty"))});
        PropertyIsEqualTo filter = this.ff.equals((Expression)func, (Expression)this.ff.literal(true));
        this.assertFeatures(this.fs, (Filter)filter, this.tname("ft1") + ".0", this.tname("ft1") + ".1", this.tname("ft1") + ".2");
    }

    @Test
    public void testStrIndexOf() throws IOException {
        Assume.assumeFalse((boolean)this.skipTests(FilterFunction_strIndexOf.class));
        Function func = this.ff.function("strIndexOf", new Expression[]{this.ff.property(this.aname("stringProperty")), this.ff.literal((Object)"er")});
        PropertyIsEqualTo filter = this.ff.equals((Expression)func, (Expression)this.ff.literal(1));
        this.assertFeatures(this.fs, (Filter)filter, this.tname("ft1") + ".0");
    }

    @Test
    public void testStrLength() throws IOException {
        Assume.assumeFalse((boolean)this.skipTests(FilterFunction_strLength.class));
        Function func = this.ff.function("strLength", new Expression[]{this.ff.property(this.aname("stringProperty"))});
        PropertyIsEqualTo filter = this.ff.equals((Expression)func, (Expression)this.ff.literal(4));
        this.assertFeatures(this.fs, (Filter)filter, this.tname("ft1") + ".0");
    }

    @Test
    public void testLength() throws IOException {
        Assume.assumeFalse((boolean)this.skipTests(LengthFunction.class));
        Function func = this.ff.function("length", new Expression[]{this.ff.property(this.aname("stringProperty"))});
        PropertyIsEqualTo filter = this.ff.equals((Expression)func, (Expression)this.ff.literal(4));
        this.assertFeatures(this.fs, (Filter)filter, this.tname("ft1") + ".0");
    }

    @Test
    public void testStrLower() throws IOException {
        Assume.assumeFalse((boolean)this.skipTests(FilterFunction_strToLowerCase.class));
        Function func = this.ff.function("strToLowerCase", new Expression[]{this.ff.property(this.aname("intProperty"))});
        PropertyIsEqualTo filter = this.ff.equals((Expression)func, (Expression)this.ff.literal((Object)"0"));
        this.assertFeatures(this.fs, (Filter)filter, this.tname("ft1") + ".0");
    }

    @Test
    public void testStrUpper() throws IOException {
        Assume.assumeFalse((boolean)this.skipTests(FilterFunction_strToUpperCase.class));
        Function func = this.ff.function("strToUpperCase", new Expression[]{this.ff.property(this.aname("stringProperty"))});
        PropertyIsEqualTo filter = this.ff.equals((Expression)func, (Expression)this.ff.literal((Object)"ZERO"));
        this.assertFeatures(this.fs, (Filter)filter, this.tname("ft1") + ".0");
    }

    @Test
    public void testStrEqualsIgnoreCase() throws IOException {
        Assume.assumeFalse((boolean)this.skipTests(FilterFunction_strEqualsIgnoreCase.class));
        Function func = this.ff.function("strEqualsIgnoreCase", new Expression[]{this.ff.property(this.aname("stringProperty")), this.ff.literal((Object)"ZeRo")});
        PropertyIsEqualTo filter = this.ff.equals((Expression)func, (Expression)this.ff.literal(true));
        this.assertFeatures(this.fs, (Filter)filter, this.tname("ft1") + ".0");
    }

    @Test
    public void testStrSubstring() throws IOException {
        Assume.assumeFalse((boolean)this.skipTests(FilterFunction_strSubstring.class));
        Function func = this.ff.function("strSubstring", new Expression[]{this.ff.property(this.aname("stringProperty")), this.ff.literal((Object)"1"), this.ff.literal(3)});
        PropertyIsEqualTo filter = this.ff.equals((Expression)func, (Expression)this.ff.literal((Object)"er"));
        this.assertFeatures(this.fs, (Filter)filter, this.tname("ft1") + ".0");
    }

    @Test
    public void testStrSubstringStart() throws IOException {
        Assume.assumeFalse((boolean)this.skipTests(FilterFunction_strSubstringStart.class));
        Function func = this.ff.function("strSubstringStart", new Expression[]{this.ff.property(this.aname("stringProperty")), this.ff.literal((Object)"1")});
        PropertyIsEqualTo filter = this.ff.equals((Expression)func, (Expression)this.ff.literal((Object)"ero"));
        this.assertFeatures(this.fs, (Filter)filter, this.tname("ft1") + ".0");
    }

    @Test
    public void testStrTrim() throws IOException {
        Assume.assumeFalse((boolean)this.skipTests(FilterFunction_strTrim.class));
        Assume.assumeFalse((boolean)this.skipTests(FilterFunction_strConcat.class));
        Function func1 = this.ff.function("strConcat", new Expression[]{this.ff.property(this.aname("stringProperty")), this.ff.literal((Object)"   ")});
        Function func2 = this.ff.function("strTrim", new Expression[]{func1});
        PropertyIsEqualTo filter = this.ff.equals((Expression)func2, (Expression)this.ff.literal((Object)"zero"));
        this.assertFeatures(this.fs, (Filter)filter, this.tname("ft1") + ".0");
    }

    @Test
    public void testAbs() throws IOException {
        Assume.assumeFalse((boolean)this.skipTests(FilterFunction_abs.class));
        Multiply mul = this.ff.multiply((Expression)this.ff.property(this.aname("doubleProperty")), (Expression)this.ff.literal(-1));
        Function func2 = this.ff.function("abs", new Expression[]{mul});
        PropertyIsEqualTo filter = this.ff.equals((Expression)func2, (Expression)this.ff.literal((Object)"1"));
        this.assertFeatures(this.fs, (Filter)filter, this.tname("ft1") + ".1");
    }

    @Test
    public void testAbs2() throws IOException {
        Assume.assumeFalse((boolean)this.skipTests(FilterFunction_abs_2.class));
        Multiply mul = this.ff.multiply((Expression)this.ff.property(this.aname("doubleProperty")), (Expression)this.ff.literal(-1));
        Function func2 = this.ff.function("abs_2", new Expression[]{mul});
        PropertyIsEqualTo filter = this.ff.equals((Expression)func2, (Expression)this.ff.literal((Object)"1"));
        this.assertFeatures(this.fs, (Filter)filter, this.tname("ft1") + ".1");
    }

    @Test
    public void testAbs3() throws IOException {
        Assume.assumeFalse((boolean)this.skipTests(FilterFunction_abs_3.class));
        Multiply mul = this.ff.multiply((Expression)this.ff.property(this.aname("doubleProperty")), (Expression)this.ff.literal(-1));
        Function func2 = this.ff.function("abs_3", new Expression[]{mul});
        PropertyIsGreaterThanOrEqualTo filter = this.ff.greaterOrEqual((Expression)func2, (Expression)this.ff.literal(1));
        this.assertFeatures(this.fs, (Filter)filter, this.tname("ft1") + ".1", this.tname("ft1") + ".2");
    }

    @Test
    public void testAbs4() throws IOException {
        Assume.assumeFalse((boolean)this.skipTests(FilterFunction_abs_4.class));
        Multiply mul = this.ff.multiply((Expression)this.ff.property(this.aname("doubleProperty")), (Expression)this.ff.literal(-1));
        Function func2 = this.ff.function("abs_4", new Expression[]{mul});
        PropertyIsGreaterThanOrEqualTo filter = this.ff.greaterOrEqual((Expression)func2, (Expression)this.ff.literal(1));
        this.assertFeatures(this.fs, (Filter)filter, this.tname("ft1") + ".1", this.tname("ft1") + ".2");
    }

    @Test
    public void testCeil() throws IOException {
        Assume.assumeFalse((boolean)this.skipTests(FilterFunction_ceil.class));
        Function func = this.ff.function("ceil", new Expression[]{this.ff.property(this.aname("doubleProperty"))});
        PropertyIsEqualTo filter = this.ff.equals((Expression)func, (Expression)this.ff.literal(2));
        this.assertFeatures(this.fs, (Filter)filter, this.tname("ft1") + ".1");
    }

    @Test
    public void testFloor() throws IOException {
        Assume.assumeFalse((boolean)this.skipTests(FilterFunction_ceil.class));
        Function func = this.ff.function("floor", new Expression[]{this.ff.property(this.aname("doubleProperty"))});
        PropertyIsEqualTo filter = this.ff.equals((Expression)func, (Expression)this.ff.literal(1));
        this.assertFeatures(this.fs, (Filter)filter, this.tname("ft1") + ".1");
    }

    void assertFeatures(SimpleFeatureSource fs2, Filter filter, String ... ids) throws IOException {
        HashSet<String> idSet = new HashSet<String>(Arrays.asList(ids));
        int count = 0;
        try (SimpleFeatureIterator fi = this.fs.getFeatures(filter).features();){
            while (fi.hasNext()) {
                SimpleFeature sf = (SimpleFeature)fi.next();
                Assert.assertTrue((String)("Found unexpected id " + sf.getID()), (boolean)idSet.contains(sf.getID()));
                ++count;
            }
        }
        if (count != idSet.size()) {
            Assert.fail((String)("Expected to find " + idSet.size() + " features, but was " + count));
        }
    }

    protected boolean skipTests(Class<?> fClass) {
        if (!this.dataStore.getFilterCapabilities().supports(fClass)) {
            LOGGER.log(Level.INFO, "Function {0} is not natively supported, skipping test", fClass.getSimpleName());
            return true;
        }
        return false;
    }
}

