/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.jdbc;

import java.io.IOException;
import java.util.Arrays;
import java.util.Set;
import java.util.TreeSet;
import org.geotools.api.feature.simple.SimpleFeature;
import org.geotools.api.filter.Filter;
import org.geotools.api.filter.FilterFactory;
import org.geotools.api.filter.Not;
import org.geotools.api.filter.PropertyIsEqualTo;
import org.geotools.api.filter.PropertyIsGreaterThan;
import org.geotools.api.filter.PropertyIsNotEqualTo;
import org.geotools.api.filter.expression.Expression;
import org.geotools.api.filter.expression.Function;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.data.simple.SimpleFeatureIterator;
import org.geotools.data.store.ContentFeatureSource;
import org.geotools.jdbc.JDBCTestSetup;
import org.geotools.jdbc.JDBCTestSupport;
import org.junit.Assert;
import org.junit.Test;

public abstract class JDBCInEncodingOnlineTest
extends JDBCTestSupport {
    @Override
    protected abstract JDBCTestSetup createTestSetup();

    @Test
    public void testSimpleIn() throws IOException {
        FilterFactory ff = this.dataStore.getFilterFactory();
        Function function = ff.function("in", new Expression[]{ff.property(this.aname("intProperty")), ff.literal((Object)"1"), ff.literal((Object)"2")});
        PropertyIsEqualTo filter = ff.equal((Expression)function, (Expression)ff.literal((Object)"true"), false);
        ContentFeatureSource fs = this.dataStore.getFeatureSource(this.tname("ft1"));
        SimpleFeatureCollection fc = fs.getFeatures((Filter)filter);
        Assert.assertEquals(this.getCaseInsensitiveSet("ft1.1", "ft1.2"), this.collectFeatureIds(fc));
    }

    @Test
    public void testSimpleIn3() throws IOException {
        FilterFactory ff = this.dataStore.getFilterFactory();
        Function function = ff.function("in3", new Expression[]{ff.property(this.aname("intProperty")), ff.literal((Object)"1"), ff.literal((Object)"1"), ff.literal((Object)"1")});
        PropertyIsEqualTo filter = ff.equal((Expression)function, (Expression)ff.literal((Object)"true"), false);
        ContentFeatureSource fs = this.dataStore.getFeatureSource(this.tname("ft1"));
        SimpleFeatureCollection fc = fs.getFeatures((Filter)filter);
        Assert.assertEquals(this.getCaseInsensitiveSet("ft1.1"), this.collectFeatureIds(fc));
    }

    @Test
    public void testNotEqual() throws IOException {
        FilterFactory ff = this.dataStore.getFilterFactory();
        Function function = ff.function("in", new Expression[]{ff.property(this.aname("intProperty")), ff.literal((Object)"1"), ff.literal((Object)"2")});
        PropertyIsNotEqualTo filter = ff.notEqual((Expression)function, (Expression)ff.literal((Object)"true"), false);
        ContentFeatureSource fs = this.dataStore.getFeatureSource(this.tname("ft1"));
        SimpleFeatureCollection fc = fs.getFeatures((Filter)filter);
        Assert.assertEquals(this.getCaseInsensitiveSet("ft1.0"), this.collectFeatureIds(fc));
    }

    @Test
    public void testNegated() throws IOException {
        FilterFactory ff = this.dataStore.getFilterFactory();
        Function function = ff.function("in", new Expression[]{ff.property(this.aname("intProperty")), ff.literal((Object)"1"), ff.literal((Object)"2")});
        Not filter = ff.not((Filter)ff.equal((Expression)function, (Expression)ff.literal((Object)"true"), false));
        ContentFeatureSource fs = this.dataStore.getFeatureSource(this.tname("ft1"));
        SimpleFeatureCollection fc = fs.getFeatures((Filter)filter);
        Assert.assertEquals(this.getCaseInsensitiveSet("ft1.0"), this.collectFeatureIds(fc));
    }

    @Test
    public void testGreater() throws IOException {
        FilterFactory ff = this.dataStore.getFilterFactory();
        Function function = ff.function("in", new Expression[]{ff.property(this.aname("intProperty")), ff.literal((Object)"1"), ff.literal((Object)"2")});
        PropertyIsGreaterThan filter = ff.greater((Expression)function, (Expression)ff.literal((Object)"false"), false);
        ContentFeatureSource fs = this.dataStore.getFeatureSource(this.tname("ft1"));
        SimpleFeatureCollection fc = fs.getFeatures((Filter)filter);
        Assert.assertEquals(this.getCaseInsensitiveSet("ft1.1", "ft1.2"), this.collectFeatureIds(fc));
    }

    public Set<String> getCaseInsensitiveSet(String ... values) {
        TreeSet<String> result = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
        result.addAll(Arrays.asList(values));
        return result;
    }

    protected Set<String> collectFeatureIds(SimpleFeatureCollection fc) {
        TreeSet<String> identifiers = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
        try (SimpleFeatureIterator fi = fc.features();){
            while (fi.hasNext()) {
                SimpleFeature sf = (SimpleFeature)fi.next();
                identifiers.add(sf.getID());
            }
        }
        return identifiers;
    }
}

