/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.jdbc.ds;

import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import org.apache.commons.dbcp.BasicDataSource;
import org.geotools.data.jdbc.datasource.DataSourceFinder;
import org.geotools.data.jdbc.datasource.UnWrapper;
import org.h2.jdbc.JdbcConnection;
import org.h2.jdbc.JdbcPreparedStatement;
import org.h2.jdbc.JdbcStatement;
import org.junit.Assert;
import org.junit.Test;

public class UnWrapperTest {
    @Test
    public void testDBCPUnwrapper() throws SQLException, IOException {
        BasicDataSource ds = new BasicDataSource();
        ds.setDriverClassName("org.h2.Driver");
        ds.setUrl("jdbc:h2:mem:test_mem");
        ds.setAccessToUnderlyingConnectionAllowed(true);
        Connection conn = ds.getConnection();
        UnWrapper uw = DataSourceFinder.getUnWrapper((Connection)conn);
        Assert.assertNotNull((Object)uw);
        Assert.assertTrue((boolean)uw.canUnwrap(conn));
        try (Connection unwrapped = uw.unwrap(conn);){
            Assert.assertNotNull((Object)unwrapped);
            Assert.assertTrue((boolean)(unwrapped instanceof JdbcConnection));
            try (Statement st = conn.createStatement();){
                uw = DataSourceFinder.getUnWrapper((Statement)st);
                Assert.assertNotNull((Object)uw);
                Assert.assertTrue((boolean)uw.canUnwrap(st));
                try (Statement uwst = uw.unwrap(st);){
                    Assert.assertNotNull((Object)uwst);
                    Assert.assertTrue((boolean)(uwst instanceof JdbcStatement));
                }
            }
            try (PreparedStatement ps = conn.prepareStatement("select curtime()");){
                uw = DataSourceFinder.getUnWrapper((Statement)ps);
                Assert.assertNotNull((Object)uw);
                Assert.assertTrue((boolean)uw.canUnwrap((Statement)ps));
                try (PreparedStatement uwps = (PreparedStatement)uw.unwrap((Statement)ps);){
                    Assert.assertNotNull((Object)uwps);
                    Assert.assertTrue((boolean)(uwps instanceof JdbcPreparedStatement));
                }
            }
        }
    }
}

