/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.jdbc;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import org.geotools.api.feature.simple.SimpleFeature;
import org.geotools.api.feature.simple.SimpleFeatureType;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.geotools.geometry.jts.LiteCoordinateSequence;
import org.geotools.jdbc.InsertionClassifier;
import org.geotools.util.factory.Hints;
import org.junit.Assert;
import org.junit.Test;
import org.locationtech.jts.geom.CoordinateSequence;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.LinearRing;
import org.locationtech.jts.geom.Polygon;

public class InsertionClassifierTest {
    private GeometryFactory geometryFactory = new GeometryFactory();

    @Test
    public void testSegregateSimple() throws Exception {
        SimpleFeatureType featureType = InsertionClassifierTest.buildType();
        ArrayList<SimpleFeature> features = new ArrayList<SimpleFeature>();
        features.add(this.createFeature(featureType, "toto", this.createLineString(), (Geometry)this.createPolygon()));
        features.add(this.createFeature(featureType, "tutu", this.createLineString(), (Geometry)this.createPolygon()));
        Map actual = InsertionClassifier.classify((SimpleFeatureType)featureType, features);
        Assert.assertEquals((long)1L, (long)actual.size());
        for (InsertionClassifier kind : actual.keySet()) {
            Assert.assertFalse((boolean)kind.useExisting);
            Assert.assertEquals((long)2L, (long)kind.geometryTypes.size());
            Assert.assertEquals(LineString.class, kind.geometryTypes.get("geom1"));
            Assert.assertEquals(Polygon.class, kind.geometryTypes.get("geom2"));
            Assert.assertEquals((long)2L, (long)((Collection)actual.get(kind)).size());
        }
    }

    @Test
    public void testSegregateMultipleGeomKinds() throws Exception {
        SimpleFeatureType featureType = InsertionClassifierTest.buildType();
        ArrayList<SimpleFeature> features = new ArrayList<SimpleFeature>();
        features.add(this.createFeature(featureType, "toto", this.createLineString(), (Geometry)this.createPolygon()));
        features.add(this.createFeature(featureType, "tutu", this.createLineString(), (Geometry)this.createLineString()));
        Map actual = InsertionClassifier.classify((SimpleFeatureType)featureType, features);
        Assert.assertEquals((long)2L, (long)actual.size());
        HashSet<Class> geom2Classes = new HashSet<Class>();
        for (InsertionClassifier kind : actual.keySet()) {
            Assert.assertFalse((boolean)kind.useExisting);
            Assert.assertEquals((long)2L, (long)kind.geometryTypes.size());
            Assert.assertEquals(LineString.class, kind.geometryTypes.get("geom1"));
            geom2Classes.add((Class)kind.geometryTypes.get("geom2"));
            Assert.assertEquals((long)1L, (long)((Collection)actual.get(kind)).size());
        }
        Assert.assertEquals(new HashSet<Class>(Arrays.asList(LineString.class, Polygon.class)), geom2Classes);
    }

    @Test
    public void testSegregateUseExisting() throws Exception {
        SimpleFeatureType featureType = InsertionClassifierTest.buildType();
        ArrayList<SimpleFeature> features = new ArrayList<SimpleFeature>();
        SimpleFeature f2 = this.createFeature(featureType, "toto", this.createLineString(), (Geometry)this.createPolygon());
        f2.getUserData().put(Hints.USE_PROVIDED_FID, true);
        features.add(f2);
        features.add(this.createFeature(featureType, "tutu", this.createLineString(), (Geometry)this.createPolygon()));
        Map actual = InsertionClassifier.classify((SimpleFeatureType)featureType, features);
        Assert.assertEquals((long)2L, (long)actual.size());
        HashSet<Boolean> uses = new HashSet<Boolean>();
        for (InsertionClassifier kind : actual.keySet()) {
            uses.add(kind.useExisting);
            Assert.assertEquals((long)2L, (long)kind.geometryTypes.size());
            Assert.assertEquals(LineString.class, kind.geometryTypes.get("geom1"));
            Assert.assertEquals(Polygon.class, kind.geometryTypes.get("geom2"));
            Assert.assertEquals((long)1L, (long)((Collection)actual.get(kind)).size());
        }
        Assert.assertEquals(new HashSet<Boolean>(Arrays.asList(Boolean.FALSE, Boolean.TRUE)), uses);
    }

    @Test
    public void testSegregateNullGeom() throws Exception {
        SimpleFeatureType featureType = InsertionClassifierTest.buildType();
        ArrayList<SimpleFeature> features = new ArrayList<SimpleFeature>();
        features.add(this.createFeature(featureType, "toto", this.createLineString(), (Geometry)this.createPolygon()));
        features.add(this.createFeature(featureType, "tutu", this.createLineString(), null));
        Map actual = InsertionClassifier.classify((SimpleFeatureType)featureType, features);
        Assert.assertEquals((long)2L, (long)actual.size());
        HashSet<Class> geom2Classes = new HashSet<Class>();
        for (InsertionClassifier kind : actual.keySet()) {
            Assert.assertFalse((boolean)kind.useExisting);
            Assert.assertEquals((long)2L, (long)kind.geometryTypes.size());
            Assert.assertEquals(LineString.class, kind.geometryTypes.get("geom1"));
            geom2Classes.add((Class)kind.geometryTypes.get("geom2"));
            Assert.assertEquals((long)1L, (long)((Collection)actual.get(kind)).size());
        }
        Assert.assertEquals(new HashSet<Class>(Arrays.asList(null, Polygon.class)), geom2Classes);
    }

    private Polygon createPolygon() {
        return this.createPolygon(0.0f, 0.0f, 1.0f, 1.0f, 2.0f, 2.0f, 0.0f, 0.0f);
    }

    private LineString createLineString() {
        return this.createLineString(0.0f, 1.0f, 2.0f, 3.0f);
    }

    private SimpleFeature createFeature(SimpleFeatureType featureType, String name, LineString geom1, Geometry geom2) {
        SimpleFeatureBuilder builder = new SimpleFeatureBuilder(featureType);
        builder.add((Object)name);
        builder.add((Object)geom1);
        builder.add((Object)geom2);
        return builder.buildFeature(name);
    }

    private Polygon createPolygon(float ... coords) {
        LinearRing shell = new LinearRing((CoordinateSequence)new LiteCoordinateSequence(coords), this.geometryFactory);
        return new Polygon(shell, null, this.geometryFactory);
    }

    private LineString createLineString(float ... coords) {
        return new LineString((CoordinateSequence)new LiteCoordinateSequence(coords), this.geometryFactory);
    }

    private static SimpleFeatureType buildType() {
        SimpleFeatureTypeBuilder builder = new SimpleFeatureTypeBuilder();
        builder.setName("Test");
        builder.add("name", String.class);
        builder.add("geom1", LineString.class);
        builder.add("geom2", Geometry.class);
        return builder.buildFeatureType();
    }
}

