/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.jdbc;

import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.TimeZone;
import org.geotools.api.data.Query;
import org.geotools.api.feature.simple.SimpleFeatureType;
import org.geotools.api.filter.Filter;
import org.geotools.api.filter.FilterFactory;
import org.geotools.api.filter.PropertyIsEqualTo;
import org.geotools.api.filter.PropertyIsGreaterThanOrEqualTo;
import org.geotools.api.filter.PropertyIsLessThanOrEqualTo;
import org.geotools.api.filter.expression.Expression;
import org.geotools.data.store.ContentFeatureSource;
import org.geotools.jdbc.JDBCDateTestSetup;
import org.geotools.jdbc.JDBCTestSupport;
import org.geotools.jdbc.PreparedStatementSQLDialect;
import org.junit.Assert;
import org.junit.Test;

public abstract class JDBCDateOnlineTest
extends JDBCTestSupport {
    @Override
    protected abstract JDBCDateTestSetup createTestSetup();

    @Test
    public void testMappings() throws Exception {
        SimpleFeatureType ft = this.dataStore.getSchema(this.tname("dates"));
        Assert.assertEquals(Date.class, (Object)ft.getDescriptor(this.aname("d")).getType().getBinding());
        Assert.assertEquals(Timestamp.class, (Object)ft.getDescriptor(this.aname("dt")).getType().getBinding());
        Assert.assertEquals(Time.class, (Object)ft.getDescriptor(this.aname("t")).getType().getBinding());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testFiltersByDate() throws Exception {
        boolean simple = this.useOneTimeZoneOnly();
        FilterFactory ff = this.dataStore.getFilterFactory();
        SimpleDateFormat df = new SimpleDateFormat("yyyy-dd-MM");
        TimeZone originalTimeZone = TimeZone.getDefault();
        TimeZone[] zones = new TimeZone[]{TimeZone.getTimeZone("Etc/GMT+12"), TimeZone.getTimeZone("PST"), TimeZone.getTimeZone("EST"), TimeZone.getTimeZone("GMT"), TimeZone.getTimeZone("CET"), TimeZone.getTimeZone("Etc/GMT-12"), TimeZone.getTimeZone("Etc/GMT-14")};
        if (simple) {
            zones = new TimeZone[]{originalTimeZone};
        }
        try {
            for (TimeZone zone : zones) {
                ContentFeatureSource fs = this.dataStore.getFeatureSource(this.tname("dates"));
                TimeZone.setDefault(zone);
                this.setup.setUpData();
                df.setTimeZone(zone);
                PropertyIsLessThanOrEqualTo f = ff.lessOrEqual((Expression)ff.property(this.aname("d")), (Expression)ff.literal((Object)df.parse("2009-28-06")));
                Assert.assertEquals((String)("wrong number of records for " + zone.getDisplayName()), (long)2L, (long)fs.getCount(new Query(this.tname("dates"), (Filter)f)));
            }
        }
        finally {
            TimeZone.setDefault(originalTimeZone);
            this.setup.setUpData();
        }
    }

    @Test
    public void testFilterByTimeStamp() throws Exception {
        ContentFeatureSource fs = this.dataStore.getFeatureSource(this.tname("dates"));
        FilterFactory ff = this.dataStore.getFilterFactory();
        PropertyIsEqualTo f = ff.equals((Expression)ff.property(this.aname("dt")), (Expression)ff.literal((Object)"2009-06-28 15:12:41"));
        Assert.assertEquals((long)1L, (long)fs.getCount(new Query(this.tname("dates"), (Filter)f)));
        f = ff.equals((Expression)ff.property(this.aname("dt")), (Expression)ff.literal((Object)new SimpleDateFormat("HH:mm:ss,dd-yyyy-MM").parse("15:12:41,28-2009-06")));
        Assert.assertEquals((long)1L, (long)fs.getCount(new Query(this.tname("dates"), (Filter)f)));
    }

    @Test
    public void testFilterByTime() throws Exception {
        ContentFeatureSource fs = this.dataStore.getFeatureSource(this.tname("dates"));
        FilterFactory ff = this.dataStore.getFilterFactory();
        PropertyIsGreaterThanOrEqualTo f = ff.greaterOrEqual((Expression)ff.property(this.aname("t")), (Expression)ff.literal((Object)"13:10:12"));
        Assert.assertEquals((long)3L, (long)fs.getCount(new Query(this.tname("dates"), (Filter)f)));
        f = ff.greaterOrEqual((Expression)ff.property(this.aname("t")), (Expression)ff.literal((Object)new SimpleDateFormat("ss:HH:mm").parse("12:13:10")));
        Assert.assertEquals((long)3L, (long)fs.getCount(new Query(this.tname("dates"), (Filter)f)));
    }

    protected boolean useOneTimeZoneOnly() {
        return this.dataStore.dialect instanceof PreparedStatementSQLDialect;
    }
}

