/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.jdbc;

import java.util.List;
import org.geotools.api.data.FeatureReader;
import org.geotools.api.data.Query;
import org.geotools.api.data.Transaction;
import org.geotools.api.feature.simple.SimpleFeature;
import org.geotools.api.feature.type.PropertyDescriptor;
import org.geotools.api.referencing.crs.CoordinateReferenceSystem;
import org.geotools.jdbc.JDBCTestSupport;
import org.junit.Assert;
import org.junit.Test;
import org.locationtech.jts.geom.Geometry;

public abstract class JDBCFeatureReaderOnlineTest
extends JDBCTestSupport {
    @Test
    public void testNext() throws Exception {
        Query query = new Query(this.tname("ft1"));
        try (FeatureReader reader = this.dataStore.getFeatureReader(query, Transaction.AUTO_COMMIT);){
            Assert.assertTrue((boolean)reader.hasNext());
            SimpleFeature feature = (SimpleFeature)reader.next();
            Assert.assertEquals((Object)feature.getName(), (Object)reader.getFeatureType().getName());
            int i = 0;
            for (PropertyDescriptor desc : reader.getFeatureType().getDescriptors()) {
                Assert.assertTrue((i < feature.getAttributeCount() ? 1 : 0) != 0);
                Assert.assertEquals((Object)feature.getAttribute(desc.getName()), (Object)feature.getAttribute(i++));
            }
            List attrs = feature.getAttributes();
            try {
                attrs.set(2, 1.1);
                feature.setAttributes(attrs);
            }
            catch (Exception e) {
                Assert.fail();
            }
            Assert.assertEquals(attrs.get(2), (Object)feature.getAttribute(2));
            Geometry g = (Geometry)feature.getDefaultGeometry();
            Assert.assertNotNull((Object)g);
            Assert.assertTrue((boolean)(g.getUserData() instanceof CoordinateReferenceSystem));
        }
    }
}

