/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.jdbc;

import com.mockrunner.mock.jdbc.MockConnection;
import com.mockrunner.mock.jdbc.MockDataSource;
import com.mockrunner.mock.jdbc.MockDatabaseMetaData;
import com.mockrunner.mock.jdbc.MockPreparedStatement;
import com.mockrunner.mock.jdbc.MockResultSet;
import com.mockrunner.mock.jdbc.MockStatement;
import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import javax.sql.DataSource;
import org.geotools.api.data.FeatureLock;
import org.geotools.api.data.Transaction;
import org.geotools.api.feature.simple.SimpleFeatureType;
import org.geotools.api.feature.type.GeometryDescriptor;
import org.geotools.api.filter.Filter;
import org.geotools.data.DefaultTransaction;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.feature.NameImpl;
import org.geotools.jdbc.BasicSQLDialect;
import org.geotools.jdbc.JDBCDataStore;
import org.geotools.jdbc.PreparedStatementSQLDialect;
import org.geotools.jdbc.SQLDialect;
import org.geotools.util.factory.Hints;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.mockito.Mockito;

public class EnsureAuthorizationTest {
    private JDBCDataStore dataStore;
    private SimpleFeatureType featureType;
    private Transaction tx;
    private TracingMockConnection cx;
    private static final String SAMPLE_FEATURE_NAME = "SAMPLE_FEATURE";
    private static final String SAMPLE_FEATURE_ID = "SAMPLE_ID";

    @Before
    public void setUp() throws SQLException {
        this.cx = new TracingMockConnection();
        this.configureMetadata();
        this.dataStore = new JDBCDataStore();
        this.dataStore.setFilterFactory(CommonFactoryFinder.getFilterFactory());
        this.dataStore.setSQLDialect((SQLDialect)this.createBasicSQLDialect());
        MockDataSource dataSource = new MockDataSource();
        dataSource.setupConnection((Connection)((Object)this.cx));
        this.dataStore.setDataSource((DataSource)dataSource);
        this.featureType = (SimpleFeatureType)Mockito.mock(SimpleFeatureType.class);
        Mockito.when((Object)this.featureType.getTypeName()).thenReturn((Object)SAMPLE_FEATURE_NAME);
        Mockito.when((Object)this.featureType.getName()).thenReturn((Object)new NameImpl(SAMPLE_FEATURE_NAME));
        this.tx = new DefaultTransaction();
    }

    @Test
    public void testFetchSizeUsedWhenNoPreparedStatement() throws IOException, SQLException {
        this.dataStore.setFetchSize(1000);
        this.createLock();
        this.dataStore.ensureAuthorization(this.featureType, (Filter)Filter.INCLUDE, this.tx, (Connection)((Object)this.cx));
        Assert.assertEquals((long)1000L, (long)this.cx.stmt.getFetchSize());
    }

    @Test
    public void testQueryIsNotExecutedIfThereAreNoLocks() throws IOException, SQLException {
        this.dataStore.ensureAuthorization(this.featureType, (Filter)Filter.INCLUDE, this.tx, (Connection)((Object)this.cx));
        Assert.assertEquals((long)0L, (long)this.cx.calls);
    }

    @Test
    public void testQueryIsExecutedIfThereAreLocks() throws IOException, SQLException {
        this.createLock();
        this.dataStore.ensureAuthorization(this.featureType, (Filter)Filter.INCLUDE, this.tx, (Connection)((Object)this.cx));
        Assert.assertNotEquals((long)0L, (long)this.cx.calls);
    }

    @Test
    public void testQueryIsFilteredOnLockedFeatureIds() throws IOException, SQLException {
        this.createLock();
        this.dataStore.ensureAuthorization(this.featureType, (Filter)Filter.INCLUDE, this.tx, (Connection)((Object)this.cx));
        Assert.assertTrue((boolean)this.cx.filteredOnIds);
    }

    @Test
    public void testQueryIsFilteredOnLockedFeatureIdsWithPreparedStatements() throws IOException, SQLException {
        this.dataStore.setSQLDialect((SQLDialect)this.createPreparedSQLDialect());
        this.createLock();
        this.dataStore.ensureAuthorization(this.featureType, (Filter)Filter.INCLUDE, this.tx, (Connection)((Object)this.cx));
        Assert.assertTrue((boolean)this.cx.filteredOnIds);
    }

    @Test
    public void testQueryIsNotFilteredOnLockedFeatureIdsIfThereAreTooManyLocks() throws IOException, SQLException {
        this.createManyLocks();
        this.dataStore.ensureAuthorization(this.featureType, (Filter)Filter.INCLUDE, this.tx, (Connection)((Object)this.cx));
        Assert.assertFalse((boolean)this.cx.filteredOnIds);
    }

    private void createManyLocks() throws IOException {
        for (int count = 0; count < 101; ++count) {
            this.dataStore.getLockingManager().lockFeatureID(SAMPLE_FEATURE_NAME, "" + count, this.tx, new FeatureLock("" + count, 10000000L));
        }
    }

    private void createLock() throws IOException {
        this.dataStore.getLockingManager().lockFeatureID(SAMPLE_FEATURE_NAME, SAMPLE_FEATURE_ID, this.tx, new FeatureLock(SAMPLE_FEATURE_ID, 10000000L));
    }

    private void configureMetadata() throws SQLException {
        ((MockDatabaseMetaData)this.cx.getMetaData()).setSearchStringEscape("");
        MockResultSet tableTypes = new MockResultSet("TABLE_TYPES");
        tableTypes.addColumn("TABLE_TYPE");
        tableTypes.addRow(new Object[]{"TABLE"});
        ((MockDatabaseMetaData)this.cx.getMetaData()).setTableTypes((ResultSet)tableTypes);
        MockResultSet tables = new MockResultSet("TABLES");
        tables.addColumn("TABLE_SCHEM");
        tables.addColumn("TABLE_NAME");
        tables.addRow(new Object[]{"", SAMPLE_FEATURE_NAME});
        ((MockDatabaseMetaData)this.cx.getMetaData()).setTables((ResultSet)tables);
        MockResultSet key = new MockResultSet("KEY");
        key.addColumn("COLUMN_NAME");
        key.addColumn("DATA_TYPE");
        key.addRow(new Object[]{"ID", 1});
        ((MockDatabaseMetaData)this.cx.getMetaData()).setPrimaryKeys(null, null, SAMPLE_FEATURE_NAME, (ResultSet)key);
        MockResultSet columns = new MockResultSet("COLUMNS");
        columns.addColumn("COLUMN_NAME");
        columns.addColumn("DATA_TYPE");
        columns.addRow(new Object[]{"ID", 1});
        ((MockDatabaseMetaData)this.cx.getMetaData()).setColumns(null, null, SAMPLE_FEATURE_NAME, "ID", (ResultSet)columns);
    }

    private BasicSQLDialect createBasicSQLDialect() {
        return new BasicSQLDialect(this.dataStore){

            public void encodeGeometryValue(Geometry value, int dimension, int srid, StringBuffer sql) throws IOException {
            }

            public void encodeGeometryEnvelope(String tableName, String geometryColumn, StringBuffer sql) {
            }

            public Envelope decodeGeometryEnvelope(ResultSet rs, int column, Connection cx) throws SQLException, IOException {
                return null;
            }

            public Geometry decodeGeometryValue(GeometryDescriptor descriptor, ResultSet rs, String column, GeometryFactory factory, Connection cx, Hints hints) throws IOException, SQLException {
                return null;
            }
        };
    }

    private PreparedStatementSQLDialect createPreparedSQLDialect() {
        return new PreparedStatementSQLDialect(this.dataStore){

            public void encodeGeometryEnvelope(String tableName, String geometryColumn, StringBuffer sql) {
            }

            public Envelope decodeGeometryEnvelope(ResultSet rs, int column, Connection cx) throws SQLException, IOException {
                return null;
            }

            public Geometry decodeGeometryValue(GeometryDescriptor descriptor, ResultSet rs, String column, GeometryFactory factory, Connection cx, Hints hints) throws IOException, SQLException {
                return null;
            }

            public void setGeometryValue(Geometry g, int dimension, int srid, Class binding, PreparedStatement ps, int column) throws SQLException {
            }
        };
    }

    public static class TracingMockConnection
    extends MockConnection {
        int calls = 0;
        boolean filteredOnIds = false;
        MockStatement stmt;
        MockPreparedStatement pstmt;

        public Statement createStatement() throws SQLException {
            this.stmt = new MockStatement((Connection)((Object)this)){

                public ResultSet executeQuery(String sql) throws SQLException {
                    if (sql.matches("^.*\"ID\"\\s+=\\s+'.*'.*$")) {
                        filteredOnIds = true;
                    }
                    return new MockResultSet(EnsureAuthorizationTest.SAMPLE_FEATURE_NAME);
                }
            };
            ++this.calls;
            return this.stmt;
        }

        public PreparedStatement prepareStatement(String sql) throws SQLException {
            return this.prepareStatement(sql, 0, 0);
        }

        public PreparedStatement prepareStatement(final String sql, int arg1, int arg2) throws SQLException {
            this.pstmt = new MockPreparedStatement((Connection)((Object)this), sql, arg1, arg2){

                public ResultSet executeQuery() throws SQLException {
                    if (sql.matches("^.*\"ID\"\\s+=\\s+\\?.*$")) {
                        filteredOnIds = true;
                    }
                    return new MockResultSet(EnsureAuthorizationTest.SAMPLE_FEATURE_NAME);
                }
            };
            ++this.calls;
            return this.pstmt;
        }
    }
}

