/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.jdbc;

import org.geotools.api.data.Query;
import org.geotools.data.store.ContentFeatureSource;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.FeatureIterator;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.jdbc.JDBCEmptyTestSetup;
import org.geotools.jdbc.JDBCTestSupport;
import org.junit.Assert;
import org.junit.Test;

public abstract class JDBCEmptyOnlineTest
extends JDBCTestSupport {
    @Override
    protected abstract JDBCEmptyTestSetup createTestSetup();

    @Test
    public void testFeatureSource() throws Exception {
        ContentFeatureSource fs = this.dataStore.getFeatureSource(this.tname("empty"));
        Assert.assertNotNull((Object)fs);
        ReferencedEnvelope bounds = fs.getBounds();
        Assert.assertTrue((boolean)bounds.isNull());
        int count = fs.getCount(Query.ALL);
        Assert.assertEquals((long)0L, (long)count);
    }

    @Test
    public void testFeatureCollection() throws Exception {
        ContentFeatureSource fs = this.dataStore.getFeatureSource(this.tname("empty"));
        FeatureCollection features = fs.getFeatures();
        Assert.assertTrue((boolean)features.getBounds().isNull());
        Assert.assertEquals((long)0L, (long)features.size());
        try (FeatureIterator i = features.features();){
            Assert.assertFalse((boolean)i.hasNext());
        }
    }
}

