/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.jdbc;

import java.io.IOException;
import org.geotools.api.feature.simple.SimpleFeature;
import org.geotools.api.feature.simple.SimpleFeatureType;
import org.geotools.api.filter.Filter;
import org.geotools.api.filter.FilterFactory;
import org.geotools.api.filter.PropertyIsEqualTo;
import org.geotools.api.filter.expression.Expression;
import org.geotools.data.DataUtilities;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.data.simple.SimpleFeatureIterator;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.jdbc.JDBCFeatureStore;
import org.geotools.jdbc.JDBCTestSupport;
import org.geotools.referencing.CRS;
import org.junit.Assert;
import org.junit.Test;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.GeometryFactory;

public abstract class JDBCFeatureCollectionOnlineTest
extends JDBCTestSupport {
    SimpleFeatureCollection collection;
    JDBCFeatureStore source;

    @Override
    protected void connect() throws Exception {
        super.connect();
        this.source = (JDBCFeatureStore)this.dataStore.getFeatureSource(this.tname("ft1"));
        this.collection = this.source.getFeatures();
    }

    @Test
    public void testIterator() throws Exception {
        try (SimpleFeatureIterator i = this.collection.features();){
            Assert.assertNotNull((Object)i);
            this.assertFeatureIterator(0, 3, i, new JDBCTestSupport.SimpleFeatureAssertion(){

                @Override
                public int toIndex(SimpleFeature feature) {
                    return ((Number)feature.getAttribute(JDBCFeatureCollectionOnlineTest.this.aname("intProperty"))).intValue();
                }

                @Override
                public void check(int index, SimpleFeature feature) {
                    Assert.assertNotNull((Object)feature);
                    String fid = feature.getID();
                    int id = Integer.parseInt(fid.substring(fid.indexOf(46) + 1));
                    Assert.assertEquals((long)index, (long)id);
                }
            });
        }
    }

    @Test
    public void testBounds() throws IOException {
        ReferencedEnvelope bounds = this.collection.getBounds();
        Assert.assertNotNull((Object)bounds);
        Assert.assertEquals((double)0.0, (double)bounds.getMinX(), (double)0.1);
        Assert.assertEquals((double)0.0, (double)bounds.getMinY(), (double)0.1);
        Assert.assertEquals((double)2.0, (double)bounds.getMaxX(), (double)0.1);
        Assert.assertEquals((double)2.0, (double)bounds.getMaxY(), (double)0.1);
    }

    @Test
    public void testSize() throws IOException {
        Assert.assertEquals((long)3L, (long)this.collection.size());
    }

    @Test
    public void testSubCollection() throws Exception {
        FilterFactory ff = this.dataStore.getFilterFactory();
        PropertyIsEqualTo f = ff.equals((Expression)ff.property(this.aname("intProperty")), (Expression)ff.literal(1));
        SimpleFeatureCollection sub = this.collection.subCollection((Filter)f);
        Assert.assertNotNull((Object)sub);
        Assert.assertEquals((long)1L, (long)sub.size());
        ReferencedEnvelope exp = new ReferencedEnvelope(1.0, 1.0, 1.0, 1.0, CRS.decode((String)"EPSG:4326"));
        ReferencedEnvelope act = sub.getBounds();
        Assert.assertEquals((double)exp.getMinX(), (double)act.getMinX(), (double)0.1);
        Assert.assertEquals((double)exp.getMinY(), (double)act.getMinY(), (double)0.1);
        Assert.assertEquals((double)exp.getMaxX(), (double)act.getMaxX(), (double)0.1);
        Assert.assertEquals((double)exp.getMaxY(), (double)act.getMaxY(), (double)0.1);
    }

    @Test
    public void testAdd() throws IOException {
        SimpleFeatureBuilder b = new SimpleFeatureBuilder((SimpleFeatureType)this.collection.getSchema());
        b.set(this.aname("intProperty"), (Object)3);
        b.set(this.aname("doubleProperty"), (Object)3.3);
        b.set(this.aname("stringProperty"), (Object)"three");
        b.set(this.aname("geometry"), (Object)new GeometryFactory().createPoint(new Coordinate(3.0, 3.0)));
        SimpleFeature feature = b.buildFeature(null);
        Assert.assertEquals((long)3L, (long)this.collection.size());
        this.source.addFeatures((FeatureCollection)DataUtilities.collection((SimpleFeature)feature));
        Assert.assertEquals((long)4L, (long)this.collection.size());
        try (SimpleFeatureIterator i = this.collection.features();){
            boolean found = false;
            while (i.hasNext()) {
                SimpleFeature f = (SimpleFeature)i.next();
                if (!"three".equals(f.getAttribute(this.aname("stringProperty")))) continue;
                Assert.assertEquals((double)((Double)feature.getAttribute(this.aname("doubleProperty"))), (double)((Double)f.getAttribute(this.aname("doubleProperty"))), (double)1.0E-5);
                Assert.assertEquals((Object)feature.getAttribute(this.aname("stringProperty")), (Object)f.getAttribute(this.aname("stringProperty")));
                Assert.assertEquals((Object)feature.getAttribute(this.aname("geometry")), (Object)f.getAttribute(this.aname("geometry")));
                found = true;
            }
            Assert.assertTrue((boolean)found);
        }
    }
}

