/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.jdbc;

import java.util.Collections;
import org.geotools.api.data.FeatureLock;
import org.geotools.api.data.FeatureLockException;
import org.geotools.api.data.FeatureReader;
import org.geotools.api.data.FeatureWriter;
import org.geotools.api.data.Query;
import org.geotools.api.data.Transaction;
import org.geotools.api.feature.simple.SimpleFeature;
import org.geotools.api.feature.type.Name;
import org.geotools.api.filter.Filter;
import org.geotools.api.filter.FilterFactory;
import org.geotools.api.filter.Id;
import org.geotools.api.filter.PropertyIsEqualTo;
import org.geotools.api.filter.expression.Expression;
import org.geotools.data.DefaultTransaction;
import org.geotools.feature.NameImpl;
import org.geotools.jdbc.JDBCFeatureStore;
import org.geotools.jdbc.JDBCTestSupport;
import org.junit.Assert;
import org.junit.Test;

public abstract class JDBCFeatureLockingOnlineTest
extends JDBCTestSupport {
    JDBCFeatureStore store;

    @Override
    protected void connect() throws Exception {
        super.connect();
        this.store = (JDBCFeatureStore)this.dataStore.getFeatureSource(this.tname("ft1"));
        this.store.setFeatureLock(FeatureLock.TRANSACTION);
    }

    @Test
    public void testLockFeatures() throws Exception {
        FeatureLock lock = new FeatureLock(this.tname("ft1"), 3600000L);
        try (DefaultTransaction tx = new DefaultTransaction();){
            SimpleFeature feature;
            this.store.setTransaction((Transaction)tx);
            this.store.setFeatureLock(lock);
            int locked = this.store.lockFeatures();
            Assert.assertTrue((locked > 0 ? 1 : 0) != 0);
            Query query = new Query(this.tname("ft1"));
            try (FeatureReader reader = this.dataStore.getFeatureReader(query, (Transaction)tx);){
                int count = 0;
                while (reader.hasNext()) {
                    ++count;
                    reader.next();
                }
                Assert.assertTrue((count > 0 ? 1 : 0) != 0);
            }
            try (FeatureWriter writer = this.dataStore.getFeatureWriter(this.tname("ft1"), (Transaction)tx);){
                Assert.assertTrue((boolean)writer.hasNext());
                feature = (SimpleFeature)writer.next();
                feature.setAttribute(this.aname("intProperty"), (Object)100);
                try {
                    writer.write();
                    Assert.fail((String)"should have thrown feature lock exception");
                }
                catch (FeatureLockException featureLockException) {
                    // empty catch block
                }
            }
            tx.addAuthorization(lock.getAuthorization());
            writer = this.dataStore.getFeatureWriter(this.tname("ft1"), (Transaction)tx);
            try {
                Assert.assertTrue((boolean)writer.hasNext());
                feature = (SimpleFeature)writer.next();
                feature.setAttribute(this.aname("intProperty"), (Object)100);
                writer.write();
            }
            finally {
                if (writer != null) {
                    writer.close();
                }
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Test
    public void testLockFeaturesWithFilter() throws Exception {
        FeatureLock lock = new FeatureLock(this.tname("ft1"), 3600000L);
        try (DefaultTransaction tx = new DefaultTransaction();){
            this.store.setTransaction((Transaction)tx);
            this.store.setFeatureLock(lock);
            FilterFactory ff = this.dataStore.getFilterFactory();
            PropertyIsEqualTo f = ff.equals((Expression)ff.property(this.aname("intProperty")), (Expression)ff.literal(1));
            int locked = this.store.lockFeatures((Filter)f);
            Assert.assertEquals((long)1L, (long)locked);
            boolean failure = false;
            try (FeatureWriter writer = this.dataStore.getFeatureWriter(this.tname("ft1"), (Transaction)tx);){
                while (writer.hasNext()) {
                    SimpleFeature feature = (SimpleFeature)writer.next();
                    Number old = (Number)feature.getAttribute(this.aname("intProperty"));
                    feature.setAttribute(this.aname("intProperty"), (Object)100);
                    if (Integer.valueOf(1).equals(old.intValue())) {
                        try {
                            writer.write();
                            Assert.fail((String)"writer should have thrown exception for locked feature");
                            continue;
                        }
                        catch (FeatureLockException e) {
                            failure = true;
                            continue;
                        }
                    }
                    writer.write();
                }
            }
            Assert.assertTrue((boolean)failure);
            return;
        }
    }

    @Test
    public void testLockFeaturesWithInvalidFilter() throws Exception {
        FeatureLock lock = new FeatureLock(this.tname("ft1"), 3600000L);
        try (DefaultTransaction tx = new DefaultTransaction();){
            this.store.setTransaction((Transaction)tx);
            this.store.setFeatureLock(lock);
            FilterFactory ff = this.dataStore.getFilterFactory();
            PropertyIsEqualTo f = ff.equals((Expression)ff.property(this.aname("invalidProperty")), (Expression)ff.literal(1));
            try {
                this.store.lockFeatures((Filter)f);
                Assert.fail((String)"Should have failed with an exception, the filter is not valid");
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @Test
    public void testLockFeaturesWithInvalidQuery() throws Exception {
        FeatureLock lock = new FeatureLock(this.tname("ft1"), 3600000L);
        try (DefaultTransaction tx = new DefaultTransaction();){
            this.store.setTransaction((Transaction)tx);
            this.store.setFeatureLock(lock);
            FilterFactory ff = this.dataStore.getFilterFactory();
            PropertyIsEqualTo f = ff.equals((Expression)ff.property(this.aname("invalidProperty")), (Expression)ff.literal(1));
            try {
                this.store.lockFeatures(new Query(this.store.getSchema().getTypeName(), (Filter)f));
                Assert.fail((String)"Should have failed with an exception, the filter is not valid");
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @Test
    public void testUnlockFeatures() throws Exception {
        FeatureLock lock = new FeatureLock(this.tname("ft1"), 3600000L);
        try (DefaultTransaction tx = new DefaultTransaction();){
            SimpleFeature feature;
            this.store.setTransaction((Transaction)tx);
            this.store.setFeatureLock(lock);
            this.store.lockFeatures();
            try (FeatureWriter writer2 = this.dataStore.getFeatureWriter(this.tname("ft1"), (Transaction)tx);){
                Assert.assertTrue((boolean)writer2.hasNext());
                feature = (SimpleFeature)writer2.next();
                feature.setAttribute(this.aname("intProperty"), (Object)100);
                try {
                    writer2.write();
                    Assert.fail((String)"write should have thrown exception");
                }
                catch (FeatureLockException featureLockException) {
                    // empty catch block
                }
            }
            try {
                this.store.unLockFeatures();
                Assert.fail((String)"unlock should have thrown an exception");
            }
            catch (FeatureLockException writer2) {
                // empty catch block
            }
            tx.addAuthorization(lock.getAuthorization());
            this.store.unLockFeatures();
            writer2 = this.dataStore.getFeatureWriter(this.tname("ft1"), (Transaction)tx);
            try {
                Assert.assertTrue((boolean)writer2.hasNext());
                feature = (SimpleFeature)writer2.next();
                feature.setAttribute(this.aname("intProperty"), (Object)100);
                writer2.write();
            }
            finally {
                if (writer2 != null) {
                    writer2.close();
                }
            }
        }
    }

    @Test
    public void testUnlockFeaturesInvalidFilter() throws Exception {
        FeatureLock lock = new FeatureLock(this.tname("ft1"), 3600000L);
        try (DefaultTransaction tx = new DefaultTransaction();){
            this.store.setTransaction((Transaction)tx);
            this.store.setFeatureLock(lock);
            tx.addAuthorization(lock.getAuthorization());
            this.store.lockFeatures();
            FilterFactory ff = this.dataStore.getFilterFactory();
            PropertyIsEqualTo f = ff.equals((Expression)ff.property(this.aname("invalidProperty")), (Expression)ff.literal(1));
            try {
                this.store.unLockFeatures(new Query(this.store.getSchema().getTypeName(), (Filter)f));
                Assert.fail((String)"Should have failed with an exception, the filter is not valid");
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.store.unLockFeatures();
        }
    }

    @Test
    public void testDeleteLockedFeatures() throws Exception {
        FeatureLock lock = new FeatureLock(this.tname("ft1"), 3600000L);
        try (DefaultTransaction tx = new DefaultTransaction();){
            this.store.setTransaction((Transaction)tx);
            this.store.setFeatureLock(lock);
            tx.addAuthorization(lock.getAuthorization());
            FilterFactory ff = this.dataStore.getFilterFactory();
            Id f1 = ff.id(Collections.singleton(ff.featureId(this.tname("ft1") + ".1")));
            Assert.assertEquals((long)1L, (long)this.store.lockFeatures((Filter)f1));
            try (DefaultTransaction tx1 = new DefaultTransaction();){
                this.store.setTransaction((Transaction)tx1);
                try {
                    this.store.removeFeatures((Filter)f1);
                    Assert.fail((String)"Locked feature should not be deleted.");
                }
                catch (FeatureLockException featureLockException) {
                    // empty catch block
                }
            }
            this.store.setTransaction((Transaction)tx);
            this.store.removeFeatures((Filter)f1);
            tx.commit();
        }
    }

    @Test
    public void testModifyLockedFeatures() throws Exception {
        FilterFactory ff = this.dataStore.getFilterFactory();
        PropertyIsEqualTo f0 = ff.equal((Expression)ff.property(this.aname("intProperty")), (Expression)ff.literal(1000), true);
        Assert.assertEquals((long)0L, (long)this.store.getCount(new Query(this.tname("ft1"), (Filter)f0)));
        FeatureLock lock = new FeatureLock(this.tname("ft1"), 3600000L);
        try (DefaultTransaction tx = new DefaultTransaction();){
            Integer v;
            this.store.setTransaction((Transaction)tx);
            this.store.setFeatureLock(lock);
            tx.addAuthorization(lock.getAuthorization());
            Id f1 = ff.id(Collections.singleton(ff.featureId(this.tname("ft1") + ".1")));
            this.store.lockFeatures((Filter)f1);
            NameImpl intProperty = new NameImpl(this.aname("intProperty"));
            try (DefaultTransaction tx1 = new DefaultTransaction();){
                this.store.setTransaction((Transaction)tx1);
                v = 1000;
                try {
                    this.store.modifyFeatures((Name)intProperty, (Object)v, (Filter)f1);
                    Assert.fail((String)"Locked feature should not be modified.");
                }
                catch (FeatureLockException featureLockException) {
                    // empty catch block
                }
            }
            this.store.setTransaction((Transaction)tx);
            this.store.modifyFeatures((Name)intProperty, (Object)v, (Filter)f1);
            tx.commit();
            Assert.assertEquals((long)1L, (long)this.store.getCount(new Query(this.tname("ft1"), (Filter)f0)));
        }
    }
}

