/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.jdbc;

import java.io.IOException;
import java.util.List;
import org.geotools.api.feature.simple.SimpleFeature;
import org.geotools.api.feature.simple.SimpleFeatureType;
import org.geotools.api.referencing.FactoryException;
import org.geotools.api.referencing.IdentifiedObject;
import org.geotools.api.referencing.crs.CoordinateReferenceSystem;
import org.geotools.data.DataUtilities;
import org.geotools.data.store.ContentFeatureSource;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.geotools.jdbc.JDBCIAUTestSetup;
import org.geotools.jdbc.JDBCTestSupport;
import org.geotools.referencing.CRS;
import org.junit.Assert;
import org.junit.Test;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Polygon;

public abstract class JDBCIAUOnlineTest
extends JDBCTestSupport {
    @Override
    protected abstract JDBCIAUTestSetup createTestSetup();

    @Test
    public void testCRS() throws Exception {
        ContentFeatureSource fs = this.dataStore.getFeatureSource(this.tname("mars_poi"));
        SimpleFeatureType ft = fs.getSchema();
        CoordinateReferenceSystem crs = ft.getCoordinateReferenceSystem();
        Assert.assertEquals((Object)"IAU:49900", (Object)CRS.lookupIdentifier((IdentifiedObject)crs, (boolean)true));
        CoordinateReferenceSystem expected = CRS.decode((String)"IAU:49900", (boolean)true);
        Assert.assertTrue((boolean)CRS.equalsIgnoreMetadata((Object)expected, (Object)crs));
        List features = DataUtilities.list((FeatureCollection)fs.getFeatures());
        Assert.assertEquals((long)3L, (long)features.size());
        for (SimpleFeature feature : features) {
            Assert.assertEquals((Object)crs, (Object)feature.getFeatureType().getCoordinateReferenceSystem());
            Point p = (Point)feature.getDefaultGeometry();
            Assert.assertEquals((Object)crs, (Object)p.getUserData());
        }
    }

    @Test
    public void testCreateSchema() throws Exception {
        SimpleFeatureType mg1 = this.createGeology("mars_geology");
        if (this.canReuseSRID()) {
            SimpleFeatureType mg2 = this.createGeology("mars_geology2");
            Assert.assertEquals((long)this.getSRID(mg1), (long)this.getSRID(mg2));
        }
    }

    protected boolean canReuseSRID() {
        return true;
    }

    protected SimpleFeatureType createGeology(String typename) throws IOException, FactoryException {
        this.dataStore.createSchema(JDBCIAUOnlineTest.buildGeologyType(typename));
        SimpleFeatureType marsGeology = this.dataStore.getSchema(typename);
        Assert.assertEquals((Object)"IAU:49901", (Object)CRS.lookupIdentifier((IdentifiedObject)marsGeology.getCoordinateReferenceSystem(), (boolean)true));
        return marsGeology;
    }

    private static SimpleFeatureType buildGeologyType(String typeName) {
        SimpleFeatureTypeBuilder tb = new SimpleFeatureTypeBuilder();
        tb.add("geom", Polygon.class, "IAU:49901");
        tb.add("type", String.class);
        tb.setName(typeName);
        return tb.buildFeatureType();
    }

    private int getSRID(SimpleFeatureType ft) {
        return (Integer)ft.getGeometryDescriptor().getUserData().get("nativeSRID");
    }
}

