/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.jdbc;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.geotools.jdbc.JDBCDelegatingTestSetup;
import org.geotools.jdbc.JDBCTestSetup;
import org.geotools.util.logging.Logging;

public abstract class JDBCMeasuredGeometriesTestSetup
extends JDBCDelegatingTestSetup {
    protected static final Logger LOGGER = Logging.getLogger(JDBCMeasuredGeometriesTestSetup.class);

    protected JDBCMeasuredGeometriesTestSetup(JDBCTestSetup delegate) {
        super(delegate);
    }

    @Override
    protected final void setUpData() throws Exception {
        this.dropTables();
        this.createTables();
    }

    private void quietly(Statement ... statements) {
        for (Statement statement : statements) {
            this.quietly(statement);
        }
    }

    private void quietly(Statement statement) {
        try {
            statement.execute();
        }
        catch (Exception exception) {
            LOGGER.log(Level.FINE, "Ignored error.", exception);
        }
    }

    private void createTables() {
        try {
            this.createTablePointsM();
            this.createTablePointsZM();
            this.createTableLinesM();
            this.createTableLinesZM();
        }
        catch (Exception exception) {
            this.dropTables();
            LOGGER.log(Level.INFO, "Error creating tables.", exception);
        }
    }

    private void dropTables() {
        this.quietly(this::dropTablePointsM, this::dropTablePointsZM, this::dropTableLinesM, this::dropTableLinesZM);
    }

    protected abstract void createTablePointsM() throws Exception;

    protected abstract void dropTablePointsM() throws Exception;

    protected abstract void createTablePointsZM() throws Exception;

    protected abstract void dropTablePointsZM() throws Exception;

    protected abstract void createTableLinesM() throws Exception;

    protected abstract void dropTableLinesM() throws Exception;

    protected abstract void createTableLinesZM() throws Exception;

    protected abstract void dropTableLinesZM() throws Exception;

    @FunctionalInterface
    private static interface Statement {
        public void execute() throws Exception;
    }
}

