/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.jdbc;

import java.util.Collections;
import org.geotools.api.data.FeatureReader;
import org.geotools.api.data.FeatureStore;
import org.geotools.api.data.Query;
import org.geotools.api.feature.simple.SimpleFeature;
import org.geotools.api.feature.simple.SimpleFeatureType;
import org.geotools.api.feature.type.AttributeDescriptor;
import org.geotools.api.filter.Filter;
import org.geotools.api.filter.FilterFactory;
import org.geotools.api.filter.Id;
import org.geotools.api.filter.PropertyIsEqualTo;
import org.geotools.api.filter.expression.Expression;
import org.geotools.data.DataUtilities;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.data.store.ContentFeatureCollection;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.geotools.jdbc.AutoGeneratedPrimaryKeyColumn;
import org.geotools.jdbc.JDBCFeatureSource;
import org.geotools.jdbc.JDBCFeatureStore;
import org.geotools.jdbc.JDBCPrimaryKeyTestSetup;
import org.geotools.jdbc.JDBCTestSupport;
import org.geotools.jdbc.NonIncrementingPrimaryKeyColumn;
import org.geotools.jdbc.PrimaryKeyColumn;
import org.geotools.jdbc.SequencedPrimaryKeyColumn;
import org.junit.Assert;
import org.junit.Test;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.GeometryFactory;

public abstract class JDBCPrimaryKeyOnlineTest
extends JDBCTestSupport {
    @Override
    protected abstract JDBCPrimaryKeyTestSetup createTestSetup();

    @Override
    protected void connect() throws Exception {
        super.connect();
        if (this.setup.canResetSchema()) {
            this.dataStore.setDatabaseSchema(null);
        }
    }

    @Test
    public void testAutoGeneratedPrimaryKey() throws Exception {
        JDBCFeatureStore fs = (JDBCFeatureStore)this.dataStore.getFeatureSource(this.tname("auto"));
        Assert.assertEquals((long)1L, (long)fs.getPrimaryKey().getColumns().size());
        Assert.assertTrue((boolean)(fs.getPrimaryKey().getColumns().get(0) instanceof AutoGeneratedPrimaryKeyColumn));
        Assert.assertNull((Object)fs.getSchema().getDescriptor(((PrimaryKeyColumn)fs.getPrimaryKey().getColumns().get(0)).getName()));
        ContentFeatureCollection features = fs.getFeatures();
        this.assertPrimaryKeyValues((SimpleFeatureCollection)features, 3);
        this.addFeature(fs.getSchema(), fs);
        this.assertPrimaryKeyValues((SimpleFeatureCollection)features, 4);
    }

    @Test
    public void testSequencedPrimaryKey() throws Exception {
        JDBCFeatureStore fs = (JDBCFeatureStore)this.dataStore.getFeatureSource(this.tname("seq"));
        Assert.assertEquals((long)1L, (long)fs.getPrimaryKey().getColumns().size());
        Assert.assertTrue((boolean)(fs.getPrimaryKey().getColumns().get(0) instanceof SequencedPrimaryKeyColumn));
        ContentFeatureCollection features = fs.getFeatures();
        this.assertPrimaryKeyValues((SimpleFeatureCollection)features, 3);
        this.addFeature(fs.getSchema(), fs);
        this.assertPrimaryKeyValues((SimpleFeatureCollection)features, 4);
    }

    @Test
    public void testNonIncrementingPrimaryKey() throws Exception {
        JDBCFeatureStore fs = (JDBCFeatureStore)this.dataStore.getFeatureSource(this.tname("noninc"));
        Assert.assertEquals((long)1L, (long)fs.getPrimaryKey().getColumns().size());
        Assert.assertTrue((boolean)(fs.getPrimaryKey().getColumns().get(0) instanceof NonIncrementingPrimaryKeyColumn));
        ContentFeatureCollection features = fs.getFeatures();
        this.assertPrimaryKeyValues((SimpleFeatureCollection)features, 3);
        this.addFeature(fs.getSchema(), fs);
        this.assertPrimaryKeyValues((SimpleFeatureCollection)features, 4);
    }

    protected void addFeature(SimpleFeatureType featureType, JDBCFeatureStore features) throws Exception {
        SimpleFeatureBuilder b = new SimpleFeatureBuilder(featureType);
        b.add((Object)"four");
        b.add((Object)new GeometryFactory().createPoint(new Coordinate(4.0, 4.0)));
        SimpleFeature f = b.buildFeature(null);
        features.addFeatures((FeatureCollection)DataUtilities.collection((SimpleFeature)f));
        Assert.assertTrue((boolean)((String)f.getUserData().get("fid")).matches(this.tname(featureType.getTypeName()) + ".4(\\..*)?"));
    }

    protected void assertPrimaryKeyValues(final SimpleFeatureCollection features, int count) throws Exception {
        this.assertFeatureIterator(1, count, features.features(), new JDBCTestSupport.SimpleFeatureAssertion(){

            @Override
            public int toIndex(SimpleFeature feature) {
                return Integer.parseInt(feature.getID().split("\\.", 2)[1]);
            }

            @Override
            public void check(int index, SimpleFeature feature) {
                Assert.assertEquals((Object)(JDBCPrimaryKeyOnlineTest.this.tname(((SimpleFeatureType)features.getSchema()).getName().getLocalPart()) + "." + index), (Object)feature.getID());
            }
        });
    }

    @Test
    public void testMultiColumnPrimaryKey() throws Exception {
        JDBCFeatureStore fs = (JDBCFeatureStore)this.dataStore.getFeatureSource(this.tname("multi"));
        Assert.assertEquals((long)2L, (long)fs.getPrimaryKey().getColumns().size());
        ContentFeatureCollection features = fs.getFeatures();
        this.assertMultiPrimaryKeyValues((SimpleFeatureCollection)features, 3);
        this.addFeature(fs.getSchema(), fs);
        this.assertMultiPrimaryKeyValues((SimpleFeatureCollection)features, 4);
        FilterFactory ff = this.dataStore.getFilterFactory();
        Id id = ff.id(Collections.singleton(ff.featureId(this.tname("multi") + ".1.x")));
        features = fs.getFeatures((Filter)id);
        Assert.assertEquals((long)1L, (long)features.size());
    }

    void assertMultiPrimaryKeyValues(SimpleFeatureCollection features, int count) throws Exception {
        this.assertFeatureIterator(1, count, features.features(), new JDBCTestSupport.SimpleFeatureAssertion(){
            String[] xyz = new String[]{"x", "y", "z"};

            @Override
            public int toIndex(SimpleFeature feature) {
                return Integer.parseInt(feature.getID().split("\\.")[1]);
            }

            @Override
            public void check(int index, SimpleFeature feature) {
                if (index < 4) {
                    Assert.assertEquals((Object)(JDBCPrimaryKeyOnlineTest.this.tname("multi") + "." + index + "." + this.xyz[index - 1]), (Object)feature.getID());
                } else {
                    Assert.assertTrue((boolean)feature.getID().startsWith(JDBCPrimaryKeyOnlineTest.this.tname("multi") + ".4."));
                }
            }
        });
    }

    @Test
    public void testNullPrimaryKey() throws Exception {
        JDBCFeatureSource fs = (JDBCFeatureSource)this.dataStore.getFeatureSource(this.tname("nokey"));
        Assert.assertFalse((boolean)(fs instanceof FeatureStore));
    }

    @Test
    public void testUniqueIndex() throws Exception {
        JDBCFeatureStore fs = (JDBCFeatureStore)this.dataStore.getFeatureSource(this.tname("uniq"));
        Assert.assertEquals((long)1L, (long)fs.getPrimaryKey().getColumns().size());
        Assert.assertTrue((boolean)(fs.getPrimaryKey().getColumns().get(0) instanceof NonIncrementingPrimaryKeyColumn));
        Assert.assertNull((Object)fs.getSchema().getDescriptor(((PrimaryKeyColumn)fs.getPrimaryKey().getColumns().get(0)).getName()));
        ContentFeatureCollection features = fs.getFeatures();
        this.assertPrimaryKeyValues((SimpleFeatureCollection)features, 3);
        this.addFeature(fs.getSchema(), fs);
        this.assertPrimaryKeyValues((SimpleFeatureCollection)features, 4);
    }

    @Test
    public void testExposePrimaryKeyColumns() throws Exception {
        JDBCFeatureStore fs = (JDBCFeatureStore)this.dataStore.getFeatureSource(this.tname("noninc"));
        Assert.assertEquals((long)2L, (long)fs.getSchema().getAttributeCount());
        fs = (JDBCFeatureStore)this.dataStore.getFeatureSource(this.tname("noninc"));
        fs.setExposePrimaryKeyColumns(true);
        Assert.assertEquals((long)3L, (long)fs.getSchema().getAttributeCount());
    }

    @Test
    public void testUpdateWithExposePrimaryKeyColumns() throws Exception {
        JDBCFeatureStore fs = (JDBCFeatureStore)this.dataStore.getFeatureSource(this.tname("nonfirst"));
        fs.setExposePrimaryKeyColumns(true);
        String key = null;
        for (AttributeDescriptor ad : fs.getSchema().getAttributeDescriptors()) {
            if (!Number.class.isAssignableFrom(ad.getType().getBinding())) continue;
            key = ad.getLocalName();
            break;
        }
        Assert.assertNotNull(key);
        Object keyValue = null;
        try (FeatureReader r = fs.getReader();){
            Assert.assertTrue((boolean)r.hasNext());
            SimpleFeature f = (SimpleFeature)r.next();
            keyValue = f.getAttribute(key);
        }
        Assert.assertNotNull((Object)keyValue);
        FilterFactory ff = CommonFactoryFinder.getFilterFactory();
        PropertyIsEqualTo filter = ff.equal((Expression)ff.property(key), (Expression)ff.literal(keyValue), false);
        Assert.assertEquals((long)1L, (long)fs.getCount(new Query(this.tname("nonfirst"), (Filter)filter)));
        try {
            fs.modifyFeatures(key, (Object)10, (Filter)filter);
            Assert.fail((String)"expected exception");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        fs.modifyFeatures(new String[]{this.aname("name"), key, this.aname("geom")}, new Object[]{"foo", 10, null}, (Filter)filter);
        try (FeatureReader r = fs.getReader((Filter)ff.equal((Expression)ff.property(key), (Expression)ff.literal(keyValue), true));){
            Assert.assertTrue((boolean)r.hasNext());
            SimpleFeature f = (SimpleFeature)r.next();
            Assert.assertEquals((Object)"foo", (Object)f.getAttribute(this.aname("name")));
        }
    }
}

