/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.jdbc;

import org.geotools.api.data.Query;
import org.geotools.api.feature.simple.SimpleFeature;
import org.geotools.api.filter.Filter;
import org.geotools.api.filter.FilterFactory;
import org.geotools.api.filter.expression.Expression;
import org.geotools.api.filter.expression.Literal;
import org.geotools.api.filter.expression.PropertyName;
import org.geotools.api.filter.spatial.BBOX;
import org.geotools.api.filter.spatial.Contains;
import org.geotools.api.filter.spatial.Crosses;
import org.geotools.api.filter.spatial.DWithin;
import org.geotools.api.filter.spatial.Disjoint;
import org.geotools.api.filter.spatial.Equals;
import org.geotools.api.filter.spatial.Intersects;
import org.geotools.api.filter.spatial.Touches;
import org.geotools.api.filter.spatial.Within;
import org.geotools.data.store.ContentFeatureCollection;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.FeatureIterator;
import org.geotools.jdbc.JDBCDataStoreAPITestSetup;
import org.geotools.jdbc.JDBCTestSupport;
import org.geotools.jdbc.TestData;
import org.junit.Assert;
import org.junit.Test;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryCollection;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.LinearRing;
import org.locationtech.jts.geom.Polygon;
import org.locationtech.jts.geom.PrecisionModel;
import org.locationtech.jts.geom.impl.PackedCoordinateSequenceFactory;

public abstract class JDBCSpatialFiltersOnlineTest
extends JDBCTestSupport {
    TestData td;

    @Override
    protected void connect() throws Exception {
        super.connect();
        if (this.td == null) {
            this.td = new TestData(((JDBCDataStoreAPITestSetup)this.setup).getInitialPrimaryKeyValue());
            this.td.ROAD = this.tname(this.td.ROAD);
            this.td.ROAD_ID = this.aname(this.td.ROAD_ID);
            this.td.ROAD_GEOM = this.aname(this.td.ROAD_GEOM);
            this.td.ROAD_NAME = this.aname(this.td.ROAD_NAME);
            this.td.RIVER = this.tname(this.td.RIVER);
            this.td.RIVER_ID = this.aname(this.td.RIVER_ID);
            this.td.RIVER_GEOM = this.aname(this.td.RIVER_GEOM);
            this.td.RIVER_FLOW = this.aname(this.td.RIVER_FLOW);
            this.td.RIVER_RIVER = this.aname(this.td.RIVER_RIVER);
            this.td.build();
        }
        if (this.setup.canResetSchema()) {
            this.dataStore.setDatabaseSchema(null);
        }
    }

    @Override
    protected abstract JDBCDataStoreAPITestSetup createTestSetup();

    @Test
    public void testBboxFilter() throws Exception {
        FilterFactory ff = CommonFactoryFinder.getFilterFactory(null);
        BBOX bbox = ff.bbox(this.aname("geom"), 2.0, 3.0, 4.0, 5.0, "EPSG:4326");
        ContentFeatureCollection features = this.dataStore.getFeatureSource(this.tname("road")).getFeatures((Filter)bbox);
        this.checkSingleResult((FeatureCollection)features, "r2");
    }

    @Test
    public void testBboxFilterDefault() throws Exception {
        FilterFactory ff = CommonFactoryFinder.getFilterFactory(null);
        BBOX bbox = ff.bbox("", 2.0, 3.0, 4.0, 5.0, "EPSG:4326");
        ContentFeatureCollection features = this.dataStore.getFeatureSource(this.tname("road")).getFeatures((Filter)bbox);
        this.checkSingleResult((FeatureCollection)features, "r2");
    }

    @Test
    public void testCrossesFilter() throws Exception {
        FilterFactory ff = CommonFactoryFinder.getFilterFactory(null);
        GeometryFactory gf = new GeometryFactory();
        PackedCoordinateSequenceFactory sf = new PackedCoordinateSequenceFactory();
        LineString ls = gf.createLineString(sf.create(new double[]{2.0, 3.0, 4.0, 3.0}, 2));
        Crosses cs = ff.crosses((Expression)ff.property(this.aname("geom")), (Expression)ff.literal((Object)ls));
        ContentFeatureCollection features = this.dataStore.getFeatureSource(this.tname("road")).getFeatures((Filter)cs);
        this.checkSingleResult((FeatureCollection)features, "r2");
    }

    @Test
    public void testIntersectsFilter() throws Exception {
        FilterFactory ff = CommonFactoryFinder.getFilterFactory(null);
        GeometryFactory gf = new GeometryFactory();
        PackedCoordinateSequenceFactory sf = new PackedCoordinateSequenceFactory();
        LineString ls = gf.createLineString(sf.create(new double[]{2.0, 1.0, 2.0, 3.0}, 2));
        Intersects is = ff.intersects((Expression)ff.property(this.aname("geom")), (Expression)ff.literal((Object)ls));
        ContentFeatureCollection features = this.dataStore.getFeatureSource(this.tname("road")).getFeatures((Filter)is);
        this.checkSingleResult((FeatureCollection)features, "r1");
    }

    @Test
    public void testIntersectsRingFilter() throws Exception {
        FilterFactory ff = CommonFactoryFinder.getFilterFactory(null);
        GeometryFactory gf = new GeometryFactory();
        PackedCoordinateSequenceFactory sf = new PackedCoordinateSequenceFactory();
        LinearRing ls = gf.createLinearRing(sf.create(new double[]{2.0, 1.0, 2.0, 3.0, 0.0, 3.0, 2.0, 1.0}, 2));
        Intersects is = ff.intersects((Expression)ff.property(this.aname("geom")), (Expression)ff.literal((Object)ls));
        ContentFeatureCollection features = this.dataStore.getFeatureSource(this.tname("road")).getFeatures((Filter)is);
        this.checkSingleResult((FeatureCollection)features, "r1");
    }

    @Test
    public void testTouchesFilter() throws Exception {
        FilterFactory ff = CommonFactoryFinder.getFilterFactory(null);
        GeometryFactory gf = new GeometryFactory();
        PackedCoordinateSequenceFactory sf = new PackedCoordinateSequenceFactory();
        LineString ls = gf.createLineString(sf.create(new double[]{1.0, 1.0, 1.0, 3.0}, 2));
        Touches is = ff.touches((Expression)ff.property(this.aname("geom")), (Expression)ff.literal((Object)ls));
        ContentFeatureCollection features = this.dataStore.getFeatureSource(this.tname("road")).getFeatures((Filter)is);
        this.checkSingleResult((FeatureCollection)features, "r1");
    }

    @Test
    public void testContainsFilter() throws Exception {
        FilterFactory ff = CommonFactoryFinder.getFilterFactory(null);
        GeometryFactory gf = new GeometryFactory();
        PackedCoordinateSequenceFactory sf = new PackedCoordinateSequenceFactory();
        LinearRing shell = gf.createLinearRing(sf.create(new double[]{2.0, -1.0, 2.0, 5.0, 4.0, 5.0, 4.0, -1.0, 2.0, -1.0}, 2));
        Polygon polygon = gf.createPolygon(shell, null);
        Contains cs = ff.contains((Expression)ff.literal((Object)polygon), (Expression)ff.property(this.aname("geom")));
        ContentFeatureCollection features = this.dataStore.getFeatureSource(this.tname("road")).getFeatures((Filter)cs);
        this.checkSingleResult((FeatureCollection)features, "r2");
    }

    @Test
    public void testWithinFilter() throws Exception {
        FilterFactory ff = CommonFactoryFinder.getFilterFactory(null);
        GeometryFactory gf = new GeometryFactory();
        PackedCoordinateSequenceFactory sf = new PackedCoordinateSequenceFactory();
        LinearRing shell = gf.createLinearRing(sf.create(new double[]{2.0, -1.0, 2.0, 5.0, 4.0, 5.0, 4.0, -1.0, 2.0, -1.0}, 2));
        Polygon polygon = gf.createPolygon(shell, null);
        Within wt = ff.within((Expression)ff.property(this.aname("geom")), (Expression)ff.literal((Object)polygon));
        ContentFeatureCollection features = this.dataStore.getFeatureSource(this.tname("road")).getFeatures((Filter)wt);
        this.checkSingleResult((FeatureCollection)features, "r2");
    }

    @Test
    public void testDisjointFilter() throws Exception {
        FilterFactory ff = CommonFactoryFinder.getFilterFactory(null);
        GeometryFactory gf = new GeometryFactory();
        PackedCoordinateSequenceFactory sf = new PackedCoordinateSequenceFactory();
        LinearRing shell = gf.createLinearRing(sf.create(new double[]{4.0, -1.0, 4.0, 5.0, 6.0, 5.0, 6.0, -1.0, 4.0, -1.0}, 2));
        Polygon polygon = gf.createPolygon(shell, null);
        Disjoint dj = ff.disjoint((Expression)ff.property(this.aname("geom")), (Expression)ff.literal((Object)polygon));
        ContentFeatureCollection features = this.dataStore.getFeatureSource(this.tname("road")).getFeatures((Filter)dj);
        this.checkSingleResult((FeatureCollection)features, "r2");
    }

    @Test
    public void testEqualsFilter() throws Exception {
        FilterFactory ff = CommonFactoryFinder.getFilterFactory(null);
        GeometryFactory gf = new GeometryFactory();
        Geometry g = gf.createGeometry((Geometry)this.td.roadFeatures[2].getDefaultGeometry());
        Equals cs = ff.equal((Expression)ff.literal((Object)g), (Expression)ff.property(this.aname("geom")));
        ContentFeatureCollection features = this.dataStore.getFeatureSource(this.tname("road")).getFeatures((Filter)cs);
        this.checkSingleResult((FeatureCollection)features, "r3");
    }

    protected void checkSingleResult(FeatureCollection features, String name) {
        Assert.assertEquals((long)1L, (long)features.size());
        try (FeatureIterator fr = features.features();){
            Assert.assertTrue((boolean)fr.hasNext());
            SimpleFeature f = (SimpleFeature)fr.next();
            Assert.assertNotNull((Object)f);
            Assert.assertEquals((Object)name, (Object)f.getAttribute(this.aname("name")));
            Assert.assertFalse((boolean)fr.hasNext());
        }
    }

    @Test
    public void testGeometryCollection() throws Exception {
        PrecisionModel precisionModel = new PrecisionModel();
        int SRID = 4326;
        GeometryFactory gf = new GeometryFactory(precisionModel, SRID);
        Coordinate[] points = new Coordinate[]{new Coordinate(30.0, 40.0), new Coordinate(50.0, 60.0)};
        LineString[] geometries = new LineString[2];
        geometries[0] = gf.createLineString(points);
        Coordinate[] points2 = new Coordinate[]{new Coordinate(40.0, 30.0), new Coordinate(70.0, 40.0)};
        geometries[1] = gf.createLineString(points2);
        GeometryFactory factory = new GeometryFactory();
        GeometryCollection geometry = new GeometryCollection((Geometry[])geometries, factory);
        FilterFactory ff = CommonFactoryFinder.getFilterFactory(null);
        PropertyName p = ff.property(this.aname("geom"));
        Literal collect = ff.literal((Object)geometry);
        DWithin dwithinGeomCo = ff.dwithin((Expression)p, (Expression)collect, 5.0, "meter");
        Query dq = new Query(this.tname("road"), (Filter)dwithinGeomCo);
        ContentFeatureCollection features = this.dataStore.getFeatureSource(this.tname("road")).getFeatures(dq);
        Assert.assertEquals((long)0L, (long)features.size());
    }
}

