/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.jdbc;

import java.util.HashSet;
import java.util.UUID;
import org.geotools.api.data.FeatureReader;
import org.geotools.api.data.FeatureWriter;
import org.geotools.api.data.Query;
import org.geotools.api.data.SimpleFeatureStore;
import org.geotools.api.data.Transaction;
import org.geotools.api.feature.simple.SimpleFeature;
import org.geotools.api.feature.simple.SimpleFeatureType;
import org.geotools.api.filter.Filter;
import org.geotools.api.filter.FilterFactory;
import org.geotools.api.filter.PropertyIsEqualTo;
import org.geotools.api.filter.expression.Expression;
import org.geotools.data.DataUtilities;
import org.geotools.data.DefaultTransaction;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.geotools.jdbc.JDBCTestSupport;
import org.geotools.jdbc.JDBCUuidTestSetup;
import org.geotools.util.factory.Hints;
import org.junit.Assert;
import org.junit.Test;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.Point;

public abstract class JDBCUuidOnlineTest
extends JDBCTestSupport {
    protected UUID uuid1 = UUID.fromString("c563f527-507e-4b80-a30b-4cab189d4dba");
    protected UUID uuid2 = UUID.fromString("cae47178-2e84-4319-a5ba-8d4089c9d80d");
    protected UUID uuid3 = UUID.fromString("34362328-9842-2385-8926-000000000003");

    @Override
    protected abstract JDBCUuidTestSetup createTestSetup();

    @Test
    public void testGetSchema() throws Exception {
        SimpleFeatureType ft = this.dataStore.getSchema(this.tname("guid"));
        Assert.assertEquals(UUID.class, (Object)ft.getDescriptor(this.aname("uuidProperty")).getType().getBinding());
    }

    @Test
    public void testGetFeatures() throws Exception {
        try (FeatureReader r = this.dataStore.getFeatureReader(new Query(this.tname("guid")), Transaction.AUTO_COMMIT);){
            r.hasNext();
            HashSet<UUID> uuids = new HashSet<UUID>();
            uuids.add(this.uuid1);
            uuids.add(this.uuid2);
            while (r.hasNext()) {
                SimpleFeature f = (SimpleFeature)r.next();
                Assert.assertNotNull((Object)uuids.remove(f.getAttribute(this.aname("uuidProperty"))));
            }
            Assert.assertTrue((boolean)uuids.isEmpty());
        }
    }

    @Test
    public void testInsertFeatures() throws Exception {
        try (DefaultTransaction transaction = new DefaultTransaction();){
            SimpleFeatureStore featureStore = (SimpleFeatureStore)this.dataStore.getFeatureSource(this.tname("guid"));
            featureStore.setTransaction((Transaction)transaction);
            Assert.assertEquals((long)featureStore.getCount(Query.ALL), (long)2L);
            SimpleFeatureType type = this.dataStore.getSchema(this.tname("guid"));
            SimpleFeature feature = SimpleFeatureBuilder.build((SimpleFeatureType)type, (Object[])new Object[]{this.uuid3}, (String)"guid.3");
            SimpleFeatureCollection collection = DataUtilities.collection((SimpleFeature)feature);
            featureStore.addFeatures((FeatureCollection)collection);
            transaction.commit();
            Assert.assertEquals((long)featureStore.getCount(Query.ALL), (long)3L);
        }
    }

    @Test
    public void testModifyFeatures() throws Exception {
        try (FeatureWriter w = this.dataStore.getFeatureWriter(this.tname("guid"), Transaction.AUTO_COMMIT);){
            w.hasNext();
            SimpleFeature f = (SimpleFeature)w.next();
            f.setAttribute(this.aname("uuidProperty"), (Object)this.uuid2);
            Assert.assertEquals((Object)this.uuid2, (Object)f.getAttribute(this.aname("uuidProperty")));
            w.write();
        }
    }

    @Test
    public void testRemoveFeatures() throws Exception {
        SimpleFeatureStore featureStore = (SimpleFeatureStore)this.dataStore.getFeatureSource(this.tname("guid"));
        FilterFactory ff = CommonFactoryFinder.getFilterFactory();
        PropertyIsEqualTo filter = ff.equals((Expression)ff.property(this.aname("uuidProperty")), (Expression)ff.literal((Object)this.uuid1));
        featureStore.removeFeatures((Filter)filter);
        Assert.assertEquals((long)1L, (long)featureStore.getCount(Query.ALL));
    }

    @Test
    public void testUUIDAsPrimaryKey() throws Exception {
        try (DefaultTransaction transaction = new DefaultTransaction();){
            SimpleFeatureStore featureStore = (SimpleFeatureStore)this.dataStore.getFeatureSource(this.tname("uuidt"));
            featureStore.setTransaction((Transaction)transaction);
            featureStore.addFeatures((FeatureCollection)this.createFeatureCollection());
            transaction.commit();
            Assert.assertEquals((long)3L, (long)featureStore.getCount(Query.ALL));
        }
    }

    private SimpleFeatureCollection createFeatureCollection() throws Exception {
        SimpleFeatureType type = this.dataStore.getSchema(this.tname("uuidt"));
        GeometryFactory gf = new GeometryFactory();
        Point p = gf.createPoint(new Coordinate(138.6, -34.93));
        SimpleFeature feature1 = SimpleFeatureBuilder.build((SimpleFeatureType)type, (Object[])new Object[]{p}, (String)this.uuid1.toString());
        feature1.getUserData().put(Hints.USE_PROVIDED_FID, true);
        feature1.getUserData().put(Hints.PROVIDED_FID, this.uuid1);
        SimpleFeature feature2 = SimpleFeatureBuilder.build((SimpleFeatureType)type, (Object[])new Object[]{p}, (String)this.uuid2.toString());
        feature2.getUserData().put(Hints.USE_PROVIDED_FID, true);
        feature2.getUserData().put(Hints.PROVIDED_FID, this.uuid2);
        SimpleFeature feature3 = SimpleFeatureBuilder.build((SimpleFeatureType)type, (Object[])new Object[]{p}, (String)this.uuid3.toString());
        feature3.getUserData().put(Hints.USE_PROVIDED_FID, true);
        feature3.getUserData().put(Hints.PROVIDED_FID, this.uuid3);
        return DataUtilities.collection((SimpleFeature[])new SimpleFeature[]{feature1, feature2, feature3});
    }
}

