/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.jdbc;

import org.geotools.api.data.FeatureStore;
import org.geotools.api.data.Transaction;
import org.geotools.api.feature.simple.SimpleFeatureType;
import org.geotools.api.feature.type.AttributeDescriptor;
import org.geotools.api.filter.FilterFactory;
import org.geotools.api.referencing.crs.CoordinateReferenceSystem;
import org.geotools.data.simple.SimpleFeatureIterator;
import org.geotools.data.store.ContentFeatureCollection;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.feature.AttributeTypeBuilder;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.jdbc.JDBCTestSupport;
import org.geotools.jdbc.JDBCViewTestSetup;
import org.junit.Assert;
import org.junit.Test;
import org.locationtech.jts.geom.Polygon;

public abstract class JDBCViewOnlineTest
extends JDBCTestSupport {
    protected static final String LAKESVIEW = "lakesview";
    protected static final String LAKESVIEWPK = "lakesviewpk";
    protected static final String FID = "fid";
    protected static final String ID = "id";
    protected static final String NAME = "name";
    protected static final String GEOM = "geom";
    protected FilterFactory ff = CommonFactoryFinder.getFilterFactory(null);
    protected SimpleFeatureType lakeViewSchema;
    protected SimpleFeatureType lakeViewPkSchema;

    @Override
    protected abstract JDBCViewTestSetup createTestSetup();

    @Override
    protected void connect() throws Exception {
        super.connect();
        AttributeTypeBuilder atb = new AttributeTypeBuilder();
        atb.setMinOccurs(this.isPkNillable() ? 0 : 1);
        atb.setMaxOccurs(1);
        atb.setNillable(this.isPkNillable());
        atb.setName(FID);
        atb.setBinding(Integer.class);
        AttributeDescriptor fidDescriptor = atb.buildDescriptor(FID);
        SimpleFeatureTypeBuilder tb = new SimpleFeatureTypeBuilder();
        tb.setNamespaceURI(this.dataStore.getNamespaceURI());
        tb.setName(LAKESVIEW);
        tb.add(fidDescriptor);
        tb.add(ID, Integer.class);
        tb.add(GEOM, Polygon.class, (CoordinateReferenceSystem)null);
        tb.add(NAME, String.class);
        this.lakeViewSchema = tb.buildFeatureType();
        this.lakeViewPkSchema = SimpleFeatureTypeBuilder.retype((SimpleFeatureType)this.lakeViewSchema, (String[])new String[]{ID, GEOM, NAME});
    }

    protected boolean isPkNillable() {
        return true;
    }

    protected boolean supportsPkOnViews() {
        return false;
    }

    @Test
    public void testSchema() throws Exception {
        SimpleFeatureType ft = this.dataStore.getSchema(this.tname(LAKESVIEW));
        this.assertFeatureTypesEqual(this.lakeViewSchema, ft);
    }

    @Test
    public void testSchemaPk() throws Exception {
        if (!this.supportsPkOnViews()) {
            return;
        }
        SimpleFeatureType ft = this.dataStore.getSchema(this.tname(LAKESVIEWPK));
        this.assertFeatureTypesEqual(this.lakeViewPkSchema, ft);
    }

    @Test
    public void testReadFeatures() throws Exception {
        ContentFeatureCollection fc = this.dataStore.getFeatureSource(this.tname(LAKESVIEW)).getFeatures();
        Assert.assertEquals((long)1L, (long)fc.size());
        try (SimpleFeatureIterator fr = fc.features();){
            Assert.assertTrue((boolean)fr.hasNext());
            fr.next();
            Assert.assertFalse((boolean)fr.hasNext());
        }
    }

    @Test
    public void testGetBounds() throws Exception {
        ReferencedEnvelope reference = this.dataStore.getFeatureSource(this.tname(LAKESVIEW)).getBounds();
        Assert.assertEquals((double)12.0, (double)reference.getMinX(), (double)0.0);
        Assert.assertEquals((double)16.0, (double)reference.getMaxX(), (double)0.0);
        Assert.assertEquals((double)4.0, (double)reference.getMinY(), (double)0.0);
        Assert.assertEquals((double)8.0, (double)reference.getMaxY(), (double)0.0);
    }

    @Test
    public void testReadOnly() throws Exception {
        try {
            this.dataStore.getFeatureWriter(this.tname(LAKESVIEW), Transaction.AUTO_COMMIT);
            Assert.fail((String)"Should not be able to pick a writer without a pk");
        }
        catch (Exception exception) {
            // empty catch block
        }
        Assert.assertFalse((boolean)(this.dataStore.getFeatureSource(this.tname(LAKESVIEW)) instanceof FeatureStore));
    }
}

