/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.jdbc;

import java.awt.RenderingHints;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import org.geotools.api.data.FeatureStore;
import org.geotools.api.data.Join;
import org.geotools.api.data.Query;
import org.geotools.api.feature.simple.SimpleFeature;
import org.geotools.api.feature.simple.SimpleFeatureType;
import org.geotools.api.feature.type.AttributeDescriptor;
import org.geotools.api.feature.type.GeometryDescriptor;
import org.geotools.api.filter.Filter;
import org.geotools.api.filter.FilterFactory;
import org.geotools.api.filter.Id;
import org.geotools.api.filter.expression.Expression;
import org.geotools.api.filter.sort.SortBy;
import org.geotools.api.filter.sort.SortOrder;
import org.geotools.data.simple.SimpleFeatureIterator;
import org.geotools.data.store.ContentFeatureSource;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.feature.FeatureIterator;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.jdbc.JDBCDataStoreAPITestSetup;
import org.geotools.jdbc.JDBCTestSupport;
import org.geotools.jdbc.PrimaryKey;
import org.geotools.jdbc.PrimaryKeyColumn;
import org.geotools.jdbc.RegexpValidator;
import org.geotools.jdbc.VirtualTable;
import org.geotools.jdbc.VirtualTableParameter;
import org.geotools.util.factory.Hints;
import org.geotools.util.logging.Logging;
import org.junit.Assert;
import org.junit.Test;
import org.locationtech.jts.geom.LineString;

public abstract class JDBCVirtualTableOnlineTest
extends JDBCTestSupport {
    protected String dbSchemaName = null;

    @Override
    protected abstract JDBCDataStoreAPITestSetup createTestSetup();

    @Override
    protected void connect() throws Exception {
        super.connect();
        StringBuffer sb = new StringBuffer();
        sb.append("select * from ");
        if (this.dbSchemaName != null) {
            this.dialect.encodeSchemaName(this.dbSchemaName, sb);
            sb.append(".");
        }
        this.dialect.encodeTableName(this.tname("river"), sb);
        VirtualTable vt = new VirtualTable("riverFull", sb.toString());
        this.dataStore.createVirtualTable(vt);
        sb.append(" where 1 = 1 :where_clause:");
        vt = new VirtualTable("riverFullPlaceHolder", sb.toString());
        this.dataStore.createVirtualTable(vt);
        sb = new StringBuffer();
        sb.append("select ");
        this.dialect.encodeColumnName(null, this.aname("id"), sb);
        sb.append(", ");
        this.dialect.encodeColumnName(null, this.aname("geom"), sb);
        sb.append(", ");
        this.dialect.encodeColumnName(null, this.aname("river"), sb);
        sb.append(", ");
        this.dialect.encodeColumnName(null, this.aname("flow"), sb);
        sb.append(" * 2 as ");
        this.dialect.encodeColumnName(null, this.aname("doubleFlow"), sb);
        sb.append(" from ");
        if (this.dbSchemaName != null) {
            this.dialect.encodeSchemaName(this.dbSchemaName, sb);
            sb.append(".");
        }
        this.dialect.encodeTableName(this.tname("river"), sb);
        sb.append(" where ");
        this.dialect.encodeColumnName(null, this.aname("flow"), sb);
        sb.append(" > 4");
        vt = new VirtualTable("riverReduced", sb.toString());
        vt.addGeometryMetadatata(this.aname("geom"), LineString.class, 4326);
        this.dataStore.createVirtualTable(vt);
        sb.append("\n--This is a comment");
        vt = new VirtualTable("riverReducedComment", sb.toString());
        vt.addGeometryMetadatata(this.aname("geom"), LineString.class, 4326);
        this.dataStore.createVirtualTable(vt);
        vt = new VirtualTable("riverReducedPk", sb.toString());
        vt.addGeometryMetadatata(this.aname("geom"), LineString.class, 4326);
        vt.setPrimaryKeyColumns(Arrays.asList(this.aname("id")));
        this.dataStore.createVirtualTable(vt);
        sb = new StringBuffer();
        sb.append("select ");
        this.dialect.encodeColumnName(null, this.aname("id"), sb);
        sb.append(", ");
        this.dialect.encodeColumnName(null, this.aname("geom"), sb);
        sb.append(", ");
        this.dialect.encodeColumnName(null, "flow", sb);
        sb.append(" * %mul% as ");
        this.dialect.encodeColumnName(null, "mulflow", sb);
        sb.append(" from ");
        if (this.dbSchemaName != null) {
            this.dialect.encodeSchemaName(this.dbSchemaName, sb);
            sb.append(".");
        }
        this.dialect.encodeTableName(this.tname("river"), sb);
        sb.append(" %where%");
        vt = new VirtualTable("riverParam", sb.toString());
        vt.addGeometryMetadatata(this.aname("geom"), LineString.class, 4326);
        vt.addParameter(new VirtualTableParameter("mul", "1", (VirtualTableParameter.Validator)new RegexpValidator("[\\d\\.e\\+-]+")));
        vt.addParameter(new VirtualTableParameter("where", ""));
        this.dataStore.createVirtualTable(vt);
    }

    @Test
    public void testGuessGeometry() throws Exception {
        SimpleFeatureType type = this.dataStore.getSchema("riverFull");
        Assert.assertNotNull((Object)type);
        Assert.assertNotNull((Object)type.getGeometryDescriptor());
        type = this.dataStore.getSchema("riverFullPlaceHolder");
        Assert.assertNotNull((Object)type);
        Assert.assertNotNull((Object)type.getGeometryDescriptor());
    }

    @Test
    public void testRiverReducedSchema() throws Exception {
        SimpleFeatureType type = this.dataStore.getSchema("riverReduced");
        Assert.assertNotNull((Object)type);
        this.checkRiverReduced(type);
    }

    @Test
    public void testRiverReducedCommentSchema() throws Exception {
        SimpleFeatureType type = this.dataStore.getSchema("riverReducedComment");
        Assert.assertNotNull((Object)type);
        this.checkRiverReduced(type);
    }

    private void checkRiverReduced(SimpleFeatureType type) {
        Assert.assertEquals((long)4L, (long)type.getAttributeCount());
        AttributeDescriptor id = type.getDescriptor(this.aname("id"));
        Assert.assertTrue((boolean)Number.class.isAssignableFrom(id.getType().getBinding()));
        GeometryDescriptor geom = type.getGeometryDescriptor();
        Assert.assertEquals((Object)this.aname("geom"), (Object)geom.getLocalName());
        AttributeDescriptor river = type.getDescriptor(this.aname("river"));
        Assert.assertEquals(String.class, (Object)river.getType().getBinding());
        AttributeDescriptor doubleFlow = type.getDescriptor(this.aname("doubleFlow"));
        Assert.assertTrue((boolean)Number.class.isAssignableFrom(doubleFlow.getType().getBinding()));
        Assert.assertEquals((Object)4326, type.getGeometryDescriptor().getUserData().get("nativeSRID"));
        Assert.assertEquals((Object)2, type.getGeometryDescriptor().getUserData().get(Hints.COORDINATE_DIMENSION));
    }

    @Test
    public void testListAll() throws Exception {
        ContentFeatureSource fsView = this.dataStore.getFeatureSource("riverReduced");
        Assert.assertFalse((boolean)(fsView instanceof FeatureStore));
        Assert.assertEquals((long)1L, (long)fsView.getCount(Query.ALL));
        try (SimpleFeatureIterator it = fsView.getFeatures().features();){
            Assert.assertTrue((boolean)it.hasNext());
            SimpleFeature sf = (SimpleFeature)it.next();
            Assert.assertEquals((Object)"rv1", (Object)sf.getAttribute(this.aname("river")));
            Assert.assertEquals((double)9.0, (double)((Number)sf.getAttribute(this.aname("doubleFlow"))).doubleValue(), (double)0.1);
            Assert.assertFalse((boolean)it.hasNext());
        }
    }

    @Test
    public void testBounds() throws Exception {
        ContentFeatureSource fsView = this.dataStore.getFeatureSource("riverReduced");
        ReferencedEnvelope env = fsView.getBounds();
        Assert.assertNotNull((Object)env);
        fsView = this.dataStore.getFeatureSource("riverFullPlaceHolder");
        env = fsView.getBounds();
        Assert.assertNotNull((Object)env);
    }

    @Test
    public void testInvalidQuery() throws Exception {
        String sql = ((VirtualTable)this.dataStore.getVirtualTables().get("riverReduced")).getSql();
        VirtualTable vt = new VirtualTable("riverPolluted", "SOME EXTRA GARBAGE " + sql);
        vt.addGeometryMetadatata("geom", LineString.class, -1);
        try {
            this.dataStore.createVirtualTable(vt);
            Assert.fail((String)"Should have failed with invalid sql definition");
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Test
    public void testGetFeatureId() throws Exception {
        ContentFeatureSource fsView = this.dataStore.getFeatureSource("riverReducedPk");
        Assert.assertFalse((boolean)(fsView instanceof FeatureStore));
        Assert.assertEquals((long)1L, (long)fsView.getCount(Query.ALL));
        try (SimpleFeatureIterator it = fsView.getFeatures().features();){
            Assert.assertTrue((boolean)it.hasNext());
            SimpleFeature sf = (SimpleFeature)it.next();
            Assert.assertEquals((Object)"riverReducedPk.0", (Object)sf.getID());
        }
    }

    @Test
    public void testGetFeatureById() throws Exception {
        ContentFeatureSource fsView = this.dataStore.getFeatureSource("riverReducedPk");
        Assert.assertFalse((boolean)(fsView instanceof FeatureStore));
        PrimaryKey pk = this.dataStore.getPrimaryKey((SimpleFeatureType)fsView.getSchema());
        Assert.assertEquals((Object)"riverReducedPk", (Object)pk.getTableName());
        Assert.assertEquals((long)1L, (long)pk.getColumns().size());
        PrimaryKeyColumn col = (PrimaryKeyColumn)pk.getColumns().get(0);
        Assert.assertEquals((Object)this.aname("id"), (Object)col.getName());
        Assert.assertTrue((boolean)Number.class.isAssignableFrom(col.getType()));
        FilterFactory ff = CommonFactoryFinder.getFilterFactory(null);
        Id filter = ff.id(Collections.singleton(ff.featureId("riverReducedPk.0")));
        Assert.assertEquals((long)1L, (long)fsView.getCount(new Query(null, (Filter)filter)));
    }

    @Test
    public void testWhereParam() throws Exception {
        ContentFeatureSource fsView = this.dataStore.getFeatureSource("riverParam");
        Assert.assertEquals((long)2L, (long)fsView.getCount(Query.ALL));
        Query q = new Query(Query.ALL);
        StringBuffer sb = new StringBuffer();
        sb.append(" where ");
        this.dialect.encodeColumnName(null, this.aname("flow"), sb);
        sb.append(" > 4");
        q.setHints(new Hints((RenderingHints.Key)Hints.VIRTUAL_TABLE_PARAMETERS, Collections.singletonMap("where", sb.toString())));
        Assert.assertEquals((long)1L, (long)fsView.getCount(q));
    }

    @Test
    public void testMulParamValid() throws Exception {
        FilterFactory ff = CommonFactoryFinder.getFilterFactory(null);
        ContentFeatureSource fsView = this.dataStore.getFeatureSource("riverParam");
        Query q = new Query(Query.ALL);
        q.setHints(new Hints((RenderingHints.Key)Hints.VIRTUAL_TABLE_PARAMETERS, Collections.singletonMap("mul", "10")));
        q.setSortBy(new SortBy[]{ff.sort(this.aname("mulflow"), SortOrder.ASCENDING)});
        try (FeatureIterator fi = fsView.getFeatures(q).features();){
            Assert.assertTrue((boolean)fi.hasNext());
            SimpleFeature f = (SimpleFeature)fi.next();
            Assert.assertEquals((double)30.0, (double)((Number)f.getAttribute(this.aname("mulflow"))).doubleValue(), (double)0.1);
            Assert.assertTrue((boolean)fi.hasNext());
            f = (SimpleFeature)fi.next();
            Assert.assertEquals((double)45.0, (double)((Number)f.getAttribute(this.aname("mulflow"))).doubleValue(), (double)0.1);
        }
    }

    @Test
    public void testMulParamInvalid() throws Exception {
        ContentFeatureSource fsView = this.dataStore.getFeatureSource("riverParam");
        Query q = new Query(Query.ALL);
        q.setHints(new Hints((RenderingHints.Key)Hints.VIRTUAL_TABLE_PARAMETERS, Collections.singletonMap("mul", "abc")));
        try {
            fsView.getFeatures(q).features();
            Assert.fail((String)"Should have thrown an exception!");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testInvalidView() throws Exception {
        StringBuffer sb = new StringBuffer();
        sb.append("select ");
        this.dialect.encodeColumnName(null, this.aname("id"), sb);
        sb.append(", ");
        this.dialect.encodeColumnName(null, this.aname("flow"), sb);
        sb.append(" from ");
        if (this.dbSchemaName != null) {
            this.dialect.encodeSchemaName(this.dbSchemaName, sb);
            sb.append(".");
        }
        this.dialect.encodeTableName(this.tname("river"), sb);
        VirtualTable vt = new VirtualTable("invalid_attribute", sb.toString());
        Handler handler = new Handler(){

            @Override
            public synchronized void publish(LogRecord record) {
                if (!record.getMessage().contains("Failed to execute statement")) {
                    Assert.fail((String)"We should not have received any log statement");
                }
            }

            @Override
            public void flush() {
            }

            @Override
            public void close() throws SecurityException {
            }
        };
        handler.setLevel(Level.WARNING);
        Logger logger = Logging.getLogger(JDBCVirtualTableOnlineTest.class);
        Level oldLevel = logger.getLevel();
        logger.setLevel(Level.SEVERE);
        logger.addHandler(handler);
        this.dataStore.createVirtualTable(vt);
        ContentFeatureSource fs = this.dataStore.getFeatureSource("invalid_attribute");
        sb.setLength(0);
        this.dialect.encodeColumnName(null, this.aname("not_valid"), sb);
        String notValid = sb.toString();
        sb.setLength(0);
        this.dialect.encodeColumnName(null, this.aname("flow"), sb);
        String flow = sb.toString();
        ((VirtualTable)this.dataStore.virtualTables.get((Object)"invalid_attribute")).sql = vt.sql.replace(flow, notValid);
        try (SimpleFeatureIterator fi = fs.getFeatures().features();){
            Assert.fail((String)"We should not have gotten here, we were supposed to get a sql exception");
        }
        catch (RuntimeException e) {
            Assert.assertTrue((boolean)(e.getCause() instanceof IOException));
        }
        finally {
            this.dataStore.dropVirtualTable("invalid_attribute");
            System.gc();
            System.runFinalization();
            logger.setLevel(oldLevel);
            logger.removeHandler(handler);
        }
    }

    @Test
    public void testJoinViews() throws Exception {
        Query joinQuery = new Query("riverFull");
        FilterFactory ff = this.dataStore.getFilterFactory();
        Join join = new Join("riverReduced", (Filter)ff.equal((Expression)ff.property("a." + this.aname("river")), (Expression)ff.property(this.aname("river")), false));
        join.setAlias("a");
        joinQuery.getJoins().add(join);
        ContentFeatureSource fsFull = this.dataStore.getFeatureSource("riverFull");
        ContentFeatureSource fsReduced = this.dataStore.getFeatureSource("riverReduced");
        int expectedCount = fsReduced.getCount(Query.ALL);
        int count = fsFull.getCount(joinQuery);
        Assert.assertEquals((long)expectedCount, (long)count);
    }

    @Test
    public void testJoinViewsWithPlaceHolder() {
        Query joinQuery = new Query("riverFullPlaceHolder");
        FilterFactory ff = this.dataStore.getFilterFactory();
        Join join = new Join("riverFullPlaceHolder", (Filter)ff.equal((Expression)ff.property("a." + this.aname("river")), (Expression)ff.property(this.aname("river")), false));
        join.setAlias("a");
        joinQuery.getJoins().add(join);
        try {
            this.dataStore.getFeatureSource("riverFullPlaceHolder").getCount(joinQuery);
        }
        catch (Exception exception) {
            Assert.assertTrue((boolean)exception.getMessage().contains("Joins between virtual tables that provide a :where_placeholder: are not supported"));
            return;
        }
        Assert.fail((String)"count query should have fail with an exception");
    }

    @Test
    public void testPaginationWithPlaceHolder() throws Exception {
        Query query = new Query("riverFullPlaceHolder");
        query.setStartIndex(Integer.valueOf(1));
        query.setMaxFeatures(2);
        int count = this.dataStore.getFeatureSource("riverFullPlaceHolder").getCount(query);
        Assert.assertEquals((long)1L, (long)count);
    }
}

