/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.jdbc;

import com.mockrunner.mock.jdbc.MockConnection;
import com.mockrunner.mock.jdbc.MockStatement;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import org.geotools.filter.function.EnvFunction;
import org.geotools.jdbc.JDBCDataStore;
import org.geotools.jdbc.SessionCommandsListener;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;

public class SessionCommandListenerTest {
    RecordingConnection conn = new RecordingConnection();
    JDBCDataStore store = new JDBCDataStore();

    @Test
    public void testPlain() throws Exception {
        SessionCommandsListener listener = new SessionCommandsListener("A", "B");
        listener.onBorrow(this.store, (Connection)((Object)this.conn));
        Assert.assertEquals((long)1L, (long)this.conn.commands.size());
        Assert.assertEquals((Object)"A", (Object)this.conn.commands.get(0));
        this.conn.commands.clear();
        listener.onRelease(this.store, (Connection)((Object)this.conn));
        Assert.assertEquals((long)1L, (long)this.conn.commands.size());
        Assert.assertEquals((Object)"B", (Object)this.conn.commands.get(0));
    }

    @Test
    public void testOnlyBorrow() throws Exception {
        SessionCommandsListener listener = new SessionCommandsListener("A", null);
        listener.onBorrow(this.store, (Connection)((Object)this.conn));
        Assert.assertEquals((long)1L, (long)this.conn.commands.size());
        Assert.assertEquals((Object)"A", (Object)this.conn.commands.get(0));
        this.conn.commands.clear();
        listener.onRelease(this.store, (Connection)((Object)this.conn));
        Assert.assertEquals((long)0L, (long)this.conn.commands.size());
    }

    @Test
    public void testOnlyRelease() throws Exception {
        SessionCommandsListener listener = new SessionCommandsListener(null, "B");
        listener.onBorrow(this.store, (Connection)((Object)this.conn));
        Assert.assertEquals((long)0L, (long)this.conn.commands.size());
        listener.onRelease(this.store, (Connection)((Object)this.conn));
        Assert.assertEquals((long)1L, (long)this.conn.commands.size());
        Assert.assertEquals((Object)"B", (Object)this.conn.commands.get(0));
    }

    @Test
    public void testTwoExpandVariablesAreReplaced() throws Exception {
        SessionCommandsListener listener = new SessionCommandsListener("call startSession('select ${user}, ${version} from 1')", null);
        EnvFunction.setLocalValue((String)"user", (Object)"user1");
        EnvFunction.setLocalValue((String)"version", (Object)"x.x");
        listener.onBorrow(this.store, (Connection)((Object)this.conn));
        Assert.assertEquals((long)1L, (long)this.conn.commands.size());
        Assert.assertEquals((Object)"call startSession('select user1, x.x from 1')", (Object)this.conn.commands.get(0));
    }

    @Test
    public void testValidSqlWhenNoVariable() throws Exception {
        SessionCommandsListener listener = new SessionCommandsListener("select true from 1", null);
        listener.onBorrow(this.store, (Connection)((Object)this.conn));
        Assert.assertEquals((long)1L, (long)this.conn.commands.size());
        Assert.assertEquals((Object)"select true from 1", (Object)this.conn.commands.get(0));
    }

    @Test
    public void testValidSqlUsingCurlyBracketsOutOfAVariableDefinition() throws Exception {
        SessionCommandsListener listener = new SessionCommandsListener("select set_config('my.userString', substring('${GSUSER}', 'user#\"[0-9]{5}#\"%', '#'), false) ", null);
        EnvFunction.setLocalValue((String)"GSUSER", (Object)"user11111");
        listener.onBorrow(this.store, (Connection)((Object)this.conn));
        Assert.assertEquals((long)1L, (long)this.conn.commands.size());
        Assert.assertEquals((Object)"select set_config('my.userString', substring('user11111', 'user#\"[0-9]{5}#\"%', '#'), false) ", (Object)this.conn.commands.get(0));
    }

    @Test
    public void testOneExpandVariablesIsReplaced() throws Exception {
        SessionCommandsListener listener = new SessionCommandsListener("call startSession('${user}')", null);
        EnvFunction.setLocalValue((String)"user", (Object)"abcde");
        listener.onBorrow(this.store, (Connection)((Object)this.conn));
        Assert.assertEquals((long)1L, (long)this.conn.commands.size());
        Assert.assertEquals((Object)"call startSession('abcde')", (Object)this.conn.commands.get(0));
    }

    @Test
    public void testReleaseConnectionsScript() throws Exception {
        SessionCommandsListener listener = new SessionCommandsListener(null, "call endSession('${user,joe}')");
        listener.onRelease(this.store, (Connection)((Object)this.conn));
        Assert.assertEquals((long)1L, (long)this.conn.commands.size());
        Assert.assertEquals((Object)"call endSession('joe')", (Object)this.conn.commands.get(0));
    }

    @Test
    public void testInvalidVariableDefinitionMissingClosingBracket() throws Exception {
        Assert.assertThrows(IllegalArgumentException.class, () -> new SessionCommandsListener("select ${user from 1)", null));
    }

    @After
    public void clearResources() {
        EnvFunction.clearLocalValues();
        this.conn.commands.clear();
    }

    static class RecordingConnection
    extends MockConnection {
        List<String> commands = new ArrayList<String>();

        RecordingConnection() {
        }

        public Statement createStatement() throws SQLException {
            return new MockStatement((Connection)((Object)this)){

                public boolean execute(String sql) throws SQLException {
                    commands.add(sql);
                    return false;
                }
            };
        }
    }
}

