/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.jdbc.datasource;

import java.sql.Connection;
import java.sql.SQLException;
import org.apache.commons.dbcp.BasicDataSource;
import org.geotools.api.data.DataSourceException;
import org.geotools.data.jdbc.datasource.DBCPDataSource;
import org.geotools.data.jdbc.datasource.ManageableDataSource;

public class DataSourceUtil {
    private DataSourceUtil() {
    }

    public static ManageableDataSource buildDefaultDataSource(String url, String driverName, String username, String password, String validationQuery) throws DataSourceException {
        return DataSourceUtil.buildDefaultDataSource(url, driverName, username, password, 10, 1, validationQuery, false, 0);
    }

    public static ManageableDataSource buildDefaultDataSource(String url, String driverName, String username, String password, int maxActive, int minIdle, String validationQuery, boolean cachePreparedStatements, int removeAbandonedTimeout) throws DataSourceException {
        BasicDataSource dataSource = new BasicDataSource();
        dataSource.setDriverClassName(driverName);
        dataSource.setUrl(url);
        dataSource.setUsername(username);
        dataSource.setPassword(password);
        dataSource.setAccessToUnderlyingConnectionAllowed(true);
        dataSource.setMaxActive(maxActive);
        dataSource.setMinIdle(minIdle);
        dataSource.setMinEvictableIdleTimeMillis(20000L);
        dataSource.setTimeBetweenEvictionRunsMillis(10000L);
        if (validationQuery != null) {
            dataSource.setTestOnBorrow(true);
            dataSource.setValidationQuery(validationQuery);
        }
        if (cachePreparedStatements) {
            dataSource.setPoolPreparedStatements(true);
            dataSource.setMaxOpenPreparedStatements(10);
        }
        if (removeAbandonedTimeout > 0) {
            dataSource.setRemoveAbandoned(true);
            dataSource.setRemoveAbandonedTimeout(removeAbandonedTimeout);
            dataSource.setLogAbandoned(true);
        }
        Connection conn = null;
        try {
            conn = dataSource.getConnection();
        }
        catch (Exception e) {
            throw new DataSourceException("Connection test failed ", (Throwable)e);
        }
        finally {
            if (conn != null) {
                try {
                    conn.close();
                }
                catch (SQLException sQLException) {}
            }
        }
        return new DBCPDataSource(dataSource);
    }
}

