/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.coverageio.jp2k;

import it.geosolutions.imageio.plugins.jp2k.JP2KStreamMetadata;
import it.geosolutions.imageio.plugins.jp2k.box.ASOCBoxMetadataNode;
import it.geosolutions.imageio.plugins.jp2k.box.LabelBoxMetadataNode;
import it.geosolutions.imageio.plugins.jp2k.box.UUIDBoxMetadataNode;
import it.geosolutions.imageio.plugins.jp2k.box.XMLBoxMetadataNode;
import it.geosolutions.imageioimpl.plugins.tiff.TIFFImageReader;
import it.geosolutions.imageioimpl.plugins.tiff.TIFFImageReaderSpi;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.util.Collection;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.metadata.IIOMetadataNode;
import javax.imageio.spi.ImageReaderSpi;
import javax.imageio.stream.ImageInputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.coverage.grid.GridCoverageFactory;
import org.geotools.coverage.grid.GridEnvelope2D;
import org.geotools.coverage.grid.io.AbstractGridCoverage2DReader;
import org.geotools.coverage.grid.io.GridCoverage2DReader;
import org.geotools.coverage.grid.io.imageio.geotiff.GeoTiffIIOMetadataDecoder;
import org.geotools.coverage.grid.io.imageio.geotiff.GeoTiffMetadata2CRSAdapter;
import org.geotools.coverage.util.CoverageUtilities;
import org.geotools.coverageio.jp2k.JP2KFormat;
import org.geotools.coverageio.jp2k.RasterManager;
import org.geotools.coverageio.jp2k.Utils;
import org.geotools.data.DataSourceException;
import org.geotools.data.PrjFileReader;
import org.geotools.data.WorldFileReader;
import org.geotools.geometry.GeneralEnvelope;
import org.geotools.geometry.PixelTranslation;
import org.geotools.referencing.CRS;
import org.geotools.referencing.operation.transform.AffineTransform2D;
import org.geotools.referencing.operation.transform.ProjectiveTransform;
import org.geotools.util.URLs;
import org.geotools.util.factory.Hints;
import org.geotools.util.logging.Logging;
import org.opengis.coverage.grid.Format;
import org.opengis.geometry.Envelope;
import org.opengis.parameter.GeneralParameterValue;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.datum.PixelInCell;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.TransformException;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public final class JP2KReader
extends AbstractGridCoverage2DReader
implements GridCoverage2DReader {
    private static final Logger LOGGER = Logging.getLogger(JP2KReader.class);
    private static final char SEPARATOR = File.separatorChar;
    private static final short[] GEOJP2_UUID = new short[]{177, 75, 248, 189, 8, 61, 75, 67, 165, 174, 140, 215, 213, 166, 206, 3};
    private static final short[] MSIG_WORLDFILEBOX_UUID = new short[]{150, 169, 241, 241, 220, 152, 64, 45, 167, 174, 214, 142, 52, 69, 24, 9};
    private static final int WORLD_FILE_INTERPRETATION_PIXEL_CORNER = 1;
    private GridEnvelope2D nativeGridRange = null;
    private GeneralEnvelope nativeEnvelope = null;
    ImageReaderSpi cachedSPI;
    URL sourceURL;
    boolean expandMe;
    private RasterManager rasterManager;
    private String parentPath;

    public JP2KReader(Object input) throws IOException {
        this(input, null);
    }

    protected void setCoverageProperties(ImageReader reader) throws IOException {
        int hrWidth = reader.getWidth(0);
        int hrHeight = reader.getHeight(0);
        Rectangle actualDim = new Rectangle(0, 0, hrWidth, hrHeight);
        this.nativeGridRange = new GridEnvelope2D(actualDim);
        if (this.crs == null) {
            this.parsePRJFile();
        }
        if (this.nativeEnvelope == null) {
            this.parseWorldFile();
        }
        if (this.crs == null || this.nativeEnvelope == null) {
            IIOMetadata metadata = reader.getStreamMetadata();
            this.checkUUIDBoxes(metadata);
            if (this.crs == null || this.nativeEnvelope == null) {
                this.checkXMLBoxes(metadata);
            }
        }
        if (this.nativeEnvelope == null) {
            throw new DataSourceException("Unavailable envelope for this coverage");
        }
        this.originalEnvelope = this.getCoverageEnvelope();
        this.originalEnvelope.setCoordinateReferenceSystem(this.crs);
        this.originalGridRange = this.getCoverageGridRange();
    }

    protected void setCoverageEnvelope(GeneralEnvelope coverageEnvelope) {
        this.nativeEnvelope = coverageEnvelope;
    }

    protected GeneralEnvelope getCoverageEnvelope() {
        return this.nativeEnvelope;
    }

    protected void setCoverageGridRange(GridEnvelope2D coverageGridRange) {
        this.nativeGridRange = coverageGridRange;
    }

    protected GridEnvelope2D getCoverageGridRange() {
        return this.nativeGridRange;
    }

    private boolean isGeoJP2(byte[] id) {
        return this.isSameUUID(id, GEOJP2_UUID);
    }

    private boolean isWorldBox(byte[] id) {
        return this.isSameUUID(id, MSIG_WORLDFILEBOX_UUID);
    }

    private boolean isSameUUID(byte[] id, short[] uuid) {
        for (int i = 0; i < uuid.length; ++i) {
            if ((id[i] & 0xFF) == uuid[i]) continue;
            return false;
        }
        return true;
    }

    private void checkXMLBoxes(IIOMetadata metadata) throws IOException {
        if (!(metadata instanceof JP2KStreamMetadata)) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("Metadata should be an instance of the expected class: JP2KStreamMetadata.");
            }
            return;
        }
        JP2KStreamMetadata jp2kMetadata = (JP2KStreamMetadata)metadata;
        List boxes = jp2kMetadata.searchOccurrencesNode(2020437024);
        if (boxes != null && !boxes.isEmpty()) {
            for (IIOMetadataNode node : boxes) {
                if (!this.isGMLJP2Box(node)) continue;
                XMLBoxMetadataNode xmlBox = (XMLBoxMetadataNode)node;
                try {
                    this.getGMLJP2(xmlBox);
                }
                catch (Exception e) {
                    LOGGER.log(Level.INFO, "Failed to parse GML georeferencing", e);
                }
            }
        }
    }

    private boolean isGMLJP2Box(IIOMetadataNode node) {
        if (!(node instanceof XMLBoxMetadataNode)) {
            return false;
        }
        Node parent = node.getParentNode();
        if (!(parent instanceof ASOCBoxMetadataNode)) {
            return false;
        }
        if (!((parent = parent.getParentNode()) instanceof ASOCBoxMetadataNode)) {
            return false;
        }
        for (Node child = parent.getFirstChild(); child != null; child = child.getNextSibling()) {
            LabelBoxMetadataNode label;
            if (!(child instanceof LabelBoxMetadataNode) || !"gml.data".equals((label = (LabelBoxMetadataNode)child).getText())) continue;
            return true;
        }
        return false;
    }

    private void getGMLJP2(XMLBoxMetadataNode xmlBox) throws IOException, ParserConfigurationException, SAXException, XPathExpressionException, FactoryException, TransformException {
        DocumentBuilder b = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        String xml = xmlBox.getXml();
        Document doc = b.parse(new ByteArrayInputStream(xml.getBytes()));
        XPath xpath = XPathFactory.newInstance().newXPath();
        Node rectifiedGrid = this.getNode(xpath, doc.getDocumentElement(), "//*[local-name() = 'RectifiedGrid']");
        if (rectifiedGrid == null) {
            LOGGER.log(Level.FINE, "Failed to parse GML georeferencing, could not locate a RectifiedGrid");
            return;
        }
        String pointOriginPath = "//*[local-name() = 'origin']/*[local-name() = 'Point']";
        Node originNode = this.getNode(xpath, rectifiedGrid, pointOriginPath);
        Node offsetVector1 = this.getNode(xpath, rectifiedGrid, "//*[local-name() = 'offsetVector'][1]");
        Node offsetVector2 = this.getNode(xpath, rectifiedGrid, "//*[local-name() = 'offsetVector'][2]");
        if (originNode == null) {
            LOGGER.log(Level.FINE, "Failed to parse GML georeferencing, could not locate origin node");
            return;
        }
        if (offsetVector1 == null || offsetVector2 == null) {
            LOGGER.log(Level.FINE, "Failed to parse GML georeferencing, could not locate required offset vectors");
            return;
        }
        Node srsNameAttribute = originNode.getAttributes().getNamedItem("srsName");
        if (srsNameAttribute == null) {
            String srsPath = "//*[local-name() = 'boundedBy']/*[local-name() = 'Envelope']/@srsName]";
            srsNameAttribute = this.getNode(xpath, doc.getDocumentElement(), srsPath);
        }
        if (srsNameAttribute == null) {
            srsNameAttribute = this.getNode(xpath, rectifiedGrid, "@srsName");
        }
        if (srsNameAttribute != null) {
            CoordinateReferenceSystem crs;
            this.crs = crs = CRS.decode((String)srsNameAttribute.getNodeValue());
        }
        Point2D origin = this.parsePoint(xpath, originNode);
        double[] off1 = this.parseOrdinates(offsetVector1, "\\s+");
        double[] off2 = this.parseOrdinates(offsetVector2, "\\s+");
        if (off1 == null || off2 == null || origin == null) {
            LOGGER.log(Level.FINE, "Missing offsets or origin, cannot build raster to world transformation");
            return;
        }
        AffineTransform at = null;
        if (CRS.getAxisOrder((CoordinateReferenceSystem)this.crs) == CRS.AxisOrder.NORTH_EAST) {
            Integer epsgCode = CRS.lookupEpsgCode((CoordinateReferenceSystem)this.crs, (boolean)false);
            if (epsgCode != null) {
                CoordinateReferenceSystem flipped;
                this.crs = flipped = CRS.decode((String)("EPSG:" + epsgCode), (boolean)true);
            }
            at = new AffineTransform(off1[1], off1[0], off2[1], off2[0], origin.getY(), origin.getX());
        } else {
            at = new AffineTransform(off1[0], off1[1], off2[0], off2[1], origin.getX(), origin.getY());
        }
        this.raster2Model = new AffineTransform2D(at);
        AffineTransform tempTransform = new AffineTransform((AffineTransform)this.raster2Model);
        tempTransform.translate(-0.5, -0.5);
        this.setEnvelopeFromTransform(tempTransform);
    }

    private Point2D parsePoint(XPath xpath, Node pointNode) throws XPathExpressionException {
        Node coordinate;
        Node coordinates;
        double[] ordinates = null;
        Node pos = this.getNode(xpath, pointNode, "//*[local-name() = 'pos']");
        if (pos != null) {
            ordinates = this.parseOrdinates(pos, "\\s+");
        }
        if (ordinates == null && (coordinates = this.getNode(xpath, pointNode, "//*[local-name() = 'coordinates']")) != null) {
            ordinates = this.parseOrdinates(coordinates, "\\s*,\\s*");
        }
        if (ordinates == null && (coordinate = this.getNode(xpath, pointNode, "//*[local-name() = 'coordinate']")) != null) {
            Node xn = this.getNode(xpath, pointNode, "//*[local-name() = 'X']");
            Node yn = this.getNode(xpath, pointNode, "//*[local-name() = 'Y']");
            double x = Double.parseDouble(xn.getTextContent());
            double y = Double.parseDouble(yn.getTextContent());
            ordinates = new double[]{x, y};
        }
        if (ordinates != null) {
            return new Point2D.Double(ordinates[0], ordinates[1]);
        }
        return null;
    }

    private double[] parseOrdinates(Node node, String separatorRegex) {
        String[] offsets1 = node.getTextContent().split(separatorRegex);
        if (offsets1.length < 2) {
            return null;
        }
        double o1 = Double.parseDouble(offsets1[0]);
        double o2 = Double.parseDouble(offsets1[1]);
        return new double[]{o1, o2};
    }

    private Node getNode(XPath xpath, Node rectifiedGrid, String path) throws XPathExpressionException {
        return (Node)xpath.evaluate(path, rectifiedGrid, XPathConstants.NODE);
    }

    private void checkUUIDBoxes(IIOMetadata metadata) throws IOException {
        if (!(metadata instanceof JP2KStreamMetadata)) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("Metadata should be an instance of the expected class: JP2KStreamMetadata.");
            }
            return;
        }
        List uuidBoxMetadataNodes = ((JP2KStreamMetadata)metadata).searchOccurrencesNode(1970628964);
        UUIDBoxMetadataNode geoJP2uuid = null;
        UUIDBoxMetadataNode worldBoxuuid = null;
        if (uuidBoxMetadataNodes != null && !uuidBoxMetadataNodes.isEmpty()) {
            for (IIOMetadataNode node : uuidBoxMetadataNodes) {
                if (!(node instanceof UUIDBoxMetadataNode)) continue;
                UUIDBoxMetadataNode uuid = (UUIDBoxMetadataNode)node;
                byte[] id = uuid.getUuid();
                if (this.isGeoJP2(id)) {
                    geoJP2uuid = uuid;
                    continue;
                }
                if (!this.isWorldBox(id)) continue;
                worldBoxuuid = uuid;
            }
        }
        if (geoJP2uuid != null) {
            this.getGeoJP2(geoJP2uuid);
        }
        if (worldBoxuuid != null && this.crs != null) {
            this.getWorldBox(worldBoxuuid);
        }
    }

    private void getWorldBox(UUIDBoxMetadataNode uuid) throws IOException {
        block8: {
            byte[] bb = uuid.getData();
            if (bb[0] != 77 || bb[1] != 83 || bb[2] != 73 || bb[3] != 71) {
                return;
            }
            byte worldFileInterpretation = bb[6];
            int ckIndex = 16;
            byte chunkIndex = bb[16];
            long chunkLength = Utils.bytes2long(bb, 18);
            if (chunkIndex != 0 && chunkLength != 48L) {
                return;
            }
            double xScale = Utils.bytes2double(bb, 22);
            double xRotation = Utils.bytes2double(bb, 30);
            double yRotation = Utils.bytes2double(bb, 38);
            double yScale = Utils.bytes2double(bb, 46);
            double xUpperLeft = Utils.bytes2double(bb, 54);
            double yUpperLeft = Utils.bytes2double(bb, 62);
            AffineTransform tempTransform = new AffineTransform(xScale, yRotation, xRotation, yScale, xUpperLeft, yUpperLeft);
            if (worldFileInterpretation == 1) {
                AffineTransform transform = (AffineTransform)ProjectiveTransform.create((AffineTransform)tempTransform);
                double tr = -PixelTranslation.getPixelTranslation((PixelInCell)PixelInCell.CELL_CORNER);
                transform.translate(tr, tr);
                this.raster2Model = ProjectiveTransform.create((AffineTransform)transform);
            } else {
                this.raster2Model = ProjectiveTransform.create((AffineTransform)tempTransform);
                tempTransform.translate(-0.5, -0.5);
            }
            try {
                GeneralEnvelope envelope = CRS.transform((MathTransform)ProjectiveTransform.create((AffineTransform)tempTransform), (Envelope)new GeneralEnvelope((Rectangle2D)this.nativeGridRange));
                envelope.setCoordinateReferenceSystem(this.crs);
                this.nativeEnvelope = envelope;
            }
            catch (TransformException e) {
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.log(Level.FINE, "Unable to parse CRS from underlying TIFF", e);
                }
            }
            catch (UnsupportedOperationException e) {
                if (!LOGGER.isLoggable(Level.FINE)) break block8;
                LOGGER.log(Level.FINE, "Unable to parse CRS from underlying TIFF due to an unsupported CRS", e);
            }
        }
    }

    private void getGeoJP2(UUIDBoxMetadataNode uuid) throws IOException {
        block9: {
            try (ByteArrayInputStream inputStream = new ByteArrayInputStream(uuid.getData());){
                TIFFImageReader tiffreader = (TIFFImageReader)new TIFFImageReaderSpi().createReaderInstance();
                tiffreader.setInput((Object)ImageIO.createImageInputStream(inputStream));
                IIOMetadata tiffmetadata = tiffreader.getImageMetadata(0);
                GeoTiffIIOMetadataDecoder metadataDecoder = new GeoTiffIIOMetadataDecoder(tiffmetadata);
                GeoTiffMetadata2CRSAdapter adapter = new GeoTiffMetadata2CRSAdapter(this.hints);
                CoordinateReferenceSystem crs = adapter.createCoordinateSystem(metadataDecoder);
                if (crs != null && this.crs == null) {
                    this.crs = crs;
                }
                if (this.raster2Model == null) {
                    this.raster2Model = GeoTiffMetadata2CRSAdapter.getRasterToModel((GeoTiffIIOMetadataDecoder)metadataDecoder);
                    AffineTransform tempTransform = new AffineTransform((AffineTransform)this.raster2Model);
                    tempTransform.translate(-0.5, -0.5);
                    this.setEnvelopeFromTransform(tempTransform);
                }
            }
            catch (Exception e) {
                if (!LOGGER.isLoggable(Level.FINE)) break block9;
                LOGGER.log(Level.FINE, "Unable to parse CRS from underlying TIFF", e);
            }
        }
    }

    private void setEnvelopeFromTransform(AffineTransform tempTransform) throws TransformException {
        GeneralEnvelope envelope = CRS.transform((MathTransform)ProjectiveTransform.create((AffineTransform)tempTransform), (Envelope)new GeneralEnvelope((Rectangle2D)this.nativeGridRange));
        envelope.setCoordinateReferenceSystem(this.crs);
        this.setCoverageEnvelope(envelope);
    }

    public int getGridCoverageCount() {
        return 1;
    }

    public synchronized void dispose() {
        super.dispose();
        this.rasterManager.dispose();
    }

    public JP2KReader(Object source, Hints uHints) throws IOException {
        super(source, uHints);
        this.sourceURL = Utils.checkSource(source);
        if (this.sourceURL == null) {
            throw new DataSourceException("This plugin accepts only File,  URL and String pointing to a file");
        }
        File inputFile = URLs.urlToFile((URL)this.sourceURL);
        if (inputFile == null) {
            throw new DataSourceException("Unable to find a file for the provided source");
        }
        this.parentPath = inputFile.getParent();
        ImageReader reader = null;
        try (ImageInputStream stream = ImageIO.createImageInputStream(inputFile);){
            if (this.cachedSPI == null && (reader = Utils.getReader(stream)) != null) {
                this.cachedSPI = reader.getOriginatingProvider();
            }
            if (reader == null) {
                throw new DataSourceException("No reader found for that source " + String.valueOf(this.sourceURL));
            }
            reader.setInput(stream);
            this.setLayout(reader);
            this.coverageName = inputFile.getName();
            int dotIndex = this.coverageName.lastIndexOf(".");
            this.coverageName = dotIndex == -1 ? this.coverageName : this.coverageName.substring(0, dotIndex);
            Object tempCRS = this.hints.get((Object)Hints.DEFAULT_COORDINATE_REFERENCE_SYSTEM);
            if (tempCRS != null) {
                this.crs = (CoordinateReferenceSystem)tempCRS;
                LOGGER.log(Level.WARNING, "Using forced coordinate reference system " + this.crs.toWKT());
            } else {
                this.setCoverageProperties(reader);
                if (this.crs == null) {
                    throw new DataSourceException("Unable to find a CRS for this coverage, using a default one");
                }
            }
            this.setResolutionInfo(reader);
            reader.dispose();
        }
        this.rasterManager = new RasterManager(this);
    }

    public Format getFormat() {
        return new JP2KFormat();
    }

    public GridCoverage2D read(GeneralParameterValue[] params) throws IOException {
        Collection<GridCoverage2D> response;
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("Reading image from " + this.sourceURL.toString());
            LOGGER.fine(new StringBuffer("Highest res ").append(this.highestRes[0]).append(" ").append(this.highestRes[1]).toString());
        }
        if ((response = this.rasterManager.read(params)).isEmpty()) {
            return null;
        }
        return response.iterator().next();
    }

    Hints getHints() {
        return this.hints;
    }

    protected double[] getHighestRes() {
        return this.highestRes;
    }

    double[][] getOverviewsResolution() {
        return this.overViewResolutions;
    }

    int getNumberOfOverviews() {
        return this.numOverviews;
    }

    MathTransform getRaster2Model() {
        return this.raster2Model;
    }

    GridCoverageFactory getGridCoverageFactory() {
        return this.coverageFactory;
    }

    String getName() {
        return this.coverageName;
    }

    protected void parsePRJFile() throws UnsupportedEncodingException {
        block19: {
            String prjPath = this.parentPath + SEPARATOR + this.coverageName + ".prj";
            File prjFile = new File(prjPath);
            if (prjFile.exists()) {
                try (FileInputStream instream = new FileInputStream(prjFile);
                     FileChannel channel = instream.getChannel();
                     PrjFileReader projReader = new PrjFileReader((ReadableByteChannel)channel);){
                    this.crs = projReader.getCoordinateReferenceSystem();
                }
                catch (IOException | FactoryException e) {
                    if (!LOGGER.isLoggable(Level.WARNING)) break block19;
                    LOGGER.log(Level.WARNING, e.getLocalizedMessage(), e);
                }
            }
        }
    }

    protected void parseWorldFile() throws IOException {
        block4: {
            String worldFilePath = new StringBuffer(this.parentPath).append(SEPARATOR).append(this.coverageName).toString();
            File file2Parse = new File(worldFilePath + ".j2w");
            boolean worldFileExists = file2Parse.exists();
            if (!worldFileExists) {
                file2Parse = new File(worldFilePath + ".wld");
                worldFileExists = file2Parse.exists();
            }
            if (worldFileExists) {
                WorldFileReader reader = new WorldFileReader(file2Parse);
                this.raster2Model = reader.getTransform();
                MathTransform tempTransform = PixelTranslation.translate((MathTransform)this.raster2Model, (PixelInCell)PixelInCell.CELL_CENTER, (PixelInCell)PixelInCell.CELL_CORNER);
                try {
                    GeneralEnvelope coverageEnvelope;
                    GeneralEnvelope gridRange = new GeneralEnvelope((Rectangle2D)this.nativeGridRange);
                    this.nativeEnvelope = coverageEnvelope = CRS.transform((MathTransform)tempTransform, (Envelope)gridRange);
                }
                catch (IllegalStateException | TransformException e) {
                    if (!LOGGER.isLoggable(Level.WARNING)) break block4;
                    LOGGER.log(Level.WARNING, e.getLocalizedMessage(), e);
                }
            }
        }
    }

    private void setResolutionInfo(ImageReader reader) throws IOException {
        Rectangle originalDim = new Rectangle(0, 0, reader.getWidth(0), reader.getHeight(0));
        if (this.nativeGridRange == null) {
            this.setCoverageGridRange(new GridEnvelope2D(originalDim));
        }
        this.highestRes = CoverageUtilities.getResolution((AffineTransform)((AffineTransform)this.raster2Model));
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine(new StringBuffer("Highest Resolution = [").append(this.highestRes[0]).append(",").append(this.highestRes[1]).toString());
        }
        this.numOverviews = 0;
        this.overViewResolutions = this.numOverviews >= 1 ? new double[this.numOverviews][2] : null;
    }
}

