/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.coverageio.jp2k;

import it.geosolutions.imageio.utilities.ImageIOUtilities;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import javax.imageio.ImageReadParam;
import javax.imageio.ImageReader;
import javax.imageio.spi.ImageReaderSpi;
import javax.imageio.stream.ImageInputStream;
import javax.media.jai.ImageLayout;
import javax.media.jai.Interpolation;
import javax.media.jai.InterpolationNearest;
import javax.media.jai.JAI;
import org.geotools.coverage.grid.GridEnvelope2D;
import org.geotools.coverage.util.CoverageUtilities;
import org.geotools.coverageio.jp2k.RasterLayerRequest;
import org.geotools.coverageio.jp2k.ReadType;
import org.geotools.coverageio.jp2k.Utils;
import org.geotools.geometry.GeneralEnvelope;
import org.geotools.geometry.PixelTranslation;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.geometry.util.XRectangle2D;
import org.geotools.image.ImageWorker;
import org.geotools.image.util.ImageUtilities;
import org.geotools.referencing.CRS;
import org.geotools.referencing.operation.builder.GridToEnvelopeMapper;
import org.geotools.referencing.operation.matrix.XAffineTransform;
import org.geotools.referencing.operation.transform.AffineTransform2D;
import org.geotools.referencing.operation.transform.ProjectiveTransform;
import org.geotools.util.logging.Logging;
import org.locationtech.jts.geom.Envelope;
import org.opengis.coverage.grid.GridEnvelope;
import org.opengis.geometry.BoundingBox;
import org.opengis.referencing.datum.PixelInCell;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.MathTransform2D;
import org.opengis.referencing.operation.NoninvertibleTransformException;
import org.opengis.referencing.operation.TransformException;

class Granule {
    static final double EPS = 1.0E-5;
    private static final Logger LOGGER = Logging.getLogger(Granule.class);
    ReferencedEnvelope granuleBBOX;
    File granuleFile;
    final Map<Integer, Level> granuleLevels = Collections.synchronizedMap(new HashMap());
    AffineTransform baseGridToWorld;
    ImageReaderSpi cachedSPI;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Granule(BoundingBox granuleBBOX, File granuleFile) {
        this.granuleBBOX = ReferencedEnvelope.reference((org.opengis.geometry.Envelope)granuleBBOX);
        this.granuleFile = granuleFile;
        ImageInputStream inStream = null;
        ImageReader reader = null;
        try {
            inStream = Utils.getInputStream(granuleFile);
            if (inStream == null) {
                throw new IllegalArgumentException("Unable to get an input stream for the provided file " + granuleFile.getAbsolutePath());
            }
            if (this.cachedSPI == null) {
                reader = Utils.getReader(inStream);
                if (reader != null) {
                    this.cachedSPI = reader.getOriginatingProvider();
                }
            } else {
                reader = this.cachedSPI.createReaderInstance();
            }
            if (reader == null) {
                throw new IllegalArgumentException("Unable to get an ImageReader for the provided file " + granuleFile.getAbsolutePath());
            }
            Rectangle originalDimension = ImageUtilities.getDimension((int)0, (ImageInputStream)inStream, (ImageReader)reader);
            GridToEnvelopeMapper geMapper = new GridToEnvelopeMapper((GridEnvelope)new GridEnvelope2D(originalDimension), (org.opengis.geometry.Envelope)granuleBBOX);
            geMapper.setPixelAnchor(PixelInCell.CELL_CENTER);
            this.baseGridToWorld = geMapper.createAffineTransform();
            this.granuleLevels.put(0, new Level(1.0, 1.0, originalDimension.width, originalDimension.height));
            return;
        }
        catch (IllegalStateException e) {
            throw new IllegalArgumentException(e);
        }
        catch (IOException e) {
            throw new IllegalArgumentException(e);
        }
        finally {
            try {
                if (inStream != null) {
                    inStream.close();
                }
            }
            catch (Throwable e) {
                throw new IllegalArgumentException(e);
            }
            finally {
                if (reader != null) {
                    reader.dispose();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RenderedImage loadRaster(ImageReadParam readParameters, int imageIndex, ReferencedEnvelope cropBBox, MathTransform2D worldToGrid, RasterLayerRequest request, Dimension tileDimension) throws IOException {
        RenderedImage renderedImage;
        if (LOGGER.isLoggable(java.util.logging.Level.FINE)) {
            LOGGER.fine("Loading raster data for granule " + this.toString());
        }
        ReferencedEnvelope bbox = new ReferencedEnvelope(this.granuleBBOX);
        ReferencedEnvelope intersection = new ReferencedEnvelope((Envelope)bbox.intersection((Envelope)cropBBox), cropBBox.getCoordinateReferenceSystem());
        ImageInputStream inStream = null;
        ImageReader reader = null;
        try {
            RenderedImage raster;
            int ssy;
            int ssx;
            int newSubSamplingFactor;
            inStream = Utils.getInputStream(this.granuleFile);
            if (inStream == null) {
                RenderedImage renderedImage2 = null;
                return renderedImage2;
            }
            if (this.cachedSPI == null) {
                reader = Utils.getReader(inStream);
                if (reader != null) {
                    this.cachedSPI = reader.getOriginatingProvider();
                }
            } else {
                reader = this.cachedSPI.createReaderInstance();
            }
            if (reader == null) {
                if (LOGGER.isLoggable(java.util.logging.Level.WARNING)) {
                    LOGGER.warning("Unable to get reader for granule " + this.toString() + " with request " + request.toString());
                }
                RenderedImage renderedImage3 = null;
                return renderedImage3;
            }
            Level selectedlevel = this.getLevel(imageIndex);
            MathTransform2D cropWorldToGrid = (MathTransform2D)PixelTranslation.translate((MathTransform)ProjectiveTransform.create((AffineTransform)selectedlevel.gridToWorldTransform), (PixelInCell)PixelInCell.CELL_CENTER, (PixelInCell)PixelInCell.CELL_CORNER).inverse();
            Rectangle sourceArea = CRS.transform((MathTransform)cropWorldToGrid, (org.opengis.geometry.Envelope)new GeneralEnvelope((org.opengis.geometry.Envelope)intersection)).toRectangle2D().getBounds();
            XRectangle2D.intersect((Rectangle2D)sourceArea, (Rectangle2D)selectedlevel.rasterDimensions, (Rectangle2D)sourceArea);
            if (sourceArea.isEmpty()) {
                if (LOGGER.isLoggable(java.util.logging.Level.FINE)) {
                    LOGGER.fine("Got empty area for granule " + this.toString() + " with request " + request.toString());
                }
                RenderedImage renderedImage4 = null;
                return renderedImage4;
            }
            if (LOGGER.isLoggable(java.util.logging.Level.FINE)) {
                LOGGER.fine(new StringBuffer("Loading level ").append(imageIndex).append(" with source region ").append(sourceArea).toString());
            }
            if ((newSubSamplingFactor = ImageIOUtilities.getSubSamplingFactor2((int)(ssx = readParameters.getSourceXSubsampling()), (int)(ssy = readParameters.getSourceYSubsampling()))) != 0) {
                readParameters.setSourceSubsampling(newSubSamplingFactor, newSubSamplingFactor, 0, 0);
            }
            readParameters.setSourceRegion(sourceArea);
            try {
                raster = request.getReadType().read(readParameters, imageIndex, this.granuleFile, selectedlevel.rasterDimensions, tileDimension, this.cachedSPI);
                if (raster == null) {
                    RenderedImage renderedImage5 = null;
                    return renderedImage5;
                }
            }
            catch (Throwable e) {
                if (LOGGER.isLoggable(java.util.logging.Level.FINE)) {
                    LOGGER.log(java.util.logging.Level.FINE, "Unable to load raster for granule " + this.toString() + " with request " + request.toString(), e);
                }
                RenderedImage renderedImage6 = null;
                return renderedImage6;
            }
            sourceArea.setRect(readParameters.getSourceRegion());
            double decimationScaleX = 1.0 * (double)sourceArea.width / (double)raster.getWidth();
            double decimationScaleY = 1.0 * (double)sourceArea.height / (double)raster.getHeight();
            AffineTransform decimationScaleTranform = XAffineTransform.getScaleInstance((double)decimationScaleX, (double)decimationScaleY);
            AffineTransform afterDecimationTranslateTranform = XAffineTransform.getTranslateInstance((double)sourceArea.x, (double)sourceArea.y);
            AffineTransform2D backToBaseLevelScaleTransform = selectedlevel.baseToLevelTransform;
            AffineTransform finalRaster2Model = new AffineTransform(this.baseGridToWorld);
            finalRaster2Model.concatenate(CoverageUtilities.CENTER_TO_CORNER);
            if (!XAffineTransform.isIdentity((AffineTransform)backToBaseLevelScaleTransform, (double)1.0E-5)) {
                finalRaster2Model.concatenate((AffineTransform)backToBaseLevelScaleTransform);
            }
            if (!XAffineTransform.isIdentity((AffineTransform)afterDecimationTranslateTranform, (double)1.0E-5)) {
                finalRaster2Model.concatenate(afterDecimationTranslateTranform);
            }
            if (!XAffineTransform.isIdentity((AffineTransform)decimationScaleTranform, (double)1.0E-5)) {
                finalRaster2Model.concatenate(decimationScaleTranform);
            }
            finalRaster2Model.preConcatenate((AffineTransform)worldToGrid);
            InterpolationNearest nearest = new InterpolationNearest();
            Rectangle2D finalLayout = ImageUtilities.layoutHelper((RenderedImage)raster, (float)((float)finalRaster2Model.getScaleX()), (float)((float)finalRaster2Model.getScaleY()), (float)((float)finalRaster2Model.getTranslateX()), (float)((float)finalRaster2Model.getTranslateY()), (Interpolation)nearest);
            if (finalLayout.isEmpty()) {
                if (LOGGER.isLoggable(java.util.logging.Level.FINE)) {
                    LOGGER.fine("Unable to create a granule " + this.toString() + " due to jai scale bug");
                }
                RenderedImage renderedImage7 = null;
                return renderedImage7;
            }
            RenderingHints localHints = new RenderingHints(JAI.KEY_REPLACE_INDEX_COLOR_MODEL, Boolean.FALSE);
            if (XAffineTransform.isIdentity((AffineTransform)finalRaster2Model, (double)1.0E-5)) {
                RenderedImage renderedImage8 = raster;
                return renderedImage8;
            }
            Dimension tileDimensions = request.getTileDimensions();
            if (tileDimensions != null && request.getReadType().equals((Object)ReadType.DIRECT_READ)) {
                ImageLayout layout = new ImageLayout();
                layout.setTileHeight(tileDimensions.width).setTileWidth(tileDimensions.height);
                localHints.add(new RenderingHints(JAI.KEY_IMAGE_LAYOUT, layout));
            }
            ImageWorker worker = new ImageWorker(raster).setRenderingHints(localHints);
            worker.affine(finalRaster2Model, (Interpolation)nearest, null);
            RenderedImage renderedImage9 = worker.getRenderedImage();
            return renderedImage9;
        }
        catch (IllegalStateException e) {
            if (LOGGER.isLoggable(java.util.logging.Level.WARNING)) {
                LOGGER.log(java.util.logging.Level.WARNING, "Unable to load raster for granule " + this.toString() + " with request " + request.toString(), e);
            }
            renderedImage = null;
            return renderedImage;
        }
        catch (NoninvertibleTransformException e) {
            if (LOGGER.isLoggable(java.util.logging.Level.WARNING)) {
                LOGGER.log(java.util.logging.Level.WARNING, "Unable to load raster for granule " + this.toString() + " with request " + request.toString(), e);
            }
            renderedImage = null;
            return renderedImage;
        }
        catch (TransformException e) {
            if (LOGGER.isLoggable(java.util.logging.Level.WARNING)) {
                LOGGER.log(java.util.logging.Level.WARNING, "Unable to load raster for granule " + this.toString() + " with request " + request.toString(), e);
            }
            renderedImage = null;
            return renderedImage;
        }
        finally {
            try {
                if (inStream != null) {
                    inStream.close();
                }
            }
            finally {
                if (reader != null) {
                    reader.dispose();
                }
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Level getLevel(int index) {
        Map<Integer, Level> map = this.granuleLevels;
        synchronized (map) {
            if (this.granuleLevels.containsKey(index)) {
                return this.granuleLevels.get(index);
            }
            ImageInputStream inStream = null;
            ImageReader reader = null;
            try {
                inStream = Utils.getInputStream(this.granuleFile);
                if (inStream == null) {
                    throw new IllegalArgumentException();
                }
                if (this.cachedSPI == null) {
                    reader = Utils.getReader(inStream);
                    if (reader != null) {
                        this.cachedSPI = reader.getOriginatingProvider();
                    }
                } else {
                    reader = this.cachedSPI.createReaderInstance();
                }
                if (reader == null) {
                    throw new IllegalArgumentException("Unable to get an ImageReader for the provided file " + this.granuleFile.getAbsolutePath());
                }
                Rectangle levelDimension = ImageUtilities.getDimension((int)index, (ImageInputStream)inStream, (ImageReader)reader);
                Level baseLevel = this.granuleLevels.get(0);
                double scaleX = (double)baseLevel.width / (1.0 * (double)levelDimension.width);
                double scaleY = (double)baseLevel.height / (1.0 * (double)levelDimension.height);
                Level newLevel = new Level(scaleX, scaleY, levelDimension.width, levelDimension.height);
                this.granuleLevels.put(index, newLevel);
                Level level = newLevel;
                return level;
            }
            catch (IllegalStateException e) {
                throw new IllegalArgumentException(e);
            }
            catch (IOException e) {
                throw new IllegalArgumentException(e);
            }
            finally {
                try {
                    if (inStream != null) {
                        inStream.close();
                    }
                }
                catch (Throwable e) {
                    throw new IllegalArgumentException(e);
                }
                finally {
                    if (reader != null) {
                        reader.dispose();
                    }
                }
            }
        }
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append("Description of a granule ").append("\n");
        buffer.append("BBOX:\t\t").append(this.granuleBBOX.toString());
        buffer.append("file:\t\t").append(this.granuleFile);
        buffer.append("gridToWorld:\t\t").append(this.baseGridToWorld);
        int i = 1;
        for (Level level : this.granuleLevels.values()) {
            int n = ++i;
            ++i;
            buffer.append("Description of level ").append(n).append("\n");
            buffer.append(level.toString()).append("\n");
        }
        return super.toString();
    }

    class Level {
        final double scaleX;
        final double scaleY;
        final int width;
        final int height;
        final AffineTransform2D baseToLevelTransform;
        final AffineTransform2D gridToWorldTransform;
        final Rectangle rasterDimensions;

        public AffineTransform getBaseToLevelTransform() {
            return this.baseToLevelTransform;
        }

        public double getScaleX() {
            return this.scaleX;
        }

        public double getScaleY() {
            return this.scaleY;
        }

        public int getWidth() {
            return this.width;
        }

        public int getHeight() {
            return this.height;
        }

        public Level(double scaleX, double scaleY, int width, int height) {
            this.scaleX = scaleX;
            this.scaleY = scaleY;
            this.baseToLevelTransform = new AffineTransform2D(XAffineTransform.getScaleInstance((double)scaleX, (double)scaleY, (double)0.0, (double)0.0));
            AffineTransform gridToWorldTransform_ = new AffineTransform((AffineTransform)this.baseToLevelTransform);
            gridToWorldTransform_.preConcatenate(CoverageUtilities.CENTER_TO_CORNER);
            gridToWorldTransform_.preConcatenate(Granule.this.baseGridToWorld);
            this.gridToWorldTransform = new AffineTransform2D(gridToWorldTransform_);
            this.width = width;
            this.height = height;
            this.rasterDimensions = new Rectangle(0, 0, width, height);
        }

        public Rectangle getBounds() {
            return (Rectangle)this.rasterDimensions.clone();
        }

        public AffineTransform2D getGridToWorldTransform() {
            return this.gridToWorldTransform;
        }

        public String toString() {
            StringBuilder buffer = new StringBuilder();
            buffer.append("Description of a granule level").append("\n");
            buffer.append("width:\t\t").append(this.width).append("\n");
            buffer.append("height:\t\t").append(this.height).append("\n");
            buffer.append("scaleX:\t\t").append(this.scaleX).append("\n");
            buffer.append("scaleY:\t\t").append(this.scaleY).append("\n");
            buffer.append("baseToLevelTransform:\t\t").append(this.baseToLevelTransform.toString()).append("\n");
            buffer.append("gridToWorldTransform:\t\t").append(this.gridToWorldTransform.toString()).append("\n");
            return buffer.toString();
        }
    }
}

