/*
 *    GeoTools - The Open Source Java GIS Toolkit
 *    http://geotools.org
 *
 *    (C) 2005-2008, Open Source Geospatial Foundation (OSGeo)
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License as published by the Free Software Foundation;
 *    version 2.1 of the License.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 */
package org.geotools.filter.function;

// this code is autogenerated - you shouldnt be modifying it!

import static org.geotools.filter.capability.FunctionNameImpl.parameter;

import org.geotools.filter.FunctionExpressionImpl;
import org.geotools.filter.capability.FunctionNameImpl;
import org.opengis.filter.capability.FunctionName;

public class FilterFunction_strAbbreviate extends FunctionExpressionImpl {

    public static FunctionName NAME =
            new FunctionNameImpl(
                    "strAbbreviate",
                    parameter("string", String.class),
                    parameter(
                            "string",
                            String.class,
                            "Input String",
                            "String to abbreviate, if null null is returned"),
                    parameter("lower", Integer.class, "Lower", "The lower limit"),
                    parameter(
                            "upper", Integer.class, "Upper", "The upper limit of returned length"),
                    parameter(
                            "appendTo",
                            String.class,
                            "",
                            "String to be appended to end of abbreviated string (can be null or empty)"));

    public FilterFunction_strAbbreviate() {
        super(NAME);
    }

    @Override
    public Object evaluate(Object feature) {
        String in;
        String append = "";
        Integer upper, lower;
        try { // attempt to get value and perform conversion
            in = getExpression(0).evaluate(feature, String.class); // extra
            // protection
            // for
            // strings
        } catch (Exception e) // probably a type error
        {
            throw new IllegalArgumentException(
                    "Filter Function problem for function strAbbreviate argument #0 - expected type String");
        }
        try {
            lower = getExpression(1).evaluate(feature, Integer.class);
        } catch (Exception e) // probably a type error
        {
            throw new IllegalArgumentException(
                    "Filter Function problem for function strAbbreviate argument #1 - expected type Integer");
        }
        try {
            upper = getExpression(2).evaluate(feature, Integer.class);
        } catch (Exception e) // probably a type error
        {
            throw new IllegalArgumentException(
                    "Filter Function problem for function strAbbreviate argument #2 - expected type Integer");
        }
        try {
            append = getExpression(3).evaluate(feature, String.class);
        } catch (Exception e) // probably a type error
        {
            throw new IllegalArgumentException(
                    "Filter Function problem for function strAbbreviate argument #3 - expected type String");
        }
        return StaticGeometry.strAbbreviate(in, lower, upper, append);
    }
}
