/*
 *    GeoTools - The Open Source Java GIS Toolkit
 *    http://geotools.org
 *
 *    (C) 2005-2008, Open Source Geospatial Foundation (OSGeo)
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License as published by the Free Software Foundation;
 *    version 2.1 of the License.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 */
package org.geotools.filter.function;

// this code is autogenerated - you shouldnt be modifying it!

import static org.geotools.filter.capability.FunctionNameImpl.parameter;

import org.geotools.factory.CommonFactoryFinder;
import org.geotools.filter.FunctionExpressionImpl;
import org.geotools.filter.capability.FunctionNameImpl;
import org.opengis.filter.Filter;
import org.opengis.filter.FilterFactory2;
import org.opengis.filter.MultiValuedFilter.MatchAction;
import org.opengis.filter.capability.FunctionName;
import org.opengis.filter.expression.Expression;

public class FilterFunction_equalTo extends FunctionExpressionImpl {
    private static FilterFactory2 ff;

    private static FilterFactory2 getFilterFactory2() {
        if (ff == null) {
            ff = CommonFactoryFinder.getFilterFactory2();
        }
        return ff;
    }

    public static FunctionName NAME =
            new FunctionNameImpl(
                    "equalTo",
                    parameter(
                            "equalTo",
                            Boolean.class,
                            "equal to",
                            "Can be used to compare for equality two numbers, two strings, two dates, and so on."),
                    parameter(
                            "a",
                            Object.class,
                            "a",
                            "Can be any object type: date, string, number, etc..."),
                    parameter(
                            "b",
                            Object.class,
                            "b",
                            "Can be any object type: date, string, number, etc..."),
                    parameter("matchAction", String.class, 0, 1));

    public FilterFunction_equalTo() {
        super(NAME);
    }

    public Object evaluate(Object feature) {
        Expression arg0 = getExpression(0);
        Expression arg1 = getExpression(1);
        MatchAction matchAction = null;

        if (getParameters().size() > 2) {
            try { // attempt to get value and perform conversion
                matchAction = (MatchAction) getExpression(2).evaluate(feature, MatchAction.class);
            } catch (Exception e) // probably a type error
            {
                throw new IllegalArgumentException(
                        "Filter Function problem for function equalTo argument #2 - expected one of ANY, ONE or ALL");
            }
        }
        Filter equalTo =
                matchAction == null
                        ? getFilterFactory2().equal(arg0, arg1, false)
                        : getFilterFactory2().equal(arg0, arg1, false, matchAction);

        return equalTo.evaluate(feature);
    }
}
