/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.crs;

import junit.framework.TestCase;
import org.geotools.data.collection.ListFeatureCollection;
import org.geotools.data.crs.ForceCoordinateSystemIterator;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.data.simple.SimpleFeatureIterator;
import org.geotools.feature.FeatureIterator;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.geotools.referencing.crs.DefaultEngineeringCRS;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.Point;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class ForceCoordinateSystemFeatureIteratorTest
extends TestCase {
    private static final String FEATURE_TYPE_NAME = "testType";

    protected void setUp() throws Exception {
        super.setUp();
    }

    private SimpleFeatureCollection createDatastore(CoordinateReferenceSystem crs, Point p) throws Exception {
        SimpleFeatureTypeBuilder builder = new SimpleFeatureTypeBuilder();
        builder.setName(FEATURE_TYPE_NAME);
        builder.setCRS(crs);
        builder.add("geom", Point.class);
        SimpleFeatureType ft = builder.buildFeatureType();
        SimpleFeatureBuilder b = new SimpleFeatureBuilder(ft);
        b.add((Object)p);
        ListFeatureCollection features = new ListFeatureCollection(ft);
        features.add(b.buildFeature(null));
        return features;
    }

    public void testSameCRS() throws Exception {
        DefaultGeographicCRS crs = DefaultGeographicCRS.WGS84;
        GeometryFactory fac = new GeometryFactory();
        Point p = fac.createPoint(new Coordinate(10.0, 10.0));
        SimpleFeatureCollection collection = this.createDatastore((CoordinateReferenceSystem)crs, p);
        SimpleFeatureIterator original = collection.features();
        ForceCoordinateSystemIterator modified = new ForceCoordinateSystemIterator((FeatureIterator)collection.features(), (SimpleFeatureType)collection.getSchema(), (CoordinateReferenceSystem)crs);
        SimpleFeature f1 = (SimpleFeature)original.next();
        SimpleFeature f2 = modified.next();
        ForceCoordinateSystemFeatureIteratorTest.assertEquals((Object)f1, (Object)f2);
        ForceCoordinateSystemFeatureIteratorTest.assertFalse((boolean)original.hasNext());
        ForceCoordinateSystemFeatureIteratorTest.assertFalse((boolean)modified.hasNext());
    }

    public void testDifferentCRS() throws Exception {
        DefaultGeographicCRS srcCRS = DefaultGeographicCRS.WGS84;
        GeometryFactory fac = new GeometryFactory();
        Point p = fac.createPoint(new Coordinate(10.0, 10.0));
        SimpleFeatureCollection collection = this.createDatastore((CoordinateReferenceSystem)srcCRS, p);
        SimpleFeatureIterator original = collection.features();
        DefaultEngineeringCRS destCRS = DefaultEngineeringCRS.CARTESIAN_2D;
        ForceCoordinateSystemIterator modified = new ForceCoordinateSystemIterator((FeatureIterator)collection.features(), (SimpleFeatureType)collection.getSchema(), (CoordinateReferenceSystem)destCRS);
        SimpleFeature f1 = (SimpleFeature)original.next();
        SimpleFeature f2 = modified.next();
        ForceCoordinateSystemFeatureIteratorTest.assertEquals((Object)((Geometry)f1.getDefaultGeometry()).getCoordinate(), (Object)((Geometry)f2.getDefaultGeometry()).getCoordinate());
        ForceCoordinateSystemFeatureIteratorTest.assertFalse((boolean)f1.getFeatureType().getCoordinateReferenceSystem().equals(f2.getFeatureType().getCoordinateReferenceSystem()));
        ForceCoordinateSystemFeatureIteratorTest.assertEquals((Object)srcCRS, (Object)f1.getFeatureType().getCoordinateReferenceSystem());
        ForceCoordinateSystemFeatureIteratorTest.assertEquals((Object)srcCRS, (Object)f1.getFeatureType().getGeometryDescriptor().getCoordinateReferenceSystem());
        ForceCoordinateSystemFeatureIteratorTest.assertEquals((Object)destCRS, (Object)f2.getFeatureType().getCoordinateReferenceSystem());
        ForceCoordinateSystemFeatureIteratorTest.assertEquals((Object)destCRS, (Object)f2.getFeatureType().getGeometryDescriptor().getCoordinateReferenceSystem());
        ForceCoordinateSystemFeatureIteratorTest.assertFalse((boolean)original.hasNext());
        ForceCoordinateSystemFeatureIteratorTest.assertFalse((boolean)modified.hasNext());
        ForceCoordinateSystemFeatureIteratorTest.assertNotNull((Object)modified.builder);
    }

    public void testNullDestination() throws Exception {
        DefaultGeographicCRS crs = DefaultGeographicCRS.WGS84;
        GeometryFactory fac = new GeometryFactory();
        Point p = fac.createPoint(new Coordinate(10.0, 10.0));
        SimpleFeatureCollection collection = this.createDatastore((CoordinateReferenceSystem)crs, p);
        try {
            new ForceCoordinateSystemIterator((FeatureIterator)collection.features(), (SimpleFeatureType)collection.getSchema(), (CoordinateReferenceSystem)null);
            ForceCoordinateSystemFeatureIteratorTest.fail();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void testNullSource() throws Exception {
        CoordinateReferenceSystem srcCRS = null;
        GeometryFactory fac = new GeometryFactory();
        Point p = fac.createPoint(new Coordinate(10.0, 10.0));
        SimpleFeatureCollection collection = this.createDatastore(srcCRS, p);
        SimpleFeatureIterator original = collection.features();
        DefaultEngineeringCRS destCRS = DefaultEngineeringCRS.CARTESIAN_2D;
        ForceCoordinateSystemIterator modified = new ForceCoordinateSystemIterator((FeatureIterator)collection.features(), (SimpleFeatureType)collection.getSchema(), (CoordinateReferenceSystem)destCRS);
        SimpleFeature f1 = (SimpleFeature)original.next();
        SimpleFeature f2 = modified.next();
        ForceCoordinateSystemFeatureIteratorTest.assertEquals((Object)((Geometry)f1.getDefaultGeometry()).getCoordinate(), (Object)((Geometry)f2.getDefaultGeometry()).getCoordinate());
        ForceCoordinateSystemFeatureIteratorTest.assertFalse((boolean)f2.getFeatureType().getCoordinateReferenceSystem().equals(f1.getFeatureType().getCoordinateReferenceSystem()));
        ForceCoordinateSystemFeatureIteratorTest.assertEquals(srcCRS, (Object)f1.getFeatureType().getCoordinateReferenceSystem());
        ForceCoordinateSystemFeatureIteratorTest.assertEquals(srcCRS, (Object)f1.getFeatureType().getGeometryDescriptor().getCoordinateReferenceSystem());
        ForceCoordinateSystemFeatureIteratorTest.assertEquals((Object)destCRS, (Object)f2.getFeatureType().getCoordinateReferenceSystem());
        ForceCoordinateSystemFeatureIteratorTest.assertEquals((Object)destCRS, (Object)f2.getFeatureType().getGeometryDescriptor().getCoordinateReferenceSystem());
        ForceCoordinateSystemFeatureIteratorTest.assertFalse((boolean)original.hasNext());
        ForceCoordinateSystemFeatureIteratorTest.assertFalse((boolean)modified.hasNext());
        ForceCoordinateSystemFeatureIteratorTest.assertNotNull((Object)modified.builder);
    }
}

