/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.crs;

import org.geotools.data.DataUtilities;
import org.geotools.data.FeatureReader;
import org.geotools.data.collection.ListFeatureCollection;
import org.geotools.data.crs.ReprojectFeatureReader;
import org.geotools.data.simple.SimpleFeatureReader;
import org.geotools.feature.FeatureCollection;
import org.geotools.referencing.CRS;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;
import org.locationtech.jts.geom.Point;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public final class ReprojectFeatureReaderTest {
    @Test
    public void testReprojectWithUserData() throws Exception {
        SimpleFeatureType featureType = DataUtilities.createType((String)"feature", (String)"id:string,geometry:Point:srid=4326");
        SimpleFeature feature = DataUtilities.createFeature((SimpleFeatureType)featureType, (String)"1|POINT(1 2)");
        ListFeatureCollection features = new ListFeatureCollection(featureType);
        features.add(feature);
        feature.getUserData().put("someKey", "someValue");
        CoordinateReferenceSystem sphericalMercator = CRS.decode((String)"EPSG:3857");
        SimpleFeatureReader reader = DataUtilities.reader((FeatureCollection)features);
        int featuresCount = 0;
        try (ReprojectFeatureReader reprojected = new ReprojectFeatureReader((FeatureReader)reader, sphericalMercator);){
            SimpleFeature reprojectedFeature = reprojected.next();
            Assert.assertThat((Object)reprojectedFeature, (Matcher)CoreMatchers.notNullValue());
            Point geometry = (Point)reprojectedFeature.getDefaultGeometry();
            this.checkDoubleValue(geometry.getX(), 222638.9816, 1.0E-4);
            this.checkDoubleValue(geometry.getY(), 111325.1429, 1.0E-4);
            Assert.assertThat(reprojectedFeature.getUserData().get("someKey"), (Matcher)CoreMatchers.is((Object)"someValue"));
        }
        Assert.assertThat((Object)(++featuresCount), (Matcher)CoreMatchers.is((Object)1));
    }

    private void checkDoubleValue(double value, double expected, double error) {
        double difference = Math.abs(value - expected);
        Assert.assertThat((Object)(difference < error ? 1 : 0), (Matcher)CoreMatchers.is((Object)true));
    }
}

