/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.memory;

import org.geotools.data.DataTestCase;
import org.geotools.data.FeatureReader;
import org.geotools.data.Query;
import org.geotools.data.Transaction;
import org.geotools.data.memory.MemoryDataStore;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;

public class MemoryDataStoreConcurrencyTest
extends DataTestCase {
    public MemoryDataStoreConcurrencyTest(String name) {
        super(name);
    }

    public void testConcurrencyReadsAndWrite() throws Exception {
        final MemoryDataStore dataStore = new MemoryDataStore();
        dataStore.createSchema(this.roadType);
        Runnable writeSomeFeatures = new Runnable(){

            @Override
            public void run() {
                for (int i = 0; i < 10000 && !Thread.interrupted(); ++i) {
                    SimpleFeature feature = SimpleFeatureBuilder.build((SimpleFeatureType)MemoryDataStoreConcurrencyTest.this.roadType, (Object[])new Object[]{i, MemoryDataStoreConcurrencyTest.this.line(new int[]{10, 10, 20, 10}), "r" + i}, (String)("road.rd" + i));
                    dataStore.addFeature(feature);
                }
            }
        };
        Thread writeThread = new Thread(writeSomeFeatures);
        writeThread.start();
        try {
            for (int i = 0; i < 10; ++i) {
                MemoryDataStoreConcurrencyTest.assertTrue((dataStore != null ? 1 : 0) != 0);
                Query query = new Query(this.roadType.getTypeName());
                FeatureReader featureReader = dataStore.getFeatureReader(query, Transaction.AUTO_COMMIT);
                MemoryDataStoreConcurrencyTest.assertTrue((featureReader != null ? 1 : 0) != 0);
                while (featureReader.hasNext()) {
                    featureReader.next();
                }
            }
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            writeThread.interrupt();
            writeThread.join();
        }
    }
}

