/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.ows;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Map;
import org.geotools.data.ows.HTTPResponse;

public class MockHttpResponse
implements HTTPResponse {
    String contentType;
    Map<String, String> headers;
    byte[] response;
    String responseCharset;

    public MockHttpResponse(String response, String contentType, String ... headers) {
        this(response.getBytes(), contentType, headers);
    }

    public MockHttpResponse(byte[] response, String contentType, String ... headers) {
        this.response = response;
        this.contentType = contentType;
        this.headers = new HashMap<String, String>();
        if (headers != null) {
            if (headers.length % 2 != 0) {
                throw new IllegalArgumentException("The headers must be a alternated sequence of keys and values, should have an even number of entries");
            }
            for (int i = 0; i < headers.length; i += 2) {
                String key = headers[i];
                String value = headers[i++];
                this.headers.put(key, value);
            }
        }
    }

    public void dispose() {
    }

    public String getContentType() {
        return this.contentType;
    }

    public String getResponseHeader(String headerName) {
        return this.headers.get(headerName);
    }

    public InputStream getResponseStream() throws IOException {
        return new ByteArrayInputStream(this.response);
    }

    public String getResponseCharset() {
        return this.responseCharset;
    }

    public String toString() {
        String contents = null;
        contents = this.responseCharset != null ? new String(this.response, Charset.forName(this.responseCharset)) : new String(this.response);
        return this.contentType + " - " + contents;
    }

    public void setResponseCharset(String responseCharset) {
        this.responseCharset = responseCharset;
    }
}

