/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.store;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.geotools.data.EmptyFeatureReader;
import org.geotools.data.FeatureReader;
import org.geotools.data.Query;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.data.simple.SimpleFeatureIterator;
import org.geotools.data.simple.SimpleFeatureSource;
import org.geotools.data.store.ContentDataStore;
import org.geotools.data.store.ContentEntry;
import org.geotools.data.store.ContentFeatureSource;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.feature.NameImpl;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.junit.Assert;
import org.junit.Test;
import org.locationtech.jts.geom.LineString;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.FeatureType;
import org.opengis.feature.type.Name;
import org.opengis.filter.FilterFactory2;
import org.opengis.filter.sort.SortBy;
import org.opengis.filter.sort.SortOrder;

public class ContentFeatureSourceTest {
    protected static final Name TYPENAME = new NameImpl("http://www.geotools.org", "Mock");
    protected static final SimpleFeatureType TYPE = ContentFeatureSourceTest.buildType();
    FilterFactory2 ff = CommonFactoryFinder.getFilterFactory2();

    protected static SimpleFeatureType buildType() {
        SimpleFeatureTypeBuilder builder = new SimpleFeatureTypeBuilder();
        builder.setName(TYPENAME);
        builder.add("geom", LineString.class);
        builder.add("name", String.class);
        builder.add("z", Integer.class);
        builder.add("cat", String.class);
        return builder.buildFeatureType();
    }

    @Test
    public void testRetypeCannotSortAll() throws Exception {
        this.checkRetypeCannotSort(Query.ALL, Query.ALL);
    }

    @Test
    public void testRetypeCannotSortCovered() throws Exception {
        Query q = new Query();
        q.setPropertyNames(new String[]{"name", "z"});
        q.setSortBy(new SortBy[]{this.ff.sort("z", SortOrder.ASCENDING)});
        this.checkRetypeCannotSort(q, q);
    }

    @Test
    public void testRetypeCannotSortPartiallyCovered() throws Exception {
        Query q = new Query();
        q.setPropertyNames(new String[]{"name"});
        q.setSortBy(new SortBy[]{this.ff.sort("name", SortOrder.ASCENDING), this.ff.sort("z", SortOrder.ASCENDING)});
        Query expected = new Query(q);
        expected.setPropertyNames(new String[]{"name", "z"});
        this.checkRetypeCannotSort(q, expected);
    }

    @Test
    public void testRetypeCannotSortFullyCovered() throws Exception {
        Query q = new Query();
        q.setPropertyNames(new String[]{"name"});
        q.setSortBy(new SortBy[]{this.ff.sort("z", SortOrder.ASCENDING)});
        Query expected = new Query(q);
        expected.setPropertyNames(new String[]{"name", "z"});
        this.checkRetypeCannotSort(q, expected);
    }

    public void checkRetypeCannotSort(Query query, final Query expected) throws IOException {
        ContentDataStore store = new ContentDataStore(){
            {
                this.namespaceURI = TYPE.getName().getNamespaceURI();
            }

            protected List<Name> createTypeNames() throws IOException {
                return new ArrayList<Name>(){
                    {
                        this.add(TYPENAME);
                    }
                };
            }

            protected ContentFeatureSource createFeatureSource(ContentEntry entry) throws IOException {
                return new ContentFeatureSource(entry, null){

                    protected ReferencedEnvelope getBoundsInternal(Query query) throws IOException {
                        throw new RuntimeException("Unexpected call");
                    }

                    protected int getCountInternal(Query query) throws IOException {
                        throw new RuntimeException("Unexpected call");
                    }

                    protected FeatureReader<SimpleFeatureType, SimpleFeature> getReaderInternal(Query query) throws IOException {
                        Assert.assertEquals((Object)expected, (Object)query);
                        return new EmptyFeatureReader((FeatureType)TYPE);
                    }

                    protected SimpleFeatureType buildFeatureType() throws IOException {
                        return TYPE;
                    }

                    protected boolean canRetype() {
                        return true;
                    }

                    protected boolean canSort() {
                        return false;
                    }
                };
            }
        };
        SimpleFeatureSource fs = store.getFeatureSource(TYPE.getName());
        SimpleFeatureCollection features = fs.getFeatures(query);
        try (SimpleFeatureIterator fi = features.features();){
            Assert.assertFalse((boolean)fi.hasNext());
        }
    }
}

