/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.store;

import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.data.simple.SimpleFeatureIterator;
import org.geotools.data.store.FeatureCollectionWrapperTestSupport;
import org.geotools.feature.collection.MaxSimpleFeatureCollection;

public class MaxFeaturesFeatureCollectionTest
extends FeatureCollectionWrapperTestSupport {
    public void testSize() throws Exception {
        MaxSimpleFeatureCollection max = new MaxSimpleFeatureCollection((SimpleFeatureCollection)this.delegate, 2L);
        MaxFeaturesFeatureCollectionTest.assertEquals((int)2, (int)max.size());
        max = new MaxSimpleFeatureCollection((SimpleFeatureCollection)this.delegate, (long)(this.delegate.size() - 1), 10L);
        MaxFeaturesFeatureCollectionTest.assertEquals((int)1, (int)max.size());
        max = new MaxSimpleFeatureCollection((SimpleFeatureCollection)this.delegate, (long)(this.delegate.size() + 1), 10L);
        MaxFeaturesFeatureCollectionTest.assertEquals((int)0, (int)max.size());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testIteratorMax() throws Exception {
        MaxSimpleFeatureCollection max = new MaxSimpleFeatureCollection((SimpleFeatureCollection)this.delegate, 2L);
        try (SimpleFeatureIterator i = max.features();){
            for (int x = 0; x < 2; ++x) {
                MaxFeaturesFeatureCollectionTest.assertTrue((boolean)i.hasNext());
                i.next();
            }
            MaxFeaturesFeatureCollectionTest.assertFalse((boolean)i.hasNext());
        }
    }

    public void testIteratorSkipMax() throws Exception {
        MaxSimpleFeatureCollection max = new MaxSimpleFeatureCollection((SimpleFeatureCollection)this.delegate, (long)(this.delegate.size() - 1), 2L);
        try (SimpleFeatureIterator i = max.features();){
            MaxFeaturesFeatureCollectionTest.assertTrue((boolean)i.hasNext());
            i.next();
            MaxFeaturesFeatureCollectionTest.assertFalse((boolean)i.hasNext());
        }
    }

    public void testIteratorSkipMoreSize() throws Exception {
        MaxSimpleFeatureCollection max = new MaxSimpleFeatureCollection((SimpleFeatureCollection)this.delegate, (long)(this.delegate.size() + 1), 2L);
        try (SimpleFeatureIterator i = max.features();){
            MaxFeaturesFeatureCollectionTest.assertFalse((boolean)i.hasNext());
        }
    }
}

