/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.util;

import java.nio.charset.Charset;
import java.util.Set;
import junit.framework.TestCase;
import org.geotools.data.util.CharsetConverterFactory;
import org.geotools.util.Converter;
import org.geotools.util.ConverterFactory;
import org.geotools.util.Converters;

public class CharsetConverterFactoryTest
extends TestCase {
    CharsetConverterFactory factory;

    protected void setUp() throws Exception {
        this.factory = new CharsetConverterFactory();
    }

    public void testLookupStringToCharset() {
        Set s = Converters.getConverterFactories(String.class, Charset.class);
        for (ConverterFactory cf : s) {
            if (!(cf instanceof CharsetConverterFactory)) continue;
            return;
        }
        CharsetConverterFactoryTest.fail((String)"CharsetConverterFactory not found");
    }

    public void testLookupCharsetToString() {
        Set s = Converters.getConverterFactories(Charset.class, String.class);
        for (ConverterFactory cf : s) {
            if (!(cf instanceof CharsetConverterFactory)) continue;
            return;
        }
        CharsetConverterFactoryTest.fail((String)"CharsetConverterFactory not found");
    }

    public void testStringToCharset() throws Exception {
        Converter c = this.factory.createConverter(String.class, Charset.class, null);
        CharsetConverterFactoryTest.assertNotNull((Object)c);
        Charset charset = (Charset)c.convert((Object)"UTF-8", Charset.class);
        CharsetConverterFactoryTest.assertNotNull((Object)charset);
        CharsetConverterFactoryTest.assertEquals((String)"UTF-8", (String)charset.name());
        CharsetConverterFactoryTest.assertNull((Object)c.convert((Object)"FOO", Charset.class));
    }

    public void testCharsetToString() throws Exception {
        Converter c = this.factory.createConverter(Charset.class, String.class, null);
        CharsetConverterFactoryTest.assertNotNull((Object)c);
        String charset = (String)c.convert((Object)Charset.forName("UTF-8"), String.class);
        CharsetConverterFactoryTest.assertEquals((String)"UTF-8", (String)charset);
    }
}

