/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.util;

import java.awt.Color;
import java.awt.RenderingHints;
import junit.framework.TestCase;
import org.geotools.data.util.ColorConverterFactory;
import org.geotools.filter.ConstantExpression;
import org.geotools.util.Converter;
import org.geotools.util.Converters;
import org.geotools.util.factory.Hints;

public class ColorConverterFactoryTest
extends TestCase {
    private static final Color THISTLE = new Color(216, 191, 216);
    private static final Color LEMON_CHIFFON = new Color(255, 250, 205);
    private static final Color ALICE_BLUE = new Color(240, 248, 255);
    private static final Color GRAY_TRANSPARENT = new Color(128, 128, 128, 128);
    private static final Color GRAY = new Color(128, 128, 128);
    ColorConverterFactory factory;

    protected void setUp() throws Exception {
        this.factory = new ColorConverterFactory();
    }

    public void testVsConstantExpression() throws Exception {
        ConstantExpression expr = ConstantExpression.color((Color)Color.RED);
        String expected = (String)expr.evaluate(null, String.class);
        Converter converter = this.factory.createConverter(Color.class, String.class, null);
        String actual = (String)converter.convert((Object)Color.RED, String.class);
        ColorConverterFactoryTest.assertEquals((String)expected, (String)actual);
    }

    public void testFromString() throws Exception {
        ColorConverterFactoryTest.assertEquals((Object)Color.RED, (Object)this.convert("#FF0000"));
    }

    public void testFromInteger() throws Exception {
        ColorConverterFactoryTest.assertEquals((Object)Color.RED, (Object)this.convert(0xFF0000));
        ColorConverterFactoryTest.assertEquals((String)"no alpha", (Object)new Color(0, 0, 255, 255), (Object)this.convert(255));
        ColorConverterFactoryTest.assertEquals((String)"255 alpha", (Object)new Color(0, 0, 255, 255), (Object)this.convert(-16776961));
        ColorConverterFactoryTest.assertEquals((String)"1 alpha", (Object)new Color(0, 0, 255, 1), (Object)this.convert(0x10000FF));
    }

    public void testFromLong() throws Exception {
        ColorConverterFactoryTest.assertEquals((Object)Color.RED, (Object)this.convert(0xFF0000));
        ColorConverterFactoryTest.assertEquals((String)"no alpha", (Object)new Color(0, 0, 255, 255), (Object)this.convert(255L));
        ColorConverterFactoryTest.assertEquals((String)"255 alpha", (Object)new Color(0, 0, 255, 255), (Object)this.convert(-16776961L));
        ColorConverterFactoryTest.assertEquals((String)"1 alpha", (Object)new Color(0, 0, 255, 1), (Object)this.convert(0x10000FFL));
    }

    public void testToCSS() throws Exception {
        Converter converter = this.factory.createConverter(Color.class, String.class, new Hints((RenderingHints.Key)Hints.COLOR_DEFINITION, (Object)"CSS"));
        ColorConverterFactoryTest.assertEquals((String)"aliceblue", (String)"aliceblue", (String)((String)converter.convert((Object)ALICE_BLUE, String.class)));
        ColorConverterFactoryTest.assertEquals((String)"gray", (String)"gray", (String)((String)converter.convert((Object)GRAY, String.class)));
        ColorConverterFactoryTest.assertEquals((String)"pale blue", (String)"rgb(33,66,255)", (String)((String)converter.convert((Object)new Color(33, 66, 255), String.class)));
        ColorConverterFactoryTest.assertEquals((String)"gray transparent", (String)"rgba(128,128,128,0.5)", (String)((String)converter.convert((Object)GRAY_TRANSPARENT, String.class)));
        ColorConverterFactoryTest.assertEquals((String)"blueish", (String)"rgba(33,66,255,0.992)", (String)((String)converter.convert((Object)new Color(33, 66, 255, 254), String.class)));
    }

    public void testFromCss() throws Exception {
        Converter converter = this.factory.createConverter(String.class, Color.class, new Hints((RenderingHints.Key)Hints.COLOR_DEFINITION, (Object)"CSS"));
        ColorConverterFactoryTest.assertEquals((String)"aliceblue", (Object)ALICE_BLUE, (Object)converter.convert((Object)"aliceblue", Color.class));
        ColorConverterFactoryTest.assertEquals((String)"AliceBlue", (Object)ALICE_BLUE, (Object)converter.convert((Object)"AliceBlue", Color.class));
        ColorConverterFactoryTest.assertEquals((String)"gray", (Object)GRAY, (Object)converter.convert((Object)"gray", Color.class));
        ColorConverterFactoryTest.assertEquals((String)"lemonchiffon", (Object)LEMON_CHIFFON, (Object)converter.convert((Object)"lemonchiffon", Color.class));
        ColorConverterFactoryTest.assertEquals((String)"WHITE", (Object)Color.WHITE, (Object)converter.convert((Object)"WHITE", Color.class));
        ColorConverterFactoryTest.assertEquals((String)"black", (Object)Color.BLACK, (Object)converter.convert((Object)"black", Color.class));
        ColorConverterFactoryTest.assertEquals((String)"thistle", (Object)THISTLE, (Object)converter.convert((Object)"thistle", Color.class));
        ColorConverterFactoryTest.assertEquals((String)"hex", (Object)GRAY, (Object)converter.convert((Object)"#808080", Color.class));
        ColorConverterFactoryTest.assertEquals((String)"hex alpha", (Object)GRAY_TRANSPARENT, (Object)converter.convert((Object)"#80808080", Color.class));
        ColorConverterFactoryTest.assertEquals((String)"rgb", (Object)GRAY, (Object)converter.convert((Object)"rgb(128,128,128)", Color.class));
        ColorConverterFactoryTest.assertEquals((String)"rgba", (Object)GRAY_TRANSPARENT, (Object)converter.convert((Object)"rgba(128,128,128, 0.5)", Color.class));
        ColorConverterFactoryTest.assertEquals((String)"rgba", (Object)GRAY, (Object)converter.convert((Object)"rgba(128,128,128, 1)", Color.class));
        ColorConverterFactoryTest.assertEquals((String)"rgba", (Object)new Color(33, 66, 255, 254), (Object)converter.convert((Object)"rgba(33,66,255,0.99607843)", Color.class));
    }

    public void testAlpha() throws Exception {
        Converter converter = this.factory.createConverter(String.class, Color.class, null);
        ColorConverterFactoryTest.assertEquals((String)"hex", (Object)GRAY, (Object)converter.convert((Object)"#808080", Color.class));
        ColorConverterFactoryTest.assertNull((String)"hex alpha", (Object)converter.convert((Object)"#80808080", Color.class));
    }

    Color convert(Object value) throws Exception {
        Converter converter = this.factory.createConverter(value.getClass(), Color.class, null);
        return (Color)converter.convert(value, Color.class);
    }

    public void testRegisteredWithConverters() {
        Color color = (Color)Converters.convert((Object)"#189E77", Color.class);
        Color expected = new Color(24, 158, 119);
        ColorConverterFactoryTest.assertNotNull((String)"converter not registered", (Object)color);
        ColorConverterFactoryTest.assertEquals((Object)expected, (Object)color);
    }

    public void testCompactColor() {
        Color color = (Color)Converters.convert((Object)"#aaa", Color.class);
        ColorConverterFactoryTest.assertEquals((int)170, (int)color.getRed());
        ColorConverterFactoryTest.assertEquals((int)170, (int)color.getGreen());
        ColorConverterFactoryTest.assertEquals((int)170, (int)color.getBlue());
    }

    public void testHsl() throws Exception {
        Converter converter = this.factory.createConverter(String.class, Color.class, new Hints((RenderingHints.Key)Hints.COLOR_DEFINITION, (Object)"CSS"));
        ColorConverterFactoryTest.assertEquals((Object)Color.BLACK, (Object)converter.convert((Object)"hsl(0, 0, 0)", Color.class));
        ColorConverterFactoryTest.assertEquals((Object)Color.WHITE, (Object)converter.convert((Object)"hsl(0, 0, 100%)", Color.class));
        ColorConverterFactoryTest.assertEquals((Object)Color.RED, (Object)converter.convert((Object)"hsl(0, 100%, 50%)", Color.class));
        ColorConverterFactoryTest.assertEquals((Object)Color.GREEN, (Object)converter.convert((Object)"hsl(120, 100%, 50%)", Color.class));
    }

    public void testHsla() throws Exception {
        Converter converter = this.factory.createConverter(String.class, Color.class, new Hints((RenderingHints.Key)Hints.COLOR_DEFINITION, (Object)"CSS"));
        ColorConverterFactoryTest.assertEquals((Object)Color.BLACK, (Object)converter.convert((Object)"hsla(0, 0%, 0%, 1)", Color.class));
        ColorConverterFactoryTest.assertEquals((Object)new Color(255, 255, 255, 128), (Object)converter.convert((Object)"hsla(0, 0%, 100%, 0.5)", Color.class));
    }
}

