/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.util;

import java.math.BigDecimal;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import junit.framework.TestCase;
import org.geotools.data.util.CommonsConverterFactory;

public class CommonsConverterFactoryTest
extends TestCase {
    CommonsConverterFactory factory;

    protected void setUp() throws Exception {
        this.factory = new CommonsConverterFactory();
        Locale.setDefault(new Locale("en", "US"));
    }

    public void testStringNumberConversion() throws Exception {
        CommonsConverterFactoryTest.assertEquals((Object)12, (Object)this.convert("12", Integer.class));
        CommonsConverterFactoryTest.assertEquals(null, (Object)this.convert("12.0", Integer.class));
        CommonsConverterFactoryTest.assertEquals(null, (Object)this.convert("12.5", Integer.class));
        CommonsConverterFactoryTest.assertEquals(null, (Object)this.convert("9223372036854775807", Integer.class));
        CommonsConverterFactoryTest.assertEquals((Object)Long.MAX_VALUE, (Object)this.convert("9223372036854775807", Long.class));
        CommonsConverterFactoryTest.assertEquals(null, (Object)this.convert("1e100", Long.class));
        CommonsConverterFactoryTest.assertEquals(null, (Object)this.convert("12.5", Long.class));
        CommonsConverterFactoryTest.assertEquals((Object)9.223372036854776E18, (Object)this.convert("9223372036854775807", Double.class));
        CommonsConverterFactoryTest.assertEquals((Object)1.0E100, (Object)this.convert("1e100", Double.class));
        CommonsConverterFactoryTest.assertEquals((Object)12.5, (Object)this.convert("12.5", Double.class));
        BigDecimal d = new BigDecimal(12345);
        d = d.divide(new BigDecimal(100));
        CommonsConverterFactoryTest.assertEquals((Object)d, (Object)this.convert("123.45", BigDecimal.class));
    }

    public void testDateConversion() throws Exception {
        CommonsConverterFactoryTest.assertEquals((Object)TimeZone.getTimeZone("UTC"), (Object)this.convert("UTC", TimeZone.class));
        CommonsConverterFactoryTest.assertNull((Object)this.convert("foobar", TimeZone.class));
        CommonsConverterFactoryTest.assertNull((Object)this.factory.createConverter(String.class, TimeZone.class, null).convert(null, TimeZone.class));
    }

    public void testTimeZoneConversion() throws Exception {
        CommonsConverterFactoryTest.assertEquals((Object)new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSX").parse("2011-08-02T00:00:00.000Z"), (Object)this.factory.createConverter(String.class, Date.class, null).convert((Object)"2011-08-02T00:00:00.000Z", Date.class));
        CommonsConverterFactoryTest.assertEquals((Object)new SimpleDateFormat("yyyy-MM-dd HH:mm:ssa").parse("2011-08-02 00:00:00AM"), (Object)this.factory.createConverter(String.class, Date.class, null).convert((Object)"2011-08-02 00:00:00AM", Date.class));
        CommonsConverterFactoryTest.assertNull((Object)this.factory.createConverter(String.class, Date.class, null).convert((Object)"2011-08-02", Date.class));
    }

    Object convert(Object source, Class target) throws Exception {
        return this.factory.createConverter(source.getClass(), target, null).convert(source, target);
    }

    public void testDataUrlConversion() throws Exception {
        String url = "data:,YQo=";
        CommonsConverterFactoryTest.assertNotNull((Object)this.convert(url, URL.class));
    }
}

