/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.util;

import junit.framework.TestCase;
import org.geotools.data.util.ScreenMap;

public class ScreenMapTest
extends TestCase {
    private int xmin;
    private int width;
    private int height;
    private int ymin;

    public void testSet() {
        this.xmin = 0;
        this.ymin = 0;
        this.width = 8;
        this.height = 8;
        ScreenMap map = new ScreenMap(0, 0, 8, 8);
        for (int x = 0; x < 8; ++x) {
            for (int y = 0; y < 8; ++y) {
                ScreenMapTest.assertEquals((boolean)false, (boolean)map.get(x, y));
            }
        }
        this.setOne(map, 0, 0, true, false);
        this.setOne(map, 0, 0, false, true);
        this.setOne(map, 3, 4, true, false);
        this.setAll(map, true);
        this.setAll(map, false);
    }

    private void setOne(ScreenMap map, int xconst, int yconst, boolean bool, boolean expectedOldValue) {
        ScreenMapTest.assertEquals((boolean)expectedOldValue, (boolean)map.get(xconst, yconst));
        map.set(xconst, yconst, bool);
        for (int x = this.xmin; x < this.width; ++x) {
            for (int y = this.ymin; y < this.height; ++y) {
                if (x == xconst && y == yconst) {
                    ScreenMapTest.assertEquals((String)("x=" + x + " y=" + y), (boolean)bool, (boolean)map.get(x, y));
                    continue;
                }
                ScreenMapTest.assertEquals((String)("x=" + x + " y=" + y), (boolean)false, (boolean)map.get(x, y));
            }
        }
    }

    private void setAll(ScreenMap map, boolean value) {
        int y;
        int x;
        for (x = this.xmin; x < this.width; ++x) {
            for (y = this.ymin; y < this.height; ++y) {
                map.set(x, y, value);
            }
        }
        for (x = this.xmin; x < this.width; ++x) {
            for (y = this.ymin; y < this.height; ++y) {
                ScreenMapTest.assertEquals((boolean)value, (boolean)map.get(x, y));
            }
        }
    }

    public void testSubsetScreen() throws Exception {
        this.xmin = 478;
        this.ymin = 0;
        this.width = 283;
        this.height = 452;
        ScreenMap map = new ScreenMap(this.xmin, this.ymin, this.width + 1, this.height + 1);
        this.setOne(map, this.xmin, this.ymin, true, false);
        this.setOne(map, this.xmin, this.ymin, false, true);
        this.setOne(map, this.xmin + this.width - 1, this.ymin, true, false);
        this.setOne(map, this.xmin + this.width - 1, this.ymin, false, true);
        this.setOne(map, this.xmin + this.width - 1, this.ymin + this.height - 1, true, false);
        this.setOne(map, this.xmin + this.width - 1, this.ymin + this.height - 1, false, true);
        this.setOne(map, this.xmin, this.ymin + this.height - 1, true, false);
        this.setOne(map, this.xmin, this.ymin + this.height - 1, false, true);
        this.setOne(map, this.xmin + 7, this.ymin, true, false);
        this.setOne(map, this.xmin + 7, this.ymin, false, true);
        this.setOne(map, this.xmin + this.width - 1, this.ymin + 10, true, false);
        this.setOne(map, this.xmin + this.width - 1, this.ymin + 10, false, true);
        this.setOne(map, this.xmin + 5, this.ymin + this.height - 1, true, false);
        this.setOne(map, this.xmin + 5, this.ymin + this.height - 1, false, true);
        this.setOne(map, this.xmin, this.ymin + 7, true, false);
        this.setOne(map, this.xmin, this.ymin + 7, false, true);
        this.setOne(map, 728, 427, true, false);
        this.setAll(map, true);
        this.setAll(map, false);
    }

    public void testOutsideScreen() throws Exception {
        this.xmin = 0;
        this.ymin = 0;
        this.width = 10;
        this.height = 10;
        ScreenMap map = new ScreenMap(this.xmin, this.ymin, this.width, this.height);
        ScreenMapTest.assertFalse((boolean)map.checkAndSet(-10, -10));
        ScreenMapTest.assertFalse((boolean)map.checkAndSet(-10, -10));
        ScreenMapTest.assertFalse((boolean)map.checkAndSet(-10, 10));
        ScreenMapTest.assertFalse((boolean)map.checkAndSet(-10, 10));
        ScreenMapTest.assertFalse((boolean)map.checkAndSet(20, 10));
        ScreenMapTest.assertFalse((boolean)map.checkAndSet(20, 10));
        ScreenMapTest.assertFalse((boolean)map.checkAndSet(20, -10));
        ScreenMapTest.assertFalse((boolean)map.checkAndSet(20, -10));
        ScreenMapTest.assertFalse((boolean)map.get(-10, -10));
        ScreenMapTest.assertFalse((boolean)map.get(-10, -10));
        ScreenMapTest.assertFalse((boolean)map.get(-10, 10));
        ScreenMapTest.assertFalse((boolean)map.get(-10, 10));
        ScreenMapTest.assertFalse((boolean)map.get(20, 10));
        ScreenMapTest.assertFalse((boolean)map.get(20, 10));
        ScreenMapTest.assertFalse((boolean)map.get(20, -10));
        ScreenMapTest.assertFalse((boolean)map.get(20, -10));
        ScreenMapTest.assertFalse((boolean)map.checkAndSet(0, 0));
        ScreenMapTest.assertTrue((boolean)map.checkAndSet(0, 0));
        ScreenMapTest.assertTrue((boolean)map.get(0, 0));
    }
}

